/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.configurationStore.LazySchemeProcessor;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.InitialConfigImportState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.actions.CtrlYActionChooser;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.BundledKeymapBean;
import com.intellij.openapi.keymap.impl.DefaultKeymap;
import com.intellij.openapi.keymap.impl.DefaultKeymapImpl;
import com.intellij.openapi.keymap.impl.DefaultKeymapKt;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.keymap.impl.KeymapImplKt;
import com.intellij.openapi.keymap.impl.KeymapManagerImplKt;
import com.intellij.openapi.keymap.impl.WeakKeymapManagerListener;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.ResourceUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="KeymapManager", storages={@Storage(value="keymap.xml", roamingType=RoamingType.PER_OS)}, additionalExportDirectory="keymaps", category=SettingsCategory.KEYMAP)
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0014\b\u0007\u0018\u0000 12\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u00011B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u001c\u0010\u0013\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000eH\u0002J\u0013\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u001bJ\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u000eH\u0016J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J.\u0010\"\u001a\u00020\u00102\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\b\u0010$\u001a\u0004\u0018\u00010\u000e2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u001bJ\b\u0010&\u001a\u00020\u0003H\u0016J\u0010\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u0003H\u0016J\u0012\u0010)\u001a\u00020\u001e2\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0002J\b\u0010+\u001a\u00020\u0010H\u0002J\u0010\u0010,\u001a\u00020\u00102\u0006\u0010-\u001a\u00020\bH\u0016J\u0010\u0010.\u001a\u00020\u00102\u0006\u0010-\u001a\u00020\bH\u0016J\u0010\u0010/\u001a\u00020\u00102\u0006\u00100\u001a\u00020\bH\u0016R:\u0010\u0006\u001a.\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b \t*\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u000b\u00a2\u0006\u0002\b\n0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/openapi/keymap/impl/KeymapManagerImpl;", "Lcom/intellij/openapi/keymap/ex/KeymapManagerEx;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "<init>", "()V", "listeners", "", "Lcom/intellij/openapi/keymap/KeymapManagerListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "schemeManager", "Lcom/intellij/openapi/options/SchemeManager;", "Lcom/intellij/openapi/keymap/Keymap;", "fireKeymapAdded", "", "keymap", "fireKeymapRemoved", "fireActiveKeymapChanged", "newScheme", "activeKeymap", "getAllKeymaps", "", "()[Lcom/intellij/openapi/keymap/Keymap;", "getKeymaps", "additionalFilter", "Ljava/util/function/Predicate;", "getKeymap", "name", "", "getActiveKeymap", "setActiveKeymap", "getSchemeManager", "setKeymaps", "keymaps", "active", "removeCondition", "getState", "loadState", "state", "getActiveKeymapName", "child", "pollQueue", "removeKeymapManagerListener", "listener", "addWeakListener", "removeWeakListener", "listenerToRemove", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nKeymapManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeymapManagerImpl.kt\ncom/intellij/openapi/keymap/impl/KeymapManagerImpl\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,259:1\n37#2,2:260\n777#3:262\n873#3,2:263\n60#4,5:265\n*S KotlinDebug\n*F\n+ 1 KeymapManagerImpl.kt\ncom/intellij/openapi/keymap/impl/KeymapManagerImpl\n*L\n155#1:260,2\n158#1:262\n158#1:263,2\n196#1:265,5\n*E\n"})
public final class KeymapManagerImpl
extends KeymapManagerEx
implements PersistentStateComponent<Element> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<KeymapManagerListener> listeners;
    @NotNull
    private final SchemeManager<Keymap> schemeManager;
    private static boolean isKeymapManagerInitialized;
    @NotNull
    public static final String KEYMAP_MANAGER_COMPONENT_NAME = "KeymapManager";
    @NotNull
    public static final String KEYMAP_STORAGE = "keymap.xml";
    @NotNull
    public static final String KEYMAP_FIELD = "active_keymap";

    public KeymapManagerImpl() {
        List list2 = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"createLockFreeCopyOnWriteList(...)");
        this.listeners = list2;
        this.schemeManager = SchemeManagerFactory.create$default((SchemeManagerFactory)SchemeManagerFactory.Companion.getInstance(), (String)"keymaps", (SchemeProcessor)((SchemeProcessor)new LazySchemeProcessor<Keymap, KeymapImpl>(){

            public KeymapImpl createScheme(SchemeDataHolder<? super KeymapImpl> dataHolder, String name2, Function1<? super String, String> attributeProvider, boolean isBundled) {
                Intrinsics.checkNotNullParameter(dataHolder, (String)"dataHolder");
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter(attributeProvider, (String)"attributeProvider");
                return KeymapImplKt.KeymapImpl(name2, dataHolder);
            }

            public void onCurrentSchemeSwitched(Keymap oldScheme, Keymap newScheme, boolean processChangeSynchronously) {
                this.fireActiveKeymapChanged(newScheme, this.getActiveKeymap());
            }

            public void reloaded(SchemeManager<Keymap> schemeManager, Collection<? extends Keymap> schemes) {
                Intrinsics.checkNotNullParameter(schemeManager, (String)"schemeManager");
                Intrinsics.checkNotNullParameter(schemes, (String)"schemes");
                if (schemeManager.getCurrentSchemeName() == null) {
                    AppUIUtil.invokeOnEdt(() -> 1.reloaded$lambda$0(schemeManager));
                }
            }

            private static final void reloaded$lambda$0(SchemeManager $schemeManager) {
                $schemeManager.setCurrentSchemeName(DefaultKeymap.Companion.getInstance().getDefaultKeymapName(), true);
            }
        }), null, null, (SettingsCategory)SettingsCategory.KEYMAP, (int)12, null);
        DefaultKeymap defaultKeymapManager = DefaultKeymap.Companion.getInstance();
        String systemDefaultKeymap = defaultKeymapManager.getDefaultKeymapName();
        for (Keymap keymap2 : defaultKeymapManager.getKeymaps$intellij_platform_ide_impl()) {
            this.schemeManager.addScheme((Object)keymap2);
            if (!Intrinsics.areEqual((Object)keymap2.getName(), (Object)systemDefaultKeymap)) continue;
            SchemeManager.setCurrent$default(this.schemeManager, (Object)keymap2, (boolean)false, (boolean)false, (int)4, null);
        }
        this.schemeManager.loadSchemes();
        isKeymapManagerInitialized = true;
        if (InitialConfigImportState.isNewUser()) {
            CtrlYActionChooser.askAboutShortcut();
        }
        BundledKeymapBean.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<BundledKeymapBean>(){

            public void extensionAdded(BundledKeymapBean extension, PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                String keymapName = DefaultKeymapKt.getKeymapName(extension);
                DefaultKeymapImpl keymap2 = DefaultKeymap.Companion.getInstance().loadKeymap$intellij_platform_ide_impl(keymapName, (SchemeDataHolder<? super KeymapImpl>)((SchemeDataHolder)new SchemeDataHolder<KeymapImpl>(extension, pluginDescriptor){
                    final /* synthetic */ BundledKeymapBean $extension;
                    final /* synthetic */ PluginDescriptor $pluginDescriptor;
                    {
                        this.$extension = $extension;
                        this.$pluginDescriptor = $pluginDescriptor;
                    }

                    public Element read() {
                        byte[] byArray = ResourceUtil.getResourceAsBytes((String)DefaultKeymapKt.getEffectiveFile(this.$extension), (ClassLoader)this.$pluginDescriptor.getClassLoader());
                        Intrinsics.checkNotNull((Object)byArray);
                        Element element = JDOMUtil.load((byte[])byArray);
                        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"load(...)");
                        return element;
                    }
                }), pluginDescriptor);
                schemeManager.addScheme((Object)keymap2);
                this.fireKeymapAdded(keymap2);
            }

            public void extensionRemoved(BundledKeymapBean extension, PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                KeymapManagerImpl._init_$removeKeymap(this, DefaultKeymapKt.getKeymapName(extension));
            }
        }, null);
    }

    private final void fireKeymapAdded(Keymap keymap2) {
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Topic topic = KeymapManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        ((KeymapManagerListener)messageBus.syncPublisher(topic)).keymapAdded(keymap2);
        for (KeymapManagerListener listener2 : this.listeners) {
            listener2.keymapAdded(keymap2);
        }
    }

    private final void fireKeymapRemoved(Keymap keymap2) {
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Topic topic = KeymapManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        ((KeymapManagerListener)messageBus.syncPublisher(topic)).keymapRemoved(keymap2);
        for (KeymapManagerListener listener2 : this.listeners) {
            listener2.keymapRemoved(keymap2);
        }
    }

    private final void fireActiveKeymapChanged(Keymap newScheme, Keymap activeKeymap) {
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Topic topic = KeymapManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        ((KeymapManagerListener)messageBus.syncPublisher(topic)).activeKeymapChanged(activeKeymap);
        for (KeymapManagerListener listener2 : this.listeners) {
            listener2.activeKeymapChanged(newScheme);
        }
    }

    @Override
    @NotNull
    public Keymap[] getAllKeymaps() {
        Collection $this$toTypedArray$iv = this.getKeymaps(null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Keymap[0]);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Keymap> getKeymaps(@Nullable Predicate<Keymap> additionalFilter) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.schemeManager.getAllSchemes();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Keymap it = (Keymap)element$iv$iv;
            boolean bl = false;
            String string = it.getPresentableName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableName(...)");
            if (!(!StringsKt.startsWith$default((CharSequence)string, (char)'$', (boolean)false, (int)2, null) && (additionalFilter == null || additionalFilter.test(it)))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public Keymap getKeymap(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return (Keymap)this.schemeManager.findSchemeByName(name2);
    }

    @NotNull
    public Keymap getActiveKeymap() {
        Keymap keymap2 = (Keymap)this.schemeManager.getActiveScheme();
        if (keymap2 == null && (keymap2 = (Keymap)this.schemeManager.findSchemeByName(DefaultKeymap.Companion.getInstance().getDefaultKeymapName())) == null) {
            Object object = this.schemeManager.findSchemeByName("$default");
            Intrinsics.checkNotNull((Object)object);
            keymap2 = (Keymap)object;
        }
        return keymap2;
    }

    @Override
    public void setActiveKeymap(@NotNull Keymap keymap2) {
        Intrinsics.checkNotNullParameter((Object)keymap2, (String)"keymap");
        SchemeManager.setCurrent$default(this.schemeManager, (Object)keymap2, (boolean)false, (boolean)false, (int)6, null);
    }

    @Override
    @NotNull
    public SchemeManager<Keymap> getSchemeManager() {
        return this.schemeManager;
    }

    public final void setKeymaps(@NotNull List<? extends Keymap> keymaps, @Nullable Keymap active, @Nullable Predicate<Keymap> removeCondition) {
        Intrinsics.checkNotNullParameter(keymaps, (String)"keymaps");
        this.schemeManager.setSchemes(keymaps, (Object)active, removeCondition);
        this.fireActiveKeymapChanged(active, this.getActiveKeymap());
    }

    @NotNull
    public Element getState() {
        Element result2;
        block1: {
            result2 = new Element("state");
            String string = this.schemeManager.getCurrentSchemeName();
            if (string == null) break block1;
            String it = string;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it, (Object)DefaultKeymap.Companion.getInstance().getDefaultKeymapName())) {
                Element e = new Element(KEYMAP_FIELD);
                e.setAttribute("name", it);
                result2.addContent(e);
            }
        }
        return result2;
    }

    public void loadState(@NotNull Element state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        String activeKeymapName = this.getActiveKeymapName(state2.getChild(KEYMAP_FIELD));
        Logger $this$debug_u24default$iv = KeymapManagerImplKt.access$getLOG$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("loadState: activeKeymapName = " + activeKeymapName, t$iv);
        }
        this.schemeManager.setCurrentSchemeName(activeKeymapName);
        if (!Intrinsics.areEqual((Object)this.schemeManager.getCurrentSchemeName(), (Object)activeKeymapName)) {
            Object[] objectArray = new Object[]{activeKeymapName};
            String string = IdeBundle.message((String)"notification.content.cannot.find.keymap", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            KeymapImplKt.notifyAboutMissingKeymap(activeKeymapName, string, false);
        }
    }

    private final String getActiveKeymapName(Element child) {
        Element element = child;
        String value = element != null ? element.getAttributeValue("name") : null;
        CharSequence charSequence = value;
        return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? value : DefaultKeymap.Companion.getInstance().getDefaultKeymapName();
    }

    private final void pollQueue() {
        this.listeners.removeIf(arg_0 -> KeymapManagerImpl.pollQueue$lambda$1(KeymapManagerImpl::pollQueue$lambda$0, arg_0));
    }

    public void removeKeymapManagerListener(@NotNull KeymapManagerListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.pollQueue();
        this.listeners.remove(listener2);
    }

    @Override
    public void addWeakListener(@NotNull KeymapManagerListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.pollQueue();
        this.listeners.add(new WeakKeymapManagerListener(this, listener2));
    }

    @Override
    public void removeWeakListener(@NotNull KeymapManagerListener listenerToRemove) {
        Intrinsics.checkNotNullParameter((Object)listenerToRemove, (String)"listenerToRemove");
        this.listeners.removeIf(arg_0 -> KeymapManagerImpl.removeWeakListener$lambda$1(arg_0 -> KeymapManagerImpl.removeWeakListener$lambda$0(listenerToRemove, arg_0), arg_0));
    }

    private static final void _init_$removeKeymap(KeymapManagerImpl this$0, String keymapName) {
        Keymap keymap2 = (Keymap)this$0.schemeManager.getActiveScheme();
        boolean isCurrent = StringsKt.equals$default((String)(keymap2 != null ? keymap2.getName() : null), (String)keymapName, (boolean)false, (int)2, null);
        Keymap keymap3 = (Keymap)this$0.schemeManager.removeScheme(keymapName);
        if (keymap3 != null) {
            this$0.fireKeymapRemoved(keymap3);
        }
        DefaultKeymap.Companion.getInstance().removeKeymap$intellij_platform_ide_impl(keymapName);
        if (isCurrent) {
            Keymap keymap4 = (Keymap)this$0.schemeManager.getActiveScheme();
            if (keymap4 == null && (keymap4 = (Keymap)this$0.schemeManager.findSchemeByName(DefaultKeymap.Companion.getInstance().getDefaultKeymapName())) == null) {
                keymap4 = (Keymap)this$0.schemeManager.findSchemeByName("$default");
            }
            Keymap activeKeymap = keymap4;
            this$0.schemeManager.setCurrent((Object)activeKeymap, true, true);
            this$0.fireActiveKeymapChanged(activeKeymap, activeKeymap);
        }
    }

    private static final boolean pollQueue$lambda$0(KeymapManagerListener it) {
        return it instanceof WeakKeymapManagerListener && ((WeakKeymapManagerListener)it).isDead();
    }

    private static final boolean pollQueue$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removeWeakListener$lambda$0(KeymapManagerListener $listenerToRemove, KeymapManagerListener it) {
        return it instanceof WeakKeymapManagerListener && ((WeakKeymapManagerListener)it).isWrapped($listenerToRemove);
    }

    private static final boolean removeWeakListener$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final boolean isKeymapManagerInitialized() {
        return Companion.isKeymapManagerInitialized();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R&\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\u0006\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/keymap/impl/KeymapManagerImpl$Companion;", "", "<init>", "()V", "value", "", "isKeymapManagerInitialized", "isKeymapManagerInitialized$annotations", "()Z", "KEYMAP_MANAGER_COMPONENT_NAME", "", "KEYMAP_STORAGE", "KEYMAP_FIELD", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isKeymapManagerInitialized() {
            return isKeymapManagerInitialized;
        }

        @JvmStatic
        public static /* synthetic */ void isKeymapManagerInitialized$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

