/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.PressureShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ui.ShortcutTextElement;
import com.intellij.openapi.keymap.impl.ui.ShortcutTextPresentation;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B9\b\u0016\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00162\u0006\u0010\u0017\u001a\u00020\u0004H\u0002J \u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u001e\u0010\u001d\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u00132\u0006\u0010\u001e\u001a\u00020\u000fH\u0002J(\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020&H\u0002J8\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020 2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010.\u001a\u0004\u0018\u00010\"2\u0006\u0010/\u001a\u00020\u0007H\u0002J\u0016\u00100\u001a\u00020\u00192\u0006\u00101\u001a\u0002022\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/openapi/keymap/impl/ui/ShortcutTextList;", "", "shortcuts", "", "Lcom/intellij/openapi/actionSystem/Shortcut;", "abbreviations", "", "", "tree", "Ljavax/swing/JComponent;", "g", "Ljava/awt/Graphics2D;", "<init>", "([Lcom/intellij/openapi/actionSystem/Shortcut;Ljava/util/Collection;Ljavax/swing/JComponent;Ljava/awt/Graphics2D;)V", "width", "", "height", "round", "elements", "", "Lcom/intellij/openapi/keymap/impl/ui/ShortcutTextElement;", "getShortcutTexts", "", "shortcut", "addShortcut", "", "result", "keyStroke", "Ljavax/swing/KeyStroke;", "addShortcutModifiers", "modifiers", "createPresentation", "Lcom/intellij/openapi/keymap/impl/ui/ShortcutTextPresentation;", "textColor", "Ljava/awt/Color;", "fillColorKey", "borderColorKey", "font", "Ljava/awt/Font;", "createTextElement", "text", "gap", "textGap", "fontMetrics", "Ljava/awt/FontMetrics;", "presentation", "getColor", "name", "draw", "bounds", "Ljava/awt/Rectangle;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nShortcutTextUi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShortcutTextUi.kt\ncom/intellij/openapi/keymap/impl/ui/ShortcutTextList\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,206:1\n1#2:207\n1915#3,2:208\n14116#4,2:210\n*S KotlinDebug\n*F\n+ 1 ShortcutTextUi.kt\ncom/intellij/openapi/keymap/impl/ui/ShortcutTextList\n*L\n140#1:208,2\n143#1:210,2\n*E\n"})
public final class ShortcutTextList {
    private final int width;
    private final int height;
    private final int round;
    @NotNull
    private final List<ShortcutTextElement> elements;

    /*
     * WARNING - void declaration
     */
    public ShortcutTextList(@Nullable Shortcut[] shortcuts, @Nullable Collection<String> abbreviations, @NotNull JComponent tree2, @NotNull Graphics2D g) {
        int n;
        int n2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        this.height = JBUI.scale((int)18);
        this.round = JBUI.scale((int)8);
        this.elements = new ArrayList();
        if ((shortcuts == null || shortcuts.length == 0) && (abbreviations == null || abbreviations.isEmpty())) {
            this.width = 0;
            return;
        }
        int fixedWidth = JBUI.scale((int)20);
        int textGap = JBUI.scale((int)4);
        int betweenGap = JBUI.scale((int)3);
        int separatorGap = JBUI.scale((int)8);
        JBFont jBFont = JBFont.medium();
        Intrinsics.checkNotNullExpressionValue((Object)jBFont, (String)"medium(...)");
        JBFont font = jBFont;
        JBFont jBFont2 = font.asBold();
        Intrinsics.checkNotNullExpressionValue((Object)jBFont2, (String)"asBold(...)");
        JBFont boldFont = jBFont2;
        FontMetrics boldMetrics = tree2.getFontMetrics((Font)boldFont);
        JBColor jBColor = JBColor.namedColor((String)"Shortcut.foreground", (Color)((Color)new JBColor(0, 14672357)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        ShortcutTextPresentation shortcutPresentation = this.createPresentation((Color)jBColor, "Shortcut.background", "Shortcut.borderColor", (Font)boldFont);
        JBColor jBColor2 = JBColor.namedColor((String)"Abbreviation.foreground", (Color)((Color)new JBColor(1516071726, -1262960832)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"namedColor(...)");
        ShortcutTextPresentation abbreviationPresentation = this.createPresentation((Color)jBColor2, "Abbreviation.background", "Abbreviation.borderColor", (Font)boldFont);
        String string = KeyMapBundle.message((String)"or.separator", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String separatorText = string;
        Color color = JBUI.CurrentTheme.Label.foreground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"foreground(...)");
        ShortcutTextPresentation separatorPresentation = new ShortcutTextPresentation(color, null, null, (Font)font);
        FontMetrics fontMetrics = tree2.getFontMetrics((Font)font);
        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
        ShortcutTextElement separatorElement = this.createTextElement(separatorText, 0, separatorGap, fontMetrics, separatorPresentation, g);
        if (shortcuts != null && !(shortcuts.length == 0)) {
            int lastShortcut = ArraysKt.getLastIndex((Object[])shortcuts);
            object = shortcuts;
            int n3 = ((Shortcut[])object).length;
            for (n2 = 0; n2 < n3; ++n2) {
                int index = n2;
                Shortcut shortcut = object[n2];
                List<String> texts = this.getShortcutTexts(shortcut);
                int lastText = CollectionsKt.getLastIndex(texts);
                Iterator iterator = ((Iterable)texts).iterator();
                int n4 = 0;
                while (iterator.hasNext()) {
                    boolean bl;
                    int gap;
                    int index2 = n4++;
                    String text2 = (String)iterator.next();
                    int n5 = gap = index2 == lastText ? 0 : betweenGap;
                    if (text2.length() == 1) {
                        bl = this.elements.add(new ShortcutTextElement(fixedWidth, gap, text2, shortcutPresentation));
                        continue;
                    }
                    Intrinsics.checkNotNull((Object)boldMetrics);
                    bl = this.elements.add(this.createTextElement(text2, gap, textGap, boldMetrics, shortcutPresentation, g));
                }
                if (index == lastShortcut) continue;
                this.elements.add(ShortcutTextElement.copy$default(separatorElement, 0, 0, null, null, 15, null));
            }
        }
        if (abbreviations != null && !abbreviations.isEmpty()) {
            if (!((Collection)this.elements).isEmpty()) {
                this.elements.add(ShortcutTextElement.copy$default(separatorElement, 0, 0, null, null, 15, null));
            }
            int lastAbbreviation = abbreviations.size() - 1;
            object = ((Iterable)abbreviations).iterator();
            n2 = 0;
            while (object.hasNext()) {
                int index = n2++;
                String abbreviation = (String)object.next();
                Intrinsics.checkNotNull((Object)boldMetrics);
                this.elements.add(this.createTextElement(abbreviation, 0, textGap, boldMetrics, abbreviationPresentation, g));
                if (index == lastAbbreviation) continue;
                this.elements.add(ShortcutTextElement.copy$default(separatorElement, 0, 0, null, null, 15, null));
            }
        }
        Iterable iterable = this.elements;
        ShortcutTextList shortcutTextList = this;
        int n6 = 0;
        for (Object t : iterable) {
            void element;
            ShortcutTextElement abbreviation = (ShortcutTextElement)t;
            n = n6;
            boolean bl = false;
            int n7 = element.getWidth() + element.getGap();
            n6 = n + n7;
        }
        n = n6;
        shortcutTextList.width = n + JBUI.scale((int)10);
    }

    private final List<String> getShortcutTexts(Shortcut shortcut) {
        int modifiers;
        if (shortcut instanceof KeyboardShortcut) {
            List list2;
            List $this$getShortcutTexts_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
            boolean bl = false;
            this.addShortcut($this$getShortcutTexts_u24lambda_u240, ((KeyboardShortcut)shortcut).getFirstKeyStroke());
            this.addShortcut($this$getShortcutTexts_u24lambda_u240, ((KeyboardShortcut)shortcut).getSecondKeyStroke());
            return CollectionsKt.build((List)list2);
        }
        if (shortcut instanceof PressureShortcut) {
            return CollectionsKt.listOf((Object)((PressureShortcut)shortcut).toString());
        }
        if (shortcut instanceof MouseShortcut && (modifiers = ((MouseShortcut)shortcut).getModifiers()) > 0) {
            List list3;
            List $this$getShortcutTexts_u24lambda_u241 = list3 = CollectionsKt.createListBuilder();
            boolean bl = false;
            this.addShortcutModifiers($this$getShortcutTexts_u24lambda_u241, modifiers);
            String string = KeymapUtil.getShortcutText((Shortcut)((Shortcut)new MouseShortcut(((MouseShortcut)shortcut).getButton(), 0, ((MouseShortcut)shortcut).getClickCount())));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getShortcutText(...)");
            $this$getShortcutTexts_u24lambda_u241.add(string);
            return CollectionsKt.build((List)list3);
        }
        return CollectionsKt.listOf((Object)KeymapUtil.getShortcutText((Shortcut)shortcut));
    }

    private final void addShortcut(List<String> result2, KeyStroke keyStroke) {
        if (keyStroke == null) {
            return;
        }
        int modifiers = keyStroke.getModifiers();
        if (modifiers > 0) {
            this.addShortcutModifiers(result2, modifiers);
            String string = KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke(keyStroke.getKeyCode(), 0, keyStroke.isOnKeyRelease()));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKeystrokeText(...)");
            v1 = result2.add(string);
        } else {
            String string = KeymapUtil.getKeystrokeText((KeyStroke)keyStroke);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKeystrokeText(...)");
            v1 = result2.add(string);
        }
    }

    private final void addShortcutModifiers(List<String> result2, int modifiers) {
        String string = KeymapUtil.getModifiersText((int)modifiers);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getModifiersText(...)");
        String modifiersText = string;
        if (KeymapUtil.isSimplifiedMacShortcuts() || !ClientSystemInfo.Companion.isMac()) {
            String[] stringArray = new String[]{"+"};
            Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)modifiersText, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                result2.add(((Object)StringsKt.trim((CharSequence)it)).toString());
            }
        } else {
            char[] cArray = modifiersText.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            char[] $this$forEach$iv = cArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                char element$iv;
                char it = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                result2.add(String.valueOf(it));
            }
        }
    }

    private final ShortcutTextPresentation createPresentation(Color textColor, String fillColorKey, String borderColorKey, Font font) {
        return new ShortcutTextPresentation(textColor, this.getColor(fillColorKey), this.getColor(borderColorKey), font);
    }

    private final ShortcutTextElement createTextElement(String text2, int gap, int textGap, FontMetrics fontMetrics, ShortcutTextPresentation presentation2, Graphics2D g) {
        Rectangle2D bounds = fontMetrics.getStringBounds(text2, g);
        double textWidth = bounds.getWidth() + (double)(textGap * 2);
        return new ShortcutTextElement((int)textWidth, gap, text2, presentation2);
    }

    private final Color getColor(String name2) {
        Color color = UIManager.getColor(name2);
        if (color != null) {
            return color;
        }
        return null;
    }

    public final void draw(@NotNull Rectangle bounds, @NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        int startX = bounds.x + bounds.width - this.width;
        int y = bounds.y + (bounds.height - this.height) / 2;
        for (ShortcutTextElement element : this.elements) {
            Color fillColor;
            ShortcutTextPresentation presentation2 = element.getPresentation();
            Color borderColor = presentation2.getBorderColor();
            if (borderColor != null) {
                g.setColor(borderColor);
                g.drawRoundRect(startX, y, element.getWidth(), this.height, this.round, this.round);
            }
            if ((fillColor = presentation2.getFillColor()) != null) {
                g.setColor(fillColor);
                g.fillRoundRect(startX, y, element.getWidth(), this.height, this.round, this.round);
            }
            g.setColor(presentation2.getTextColor());
            g.setFont(presentation2.getFont());
            UIUtil.drawCenteredString((Graphics2D)g, (Rectangle)new Rectangle(startX, y, element.getWidth(), this.height), (String)element.getText());
            startX += element.getWidth() + element.getGap();
        }
    }
}

