/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.HintHint;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bJ#\u0010\f\u001a\u00020\u000b2\u000b\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J%\u0010\u0013\u001a\u00020\u000b2\u000b\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000f2\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/project/DumbServiceBalloon;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "myService", "Lcom/intellij/openapi/project/DumbServiceBalloon$Service;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/project/DumbServiceBalloon$Service;)V", "myBalloon", "Lcom/intellij/openapi/ui/popup/Balloon;", "dispose", "", "showDumbModeActionBalloon", "balloonText", "", "Lcom/intellij/openapi/util/NlsContexts$PopupContent;", "runWhenSmartAndBalloonStillShowing", "Ljava/lang/Runnable;", "runWhenCancelled", "tryShowBalloonTillSmartMode", "runWhenSmartAndBalloonNotHidden", "Service", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class DumbServiceBalloon {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Service myService;
    @Nullable
    private Balloon myBalloon;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final JBInsets DUMB_BALLOON_INSETS;

    public DumbServiceBalloon(@NotNull Project myProject, @NotNull Service myService) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)myService, (String)"myService");
        this.myProject = myProject;
        this.myService = myService;
    }

    public final void dispose() {
        if (this.myBalloon != null) {
            Balloon balloon = this.myBalloon;
            Intrinsics.checkNotNull((Object)balloon);
            Disposer.dispose((Disposable)((Disposable)balloon));
        }
    }

    public final void showDumbModeActionBalloon(@NotNull String balloonText, @NotNull Runnable runWhenSmartAndBalloonStillShowing, @NotNull Runnable runWhenCancelled) {
        Intrinsics.checkNotNullParameter((Object)balloonText, (String)"balloonText");
        Intrinsics.checkNotNullParameter((Object)runWhenSmartAndBalloonStillShowing, (String)"runWhenSmartAndBalloonStillShowing");
        Intrinsics.checkNotNullParameter((Object)runWhenCancelled, (String)"runWhenCancelled");
        if (LightEdit.owns((Project)this.myProject)) {
            return;
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (!this.myService.isDumb()) {
            UIEventLogger.DumbModeBalloonWasNotNeeded.log(this.myProject);
            runWhenSmartAndBalloonStillShowing.run();
            return;
        }
        if (this.myBalloon != null) {
            return;
        }
        this.tryShowBalloonTillSmartMode(balloonText, runWhenSmartAndBalloonStillShowing, runWhenCancelled);
    }

    private final void tryShowBalloonTillSmartMode(String balloonText, Runnable runWhenSmartAndBalloonNotHidden, Runnable runWhenCancelled) {
        LOG.assertTrue(this.myBalloon == null);
        long startTimestamp = System.nanoTime();
        UIEventLogger.DumbModeBalloonRequested.log(this.myProject);
        BalloonBuilder builder = ExperimentalUI.Companion.isNewUI() ? JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(balloonText, null, HintHint.Status.Info.foreground, HintHint.Status.Info.background, null).setBorderColor(HintHint.Status.Info.border).setShowCallout(true).setBorderInsets((Insets)JBUI.insets((int)9, (int)7, (int)11, (int)7)).setPointerSize((Dimension)JBUI.size((int)16, (int)8)).setPointerShiftedToStart(true).setCornerRadius(JBUI.scale((int)8)) : JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(balloonText, MessageType.WARNING, null).setBorderInsets((Insets)DUMB_BALLOON_INSETS).setShowCallout(false);
        Balloon balloon = this.myBalloon = builder.createBalloon();
        Intrinsics.checkNotNull((Object)balloon);
        balloon.setAnimationEnabled(false);
        Balloon balloon2 = this.myBalloon;
        Intrinsics.checkNotNull((Object)balloon2);
        balloon2.addListener(new JBPopupListener(this, runWhenCancelled){
            final /* synthetic */ DumbServiceBalloon this$0;
            final /* synthetic */ Runnable $runWhenCancelled;
            {
                this.this$0 = $receiver;
                this.$runWhenCancelled = $runWhenCancelled;
            }

            public void onClosed(LightweightWindowEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (DumbServiceBalloon.access$getMyBalloon$p(this.this$0) == null) {
                    return;
                }
                UIEventLogger.DumbModeBalloonCancelled.log(DumbServiceBalloon.access$getMyProject$p(this.this$0));
                this.$runWhenCancelled.run();
                DumbServiceBalloon.access$setMyBalloon$p(this.this$0, null);
            }
        });
        this.myService.runWhenSmart(() -> DumbServiceBalloon.tryShowBalloonTillSmartMode$lambda$0(this, startTimestamp, runWhenSmartAndBalloonNotHidden));
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(arg_0 -> DumbServiceBalloon.tryShowBalloonTillSmartMode$lambda$2(arg_0 -> DumbServiceBalloon.tryShowBalloonTillSmartMode$lambda$1(this, arg_0), arg_0));
    }

    private static final void tryShowBalloonTillSmartMode$lambda$0(DumbServiceBalloon this$0, long $startTimestamp, Runnable $runWhenSmartAndBalloonNotHidden) {
        Balloon balloon = this$0.myBalloon;
        if (balloon == null) {
            return;
        }
        Balloon balloon2 = balloon;
        UIEventLogger.DumbModeBalloonProceededToActions.log(this$0.myProject, (Object)TimeoutUtil.getDurationMillis((long)$startTimestamp));
        $runWhenSmartAndBalloonNotHidden.run();
        this$0.myBalloon = null;
        balloon2.hide();
    }

    private static final Unit tryShowBalloonTillSmartMode$lambda$1(DumbServiceBalloon this$0, DataContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this$0.myService.isDumb()) {
            return Unit.INSTANCE;
        }
        if (this$0.myBalloon == null) {
            return Unit.INSTANCE;
        }
        UIEventLogger.DumbModeBalloonShown.log(this$0.myProject);
        Balloon balloon = this$0.myBalloon;
        Intrinsics.checkNotNull((Object)balloon);
        Balloon balloon2 = this$0.myBalloon;
        Intrinsics.checkNotNull((Object)balloon2);
        balloon.show(DumbServiceBalloon.Companion.getDumbBalloonPopupPoint(balloon2, context), Balloon.Position.above);
        return Unit.INSTANCE;
    }

    private static final void tryShowBalloonTillSmartMode$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Balloon access$getMyBalloon$p(DumbServiceBalloon $this) {
        return $this.myBalloon;
    }

    public static final /* synthetic */ Project access$getMyProject$p(DumbServiceBalloon $this) {
        return $this.myProject;
    }

    public static final /* synthetic */ void access$setMyBalloon$p(DumbServiceBalloon $this, Balloon balloon) {
        $this.myBalloon = balloon;
    }

    static {
        Logger logger = Logger.getInstance(DumbServiceBalloon.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        JBInsets jBInsets = JBInsets.create((int)5, (int)8);
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"create(...)");
        DUMB_BALLOON_INSETS = jBInsets;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/project/DumbServiceBalloon$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "DUMB_BALLOON_INSETS", "Lcom/intellij/util/ui/JBInsets;", "getDumbBalloonPopupPoint", "Lcom/intellij/ui/awt/RelativePoint;", "balloon", "Lcom/intellij/openapi/ui/popup/Balloon;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final RelativePoint getDumbBalloonPopupPoint(Balloon balloon, DataContext context) {
            RelativePoint relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(context);
            Intrinsics.checkNotNullExpressionValue((Object)relativePoint, (String)"guessBestPopupLocation(...)");
            RelativePoint relativePoint2 = relativePoint;
            Point point = relativePoint2.getPoint();
            if (ExperimentalUI.Companion.isNewUI()) {
                Component component2 = (Component)PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(context);
                if (component2 instanceof EditorComponentImpl) {
                    point.translate(0, -((EditorComponentImpl)component2).getEditor().getLineHeight());
                    return new RelativePoint(relativePoint2.getComponent(), point);
                }
                return relativePoint2;
            }
            Dimension size2 = balloon.getPreferredSize();
            point.translate(size2.width / 2, 0);
            point.translate(-DUMB_BALLOON_INSETS.left - AllIcons.General.BalloonWarning.getIconWidth() - JBUIScale.scale((int)6), 0);
            return new RelativePoint(relativePoint2.getComponent(), point);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/project/DumbServiceBalloon$Service;", "", "isDumb", "", "()Z", "runWhenSmart", "", "runnable", "Ljava/lang/Runnable;", "intellij.platform.ide.impl"})
    public static interface Service {
        public boolean isDumb();

        public void runWhenSmart(@NotNull Runnable var1);
    }
}

