/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl.shared;

import com.intellij.configurationStore.StorageManagerFileWriteRequestor;
import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.impl.shared.ConfigFilesUpdatedByThisProcess;
import com.intellij.openapi.project.impl.shared.SharedConfigFolderStreamProvider;
import com.intellij.openapi.project.impl.shared.SharedConfigFolderStreamProviderKt;
import com.intellij.openapi.project.impl.shared.SharedConfigFolderUtil;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import javax.xml.stream.XMLStreamException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J.\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0014\u0010\u0013\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0004\u0012\u00020\u00160\u0014H\u0016J2\u0010\u0017\u001a\u00020\u00162\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\u0014\u0010\u0013\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0004\u0012\u00020\u00160\u0014H\u0002J\u0088\u0001\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122!\u0010\u001e\u001a\u001d\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b( \u0012\u0004\u0012\u00020\f0\u00142K\u0010!\u001aG\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b( \u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(#\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b($\u0012\u0004\u0012\u00020\f0\"H\u0016J \u0010%\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010(\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010)\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010*\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\r\u00a8\u0006+"}, d2={"Lcom/intellij/openapi/project/impl/shared/SharedConfigFolderStreamProvider;", "Lcom/intellij/configurationStore/StreamProvider;", "Lcom/intellij/configurationStore/StorageManagerFileWriteRequestor;", "root", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "configFilesUpdatedByThisProcess", "Lcom/intellij/openapi/project/impl/shared/ConfigFilesUpdatedByThisProcess;", "getConfigFilesUpdatedByThisProcess$intellij_platform_ide_impl", "()Lcom/intellij/openapi/project/impl/shared/ConfigFilesUpdatedByThisProcess;", "isExclusive", "", "()Z", "read", "fileSpec", "", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "consumer", "Lkotlin/Function1;", "Ljava/io/InputStream;", "", "processReadException", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "file", "processChildren", "path", "filter", "Lkotlin/ParameterName;", "name", "processor", "Lkotlin/Function3;", "input", "readOnly", "write", "content", "", "delete", "resolveSpec", "checkFile", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nSharedConfigFolderStreamProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedConfigFolderStreamProvider.kt\ncom/intellij/openapi/project/impl/shared/SharedConfigFolderStreamProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,134:1\n67#2,4:135\n67#2,4:139\n67#2,4:143\n*S KotlinDebug\n*F\n+ 1 SharedConfigFolderStreamProvider.kt\ncom/intellij/openapi/project/impl/shared/SharedConfigFolderStreamProvider\n*L\n108#1:135,4\n119#1:139,4\n47#1:143,4\n*E\n"})
public final class SharedConfigFolderStreamProvider
implements StreamProvider,
StorageManagerFileWriteRequestor {
    @NotNull
    private final Path root;
    @NotNull
    private final ConfigFilesUpdatedByThisProcess configFilesUpdatedByThisProcess;
    private final boolean isExclusive;

    public SharedConfigFolderStreamProvider(@NotNull Path root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.root = root;
        this.configFilesUpdatedByThisProcess = new ConfigFilesUpdatedByThisProcess();
        this.isExclusive = true;
    }

    @NotNull
    public final ConfigFilesUpdatedByThisProcess getConfigFilesUpdatedByThisProcess$intellij_platform_ide_impl() {
        return this.configFilesUpdatedByThisProcess;
    }

    public boolean isExclusive() {
        return this.isExclusive;
    }

    public boolean read(@NotNull String fileSpec, @NotNull RoamingType roamingType, @NotNull Function1<? super InputStream, Unit> consumer) {
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (!this.isApplicable(fileSpec, roamingType)) {
            return false;
        }
        Path file2 = this.resolveSpec(fileSpec);
        if (this.checkFile(file2)) {
            try {
                SharedConfigFolderUtil.INSTANCE.readNonEmptyFileWithRetries$intellij_platform_ide_impl(file2, arg_0 -> SharedConfigFolderStreamProvider.read$lambda$0(consumer, file2, arg_0));
            }
            catch (JDOMException e) {
                this.processReadException((Exception)((Object)e), file2, consumer);
            }
            catch (XMLStreamException e) {
                this.processReadException(e, file2, consumer);
            }
            catch (IOException e) {
                this.processReadException(e, file2, consumer);
            }
        } else {
            consumer.invoke(null);
        }
        return true;
    }

    private final void processReadException(Exception e, Path file2, Function1<? super InputStream, Unit> consumer) {
        SharedConfigFolderStreamProviderKt.access$getLOG$p().warn((Throwable)e);
        Application app = ApplicationManager.getApplication();
        if (app != null && !app.isUnitTestMode() && !app.isHeadlessEnvironment()) {
            Object[] objectArray = new Object[]{file2, e.getMessage()};
            new Notification("Load Error", DiagnosticBundle.message("notification.cannot.load.settings.title", new Object[0]), DiagnosticBundle.message("notification.cannot.load.settings.content", objectArray), NotificationType.WARNING).notify(null);
        }
        consumer.invoke(null);
    }

    public boolean processChildren(@NotNull String path, @NotNull RoamingType roamingType, @NotNull Function1<? super String, Boolean> filter2, @NotNull Function3<? super String, ? super InputStream, ? super Boolean, Boolean> processor2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        Path file2 = this.root.resolve(path);
        Intrinsics.checkNotNull((Object)file2);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(file2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return true;
        }
        Files.walkFileTree(file2, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(filter2, this, processor2){
            final /* synthetic */ Function1<String, Boolean> $filter;
            final /* synthetic */ SharedConfigFolderStreamProvider this$0;
            final /* synthetic */ Function3<String, InputStream, Boolean, Boolean> $processor;
            {
                this.$filter = $filter;
                this.this$0 = $receiver;
                this.$processor = $processor;
            }

            public FileVisitResult visitFile(Path child, BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter((Object)child, (String)"child");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                if (!((Boolean)this.$filter.invoke((Object)PathsKt.getName((Path)child))).booleanValue()) {
                    return FileVisitResult.CONTINUE;
                }
                if (!SharedConfigFolderStreamProvider.access$checkFile(this.this$0, child)) {
                    return FileVisitResult.CONTINUE;
                }
                boolean abort = (Boolean)SharedConfigFolderUtil.INSTANCE.readNonEmptyFileWithRetries$intellij_platform_ide_impl(child, arg_0 -> processChildren.1.visitFile$lambda$0(this.$processor, child, arg_0));
                if (abort) {
                }
                return FileVisitResult.CONTINUE;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static final boolean visitFile$lambda$0(Function3 $processor, Path $child, InputStream stream) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                Closeable closeable = stream;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl2 = false;
                    bl = (Boolean)$processor.invoke((Object)PathsKt.getName((Path)$child), (Object)it, (Object)false) == false;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return bl;
            }
        });
        return true;
    }

    public void write(@NotNull String fileSpec, @NotNull byte[] content2, @NotNull RoamingType roamingType) {
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
        if (Intrinsics.areEqual((Object)fileSpec, (Object)"$CACHE_FILE$")) {
            return;
        }
        Path file2 = this.resolveSpec(fileSpec);
        Logger $this$trace$iv = SharedConfigFolderStreamProviderKt.access$getLOG$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("write " + content2.length + " bytes to " + file2);
        }
        this.configFilesUpdatedByThisProcess.saved(fileSpec, content2);
        SharedConfigFolderUtil.INSTANCE.writeToSharedFile(file2, content2);
    }

    public boolean delete(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
        if (!this.isApplicable(fileSpec, roamingType)) {
            return false;
        }
        Path file2 = this.resolveSpec(fileSpec);
        Logger $this$trace$iv = SharedConfigFolderStreamProviderKt.access$getLOG$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("delete " + file2);
        }
        this.configFilesUpdatedByThisProcess.deleted(fileSpec);
        SharedConfigFolderUtil.INSTANCE.deleteSharedFile(file2);
        return true;
    }

    private final Path resolveSpec(String fileSpec) {
        Path path = this.root.resolve(StoreUtilKt.getFileRelativeToRootConfig(fileSpec));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private final boolean checkFile(Path file2) {
        BasicFileAttributes attributes = PathKt.basicAttributesIfExists((Path)file2);
        return attributes != null && !attributes.isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit read$lambda$0(Function1 $consumer, Path $file, InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Logger $this$trace$iv = SharedConfigFolderStreamProviderKt.access$getLOG$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("read " + Files.size($file) + " bytes from " + $file);
        }
        Closeable closeable = stream;
        Throwable throwable = null;
        try {
            Object object = $consumer.invoke((Object)closeable);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$checkFile(SharedConfigFolderStreamProvider $this, Path file2) {
        return $this.checkFile(file2);
    }
}

