/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.updateSettings.PluginUpdateInfo;
import com.intellij.openapi.updateSettings.impl.InternalPluginResults;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateCheckerFacade;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLockAbsence;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/updateSettings/PluginUpdateCheckService;", "", "<init>", "()V", "getPluginUpdate", "Lcom/intellij/openapi/updateSettings/PluginUpdateInfo;", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nPluginUpdateCheckService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginUpdateCheckService.kt\ncom/intellij/openapi/updateSettings/PluginUpdateCheckService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,50:1\n23#2:51\n23#2:52\n*S KotlinDebug\n*F\n+ 1 PluginUpdateCheckService.kt\ncom/intellij/openapi/updateSettings/PluginUpdateCheckService\n*L\n32#1:51\n38#1:52\n*E\n"})
public final class PluginUpdateCheckService {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @RequiresBackgroundThread
    @RequiresReadLockAbsence
    @NotNull
    public final PluginUpdateInfo getPluginUpdate(@NotNull PluginId pluginId, @Nullable ProgressIndicator indicator2) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        ThreadingAssertions.assertBackgroundThread();
        ThreadingAssertions.assertNoOwnReadAccess();
        InternalPluginResults result2 = UpdateCheckerFacade.getPluginUpdates$default(UpdateCheckerFacade.Companion.getInstance(), CollectionsKt.listOf((Object)pluginId), indicator2, null, 4, null);
        Collection<PluginDownloader> updates = result2.getPluginUpdates().getAllEnabled();
        if (updates.size() > 1) {
            PluginUpdateCheckService $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PluginUpdateCheckService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("There are " + updates.size() + " plugin updates returned for a single plugin request");
            return new PluginUpdateInfo.NoUpdate();
        }
        if (!updates.isEmpty()) {
            if (!result2.getErrors().isEmpty()) {
                PluginUpdateCheckService $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(PluginUpdateCheckService.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Ignored failures on update check because an update found: " + result2.getErrors());
            }
            return new PluginUpdateInfo.UpdateAvailable((PluginDownloader)CollectionsKt.first((Iterable)updates));
        }
        if (!result2.getErrors().isEmpty()) {
            return new PluginUpdateInfo.CheckFailed(result2.getErrors());
        }
        return new PluginUpdateInfo.NoUpdate();
    }

    public static /* synthetic */ PluginUpdateInfo getPluginUpdate$default(PluginUpdateCheckService pluginUpdateCheckService, PluginId pluginId, ProgressIndicator progressIndicator, int n, Object object) {
        if ((n & 2) != 0) {
            progressIndicator = null;
        }
        return pluginUpdateCheckService.getPluginUpdate(pluginId, progressIndicator);
    }

    @JvmStatic
    @NotNull
    public static final PluginUpdateCheckService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/updateSettings/PluginUpdateCheckService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/openapi/updateSettings/PluginUpdateCheckService;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nPluginUpdateCheckService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginUpdateCheckService.kt\ncom/intellij/openapi/updateSettings/PluginUpdateCheckService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,50:1\n42#2,3:51\n*S KotlinDebug\n*F\n+ 1 PluginUpdateCheckService.kt\ncom/intellij/openapi/updateSettings/PluginUpdateCheckService$Companion\n*L\n20#1:51,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PluginUpdateCheckService getInstance() {
            boolean $i$f$service = false;
            Class<PluginUpdateCheckService> serviceClass$iv = PluginUpdateCheckService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (PluginUpdateCheckService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

