/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecordsImpl;
import com.intellij.util.containers.WeakInterner;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class FilePathInterner
extends WeakInterner<CharSequence> {
    private final FSRecordsImpl vfs;

    public FilePathInterner() {
        this(FSRecords.getInstance());
    }

    public FilePathInterner(@NotNull FSRecordsImpl vfs) {
        if (vfs == null) {
            FilePathInterner.$$$reportNull$$$0(0);
        }
        this.vfs = vfs;
    }

    @NotNull
    public CharSequence intern(@NotNull CharSequence path) {
        List names;
        int[] nameIds;
        if (path == null) {
            FilePathInterner.$$$reportNull$$$0(1);
        }
        CharSequence charSequence = (nameIds = (names = StringUtil.split((String)path.toString(), (String)"/")).stream().mapToInt(name2 -> this.vfs.getNameId((String)name2)).toArray()).length == 0 ? "" : (CharSequence)super.intern((Object)new FileSeparatedCharSequence(this.vfs, nameIds));
        if (charSequence == null) {
            FilePathInterner.$$$reportNull$$$0(2);
        }
        return charSequence;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/impl/FilePathInterner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/FilePathInterner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "intern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "intern";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static final class FileSeparatedCharSequence
    implements CharSequenceWithStringHash {
        @NotNull
        private final FSRecordsImpl vfs;
        private final int[] nameIds;
        private transient int hash;

        private FileSeparatedCharSequence(@NotNull FSRecordsImpl vfs, int @NotNull [] nameIds) {
            if (vfs == null) {
                FileSeparatedCharSequence.$$$reportNull$$$0(0);
            }
            if (nameIds == null) {
                FileSeparatedCharSequence.$$$reportNull$$$0(1);
            }
            this.vfs = vfs;
            this.nameIds = nameIds;
        }

        public int length() {
            int length = 0;
            for (int nameId : this.nameIds) {
                CharSequence name2 = this.nameByNameId(nameId);
                length += name2.length();
            }
            return length + this.nameIds.length - 1;
        }

        public char charAt(int index) {
            for (int n = 0; n < this.nameIds.length; ++n) {
                int nameId;
                CharSequence name2;
                if (n > 0) {
                    if (index == 0) {
                        return '/';
                    }
                    --index;
                }
                if (index < (name2 = this.nameByNameId(nameId = this.nameIds[n])).length()) {
                    return name2.charAt(index);
                }
                index -= name2.length();
            }
            throw new IndexOutOfBoundsException();
        }

        @NotNull
        public CharSequence subSequence(int start2, int end) {
            String string = this.toString().substring(start2, end);
            if (string == null) {
                FileSeparatedCharSequence.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String toString() {
            StringBuilder b = new StringBuilder(this.length() + this.nameIds.length - 1);
            for (int n = 0; n < this.nameIds.length; ++n) {
                if (n > 0 || !SystemInfo.isWindows) {
                    b.append('/');
                }
                int nameId = this.nameIds[n];
                CharSequence name2 = this.nameByNameId(nameId);
                b.append(name2);
            }
            String string = b.toString();
            if (string == null) {
                FileSeparatedCharSequence.$$$reportNull$$$0(3);
            }
            return string;
        }

        public int hashCode() {
            int h = this.hash;
            if (h == 0) {
                for (int n = 0; n < this.nameIds.length; ++n) {
                    if (n > 0 || !SystemInfo.isWindows) {
                        h = h * 31 + 47;
                    }
                    int nameId = this.nameIds[n];
                    CharSequence name2 = this.nameByNameId(nameId);
                    for (int i2 = 0; i2 < name2.length(); ++i2) {
                        char c = name2.charAt(i2);
                        h = h * 31 + c;
                    }
                }
                this.hash = h;
                return h;
            }
            return h;
        }

        @NotNull
        private CharSequence nameByNameId(int nameId) {
            String string = this.vfs.getNameByNameId(nameId);
            if (string == null) {
                FileSeparatedCharSequence.$$$reportNull$$$0(4);
            }
            return string;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FileSeparatedCharSequence)) {
                return false;
            }
            FileSeparatedCharSequence other = (FileSeparatedCharSequence)obj;
            return Arrays.equals(this.nameIds, other.nameIds);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vfs";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameIds";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/newvfs/impl/FilePathInterner$FileSeparatedCharSequence";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/FilePathInterner$FileSeparatedCharSequence";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "subSequence";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "nameByNameId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

