/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent.dev;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.newvfs.persistent.dev.DurablePersistentByteArrayImpl;
import com.intellij.openapi.vfs.newvfs.persistent.dev.DurablePersistentByteArrayKt;
import com.intellij.openapi.vfs.newvfs.persistent.dev.ImmutableVirtualByteArray;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.ResilientFileChannel;
import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\bg\u0018\u0000 \t2\u00060\u0001j\u0002`\u0002:\u0001\tJ\b\u0010\u0003\u001a\u00020\u0004H&J\u001c\u0010\u0005\u001a\u00020\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/vfs/newvfs/persistent/dev/DurablePersistentByteArray;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "getLastSnapshot", "", "commitChange", "modify", "Lkotlin/Function1;", "", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public interface DurablePersistentByteArray
extends AutoCloseable {
    @NotNull
    public static final Companion Companion = com.intellij.openapi.vfs.newvfs.persistent.dev.DurablePersistentByteArray$Companion.$$INSTANCE;
    public static final long INVALID_CHECKSUM = 160159261748363264L;
    public static final int FIRST_INSTANCE_MARK = 0x1A1A1A1A;
    public static final int SECOND_INSTANCE_MARK = 0x2B2B2B2;

    @NotNull
    public byte[] getLastSnapshot();

    @NotNull
    public byte[] commitChange(@NotNull Function1<? super byte[], Unit> var1);

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002$%B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0016H\u0002J,\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000bH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/openapi/vfs/newvfs/persistent/dev/DurablePersistentByteArray$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG$intellij_platform_ide_impl", "()Lcom/intellij/openapi/diagnostic/Logger;", "INVALID_CHECKSUM", "", "FIRST_INSTANCE_MARK", "", "SECOND_INSTANCE_MARK", "open", "Lcom/intellij/openapi/vfs/newvfs/persistent/dev/DurablePersistentByteArray;", "path", "Ljava/nio/file/Path;", "mode", "Lcom/intellij/openapi/vfs/newvfs/persistent/dev/DurablePersistentByteArray$Companion$OpenMode;", "size", "makeDefaultValue", "Lkotlin/Function0;", "", "createInitialState", "", "layoutBuilder", "Lcom/intellij/openapi/vfs/newvfs/persistent/dev/DurablePersistentByteArrayImpl$Companion$CompactLayoutBuilder;", "defaultValue", "recoverLastState", "Lkotlin/Pair;", "", "fileHandler", "Lcom/intellij/util/io/ResilientFileChannel;", "layout", "Lcom/intellij/openapi/vfs/newvfs/persistent/dev/DurablePersistentByteArrayImpl$Companion$LayoutHandler;", "expectedSize", "OpenMode", "IncompatibleLayoutException", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nDurablePersistentByteArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DurablePersistentByteArray.kt\ncom/intellij/openapi/vfs/newvfs/persistent/dev/DurablePersistentByteArray$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,390:1\n60#2,5:391\n60#2,5:396\n60#2,5:402\n13#2:407\n1#3:401\n*S KotlinDebug\n*F\n+ 1 DurablePersistentByteArray.kt\ncom/intellij/openapi/vfs/newvfs/persistent/dev/DurablePersistentByteArray$Companion\n*L\n157#1:391,5\n178#1:396,5\n167#1:402,5\n47#1:407\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final Logger LOG;
        public static final long INVALID_CHECKSUM = 160159261748363264L;
        public static final int FIRST_INSTANCE_MARK = 0x1A1A1A1A;
        public static final int SECOND_INSTANCE_MARK = 0x2B2B2B2;

        private Companion() {
        }

        @NotNull
        public final Logger getLOG$intellij_platform_ide_impl() {
            return LOG;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final DurablePersistentByteArray open(@NotNull Path path, @NotNull OpenMode mode, int size2, @NotNull Function0<byte[]> makeDefaultValue) throws IncompatibleLayoutException, IOException {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            Intrinsics.checkNotNullParameter(makeDefaultValue, (String)"makeDefaultValue");
            DurablePersistentByteArrayImpl.Companion.CompactLayoutBuilder layoutBuilder = DurablePersistentByteArrayImpl.Companion.CompactLayoutBuilder.INSTANCE;
            if (!(1 <= size2 ? size2 <= layoutBuilder.getMaxStateSize() : false)) {
                boolean bl = false;
                String string = "size=" + size2 + " must be in 1.." + layoutBuilder.getMaxStateSize();
                throw new IllegalArgumentException(string.toString());
            }
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Closeable closeable = (Closeable)new ResilientFileChannel(path, mode.getOpenOptions());
                Throwable throwable = null;
                try {
                    ResilientFileChannel fileHandler = (ResilientFileChannel)closeable;
                    boolean bl = false;
                    DurablePersistentByteArrayImpl.Companion.LayoutHandler layout2 = layoutBuilder.buildLayout((FileChannel)fileHandler, size2);
                    Pair<byte[], Boolean> pair = $$INSTANCE.recoverLastState(fileHandler, layout2, size2);
                    byte[] lastState = (byte[])pair.component1();
                    boolean lastStateIsInSecondInstance = (Boolean)pair.component2();
                    DurablePersistentByteArray durablePersistentByteArray = new DurablePersistentByteArrayImpl(path, mode, layout2, lastStateIsInSecondInstance, lastState);
                    return durablePersistentByteArray;
                }
                catch (Throwable bl) {
                    throwable = bl;
                    throw bl;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
                case 1: {
                    byte[] byArray = (byte[])makeDefaultValue.invoke();
                    byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(...)");
                    return new ImmutableVirtualByteArray(path, byArray2);
                }
                case 2: {
                    byte[] byArray = (byte[])makeDefaultValue.invoke();
                    byte[] byArray3 = Arrays.copyOf(byArray, byArray.length);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"copyOf(...)");
                    byte[] defaultValue = byArray3;
                    if (!(defaultValue.length == size2)) {
                        String layout2 = "Failed requirement.";
                        throw new IllegalArgumentException(layout2.toString());
                    }
                    FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                    Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(PathKt.createParentDirectories((Path)path), Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(...)");
                    this.createInitialState(path, layoutBuilder, defaultValue);
                    ResilientFileChannel fileHandler = new ResilientFileChannel(path, mode.getOpenOptions());
                    DurablePersistentByteArrayImpl.Companion.LayoutHandler layout3 = layoutBuilder.buildLayout((FileChannel)fileHandler, size2);
                    return new DurablePersistentByteArrayImpl(path, mode, layout3, false, defaultValue);
                }
            }
            throw new NoWhenBranchMatchedException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void createInitialState(Path path, DurablePersistentByteArrayImpl.Companion.CompactLayoutBuilder layoutBuilder, byte[] defaultValue) {
            CopyOption[] copyOptionArray;
            Path initPath = path.resolveSibling(path.getFileName() + ".init");
            Intrinsics.checkNotNull((Object)initPath);
            Path path2 = initPath;
            Object object = new LinkOption[]{};
            if (!Files.exists(path2, Arrays.copyOf(object, ((LinkOption[])object).length))) {
                path2 = PathKt.createParentDirectories((Path)initPath);
                object = new FileAttribute[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(path2, (FileAttribute[])Arrays.copyOf(object, ((Object[])object).length)), (String)"createFile(...)");
            }
            int size2 = defaultValue.length;
            object = layoutBuilder.buildLayout((FileChannel)new ResilientFileChannel(initPath, OpenMode.ReadWrite.getOpenOptions()), size2);
            Throwable throwable = null;
            try {
                DurablePersistentByteArrayImpl.Companion.LayoutHandler it = (DurablePersistentByteArrayImpl.Companion.LayoutHandler)object;
                boolean bl = false;
                int checkSum = DurablePersistentByteArrayKt.access$getCheckSum(defaultValue);
                it.writeHeader(1, size2, 0x1A1A1A1A, checkSum, checkSum);
                it.writeState(defaultValue, false);
                it.writeState(defaultValue, true);
                it.flush();
                copyOptionArray = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
            object = initPath;
            copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            CopyOption[] copyOptionArray2 = copyOptionArray;
            Intrinsics.checkNotNullExpressionValue((Object)Files.move((Path)object, path, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length)), (String)"move(...)");
        }

        private final Pair<byte[], Boolean> recoverLastState(ResilientFileChannel fileHandler, DurablePersistentByteArrayImpl.Companion.LayoutHandler layout2, int expectedSize) {
            byte[] probableLastState;
            boolean useSecondInstance;
            Logger logger;
            boolean $i$f$debug;
            Throwable t$iv;
            Logger $this$debug_u24default$iv;
            if (fileHandler.size() != (long)layout2.getFullSize()) {
                throw new IncompatibleLayoutException(this + ": file length (=" + fileHandler.size() + ") doesn't match the expected length (" + layout2.getFullSize() + ")");
            }
            int version = layout2.readVersion();
            if (version != 1) {
                throw new IncompatibleLayoutException(this + ": binary version mismatch (file version=" + version + " vs current=1)");
            }
            int stateSize = layout2.readSize();
            if (stateSize != expectedSize) {
                throw new IncompatibleLayoutException(this + ": state size mismatch (file state size=" + stateSize + " vs expected=" + expectedSize + ")");
            }
            int instanceValue = layout2.readCurrentInstance();
            switch (instanceValue) {
                case 0x1A1A1A1A: {
                    boolean bl = false;
                    break;
                }
                case 0x2B2B2B2: {
                    boolean bl = true;
                    break;
                }
                default: {
                    $this$debug_u24default$iv = LOG;
                    t$iv = null;
                    $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        logger = $this$debug_u24default$iv;
                        boolean bl = false;
                        logger.debug("instance value is broken: " + instanceValue, t$iv);
                    }
                    boolean bl = useSecondInstance = false;
                }
            }
            if (probableLastState != null) {
                probableLastState = com.intellij.openapi.vfs.newvfs.persistent.dev.DurablePersistentByteArray$Companion.recoverLastState$tryReadState(layout2, expectedSize, useSecondInstance);
                return TuplesKt.to((Object)probableLastState, (Object)useSecondInstance);
            }
            $this$debug_u24default$iv = LOG;
            t$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug($$INSTANCE + ": probable state read failed (second instance=" + useSecondInstance + "), trying the other one", t$iv);
            }
            byte[] fallbackState = com.intellij.openapi.vfs.newvfs.persistent.dev.DurablePersistentByteArray$Companion.recoverLastState$tryReadState(layout2, expectedSize, !useSecondInstance);
            if (!(fallbackState != null)) {
                boolean bl = false;
                String string = $$INSTANCE + ": state recovery failed: both instances are corrupted ";
                throw new IllegalStateException(string.toString());
            }
            return TuplesKt.to((Object)fallbackState, (Object)(!useSecondInstance ? 1 : 0));
        }

        private static final byte[] recoverLastState$tryReadState(DurablePersistentByteArrayImpl.Companion.LayoutHandler $layout, int $expectedSize, boolean useSecondInstance) {
            long checkSum;
            byte[] stateArr = $layout.readState($expectedSize, useSecondInstance);
            long stateCheckSum = DurablePersistentByteArrayKt.access$getCheckSum(stateArr);
            if (stateCheckSum != (checkSum = $layout.readCheckSum(useSecondInstance))) {
                Logger $this$debug_u24default$iv = LOG;
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    String string = Long.toString(stateCheckSum, CharsKt.checkRadix((int)16));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    String string2 = Long.toString(checkSum, CharsKt.checkRadix((int)16));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                    logger.debug($$INSTANCE + ": state (second instance=" + useSecondInstance + ") checksum mismatch: state checksum=0x" + string + " vs stored checksum=0x" + string2, t$iv);
                }
                return null;
            }
            return stateArr;
        }

        static {
            $$INSTANCE = new Companion();
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(DurablePersistentByteArray.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            LOG = logger;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vfs/newvfs/persistent/dev/DurablePersistentByteArray$Companion$IncompatibleLayoutException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "<init>", "(Ljava/lang/String;)V", "intellij.platform.ide.impl"})
        public static final class IncompatibleLayoutException
        extends Exception {
            public IncompatibleLayoutException(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                super(message);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vfs/newvfs/persistent/dev/DurablePersistentByteArray$Companion$OpenMode;", "", "openOptions", "", "Ljava/nio/file/OpenOption;", "<init>", "(Ljava/lang/String;ILjava/util/Set;)V", "getOpenOptions", "()Ljava/util/Set;", "Read", "ReadWrite", "intellij.platform.ide.impl"})
        public static final class OpenMode
        extends Enum<OpenMode> {
            @NotNull
            private final Set<OpenOption> openOptions;
            public static final /* enum */ OpenMode Read;
            public static final /* enum */ OpenMode ReadWrite;
            private static final /* synthetic */ OpenMode[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private OpenMode(Set<? extends OpenOption> openOptions) {
                this.openOptions = openOptions;
            }

            @NotNull
            public final Set<OpenOption> getOpenOptions() {
                return this.openOptions;
            }

            public static OpenMode[] values() {
                return (OpenMode[])$VALUES.clone();
            }

            public static OpenMode valueOf(String value) {
                return Enum.valueOf(OpenMode.class, value);
            }

            @NotNull
            public static EnumEntries<OpenMode> getEntries() {
                return $ENTRIES;
            }

            static {
                EnumSet<Enum> enumSet = EnumSet.of((Enum)StandardOpenOption.READ);
                Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
                Read = new OpenMode((Set<? extends OpenOption>)enumSet);
                EnumSet<Enum> enumSet2 = EnumSet.of((Enum)StandardOpenOption.READ, (Enum)StandardOpenOption.WRITE);
                Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"of(...)");
                ReadWrite = new OpenMode((Set<? extends OpenOption>)enumSet2);
                $VALUES = openModeArray = new OpenMode[]{OpenMode.Read, OpenMode.ReadWrite};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[OpenMode.values().length];
                try {
                    nArray[OpenMode.Read.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OpenMode.ReadWrite.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

