/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.ui.MaximizeDialogKt;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutineSupport;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.WindowInfo;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.FloatingDecoratorMarker;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.openapi.wm.impl.ToolWindowExternalDecorator;
import com.intellij.openapi.wm.impl.ToolWindowExternalDecoratorBoundsHelper;
import com.intellij.openapi.wm.impl.ToolWindowExternalDecoratorKt;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.toolWindow.InternalDecoratorImpl;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.DisposableWindow;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ToolbarService;
import com.intellij.ui.WindowRoundedCornersManager;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.util.Alarm;
import com.intellij.util.MathUtil;
import com.intellij.util.SingleEdtTaskScheduler;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBInsets;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import kotlin.Unit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class FloatingDecorator
extends JDialog
implements FloatingDecoratorMarker,
ToolWindowExternalDecorator,
DisposableWindow {
    private static final Logger LOG = Logger.getInstance(FloatingDecorator.class);
    static final int DIVIDER_WIDTH = 3;
    private static final int ANCHOR_TOP = 1;
    private static final int ANCHOR_LEFT = 2;
    private static final int ANCHOR_BOTTOM = 4;
    private static final int ANCHOR_RIGHT = 8;
    private static final int DELAY = 15;
    private static final int TOTAL_FRAME_COUNT = 7;
    private final MyUISettingsListener uiSettingsListener;
    @NotNull
    private final InternalDecoratorImpl myDecorator;
    private WindowInfo myInfo;
    @NotNull
    private final ToolWindowExternalDecoratorBoundsHelper myBoundsHelper;
    private final Disposable disposable;
    private boolean myDisposed;
    private final SingleEdtTaskScheduler delayAlarm;
    private final Alarm myFrameTicker;
    private final MyAnimator myAnimator;
    private int myCurrentFrame;
    private float myStartRatio;
    private float myEndRatio;

    FloatingDecorator(@NotNull JFrame owner, final @NotNull InternalDecoratorImpl decorator) {
        if (owner == null) {
            FloatingDecorator.$$$reportNull$$$0(0);
        }
        if (decorator == null) {
            FloatingDecorator.$$$reportNull$$$0(1);
        }
        super((Frame)owner, decorator.toolWindow.getStripeTitle());
        this.myBoundsHelper = new ToolWindowExternalDecoratorBoundsHelper(this);
        this.disposable = Disposer.newDisposable();
        this.myDisposed = false;
        this.delayAlarm = SingleEdtTaskScheduler.createSingleEdtTaskScheduler((CoroutineSupport.UiDispatcherKind)CoroutineSupport.UiDispatcherKind.STRICT);
        this.myDecorator = decorator;
        ClientProperty.put((Window)this, (Key)DECORATOR_PROPERTY, (Object)this);
        MnemonicHelper.init((Component)this.getContentPane());
        this.setDefaultCloseOperation(0);
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        if (SystemInfo.isWindows) {
            this.setUndecorated(true);
            contentPane.add((Component)new BorderItem(1), "North");
            contentPane.add((Component)new BorderItem(2), "West");
            contentPane.add((Component)new BorderItem(4), "South");
            contentPane.add((Component)new BorderItem(8), "East");
            contentPane.add((Component)((Object)decorator), "Center");
        } else {
            contentPane.add((Component)((Object)decorator), "Center");
        }
        this.setDefaultCloseOperation(0);
        final ToolWindowImpl toolWindow2 = decorator.toolWindow;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Updating floating window " + toolWindow2.getId() + " bounds because it's closed: " + String.valueOf(FloatingDecorator.this.getBounds()));
                }
                toolWindow2.toolWindowManager.movedOrResized(decorator);
                toolWindow2.toolWindowManager.hideToolWindow(toolWindow2.getId(), false);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Floating tool window " + toolWindow2.getId() + " moved to " + String.valueOf(FloatingDecorator.this.getBounds()) + ", scheduling bounds update");
                }
                toolWindow2.onMovedOrResized();
            }
        });
        this.myFrameTicker = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this.disposable);
        this.myAnimator = new MyAnimator();
        this.myCurrentFrame = 0;
        this.myStartRatio = 0.0f;
        this.myEndRatio = 0.0f;
        this.uiSettingsListener = new MyUISettingsListener();
        IdeGlassPaneImpl ideGlassPane = new IdeGlassPaneImpl(this.getRootPane(), true);
        this.getRootPane().setGlassPane(ideGlassPane);
        ideGlassPane.addMousePreprocessor(new MouseAdapter(this){}, this.disposable);
        if (SystemInfo.isWindows && WindowRoundedCornersManager.isAvailable()) {
            WindowRoundedCornersManager.setRoundedCorners(this);
        }
        MaximizeDialogKt.setMaximizeButtonShown(this, true);
    }

    @Override
    public void show() {
        ComponentUtil.decorateWindowHeader((JRootPane)this.rootPane);
        ToolbarService.Companion.getInstance().setTransparentTitleBar((Window)this, this.rootPane, runnable2 -> {
            Disposer.register((Disposable)this.disposable, () -> runnable2.run());
            return Unit.INSTANCE;
        });
        boolean isActive = this.myInfo.isActiveOnStart();
        this.setAutoRequestFocus(isActive);
        try {
            super.show();
        }
        finally {
            this.setAutoRequestFocus(true);
        }
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings.getState().getEnableAlphaMode()) {
            WindowManagerEx windowManager = WindowManagerEx.getInstanceEx();
            windowManager.setAlphaModeEnabled(this, true);
            if (isActive) {
                windowManager.setAlphaModeRatio(this, 0.0f);
            } else {
                windowManager.setAlphaModeRatio(this, uiSettings.getState().getAlphaModeRatio());
            }
        }
        this.paint(GraphicsUtil.safelyGetGraphics((Component)this));
        ApplicationManager.getApplication().getMessageBus().connect(this.disposable).subscribe(UISettingsListener.TOPIC, (Object)this.uiSettingsListener);
    }

    @Override
    public void dispose() {
        if (ScreenUtil.isStandardAddRemoveNotify((Component)this.getParent())) {
            this.delayAlarm.dispose();
            Disposer.dispose((Disposable)this.disposable);
        } else if (this.isShowing()) {
            SwingUtilities.invokeLater(() -> this.show());
        }
        super.dispose();
        this.myDisposed = true;
    }

    public boolean isWindowDisposed() {
        return this.myDisposed;
    }

    @Override
    @NotNull
    public Window getWindow() {
        FloatingDecorator floatingDecorator = this;
        if (floatingDecorator == null) {
            FloatingDecorator.$$$reportNull$$$0(2);
        }
        return floatingDecorator;
    }

    @Override
    @NotNull
    public String getId() {
        String string = this.myDecorator.getToolWindowId();
        if (string == null) {
            FloatingDecorator.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public void setLocationRelativeTo(Component c) {
        super.setLocationRelativeTo(c);
        this.myBoundsHelper.setBounds(this.getBounds());
    }

    @Override
    @NotNull
    public Rectangle getVisibleWindowBounds() {
        Rectangle result2 = this.getBounds();
        JBInsets.removeFrom((Rectangle)result2, (Insets)ToolWindowExternalDecoratorKt.getInvisibleInsets(this));
        Rectangle rectangle = result2;
        if (rectangle == null) {
            FloatingDecorator.$$$reportNull$$$0(4);
        }
        return rectangle;
    }

    @Override
    public void setVisibleWindowBounds(@NotNull Rectangle r) {
        if (r == null) {
            FloatingDecorator.$$$reportNull$$$0(5);
        }
        this.myBoundsHelper.setBounds(r);
        Rectangle newBounds = new Rectangle(r);
        JBInsets.addTo((Rectangle)newBounds, (Insets)ToolWindowExternalDecoratorKt.getInvisibleInsets(this));
        super.setBounds(newBounds);
    }

    @Override
    @NotNull
    public ToolWindowType getToolWindowType() {
        ToolWindowType toolWindowType = ToolWindowType.FLOATING;
        if (toolWindowType == null) {
            FloatingDecorator.$$$reportNull$$$0(6);
        }
        return toolWindowType;
    }

    @Override
    @ApiStatus.Internal
    public void apply(@NotNull WindowInfo info) {
        if (info == null) {
            FloatingDecorator.$$$reportNull$$$0(7);
        }
        LOG.assertTrue(info.getType() == ToolWindowType.FLOATING);
        this.myInfo = info;
        this.applyBounds(info);
        this.applyAlphaMode(info);
    }

    private void applyBounds(WindowInfo info) {
        Rectangle bounds = info.getFloatingBounds();
        if (bounds != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Applying floating tool window " + info.getId() + " bounds from window info: " + String.valueOf(bounds));
            }
            this.setVisibleWindowBounds(bounds);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Window " + info.getId() + " info has no floating bounds, not applying anything");
        }
    }

    private void applyAlphaMode(@NotNull WindowInfo info) {
        UISettings uiSettings;
        if (info == null) {
            FloatingDecorator.$$$reportNull$$$0(8);
        }
        if (!((uiSettings = UISettings.getInstance()).getState().getEnableAlphaMode() && this.isShowing() && this.isDisplayable())) {
            return;
        }
        this.delayAlarm.cancel();
        if (info.isActiveOnStart()) {
            this.myFrameTicker.cancelAllRequests();
            this.myStartRatio = this.getCurrentAlphaRatio();
            if (this.myCurrentFrame > 0) {
                this.myCurrentFrame = 7 - this.myCurrentFrame;
            }
            this.myEndRatio = 0.0f;
            this.myFrameTicker.addRequest((Runnable)this.myAnimator, 15);
        } else {
            this.delayAlarm.request((long)uiSettings.getState().getAlphaModeDelay(), () -> {
                this.myFrameTicker.cancelAllRequests();
                this.myStartRatio = this.getCurrentAlphaRatio();
                if (this.myCurrentFrame > 0) {
                    this.myCurrentFrame = 7 - this.myCurrentFrame;
                }
                this.myEndRatio = uiSettings.getState().getAlphaModeRatio();
                this.myFrameTicker.addRequest((Runnable)this.myAnimator, 15);
            });
        }
    }

    private float getCurrentAlphaRatio() {
        float delta = (this.myEndRatio - this.myStartRatio) / 7.0f;
        if (this.myStartRatio > this.myEndRatio) {
            delta *= 2.0f;
        }
        float ratio = this.myStartRatio + (float)this.myCurrentFrame * delta;
        return MathUtil.clamp((float)ratio, (float)0.0f, (float)1.0f);
    }

    @Override
    public void reshape(int x, int y, int width, int height) {
        if (this.myDecorator == null) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace(new Throwable("FloatingDecorator " + this.myDecorator.toolWindow.getId() + " bounds changed to " + x + ", " + y + ", " + width + ", " + height));
        }
        super.reshape(x, y, width, height);
    }

    @Override
    @NotNull
    public Logger log() {
        Logger logger = LOG;
        if (logger == null) {
            FloatingDecorator.$$$reportNull$$$0(9);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/FloatingDecorator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/FloatingDecorator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWindow";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleWindowBounds";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "log";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setVisibleWindowBounds";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyAlphaMode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6, 9 -> new IllegalStateException(string);
        };
    }

    private final class BorderItem
    extends JPanel {
        private static final int RESIZER_WIDTH = 10;
        private final int myAnchor;
        private int myMotionMask;
        private Point myLastPoint;
        private boolean myDragging;

        BorderItem(int anchor) {
            this.myAnchor = anchor;
            this.enableEvents(48L);
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent e) {
            super.processMouseMotionEvent(e);
            if (506 == e.getID() && this.myLastPoint != null) {
                Point offset;
                Point newPoint = e.getPoint();
                SwingUtilities.convertPointToScreen(newPoint, this);
                Rectangle screenBounds = WindowManagerEx.getInstanceEx().getScreenBounds();
                int screenMaxX = screenBounds.x + screenBounds.width;
                int screenMaxY = screenBounds.y + screenBounds.height;
                newPoint.x = MathUtil.clamp((int)newPoint.x, (int)screenBounds.x, (int)screenMaxX);
                newPoint.y = MathUtil.clamp((int)newPoint.y, (int)screenBounds.y, (int)screenMaxY);
                Rectangle oldBounds = FloatingDecorator.this.getBounds();
                Rectangle newBounds = new Rectangle(oldBounds);
                if ((this.myMotionMask & 1) > 0) {
                    newPoint.y = Math.min(newPoint.y, oldBounds.y + oldBounds.height - 6);
                    if (newPoint.y < screenBounds.y + 3) {
                        newPoint.y = screenBounds.y;
                    }
                    offset = new Point(newPoint.x - this.myLastPoint.x, newPoint.y - this.myLastPoint.y);
                    newBounds.y = oldBounds.y + offset.y;
                    newBounds.height = oldBounds.height - offset.y;
                }
                if ((this.myMotionMask & 2) > 0) {
                    newPoint.x = Math.min(newPoint.x, oldBounds.x + oldBounds.width - 6);
                    if (newPoint.x < screenBounds.x + 3) {
                        newPoint.x = screenBounds.x;
                    }
                    offset = new Point(newPoint.x - this.myLastPoint.x, newPoint.y - this.myLastPoint.y);
                    newBounds.x = oldBounds.x + offset.x;
                    newBounds.width = oldBounds.width - offset.x;
                }
                if ((this.myMotionMask & 4) > 0) {
                    newPoint.y = Math.max(newPoint.y, oldBounds.y + 6);
                    if (newPoint.y > screenMaxY - 3) {
                        newPoint.y = screenMaxY;
                    }
                    offset = new Point(newPoint.x - this.myLastPoint.x, newPoint.y - this.myLastPoint.y);
                    newBounds.height = oldBounds.height + offset.y;
                }
                if ((this.myMotionMask & 8) > 0) {
                    newPoint.x = Math.max(newPoint.x, oldBounds.x + 6);
                    if (newPoint.x > screenMaxX - 3) {
                        newPoint.x = screenMaxX;
                    }
                    offset = new Point(newPoint.x - this.myLastPoint.x, newPoint.y - this.myLastPoint.y);
                    newBounds.width = oldBounds.width + offset.x;
                }
                FloatingDecorator.this.setBounds(newBounds.x, newBounds.y, newBounds.width, newBounds.height);
                this.myLastPoint = newPoint;
            } else if (e.getID() == 503 && !this.myDragging) {
                this.setMotionMask(e.getPoint());
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
            switch (e.getID()) {
                case 501: {
                    this.myLastPoint = e.getPoint();
                    SwingUtilities.convertPointToScreen(this.myLastPoint, this);
                    this.setMotionMask(e.getPoint());
                    this.myDragging = true;
                    break;
                }
                case 502: {
                    FloatingDecorator.this.validate();
                    FloatingDecorator.this.repaint();
                    this.myDragging = false;
                    break;
                }
                case 504: {
                    if (this.myDragging) break;
                    this.setMotionMask(e.getPoint());
                }
            }
        }

        private void setMotionMask(Point p) {
            this.myMotionMask = this.myAnchor;
            if (1 == this.myAnchor || 4 == this.myAnchor) {
                if (p.getX() < 10.0) {
                    this.myMotionMask |= 2;
                } else if (p.getX() > (double)(this.getWidth() - 10)) {
                    this.myMotionMask |= 8;
                }
            } else if (p.getY() < 10.0) {
                this.myMotionMask |= 1;
            } else if (p.getY() > (double)(this.getHeight() - 10)) {
                this.myMotionMask |= 4;
            }
            if (this.myMotionMask == 1) {
                this.setCursor(Cursor.getPredefinedCursor(8));
            } else if (this.myMotionMask == 3) {
                this.setCursor(Cursor.getPredefinedCursor(6));
            } else if (this.myMotionMask == 2) {
                this.setCursor(Cursor.getPredefinedCursor(10));
            } else if (this.myMotionMask == 6) {
                this.setCursor(Cursor.getPredefinedCursor(4));
            } else if (this.myMotionMask == 4) {
                this.setCursor(Cursor.getPredefinedCursor(9));
            } else if (this.myMotionMask == 12) {
                this.setCursor(Cursor.getPredefinedCursor(5));
            } else if (this.myMotionMask == 8) {
                this.setCursor(Cursor.getPredefinedCursor(11));
            } else if (this.myMotionMask == 9) {
                this.setCursor(Cursor.getPredefinedCursor(7));
            }
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            if (1 == this.myAnchor || 4 == this.myAnchor) {
                d.height = 3;
            } else {
                d.width = 3;
            }
            return d;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            JBColor lightGray = new JBColor((Color)JBColor.LIGHT_GRAY, (Color)Gray._95);
            JBColor gray = new JBColor((Color)JBColor.GRAY, (Color)Gray._95);
            if (1 == this.myAnchor) {
                g.setColor((Color)lightGray);
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)0.0, (double)0.0, (double)(this.getWidth() - 1), (double)0.0);
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)0.0, (double)0.0, (double)0.0, (double)(this.getHeight() - 1));
                g.setColor((Color)JBColor.GRAY);
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(this.getWidth() - 1), (double)0.0, (double)(this.getWidth() - 1), (double)(this.getHeight() - 1));
            } else if (2 == this.myAnchor) {
                g.setColor((Color)lightGray);
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)0.0, (double)0.0, (double)0.0, (double)(this.getHeight() - 1));
            } else {
                if (4 == this.myAnchor) {
                    g.setColor((Color)lightGray);
                    LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)0.0, (double)0.0, (double)0.0, (double)(this.getHeight() - 1));
                    g.setColor((Color)gray);
                    LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)0.0, (double)(this.getHeight() - 1), (double)(this.getWidth() - 1), (double)(this.getHeight() - 1));
                } else {
                    g.setColor((Color)gray);
                }
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(this.getWidth() - 1), (double)0.0, (double)(this.getWidth() - 1), (double)(this.getHeight() - 1));
            }
        }
    }

    private final class MyAnimator
    implements Runnable {
        private MyAnimator() {
        }

        @Override
        public void run() {
            if (FloatingDecorator.this.isDisplayable() && FloatingDecorator.this.isShowing()) {
                WindowManager.getInstance().setAlphaModeRatio((Window)FloatingDecorator.this, FloatingDecorator.this.getCurrentAlphaRatio());
            }
            if (FloatingDecorator.this.myCurrentFrame < 7) {
                ++FloatingDecorator.this.myCurrentFrame;
                FloatingDecorator.this.myFrameTicker.addRequest((Runnable)FloatingDecorator.this.myAnimator, 15);
            } else {
                FloatingDecorator.this.myFrameTicker.cancelAllRequests();
            }
        }
    }

    private final class MyUISettingsListener
    implements UISettingsListener {
        private MyUISettingsListener() {
        }

        public void uiSettingsChanged(@NotNull UISettings uiSettings) {
            if (uiSettings == null) {
                MyUISettingsListener.$$$reportNull$$$0(0);
            }
            LOG.assertTrue(FloatingDecorator.this.isDisplayable());
            LOG.assertTrue(FloatingDecorator.this.isShowing());
            WindowManager windowManager = WindowManager.getInstance();
            FloatingDecorator.this.delayAlarm.cancel();
            if (uiSettings.getState().getEnableAlphaMode()) {
                if (!FloatingDecorator.this.isActive()) {
                    windowManager.setAlphaModeEnabled((Window)FloatingDecorator.this, true);
                    windowManager.setAlphaModeRatio((Window)FloatingDecorator.this, uiSettings.getState().getAlphaModeRatio());
                }
            } else {
                windowManager.setAlphaModeEnabled((Window)FloatingDecorator.this, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiSettings", "com/intellij/openapi/wm/impl/FloatingDecorator$MyUISettingsListener", "uiSettingsChanged"));
        }
    }
}

