/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.FocusManagerImpl;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.system.OS;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UnixDesktopEnv;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.swing.JFrame;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.AWTAccessor;

@ApiStatus.Internal
public final class X11UiUtil {
    private static final Logger LOG = Logger.getInstance(X11UiUtil.class);
    private static final int True = 1;
    private static final int False = 0;
    private static final long XA_ATOM = 4L;
    private static final long XA_WINDOW = 33L;
    private static final long ANY_PROPERTY_TYPE = 0L;
    private static final int CLIENT_MESSAGE = 33;
    private static final int FORMAT_LONG = 32;
    private static final long EVENT_MASK = 0x180000L;
    private static final long NET_WM_STATE_REMOVE = 0L;
    private static final long NET_WM_STATE_ADD = 1L;
    private static final long NET_WM_STATE_TOGGLE = 2L;
    public static final String KDE_LAF_PROPERTY = "LookAndFeelPackage=";
    public static final Set<String> TILE_WM = Set.of("awesome", "bspwm", "cagebreak", "compiz", "dwl", "dwm", "frankenwm", "herbstluftwm", "hyprland", "i3", "ion", "larswm", "leftwm", "notion", "qtile", "ratpoison", "river", "snapwm", "spectrwm", "stumpwm", "sway", "wmii", "xmonad");
    private static final String GSETTINGS_COMMAND = "gsettings";
    private static final ConcurrentHashMap<String, Boolean> unsupportedCommands = new ConcurrentHashMap();
    @Nullable
    private static final Xlib X11 = Xlib.getInstance();

    public static boolean isInitialized() {
        return X11 != null;
    }

    public static boolean isFullScreenSupported() {
        if (X11 == null) {
            return false;
        }
        List<ProjectFrameHelper> frames = WindowManagerEx.getInstanceEx().getProjectFrameHelpers();
        if (frames.isEmpty()) {
            return true;
        }
        IdeFrameImpl frame = frames.getFirst().getFrame();
        return X11UiUtil.hasWindowProperty(frame, X11UiUtil.X11.NET_WM_ALLOWED_ACTIONS, X11UiUtil.X11.NET_WM_ACTION_FULLSCREEN);
    }

    public static boolean isInFullScreenMode(JFrame frame) {
        return X11 != null && X11UiUtil.hasWindowProperty(frame, X11UiUtil.X11.NET_WM_STATE, X11UiUtil.X11.NET_WM_STATE_FULLSCREEN);
    }

    public static boolean isVMaximized(JFrame frame) {
        return X11 != null && X11UiUtil.hasWindowProperty(frame, X11UiUtil.X11.NET_WM_STATE, X11UiUtil.X11.NET_WM_STATE_MAXIMIZED_VERT);
    }

    public static boolean isHMaximized(JFrame frame) {
        return X11 != null && X11UiUtil.hasWindowProperty(frame, X11UiUtil.X11.NET_WM_STATE, X11UiUtil.X11.NET_WM_STATE_MAXIMIZED_HORZ);
    }

    public static void setMaximized(JFrame frame, boolean maximized) {
        if (X11 == null) {
            return;
        }
        if (maximized) {
            X11.sendClientMessage(frame, "set Maximized mode", X11UiUtil.X11.NET_WM_STATE, 1L, X11UiUtil.X11.NET_WM_STATE_MAXIMIZED_HORZ, X11UiUtil.X11.NET_WM_STATE_MAXIMIZED_VERT);
        } else {
            X11.sendClientMessage(frame, "reset Maximized mode", X11UiUtil.X11.NET_WM_STATE, 0L, X11UiUtil.X11.NET_WM_STATE_MAXIMIZED_HORZ, X11UiUtil.X11.NET_WM_STATE_MAXIMIZED_VERT);
        }
    }

    public static boolean isWSL() {
        return OS.isGenericUnix() && System.getenv("WSL_DISTRO_NAME") != null;
    }

    public static boolean isTileWM() {
        String desktop = System.getenv("XDG_CURRENT_DESKTOP");
        return OS.isGenericUnix() && desktop != null && TILE_WM.contains(desktop.toLowerCase(Locale.ENGLISH));
    }

    public static boolean isUndefinedDesktop() {
        return OS.isGenericUnix() && System.getenv("XDG_CURRENT_DESKTOP") == null;
    }

    @RequiresBackgroundThread
    @Nullable
    public static String getTheme() {
        ThreadingAssertions.assertBackgroundThread();
        if (UnixDesktopEnv.CURRENT == UnixDesktopEnv.GNOME) {
            String result2 = X11UiUtil.exec("Cannot get gnome theme", GSETTINGS_COMMAND, "get", "org.gnome.desktop.interface", "gtk-theme");
            return X11UiUtil.trimQuotes(result2);
        }
        if (UnixDesktopEnv.CURRENT == UnixDesktopEnv.KDE) {
            Path home = Path.of(System.getenv("HOME"), ".config/kdeglobals");
            List<String> matches = X11UiUtil.grepFile("Cannot get KDE theme", home, Pattern.compile("\\s*LookAndFeelPackage=.*"));
            if (matches.size() != 1) {
                return null;
            }
            String result3 = matches.getFirst().trim();
            if (result3.startsWith(KDE_LAF_PROPERTY)) {
                return result3.substring(KDE_LAF_PROPERTY.length()).trim();
            }
            return null;
        }
        return null;
    }

    @ApiStatus.Internal
    @RequiresBackgroundThread
    @Nullable
    public static String getIconTheme() {
        ThreadingAssertions.assertBackgroundThread();
        String result2 = X11UiUtil.exec("Cannot get icon theme", GSETTINGS_COMMAND, "get", "org.gnome.desktop.interface", "icon-theme");
        return X11UiUtil.trimQuotes(result2);
    }

    @RequiresBackgroundThread
    @ApiStatus.Internal
    @Nullable
    public static String getWindowButtonsConfig() {
        ThreadingAssertions.assertBackgroundThread();
        if (UnixDesktopEnv.CURRENT == UnixDesktopEnv.GNOME || UnixDesktopEnv.CURRENT == UnixDesktopEnv.KDE) {
            String execResult = X11UiUtil.exec("Cannot get gnome WM buttons layout", GSETTINGS_COMMAND, "get", "org.gnome.desktop.wm.preferences", "button-layout");
            return X11UiUtil.trimQuotes(execResult);
        }
        return null;
    }

    @Nullable
    private static String trimQuotes(@Nullable String s) {
        boolean quoted = s != null && s.length() > 1 && s.startsWith("'") && s.endsWith("'");
        return quoted ? s.substring(1, s.length() - 1) : s;
    }

    private static boolean hasWindowProperty(JFrame frame, long name2, long expected) {
        if (X11 == null) {
            return false;
        }
        try {
            long window;
            long[] values;
            Object peer = AWTAccessor.getComponentAccessor().getPeer(frame);
            if (peer != null && (values = X11.getWindowProperty(window = ((Long)X11UiUtil.X11.getWindow.invoke(peer, new Object[0])).longValue(), name2, 4L)) != null) {
                return ArrayUtil.indexOf((long[])values, (long)expected) != -1;
            }
            return false;
        }
        catch (Throwable t) {
            LOG.info("cannot check window property", t);
            return false;
        }
    }

    public static void toggleFullScreenMode(JFrame frame) {
        if (X11 == null) {
            return;
        }
        X11.sendClientMessage(frame, "toggle mode", X11UiUtil.X11.NET_WM_STATE, 2L, X11UiUtil.X11.NET_WM_STATE_FULLSCREEN);
    }

    public static void setFullScreenMode(JFrame frame, boolean fullScreen) {
        if (X11 == null) {
            return;
        }
        if (fullScreen) {
            X11.sendClientMessage(frame, "set FullScreen mode", X11UiUtil.X11.NET_WM_STATE, 1L, X11UiUtil.X11.NET_WM_STATE_FULLSCREEN);
        } else {
            X11.sendClientMessage(frame, "reset FullScreen mode", X11UiUtil.X11.NET_WM_STATE, 0L, X11UiUtil.X11.NET_WM_STATE_FULLSCREEN);
        }
    }

    public static void activate(@NotNull Window window) {
        if (window == null) {
            X11UiUtil.$$$reportNull$$$0(0);
        }
        if (X11 == null) {
            return;
        }
        if (FocusManagerImpl.FOCUS_REQUESTS_LOG.isDebugEnabled()) {
            FocusManagerImpl.FOCUS_REQUESTS_LOG.debug("_NET_ACTIVE_WINDOW", new Throwable());
        }
        X11.sendClientMessage(window, "activate", X11UiUtil.X11.NET_ACTIVE_WINDOW, new long[0]);
    }

    @ApiStatus.Internal
    public static boolean activate(long windowId) {
        if (X11 == null) {
            return false;
        }
        if (FocusManagerImpl.FOCUS_REQUESTS_LOG.isDebugEnabled()) {
            FocusManagerImpl.FOCUS_REQUESTS_LOG.debug("_NET_ACTIVE_WINDOW", new Throwable());
        }
        try {
            long rootWindow = X11.getRootWindow(0L);
            X11.sendClientMessage(rootWindow, windowId, X11UiUtil.X11.NET_ACTIVE_WINDOW, new long[0]);
            return true;
        }
        catch (Exception e) {
            LOG.error("Can not activate window:" + windowId, (Throwable)e);
            return false;
        }
    }

    @ApiStatus.Internal
    public static Long findVisibleWindowByPid(long pid) {
        if (X11 == null) {
            return null;
        }
        try {
            long rootWindow = X11.getRootWindow(0L);
            return X11.findProcessWindow(rootWindow, pid, 0);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void requestAttention(@NotNull Window window) {
        if (window == null) {
            X11UiUtil.$$$reportNull$$$0(1);
        }
        if (X11 == null) {
            return;
        }
        X11.sendClientMessage(window, "request attention", X11UiUtil.X11.NET_WM_STATE, 1L, X11UiUtil.X11.NET_WM_STATE_DEMANDS_ATTENTION);
    }

    private static Method method(Class<?> aClass, String name2, Class<?> ... parameterTypes) throws Exception {
        while (aClass != null) {
            try {
                Method method = aClass.getDeclaredMethod(name2, parameterTypes);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException e) {
                aClass = aClass.getSuperclass();
            }
        }
        throw new NoSuchMethodException(name2);
    }

    private static Method method(Class<?> aClass, String name2, int parameters) throws Exception {
        for (Method method : aClass.getDeclaredMethods()) {
            if (method.getParameterCount() != parameters || !name2.equals(method.getName())) continue;
            method.setAccessible(true);
            return method;
        }
        throw new NoSuchMethodException(name2);
    }

    private static Field field(Class<?> aClass, String name2) throws Exception {
        Field field = aClass.getDeclaredField(name2);
        field.setAccessible(true);
        return field;
    }

    @Nullable
    private static String exec(String errorMessage, String ... command) {
        if (command.length == 0) {
            LOG.error(errorMessage, new String[]{"No command provided"});
            return null;
        }
        if (unsupportedCommands.containsKey(command[0])) {
            return null;
        }
        try {
            Process process2 = new ProcessBuilder(command).start();
            if (!process2.waitFor(5L, TimeUnit.SECONDS)) {
                LOG.info(errorMessage + ": timeout");
                process2.destroyForcibly();
                return null;
            }
            if (process2.exitValue() != 0) {
                LOG.info(errorMessage + ": exit code " + process2.exitValue());
                return null;
            }
            return StreamUtil.readText((Reader)new InputStreamReader(process2.getInputStream(), StandardCharsets.UTF_8)).trim();
        }
        catch (Exception e) {
            String exceptionMessage = e.getMessage();
            if (exceptionMessage.contains("No such file or directory")) {
                unsupportedCommands.put(command[0], true);
                LOG.info(errorMessage + ": " + exceptionMessage);
                LOG.trace((Throwable)e);
            } else {
                LOG.info(errorMessage, (Throwable)e);
            }
            return null;
        }
    }

    private static List<String> grepFile(String errorMessage, Path file2, Pattern pattern) {
        List<String> list2;
        block8: {
            Stream<String> lines = Files.lines(file2);
            try {
                list2 = lines.filter(line -> pattern.matcher((CharSequence)line).matches()).toList();
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.info(errorMessage, (Throwable)e);
                    return List.of();
                }
            }
            lines.close();
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "window";
        objectArray2[1] = "com/intellij/openapi/wm/impl/X11UiUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "activate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "requestAttention";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Xlib {
        private Method XGetWindowProperty;
        private Method XFree;
        private Method RootWindow;
        private Method XSendEvent;
        private Method getWindow;
        private Method getScreenNumber;
        private Method awtLock;
        private Method awtUnlock;
        private Method getChildWindows;
        private Method XGetWindowAttributes;
        private long display;
        private long NET_SUPPORTING_WM_CHECK;
        private long NET_WM_ALLOWED_ACTIONS;
        private long NET_WM_STATE;
        private long NET_WM_ACTION_FULLSCREEN;
        private long NET_WM_STATE_FULLSCREEN;
        private long NET_WM_STATE_MAXIMIZED_VERT;
        private long NET_WM_STATE_MAXIMIZED_HORZ;
        private long NET_WM_STATE_DEMANDS_ATTENTION;
        private long NET_ACTIVE_WINDOW;
        private long _NET_WM_PID;

        private Xlib() {
        }

        @Nullable
        private static Xlib getInstance() {
            Class<?> toolkitClass = Toolkit.getDefaultToolkit().getClass();
            if (!StartupUiUtil.isXToolkit()) {
                return null;
            }
            try {
                Xlib x11 = new Xlib();
                Class<?> XlibWrapper = Class.forName("sun.awt.X11.XlibWrapper");
                x11.XGetWindowProperty = X11UiUtil.method(XlibWrapper, "XGetWindowProperty", 12);
                x11.XFree = X11UiUtil.method(XlibWrapper, "XFree", 1);
                x11.RootWindow = X11UiUtil.method(XlibWrapper, "RootWindow", 2);
                x11.XSendEvent = X11UiUtil.method(XlibWrapper, "XSendEvent", 5);
                x11.XGetWindowAttributes = X11UiUtil.method(XlibWrapper, "XGetWindowAttributes", 3);
                Class<?> XBaseWindow = Class.forName("sun.awt.X11.XBaseWindow");
                x11.getWindow = X11UiUtil.method(XBaseWindow, "getWindow", new Class[0]);
                x11.getScreenNumber = X11UiUtil.method(XBaseWindow, "getScreenNumber", new Class[0]);
                x11.display = (Long)X11UiUtil.method(toolkitClass, "getDisplay", new Class[0]).invoke(null, new Object[0]);
                x11.awtLock = X11UiUtil.method(toolkitClass, "awtLock", new Class[0]);
                x11.awtUnlock = X11UiUtil.method(toolkitClass, "awtUnlock", new Class[0]);
                Class<?> XlibUtil = Class.forName("sun.awt.X11.XlibUtil");
                x11.getChildWindows = X11UiUtil.method(XlibUtil, "getChildWindows", Long.TYPE);
                Class<?> XAtom = Class.forName("sun.awt.X11.XAtom");
                Method get = X11UiUtil.method(XAtom, "get", String.class);
                Field atom = X11UiUtil.field(XAtom, "atom");
                x11.NET_SUPPORTING_WM_CHECK = (Long)atom.get(get.invoke(null, "_NET_SUPPORTING_WM_CHECK"));
                x11.NET_WM_ALLOWED_ACTIONS = (Long)atom.get(get.invoke(null, "_NET_WM_ALLOWED_ACTIONS"));
                x11.NET_WM_STATE = (Long)atom.get(get.invoke(null, "_NET_WM_STATE"));
                x11.NET_WM_ACTION_FULLSCREEN = (Long)atom.get(get.invoke(null, "_NET_WM_ACTION_FULLSCREEN"));
                x11.NET_WM_STATE_FULLSCREEN = (Long)atom.get(get.invoke(null, "_NET_WM_STATE_FULLSCREEN"));
                x11.NET_WM_STATE_MAXIMIZED_VERT = (Long)atom.get(get.invoke(null, "_NET_WM_STATE_MAXIMIZED_VERT"));
                x11.NET_WM_STATE_MAXIMIZED_HORZ = (Long)atom.get(get.invoke(null, "_NET_WM_STATE_MAXIMIZED_HORZ"));
                x11.NET_WM_STATE_DEMANDS_ATTENTION = (Long)atom.get(get.invoke(null, "_NET_WM_STATE_DEMANDS_ATTENTION"));
                x11.NET_ACTIVE_WINDOW = (Long)atom.get(get.invoke(null, "_NET_ACTIVE_WINDOW"));
                x11._NET_WM_PID = (Long)atom.get(get.invoke(null, "_NET_WM_PID"));
                Long netWmWindow = x11.getNetWmWindow();
                if (netWmWindow == null) {
                    LOG.info("_NET protocol is not supported");
                    return null;
                }
                return x11;
            }
            catch (Throwable t) {
                LOG.info("cannot initialize", t);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long getRootWindow(long screen) throws Exception {
            this.awtLock.invoke(null, new Object[0]);
            try {
                long l = (Long)this.RootWindow.invoke(null, this.display, screen);
                return l;
            }
            finally {
                this.awtUnlock.invoke(null, new Object[0]);
            }
        }

        @Nullable
        private Long getNetWmWindow() throws Exception {
            long rootWindow = this.getRootWindow(0L);
            long[] values = this.getWindowProperty(rootWindow, this.NET_SUPPORTING_WM_CHECK, 33L);
            return values != null && values.length > 0 ? Long.valueOf(values[0]) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long @Nullable [] getWindowProperty(long window, long name2, long type) throws Exception {
            this.awtLock.invoke(null, new Object[0]);
            try (Memory buffer2 = new Memory(64L);){
                buffer2.clear();
                long pBuf = Pointer.nativeValue((Pointer)buffer2);
                int result2 = (Integer)this.XGetWindowProperty.invoke(null, this.display, window, name2, 0L, 65535L, 0L, type, pBuf, pBuf + 8L, pBuf + 16L, pBuf + 24L, pBuf + 32L);
                if (result2 == 0) {
                    int format = buffer2.getInt(8L);
                    Pointer pointer = buffer2.getPointer(32L);
                    if (pointer != Pointer.NULL) {
                        if (format == 32) {
                            int length = (int)buffer2.getLong(16L);
                            long[] lArray = pointer.getLongArray(0L, length);
                            return lArray;
                        }
                        LOG.info("unexpected format: " + format);
                        this.XFree.invoke(null, Pointer.nativeValue((Pointer)pointer));
                    }
                }
            }
            finally {
                this.awtUnlock.invoke(null, new Object[0]);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendClientMessage(long target, long window, long type, long ... data2) throws Exception {
            assert (data2.length <= 5);
            this.awtLock.invoke(null, new Object[0]);
            try (Memory event = new Memory(128L);){
                event.clear();
                event.setInt(0L, 33);
                event.setInt(16L, 1);
                event.setLong(32L, window);
                event.setLong(40L, type);
                event.setInt(48L, 32);
                for (int i2 = 0; i2 < data2.length; ++i2) {
                    event.setLong(56L + 8L * (long)i2, data2[i2]);
                }
                this.XSendEvent.invoke(null, this.display, target, false, 0x180000L, Pointer.nativeValue((Pointer)event));
            }
            finally {
                this.awtUnlock.invoke(null, new Object[0]);
            }
        }

        private void sendClientMessage(Window window, String operation2, long type, long ... params) {
            try {
                Object peer = AWTAccessor.getComponentAccessor().getPeer(window);
                if (peer == null) {
                    throw new IllegalStateException(String.valueOf(window) + " has no peer");
                }
                long windowId = (Long)this.getWindow.invoke(peer, new Object[0]);
                long screen = (Long)this.getScreenNumber.invoke(peer, new Object[0]);
                long rootWindow = this.getRootWindow(screen);
                this.sendClientMessage(rootWindow, windowId, type, params);
            }
            catch (Throwable t) {
                LOG.info("cannot " + operation2, t);
            }
        }

        private Long findProcessWindow(long window, long pid, int recursionLevel) throws InvocationTargetException, IllegalAccessException {
            if (recursionLevel > 100) {
                LOG.warn("Recursion level exceeded. Deep lying windows will be skipped");
                return null;
            }
            if (this.isProcessWindowOwner(window, pid) && Xlib.isViewableWin(window).booleanValue()) {
                return window;
            }
            Set<Long> childWindows = this.getChildWindows(window);
            if (childWindows == null) {
                return null;
            }
            for (Long childWindow : childWindows) {
                Long wnd = this.findProcessWindow(childWindow, pid, recursionLevel + 1);
                if (wnd == null) continue;
                return wnd;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Boolean isViewableWin(long window) throws InvocationTargetException, IllegalAccessException {
            assert (X11 != null);
            try {
                Boolean bl;
                X11UiUtil.X11.awtLock.invoke(null, new Object[0]);
                XWindowAttributesWrapper wrapper2 = new XWindowAttributesWrapper(window);
                try {
                    bl = wrapper2.getMapState() == XWindowAttributesWrapper.MapState.IsViewable;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            wrapper2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                        Boolean bl2 = false;
                        return bl2;
                    }
                }
                wrapper2.close();
                return bl;
            }
            finally {
                X11UiUtil.X11.awtUnlock.invoke(null, new Object[0]);
            }
        }

        private boolean isProcessWindowOwner(Long window, long pid) {
            long[] value;
            try {
                value = this.getWindowProperty(window, this._NET_WM_PID, 0L);
            }
            catch (Exception ex) {
                LOG.error("Exception on obtaingin \"_NET_WM_PID\" window property", (Throwable)ex);
                return false;
            }
            if (value == null) {
                LOG.trace("_NET_WM_PID property is not set for window " + window);
                return false;
            }
            long windowPid = value[0];
            return windowPid == pid;
        }

        public Set<Long> getChildWindows(Long window) {
            try {
                Set windows = (Set)this.getChildWindows.invoke(null, window);
                return windows;
            }
            catch (Exception e) {
                LOG.error("Can't get children for window: " + window, (Throwable)e);
                return null;
            }
        }
    }

    private static final class XWindowAttributesWrapper
    implements AutoCloseable {
        private final Object instance;
        private static Constructor<?> ctor;
        private static Method get_map_state;
        private static Method getPData;
        private static Method dispose;

        private MapState getMapState() throws InvocationTargetException, IllegalAccessException {
            return MapState.values()[(Integer)get_map_state.invoke(this.instance, new Object[0])];
        }

        private XWindowAttributesWrapper(long windowId) throws Exception {
            assert (X11 != null);
            this.instance = XWindowAttributesWrapper.getXWindowAttributesCtor().newInstance(new Object[0]);
            Object ptrData = getPData.invoke(this.instance, new Object[0]);
            Integer operationResult = (Integer)X11UiUtil.X11.XGetWindowAttributes.invoke(null, X11UiUtil.X11.display, windowId, ptrData);
            if (operationResult == 0) {
                throw new Exception("XGetWindowAttributes failed :" + operationResult);
            }
        }

        @Override
        public void close() throws Exception {
            dispose.invoke(this.instance, new Object[0]);
        }

        private static Constructor<?> getXWindowAttributesCtor() throws Exception {
            if (ctor == null) {
                Class<?> clazz = Class.forName("sun.awt.X11.XWindowAttributes");
                ctor = clazz.getConstructor(new Class[0]);
                get_map_state = X11UiUtil.method(clazz, "get_map_state", new Class[0]);
                dispose = X11UiUtil.method(clazz, "dispose", new Class[0]);
                getPData = X11UiUtil.method(clazz, "getPData", new Class[0]);
            }
            return ctor;
        }

        private static enum MapState {
            IsUnmapped,
            IsUnviewable,
            IsViewable;

        }
    }
}

