/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen.projectActions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.ProjectWindowCustomizerService;
import com.intellij.ide.RecentProjectIconHelper;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.wm.impl.welcomeScreen.projectActions.ChangeProjectIconActionKt;
import com.intellij.openapi.wm.impl.welcomeScreen.projectActions.IconPreviewPanel;
import com.intellij.openapi.wm.impl.welcomeScreen.projectActions.ProjectIconUI;
import com.intellij.openapi.wm.impl.welcomeScreen.projectActions.RecentProjectsWelcomeScreenActionBase;
import com.intellij.openapi.wm.impl.welcomeScreen.recentProjects.ProviderRecentProjectItem;
import com.intellij.openapi.wm.impl.welcomeScreen.recentProjects.RecentProjectItem;
import com.intellij.openapi.wm.impl.welcomeScreen.recentProjects.RecentProjectTreeItem;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.JBUI;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/wm/impl/welcomeScreen/projectActions/ChangeProjectIconAction;", "Lcom/intellij/openapi/wm/impl/welcomeScreen/projectActions/RecentProjectsWelcomeScreenActionBase;", "<init>", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getProjectPath", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "selectedItem", "Lcom/intellij/openapi/wm/impl/welcomeScreen/recentProjects/RecentProjectTreeItem;", "update", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nChangeProjectIconAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeProjectIconAction.kt\ncom/intellij/openapi/wm/impl/welcomeScreen/projectActions/ChangeProjectIconAction\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,204:1\n13#2:205\n*S KotlinDebug\n*F\n+ 1 ChangeProjectIconAction.kt\ncom/intellij/openapi/wm/impl/welcomeScreen/projectActions/ChangeProjectIconAction\n*L\n80#1:205\n*E\n"})
public final class ChangeProjectIconAction
extends RecentProjectsWelcomeScreenActionBase {
    public ChangeProjectIconAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project2 = event.getProject();
        RecentProjectTreeItem selectedItem = RecentProjectsWelcomeScreenActionBase.Companion.getSelectedItem$intellij_platform_ide_impl(event);
        Path path = this.getProjectPath(project2, selectedItem);
        if (path == null) {
            return;
        }
        Path projectPath = path;
        Path path2 = RecentProjectIconHelper.Companion.getDotIdeaPath$intellij_platform_ide_impl(projectPath);
        if (path2 == null) {
            return;
        }
        Path basePath = path2;
        ProjectIconUI ui = new ProjectIconUI(projectPath);
        DialogPanel panel2 = BuilderKt.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> ChangeProjectIconAction.actionPerformed$lambda$0(ui, arg_0)));
        String string = IdeBundle.message((String)"dialog.title.change.project.icon", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        if (ComponentsKt.dialog$default(string, (JComponent)panel2, false, null, false, null, null, null, null, null, null, 2044, null).showAndGet()) {
            ChangeProjectIconActionKt.access$changeProjectIcon(basePath, ui, projectPath, event);
        }
    }

    private final Path getProjectPath(Project project2, RecentProjectTreeItem selectedItem) {
        if (selectedItem instanceof RecentProjectItem) {
            try {
                return Path.of(((RecentProjectItem)selectedItem).projectPath, new String[0]);
            }
            catch (InvalidPathException e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(ChangeProjectIconAction.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn((Throwable)e);
                return null;
            }
        }
        if (project2 != null && selectedItem == null) {
            return ProjectWindowCustomizerService.Companion.projectPath(project2);
        }
        return null;
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project2 = event.getProject();
        RecentProjectTreeItem selectedItem = RecentProjectsWelcomeScreenActionBase.Companion.getSelectedItem$intellij_platform_ide_impl(event);
        event.getPresentation().setEnabled(this.getProjectPath(project2, selectedItem) != null);
        event.getPresentation().setVisible(!(selectedItem instanceof ProviderRecentProjectItem));
    }

    private static final Unit actionPerformed$lambda$0$0$0$1$0(JEditorPane $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setForeground(JBUI.CurrentTheme.ContextHelp.FOREGROUND);
        return Unit.INSTANCE;
    }

    private static final Unit actionPerformed$lambda$0$0$0$0(ProjectIconUI $ui, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)$ui.getSetIconActionLink()).gap(RightGap.SMALL);
        JComponent jComponent = $ui.getRemoveIcon().getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        $this$row.cell(jComponent);
        return Unit.INSTANCE;
    }

    private static final Unit actionPerformed$lambda$0$0$0$1(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"link.change.project.icon.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Row.text$default($this$row, string, 0, null, 6, null).applyToComponent(ChangeProjectIconAction::actionPerformed$lambda$0$0$0$1$0);
        return Unit.INSTANCE;
    }

    private static final Unit actionPerformed$lambda$0$0$0(ProjectIconUI $ui, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default($this$panel, null, arg_0 -> ChangeProjectIconAction.actionPerformed$lambda$0$0$0$0($ui, arg_0), 1, null);
        Panel.row$default($this$panel, null, ChangeProjectIconAction::actionPerformed$lambda$0$0$0$1, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit actionPerformed$lambda$0$0(ProjectIconUI $ui, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)new IconPreviewPanel((JComponent)$ui.getIconLabel()));
        $this$row.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> ChangeProjectIconAction.actionPerformed$lambda$0$0$0($ui, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit actionPerformed$lambda$0(ProjectIconUI $ui, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default($this$panel, null, arg_0 -> ChangeProjectIconAction.actionPerformed$lambda$0$0($ui, arg_0), 1, null);
        return Unit.INSTANCE;
    }
}

