/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.diagnostic.startUpPerformanceReporter;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0005H\u0016J'\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/platform/ide/diagnostic/startUpPerformanceReporter/StartupPerformanceCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getGroup", "DURATION", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "PROJECTS_COUNT", "SPLASH_SHOWN", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "SPLASH_HIDDEN", "PROJECT_FRAME_VISIBLE", "TOTAL_DURATION", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "BOOTSTRAP", "SPLASH", "APP_INIT", "logStartupPerformanceEvent", "", "project", "Lcom/intellij/openapi/project/Project;", "eventId", "", "duration", "logStartupPerformanceEvent$intellij_platform_ide_impl", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nStartupPerformanceCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StartupPerformanceCollector.kt\ncom/intellij/platform/ide/diagnostic/startUpPerformanceReporter/StartupPerformanceCollector\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,46:1\n13#2:47\n*S KotlinDebug\n*F\n+ 1 StartupPerformanceCollector.kt\ncom/intellij/platform/ide/diagnostic/startUpPerformanceReporter/StartupPerformanceCollector\n*L\n42#1:47\n*E\n"})
public final class StartupPerformanceCollector
extends CounterUsagesCollector {
    @NotNull
    public static final StartupPerformanceCollector INSTANCE = new StartupPerformanceCollector();
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("startup", 5, null, 4, null);
    @NotNull
    private static final IntEventField DURATION = EventFields.Int((String)"duration");
    @NotNull
    private static final IntEventField PROJECTS_COUNT = EventFields.Int((String)"projects_count");
    @NotNull
    private static final EventId1<Integer> SPLASH_SHOWN = GROUP.registerEvent("splashShown", (EventField)DURATION);
    @NotNull
    private static final EventId1<Integer> SPLASH_HIDDEN = GROUP.registerEvent("splashHidden", (EventField)DURATION);
    @NotNull
    private static final EventId1<Integer> PROJECT_FRAME_VISIBLE = GROUP.registerEvent("projectFrameVisible", (EventField)DURATION);
    @NotNull
    private static final VarargEventId TOTAL_DURATION;
    @NotNull
    private static final EventId1<Integer> BOOTSTRAP;
    @NotNull
    private static final EventId1<Integer> SPLASH;
    @NotNull
    private static final EventId1<Integer> APP_INIT;

    private StartupPerformanceCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    public final void logStartupPerformanceEvent$intellij_platform_ide_impl(@Nullable Project project2, @NotNull String eventId, int duration2) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        switch (eventId) {
            case "bootstrap": {
                BOOTSTRAP.log((Object)duration2);
                break;
            }
            case "splash": {
                SPLASH.log((Object)duration2);
                break;
            }
            case "app initialization": {
                APP_INIT.log((Object)duration2);
                break;
            }
            case "event:splash shown": {
                SPLASH_SHOWN.log((Object)duration2);
                break;
            }
            case "event:splash hidden": {
                SPLASH_HIDDEN.log((Object)duration2);
                break;
            }
            case "projectFrameVisible": {
                PROJECT_FRAME_VISIBLE.log((Object)duration2);
                break;
            }
            case "totalDuration": {
                int openedProjects = ProjectManager.getInstance().getOpenProjects().length;
                Project projectToReport = openedProjects == 1 ? project2 : null;
                EventPair[] eventPairArray = new EventPair[]{DURATION.with((Object)duration2), PROJECTS_COUNT.with((Object)openedProjects)};
                TOTAL_DURATION.log(projectToReport, eventPairArray);
                break;
            }
            default: {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(StartupPerformanceCollector.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Trying to log unknown startup performance metric ('" + eventId + "'). To record it, register a corresponding event and increment group version.");
            }
        }
    }

    static {
        EventField[] eventFieldArray = new EventField[]{DURATION, PROJECTS_COUNT};
        TOTAL_DURATION = GROUP.registerVarargEvent("totalDuration", eventFieldArray);
        BOOTSTRAP = GROUP.registerEvent("bootstrap", (EventField)DURATION);
        SPLASH = GROUP.registerEvent("splash", (EventField)DURATION);
        APP_INIT = GROUP.registerEvent("appInit", (EventField)DURATION);
    }
}

