/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.ui.text.ShortcutsRenderingUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.GotItComponentBuilderKt;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.ExtendableHTMLViewFactory;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.InlineView;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="Use JBHtmlPane and <shortcut> element instead")
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \t2\u00020\u0001:\u0002\t\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0096\u0082\u0004\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ui/ShortcutExtension;", "Lcom/intellij/util/ui/ExtendableHTMLViewFactory$Extension;", "<init>", "()V", "invoke", "Ljavax/swing/text/View;", "elem", "Ljavax/swing/text/Element;", "defaultView", "Companion", "ShortcutView", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class ShortcutExtension
implements ExtendableHTMLViewFactory.Extension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex SHORTCUT_REGEX = new Regex("<shortcut (?<type>actionId|raw)=\"(?<value>[\\w. ]+)\"/>");

    @Nullable
    public View invoke(@NotNull Element elem, @NotNull View defaultView) {
        AttributeSet tagAttributes;
        Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
        Intrinsics.checkNotNullParameter((Object)defaultView, (String)"defaultView");
        Object object = elem.getAttributes().getAttribute(HTML.Tag.SPAN);
        AttributeSet attributeSet = tagAttributes = object instanceof AttributeSet ? (AttributeSet)object : null;
        if (Intrinsics.areEqual((Object)(attributeSet != null ? attributeSet.getAttribute(HTML.Attribute.CLASS) : null), (Object)"shortcut")) {
            return new ShortcutView(elem);
        }
        return null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J \u0010\n\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000b2\u000b\u0010\f\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000b2\u0006\u0010\r\u001a\u00020\u000eJ \u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001f\u0010\u0012\u001a\f0\u0005\u00a2\u0006\u0002\b\u0013\u00a2\u0006\u0002\b\u00142\u000b\u0010\u0015\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0013H\u0002R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ui/ShortcutExtension$Companion;", "", "<init>", "()V", "getStyles", "", "foreground", "Ljava/awt/Color;", "background", "border", "patchShortcutTags", "Lorg/jetbrains/annotations/Nls;", "htmlText", "needLogIncorrectInput", "", "getShortcutText", "type", "value", "shortcutSpan", "Lcom/intellij/openapi/util/NlsSafe;", "Lorg/jetbrains/annotations/NotNull;", "shortcutText", "SHORTCUT_REGEX", "Lkotlin/text/Regex;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nGotItComponentBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GotItComponentBuilder.kt\ncom/intellij/ui/ShortcutExtension$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,1135:1\n23#2:1136\n23#2:1137\n23#2:1138\n*S KotlinDebug\n*F\n+ 1 GotItComponentBuilder.kt\ncom/intellij/ui/ShortcutExtension$Companion\n*L\n853#1:1136\n865#1:1137\n870#1:1138\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getStyles(@NotNull Color foreground, @NotNull Color background, @NotNull Color border) {
            Intrinsics.checkNotNullParameter((Object)foreground, (String)"foreground");
            Intrinsics.checkNotNullParameter((Object)background, (String)"background");
            Intrinsics.checkNotNullParameter((Object)border, (String)"border");
            return ".shortcut { font-weight: bold; color: " + ColorUtil.toHtmlColor((Color)foreground) + "; background-color: " + ColorUtil.toHtmlColor((Color)background) + "; border-color: #" + ColorUtil.toHex((Color)border, (boolean)true) + " }";
        }

        @NotNull
        public final String patchShortcutTags(@NotNull String htmlText, boolean needLogIncorrectInput) {
            Intrinsics.checkNotNullParameter((Object)htmlText, (String)"htmlText");
            Sequence shortcuts = Regex.findAll$default((Regex)SHORTCUT_REGEX, (CharSequence)htmlText, (int)0, (int)2, null);
            if (!SequencesKt.any((Sequence)shortcuts)) {
                return htmlText;
            }
            StringBuilder builder = new StringBuilder();
            int ind = 0;
            for (MatchResult shortcut : shortcuts) {
                String string = htmlText.substring(ind, shortcut.getRange().getFirst());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                builder.append(string);
                MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)shortcut.getGroups(), (String)"type");
                Intrinsics.checkNotNull((Object)matchGroup);
                String string2 = matchGroup.getValue();
                MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)shortcut.getGroups(), (String)"value");
                Intrinsics.checkNotNull((Object)matchGroup2);
                String text2 = this.getShortcutText(string2, matchGroup2.getValue(), needLogIncorrectInput);
                String span = this.shortcutSpan(text2);
                builder.append("\u00a0" + span + "\u00a0");
                ind = shortcut.getRange().getLast() + 1;
            }
            String string = htmlText.substring(ind);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            builder.append(string);
            String string3 = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            return string3;
        }

        private final String getShortcutText(String type, String value, boolean needLogIncorrectInput) {
            String string;
            String string2 = type;
            if (Intrinsics.areEqual((Object)string2, (Object)"actionId")) {
                KeyboardShortcut shortcut = ShortcutsRenderingUtil.INSTANCE.getShortcutByActionId(value);
                if (shortcut != null) {
                    string = (String)ShortcutsRenderingUtil.INSTANCE.getKeyboardShortcutData(shortcut).getFirst();
                } else {
                    if (ActionManager.getInstance().getAction(value) == null) {
                        if (needLogIncorrectInput) {
                            Companion $this$thisLogger$iv = this;
                            boolean $i$f$thisLogger = false;
                            Logger logger = Logger.getInstance(Companion.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                            logger.error("No action with " + value + " id is registered");
                        }
                        return value;
                    }
                    string = (String)ShortcutsRenderingUtil.INSTANCE.getGotoActionData(value, needLogIncorrectInput).getFirst();
                }
            } else if (Intrinsics.areEqual((Object)string2, (Object)"raw")) {
                KeyStroke keyStroke = KeyStroke.getKeyStroke(value);
                if (keyStroke != null) {
                    string = (String)ShortcutsRenderingUtil.INSTANCE.getKeyStrokeData(keyStroke).getFirst();
                } else {
                    if (needLogIncorrectInput) {
                        Companion $this$thisLogger$iv = this;
                        boolean $i$f$thisLogger = false;
                        Logger logger = Logger.getInstance(Companion.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.error("Invalid key stroke: " + value);
                    }
                    string = value;
                }
            } else {
                if (needLogIncorrectInput) {
                    Companion $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("Unknown shortcut type: " + type + ", use 'actionId' or 'raw'");
                }
                string = value;
            }
            return string;
        }

        private final String shortcutSpan(String shortcutText) {
            String string = HtmlChunk.span().attr("class", "shortcut").addText(shortcutText).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00192\u0006\u0010\u001b\u001a\u00020\u0017H\u0002R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0016\u0010\f\u001a\u0004\u0018\u00010\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\t\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ui/ShortcutExtension$ShortcutView;", "Ljavax/swing/text/html/InlineView;", "elem", "Ljavax/swing/text/Element;", "<init>", "(Ljavax/swing/text/Element;)V", "horizontalIndent", "", "getHorizontalIndent", "()F", "verticalIndent", "getVerticalIndent", "borderColor", "Ljava/awt/Color;", "getBorderColor", "()Ljava/awt/Color;", "arcSize", "getArcSize", "paint", "", "g", "Ljava/awt/Graphics;", "a", "Ljava/awt/Shape;", "calculateRectangles", "", "Ljava/awt/geom/RoundRectangle2D;", "allocation", "Companion", "intellij.platform.ide.impl"})
    private static final class ShortcutView
    extends InlineView {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private static final float DEFAULT_HORIZONTAL_INDENT = 3.0f;
        private static final float DEFAULT_VERTICAL_INDENT = 0.0f;
        private static final float DEFAULT_ARC = 8.0f;
        @NotNull
        private static final Regex SHORTCUT_PART_REGEX = new Regex(ShortcutsRenderingUtil.INSTANCE.getSHORTCUT_PART_SEPARATOR());

        public ShortcutView(@NotNull Element elem) {
            Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
            super(elem);
        }

        private final float getHorizontalIndent() {
            View view2 = this;
            CSS.Attribute attribute = CSS.Attribute.MARGIN_LEFT;
            Intrinsics.checkNotNullExpressionValue((Object)attribute, (String)"MARGIN_LEFT");
            return GotItComponentBuilderKt.access$getFloatAttribute(view2, attribute, 3.0f);
        }

        private final float getVerticalIndent() {
            View view2 = this;
            CSS.Attribute attribute = CSS.Attribute.MARGIN_TOP;
            Intrinsics.checkNotNullExpressionValue((Object)attribute, (String)"MARGIN_TOP");
            return GotItComponentBuilderKt.access$getFloatAttribute(view2, attribute, 0.0f);
        }

        private final Color getBorderColor() {
            return GotItComponentBuilderKt.access$getBorderColorAttr(this);
        }

        private final float getArcSize() {
            return JBUIScale.scale((float)8.0f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(@NotNull Graphics g, @NotNull Shape a) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            List rectangles = this.calculateRectangles(a);
            Color borderColor = this.getBorderColor();
            Color backgroundColor = this.getBackground();
            Graphics graphics = g.create();
            Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            Graphics2D g2d = (Graphics2D)graphics;
            try {
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                List list2 = rectangles;
                if (list2 == null) {
                    list2 = CollectionsKt.emptyList();
                }
                for (RoundRectangle2D rect : list2) {
                    g2d.setColor(backgroundColor);
                    g2d.fill(rect);
                    if (borderColor == null) continue;
                    g2d.setColor(borderColor);
                    g2d.draw(rect);
                }
            }
            finally {
                g2d.dispose();
            }
            try {
                this.setBackground(null);
                super.paint(g, a);
            }
            finally {
                this.setBackground(backgroundColor);
            }
        }

        private final List<RoundRectangle2D> calculateRectangles(Shape allocation) {
            int startOffset = this.getElement().getStartOffset();
            try {
                String text2 = this.getElement().getDocument().getText(startOffset, this.getElement().getEndOffset() - startOffset);
                float horIndent = this.getHorizontalIndent();
                float vertIndent = this.getVerticalIndent();
                Intrinsics.checkNotNull((Object)text2);
                CharSequence charSequence = text2;
                Regex regex = SHORTCUT_PART_REGEX;
                int n = 0;
                List parts = regex.split(charSequence, n);
                List rectangles = new ArrayList();
                int curInd = 0;
                for (String part : parts) {
                    Rectangle2D textRect = this.modelToView(startOffset + curInd, Position.Bias.Forward, startOffset + curInd + part.length(), Position.Bias.Backward, allocation).getBounds2D();
                    rectangles.add(new RoundRectangle2D.Double(textRect.getX() - (double)horIndent, textRect.getY() - (double)vertIndent, textRect.getWidth() + (double)((float)2 * horIndent), textRect.getHeight() + (double)((float)2 * vertIndent), this.getArcSize(), this.getArcSize()));
                    curInd += part.length() + ShortcutsRenderingUtil.INSTANCE.getSHORTCUT_PART_SEPARATOR().length();
                }
                return rectangles;
            }
            catch (BadLocationException ex) {
                return null;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/ui/ShortcutExtension$ShortcutView$Companion;", "", "<init>", "()V", "DEFAULT_HORIZONTAL_INDENT", "", "DEFAULT_VERTICAL_INDENT", "DEFAULT_ARC", "SHORTCUT_PART_REGEX", "Lkotlin/text/Regex;", "intellij.platform.ide.impl"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

