/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.AppUIUtilKt;
import com.intellij.ui.SystemNotificationsImpl;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.Window;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SystemTrayNotifications
implements SystemNotificationsImpl.Notifier {
    private static SystemTrayNotifications ourWin10Instance;
    private final TrayIcon myTrayIcon;
    private final TrayIcon.MessageType myType;

    @Nullable
    static synchronized SystemTrayNotifications getWin10Instance() throws AWTException {
        if (ourWin10Instance == null && SystemTray.isSupported()) {
            ourWin10Instance = new SystemTrayNotifications(SystemTrayNotifications.createImage(), TrayIcon.MessageType.INFO);
        }
        return ourWin10Instance;
    }

    private static Image createImage() {
        Icon icon2 = AppUIUtilKt.loadSmallApplicationIcon(ScaleContext.create(), 16);
        return ImageUtil.toBufferedImage((Image)IconUtil.toImage((Icon)icon2));
    }

    private SystemTrayNotifications(@NotNull Image image2, @NotNull TrayIcon.MessageType type) throws AWTException {
        if (image2 == null) {
            SystemTrayNotifications.$$$reportNull$$$0(0);
        }
        if (type == null) {
            SystemTrayNotifications.$$$reportNull$$$0(1);
        }
        this.myType = type;
        String tooltip = ApplicationInfoImpl.getShadowInstance().getFullApplicationName();
        this.myTrayIcon = new TrayIcon(image2, tooltip);
        this.myTrayIcon.setImageAutoSize(true);
        SystemTray.getSystemTray().add(this.myTrayIcon);
        this.myTrayIcon.addActionListener(e -> {
            IdeFrame frame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
            if (frame instanceof Window) {
                UIUtil.toFront((Window)((Window)frame));
            }
        });
    }

    @Override
    public void notify(@NotNull String name2, @NotNull String title2, @NotNull String description) {
        if (name2 == null) {
            SystemTrayNotifications.$$$reportNull$$$0(2);
        }
        if (title2 == null) {
            SystemTrayNotifications.$$$reportNull$$$0(3);
        }
        if (description == null) {
            SystemTrayNotifications.$$$reportNull$$$0(4);
        }
        this.myTrayIcon.displayMessage(title2, description, this.myType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/SystemTrayNotifications";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "notify";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

