/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.RegularWindowMouseListenerSupport;
import com.intellij.ui.WaylandWindowMouseListenerSupport;
import com.intellij.ui.WindowMouseListener;
import com.intellij.ui.WindowMouseListenerSource;
import com.intellij.ui.WindowMouseListenerSupportKt;
import com.jetbrains.JBR;
import com.jetbrains.WindowMove;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0001<B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0014\u001a\u00020\u000eH$J\u0012\u0010\u0015\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H$J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000eJ\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0017H\u0014J \u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0017H\u0002J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0017H\u0002J\u0018\u0010!\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0017H\u0014J\u0016\u0010\"\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u000eJ0\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*H\u0017J\u0018\u0010+\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u000eH\u0002J \u0010,\u001a\u00020\u00192\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.2\u0006\u0010\u001e\u001a\u00020\u0017H\u0014J\u0010\u00100\u001a\u00020\u00192\u0006\u00101\u001a\u00020\fH$J\u0018\u00102\u001a\u0002032\u0006\u00101\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J(\u00104\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u00105\u001a\u00020.2\u0006\u00106\u001a\u00020\u000e2\u0006\u00107\u001a\u00020\u000eH\u0002J\u0010\u00108\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u00109\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0017H\u0002J\b\u0010:\u001a\u00020\u0019H\u0002J\u001a\u0010;\u001a\u00020\u00192\u0006\u00101\u001a\u00020\f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0010\u0082\u0001\u0002=>\u00a8\u0006?"}, d2={"Lcom/intellij/ui/WindowMouseListenerSupport;", "", "source", "Lcom/intellij/ui/WindowMouseListenerSource;", "<init>", "(Lcom/intellij/ui/WindowMouseListenerSource;)V", "value", "", "cursorType", "getCursorType", "()I", "currentSession", "Lcom/intellij/ui/WindowMouseListenerSupport$WindowListenerSession;", "leftMouseButtonOnly", "", "getLeftMouseButtonOnly", "()Z", "setLeftMouseButtonOnly", "(Z)V", "isBusy", "moveAfterMouseRelease", "jbrMoveSupported", "component", "Ljava/awt/Component;", "update", "", "event", "Ljava/awt/event/MouseEvent;", "start", "beforeUpdate", "view", "updateCursor", "content", "onStarted", "process", "mouseMove", "getResizeCursor", "top", "left", "bottom", "right", "resizeArea", "Ljava/awt/Insets;", "handleDragEvent", "makeChangeValid", "oldBounds", "Ljava/awt/Rectangle;", "newBounds", "onDraggingStarted", "session", "computeOffsetFromInitialLocation", "Ljava/awt/Point;", "setViewBounds", "bounds", "moved", "resized", "handleStopEvent", "resetCursor", "stop", "enterJbrMoveMode", "WindowListenerSession", "Lcom/intellij/ui/RegularWindowMouseListenerSupport;", "Lcom/intellij/ui/WaylandWindowMouseListenerSupport;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nWindowMouseListenerSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowMouseListenerSupport.kt\ncom/intellij/ui/WindowMouseListenerSupport\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,406:1\n60#2,5:407\n60#2,5:412\n60#2,5:417\n60#2,5:422\n60#2,5:427\n*S KotlinDebug\n*F\n+ 1 WindowMouseListenerSupport.kt\ncom/intellij/ui/WindowMouseListenerSupport\n*L\n70#1:407,5\n104#1:412,5\n182#1:417,5\n199#1:422,5\n236#1:427,5\n*E\n"})
public abstract sealed class WindowMouseListenerSupport
permits RegularWindowMouseListenerSupport, WaylandWindowMouseListenerSupport {
    @NotNull
    private final WindowMouseListenerSource source;
    private int cursorType;
    @Nullable
    private WindowListenerSession currentSession;
    private boolean leftMouseButtonOnly;

    private WindowMouseListenerSupport(WindowMouseListenerSource source) {
        this.source = source;
    }

    @JdkConstants.CursorType
    public final int getCursorType() {
        return this.cursorType;
    }

    public final boolean getLeftMouseButtonOnly() {
        return this.leftMouseButtonOnly;
    }

    public final void setLeftMouseButtonOnly(boolean bl) {
        this.leftMouseButtonOnly = bl;
    }

    public final boolean isBusy() {
        return this.currentSession != null;
    }

    protected abstract boolean moveAfterMouseRelease();

    protected abstract boolean jbrMoveSupported(@Nullable Component var1);

    public final void update(@NotNull MouseEvent event, boolean start2) {
        Component content2;
        Component view2;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.isConsumed() || start2 && this.leftMouseButtonOnly && !SwingUtilities.isLeftMouseButton(event)) {
            return;
        }
        if (this.isBusy() && start2) {
            Logger $this$debug_u24default$iv = WindowMouseListenerSupportKt.access$getLOG$p();
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Received a mouse pressed event while in a drag session. This means that the release event was missed, cleaning up the previous session", t$iv);
            }
            this.stop();
        }
        if (!this.isBusy() && (view2 = this.source.getView(content2 = this.source.getContent(event))) != null && view2.isShowing()) {
            this.beforeUpdate(event, view2);
            this.updateCursor(event, content2, view2);
            if (start2 && this.cursorType != -1) {
                this.start(event, view2);
                event.consume();
            }
        }
    }

    protected void beforeUpdate(@NotNull MouseEvent event, @NotNull Component view2) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
    }

    private final void updateCursor(MouseEvent event, Component content2, Component view2) {
        this.cursorType = this.source.isDisabled(view2) ? -1 : this.source.getCursorType(view2, event.getLocationOnScreen());
        this.source.setCursor(content2, Cursor.getPredefinedCursor(this.cursorType == -1 ? 0 : this.cursorType));
    }

    private final void start(MouseEvent event, Component view2) {
        Point point = event.getLocationOnScreen();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocationOnScreen(...)");
        Rectangle rectangle = view2.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getBounds(...)");
        this.currentSession = new WindowListenerSession(point, rectangle, event.getButton(), false, false, 24, null);
        Logger $this$debug_u24default$iv = WindowMouseListenerSupportKt.access$getLOG$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Starting a new move/resize session: " + this.currentSession, t$iv);
        }
        this.onStarted(event, view2);
    }

    protected void onStarted(@NotNull MouseEvent event, @NotNull Component view2) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
    }

    public final void process(@NotNull MouseEvent event, boolean mouseMove) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!event.isConsumed()) {
            this.handleDragEvent(event, mouseMove);
        }
        if (!mouseMove) {
            this.handleStopEvent(event);
        }
    }

    @JdkConstants.CursorType
    public int getResizeCursor(int top, int left, int bottom, int right, @NotNull Insets resizeArea) {
        Intrinsics.checkNotNullParameter((Object)resizeArea, (String)"resizeArea");
        if (top < resizeArea.top) {
            if (left < resizeArea.left * 2) {
                return 6;
            }
            if (right < resizeArea.right * 2) {
                return 7;
            }
            return 8;
        }
        if (bottom < resizeArea.bottom) {
            if (left < resizeArea.left * 2) {
                return 4;
            }
            if (right < resizeArea.right * 2) {
                return 5;
            }
            return 9;
        }
        if (left < resizeArea.left) {
            if (top < resizeArea.top * 2) {
                return 6;
            }
            if (bottom < resizeArea.bottom * 2) {
                return 4;
            }
            return 10;
        }
        if (right < resizeArea.right) {
            if (top < resizeArea.top * 2) {
                return 7;
            }
            if (bottom < resizeArea.bottom * 2) {
                return 5;
            }
            return 11;
        }
        return -1;
    }

    private final void handleDragEvent(MouseEvent event, boolean mouseMove) {
        WindowListenerSession windowListenerSession = this.currentSession;
        if (windowListenerSession == null) {
            return;
        }
        WindowListenerSession session = windowListenerSession;
        if (mouseMove) {
            this.onDraggingStarted(session);
        }
        Component content2 = this.source.getContent(event);
        Component view2 = this.source.getView(content2);
        if (mouseMove && this.cursorType == 0 && this.jbrMoveSupported(view2)) {
            WindowMouseListenerSupportKt.access$getLOG$p().debug("Entering the move-with-the-mouse mode");
            this.enterJbrMoveMode(session, view2);
            return;
        }
        if (view2 != null) {
            Rectangle bounds = new Rectangle(session.getViewBounds());
            Point delta = this.computeOffsetFromInitialLocation(session, event);
            if (this.cursorType == 0 && view2 instanceof Frame) {
                int state2 = ((Frame)view2).getExtendedState();
                if (WindowMouseListener.isStateSet(2, state2)) {
                    delta.x = 0;
                }
                if (WindowMouseListener.isStateSet(4, state2)) {
                    delta.y = 0;
                }
            }
            Rectangle oldBounds = new Rectangle(bounds);
            this.source.updateBounds(bounds, view2, delta.x, delta.y);
            this.makeChangeValid(oldBounds, bounds, view2);
            Rectangle currentViewBounds = view2.getBounds();
            if (!Intrinsics.areEqual((Object)bounds, (Object)currentViewBounds)) {
                boolean reallyMoveWindow;
                boolean moved = bounds.x != currentViewBounds.x || bounds.y != currentViewBounds.y;
                boolean resized = bounds.width != currentViewBounds.width || bounds.height != currentViewBounds.height;
                boolean bl = reallyMoveWindow = !this.moveAfterMouseRelease() || !mouseMove;
                if (moved && reallyMoveWindow || resized) {
                    Logger $this$debug_u24default$iv = WindowMouseListenerSupportKt.access$getLOG$p();
                    Throwable t$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        Logger logger = $this$debug_u24default$iv;
                        boolean bl2 = false;
                        logger.debug("Applying the new bounds: " + bounds, t$iv);
                    }
                    this.setViewBounds(view2, bounds, moved, resized);
                }
            }
        }
        event.consume();
    }

    protected void makeChangeValid(@NotNull Rectangle oldBounds, @NotNull Rectangle newBounds, @NotNull Component view2) {
        Intrinsics.checkNotNullParameter((Object)oldBounds, (String)"oldBounds");
        Intrinsics.checkNotNullParameter((Object)newBounds, (String)"newBounds");
        Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
    }

    protected abstract void onDraggingStarted(@NotNull WindowListenerSession var1);

    @NotNull
    protected Point computeOffsetFromInitialLocation(@NotNull WindowListenerSession session, @NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Point location = session.getLocation();
        int dx = event.getXOnScreen() - location.x;
        int dy = event.getYOnScreen() - location.y;
        Point offset = new Point(dx, dy);
        Logger $this$debug_u24default$iv = WindowMouseListenerSupportKt.access$getLOG$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Relative mouse movement computed: " + event.getLocationOnScreen() + " - " + location + " = " + offset, t$iv);
        }
        return offset;
    }

    private final void setViewBounds(Component view2, Rectangle bounds, boolean moved, boolean resized) {
        view2.reshape(bounds.x, bounds.y, bounds.width, bounds.height);
        view2.invalidate();
        view2.validate();
        view2.repaint();
        if (moved) {
            this.source.notifyMoved();
        }
        if (resized) {
            this.source.notifyResized();
        }
    }

    private final void handleStopEvent(MouseEvent event) {
        WindowListenerSession windowListenerSession = this.currentSession;
        if (windowListenerSession == null) {
            return;
        }
        WindowListenerSession session = windowListenerSession;
        this.resetCursor(this.source.getContent(event));
        if (session.getExpectMouseReleased() && event.getID() == 502) {
            session.setExpectMouseReleased(false);
            event.consume();
        }
        if (session.getExpectMouseClicked() && event.getID() == 500) {
            session.setExpectMouseClicked(false);
            event.consume();
        }
        if (!session.getExpectMouseReleased() && !session.getExpectMouseClicked()) {
            this.stop();
        }
    }

    private final void resetCursor(Component content2) {
        this.source.setCursor(content2, Cursor.getPredefinedCursor(0));
    }

    private final void stop() {
        Logger $this$debug_u24default$iv = WindowMouseListenerSupportKt.access$getLOG$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("The move/resize session has finished: " + this.currentSession, t$iv);
        }
        this.currentSession = null;
    }

    private final void enterJbrMoveMode(WindowListenerSession session, Component view2) {
        WindowMove windowMove = JBR.getWindowMove();
        Intrinsics.checkNotNull((Object)view2, (String)"null cannot be cast to non-null type java.awt.Window");
        windowMove.startMovingTogetherWithMouse((Window)view2, session.getMouseButton());
        this.stop();
    }

    public /* synthetic */ WindowMouseListenerSupport(WindowMouseListenerSource source, DefaultConstructorMarker $constructor_marker) {
        this(source);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0019\n\u0002\u0010\u000e\n\u0000\b\u0084\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\tH\u00c6\u0003J;\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u00c6\u0001J\u0014\u0010\u001f\u001a\u00020\t2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010!\u001a\u00020\u0007H\u00d6\u0081\u0004J\n\u0010\"\u001a\u00020#H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\n\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0014\"\u0004\b\u0018\u0010\u0016\u00a8\u0006$"}, d2={"Lcom/intellij/ui/WindowMouseListenerSupport$WindowListenerSession;", "", "location", "Ljava/awt/Point;", "viewBounds", "Ljava/awt/Rectangle;", "mouseButton", "", "expectMouseReleased", "", "expectMouseClicked", "<init>", "(Ljava/awt/Point;Ljava/awt/Rectangle;IZZ)V", "getLocation", "()Ljava/awt/Point;", "getViewBounds", "()Ljava/awt/Rectangle;", "getMouseButton", "()I", "getExpectMouseReleased", "()Z", "setExpectMouseReleased", "(Z)V", "getExpectMouseClicked", "setExpectMouseClicked", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "toString", "", "intellij.platform.ide.impl"})
    protected static final class WindowListenerSession {
        @NotNull
        private final Point location;
        @NotNull
        private final Rectangle viewBounds;
        private final int mouseButton;
        private boolean expectMouseReleased;
        private boolean expectMouseClicked;

        public WindowListenerSession(@NotNull Point location, @NotNull Rectangle viewBounds, int mouseButton, boolean expectMouseReleased, boolean expectMouseClicked) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)viewBounds, (String)"viewBounds");
            this.location = location;
            this.viewBounds = viewBounds;
            this.mouseButton = mouseButton;
            this.expectMouseReleased = expectMouseReleased;
            this.expectMouseClicked = expectMouseClicked;
        }

        public /* synthetic */ WindowListenerSession(Point point, Rectangle rectangle, int n, boolean bl, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                bl = true;
            }
            if ((n2 & 0x10) != 0) {
                bl2 = true;
            }
            this(point, rectangle, n, bl, bl2);
        }

        @NotNull
        public final Point getLocation() {
            return this.location;
        }

        @NotNull
        public final Rectangle getViewBounds() {
            return this.viewBounds;
        }

        public final int getMouseButton() {
            return this.mouseButton;
        }

        public final boolean getExpectMouseReleased() {
            return this.expectMouseReleased;
        }

        public final void setExpectMouseReleased(boolean bl) {
            this.expectMouseReleased = bl;
        }

        public final boolean getExpectMouseClicked() {
            return this.expectMouseClicked;
        }

        public final void setExpectMouseClicked(boolean bl) {
            this.expectMouseClicked = bl;
        }

        @NotNull
        public final Point component1() {
            return this.location;
        }

        @NotNull
        public final Rectangle component2() {
            return this.viewBounds;
        }

        public final int component3() {
            return this.mouseButton;
        }

        public final boolean component4() {
            return this.expectMouseReleased;
        }

        public final boolean component5() {
            return this.expectMouseClicked;
        }

        @NotNull
        public final WindowListenerSession copy(@NotNull Point location, @NotNull Rectangle viewBounds, int mouseButton, boolean expectMouseReleased, boolean expectMouseClicked) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)viewBounds, (String)"viewBounds");
            return new WindowListenerSession(location, viewBounds, mouseButton, expectMouseReleased, expectMouseClicked);
        }

        public static /* synthetic */ WindowListenerSession copy$default(WindowListenerSession windowListenerSession, Point point, Rectangle rectangle, int n, boolean bl, boolean bl2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                point = windowListenerSession.location;
            }
            if ((n2 & 2) != 0) {
                rectangle = windowListenerSession.viewBounds;
            }
            if ((n2 & 4) != 0) {
                n = windowListenerSession.mouseButton;
            }
            if ((n2 & 8) != 0) {
                bl = windowListenerSession.expectMouseReleased;
            }
            if ((n2 & 0x10) != 0) {
                bl2 = windowListenerSession.expectMouseClicked;
            }
            return windowListenerSession.copy(point, rectangle, n, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "WindowListenerSession(location=" + this.location + ", viewBounds=" + this.viewBounds + ", mouseButton=" + this.mouseButton + ", expectMouseReleased=" + this.expectMouseReleased + ", expectMouseClicked=" + this.expectMouseClicked + ")";
        }

        public int hashCode() {
            int result2 = this.location.hashCode();
            result2 = result2 * 31 + this.viewBounds.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.mouseButton);
            result2 = result2 * 31 + Boolean.hashCode(this.expectMouseReleased);
            result2 = result2 * 31 + Boolean.hashCode(this.expectMouseClicked);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WindowListenerSession)) {
                return false;
            }
            WindowListenerSession windowListenerSession = (WindowListenerSession)other;
            if (!Intrinsics.areEqual((Object)this.location, (Object)windowListenerSession.location)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.viewBounds, (Object)windowListenerSession.viewBounds)) {
                return false;
            }
            if (this.mouseButton != windowListenerSession.mouseButton) {
                return false;
            }
            if (this.expectMouseReleased != windowListenerSession.expectMouseReleased) {
                return false;
            }
            return this.expectMouseClicked == windowListenerSession.expectMouseClicked;
        }
    }
}

