/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.ApdexData;
import com.intellij.diagnostic.CheckerState;
import com.intellij.diagnostic.IdePerformanceListener;
import com.intellij.diagnostic.JitWatcher;
import com.intellij.diagnostic.PerformanceListener;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.diagnostic.PerformanceWatcherImpl;
import com.intellij.diagnostic.PerformanceWatcherImplKt;
import com.intellij.diagnostic.SamplingTask;
import com.intellij.diagnostic.ThreadDump;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutineSupport;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.platform.diagnostic.telemetry.Scope;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.io.BlockingKt;
import java.awt.Toolkit;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.management.ThreadInfo;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.ModalityEvent;
import sun.awt.ModalityListener;
import sun.awt.SunToolkit;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0003IJKB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001f\u001a\u00020 H\u0016J\u000e\u0010!\u001a\u00020 H\u0082@\u00a2\u0006\u0002\u0010\"J8\u0010#\u001a\u00020 2(\u0010$\u001a$\b\u0001\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0&\u0012\u0006\u0012\u0004\u0018\u00010'0%H\u0096@\u00a2\u0006\u0002\u0010(J\u0016\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020\u000eH\u0082@\u00a2\u0006\u0002\u0010+J\u0015\u00107\u001a\u0002082\u000b\u00109\u001a\u000702\u00a2\u0006\u0002\b:H\u0016J\b\u0010;\u001a\u00020 H\u0017J\b\u0010<\u001a\u00020 H\u0017J\u0016\u0010=\u001a\u00020 2\f\u0010>\u001a\b\u0018\u00010\u0010R\u00020\u0000H\u0002J\"\u0010?\u001a\u0004\u0018\u00010\u00072\u0006\u0010@\u001a\u0002022\u0006\u0010A\u001a\u00020\u001a2\u0006\u0010B\u001a\u00020\u001aH\u0016J*\u0010?\u001a\u0004\u0018\u00010\u00072\u0006\u0010@\u001a\u0002022\u0006\u0010A\u001a\u00020\u001a2\u0006\u0010C\u001a\u0002022\u0006\u0010B\u001a\u00020\u001aH\u0002J\"\u0010?\u001a\u0004\u0018\u00010\u00072\u0006\u0010@\u001a\u0002022\u0006\u0010A\u001a\u00020\u001a2\u0006\u0010D\u001a\u000202H\u0002J\b\u0010E\u001a\u000202H\u0002J\b\u0010F\u001a\u00020 H\u0016J\b\u0010G\u001a\u00020HH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0018\u00010\u0010R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0018\u00010\u0010R\u00020\u00000\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010.R\u0016\u00101\u001a\u0004\u0018\u0001028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0014\u00105\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010.\u00a8\u0006L"}, d2={"Lcom/intellij/diagnostic/PerformanceWatcherImpl;", "Lcom/intellij/diagnostic/PerformanceWatcher;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "logDir", "Ljava/nio/file/Path;", "Lorg/jetbrains/annotations/NotNull;", "swingApdex", "Lcom/intellij/diagnostic/ApdexData;", "kotlin.jvm.PlatformType", "generalApdex", "lastSampling", "", "currentEdtEventChecker", "Lcom/intellij/diagnostic/PerformanceWatcherImpl$FreezeCheckerTask;", "jitWatcher", "Lcom/intellij/diagnostic/JitWatcher;", "unresponsiveIntervalLazy", "Lcom/intellij/openapi/util/registry/RegistryValue;", "getUnresponsiveIntervalLazy", "()Lcom/intellij/openapi/util/registry/RegistryValue;", "unresponsiveIntervalLazy$delegate", "Lkotlin/Lazy;", "isActive", "", "smokeAndMirrorsCounter", "", "taskFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "startEdtSampling", "", "asyncInit", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "processUnfinishedFreeze", "consumer", "Lkotlin/Function3;", "Lkotlin/coroutines/Continuation;", "", "(Lkotlin/jvm/functions/Function3;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "samplePerformance", "samplingIntervalMs", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dumpInterval", "getDumpInterval", "()I", "maxDumpDuration", "getMaxDumpDuration", "jitProblem", "", "getJitProblem", "()Ljava/lang/String;", "unresponsiveInterval", "getUnresponsiveInterval", "smokeAndMirrors", "Lcom/intellij/openapi/application/AccessToken;", "name", "Lorg/jetbrains/annotations/NonNls;", "edtEventStarted", "edtEventFinished", "stopCurrentTaskAndReEmit", "task", "dumpThreads", "pathPrefix", "appendMillisecondsToFileName", "stripDump", "contentsPrefix", "rawDump", "getMemoryUsage", "clearFreezeStacktraces", "newSnapshot", "Lcom/intellij/diagnostic/PerformanceWatcher$Snapshot;", "FreezeCheckerTask", "MySamplingTask", "SnapshotImpl", "intellij.platform.ide.impl"})
public final class PerformanceWatcherImpl
extends PerformanceWatcher {
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final Path logDir;
    private volatile ApdexData swingApdex;
    private volatile ApdexData generalApdex;
    private volatile long lastSampling;
    @Nullable
    private FreezeCheckerTask currentEdtEventChecker;
    @NotNull
    private final JitWatcher jitWatcher;
    @NotNull
    private final Lazy unresponsiveIntervalLazy$delegate;
    private final boolean isActive;
    private int smokeAndMirrorsCounter;
    @NotNull
    private final MutableSharedFlow<FreezeCheckerTask> taskFlow;

    public PerformanceWatcherImpl(@NotNull CoroutineScope coroutineScope) {
        block1: {
            Toolkit toolkit;
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            this.coroutineScope = coroutineScope;
            Path path = PathManager.getLogDir();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getLogDir(...)");
            this.logDir = path;
            this.swingApdex = ApdexData.EMPTY;
            this.generalApdex = ApdexData.EMPTY;
            this.lastSampling = System.nanoTime();
            this.jitWatcher = new JitWatcher();
            this.unresponsiveIntervalLazy$delegate = LazyKt.lazy(PerformanceWatcherImpl::unresponsiveIntervalLazy_delegate$lambda$0);
            this.isActive = !ApplicationManager.getApplication().isHeadlessEnvironment();
            this.taskFlow = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
            if (this.isActive) {
                PerformanceWatcherImplKt.access$getLOG().debug("Freeze detection started");
                BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)new CoroutineName("EDT freeze detector")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ PerformanceWatcherImpl this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                v0 = PerformanceWatcherImpl.access$asyncInit(this.this$0, (Continuation)this);
                                if (v0 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                this.label = 2;
                                v1 = FlowKt.collectLatest((Flow)((Flow)PerformanceWatcherImpl.access$getTaskFlow$p(this.this$0)), (Function2)((Function2)new Function2<FreezeCheckerTask, Continuation<? super Unit>, Object>(this.this$0, null){
                                    int label;
                                    /* synthetic */ Object L$0;
                                    final /* synthetic */ PerformanceWatcherImpl this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(2, $completion);
                                    }

                                    /*
                                     * Unable to fully structure code
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        var2_2 = (FreezeCheckerTask)this.L$0;
                                        var3_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                if (task == null) {
                                                    return Unit.INSTANCE;
                                                }
                                                this.L$0 = task;
                                                this.label = 1;
                                                v0 = DelayKt.delay((long)this.this$0.getUnresponsiveInterval(), (Continuation)((Continuation)this));
                                                if (v0 == var3_3) {
                                                    return var3_3;
                                                }
                                                ** GOTO lbl17
                                            }
                                            case 1: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                v0 = $result;
lbl17:
                                                // 2 sources

                                                task.edtFrozen();
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                        var3_3.L$0 = value;
                                        return (Continuation)var3_3;
                                    }

                                    public final Object invoke(FreezeCheckerTask p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (v1 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl21
                            }
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl21:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            }
            SunToolkit sunToolkit = (toolkit = Toolkit.getDefaultToolkit()) instanceof SunToolkit ? (SunToolkit)toolkit : null;
            if (sunToolkit == null) break block1;
            sunToolkit.addModalityListener(new ModalityListener(){

                @Override
                public void modalityPushed(ModalityEvent ev) {
                    Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
                }

                @Override
                public void modalityPopped(ModalityEvent ev) {
                    Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
                    this.stopCurrentTaskAndReEmit(new FreezeCheckerTask(System.nanoTime()));
                }
            });
        }
    }

    private final RegistryValue getUnresponsiveIntervalLazy() {
        Lazy lazy = this.unresponsiveIntervalLazy$delegate;
        return (RegistryValue)lazy.getValue();
    }

    public void startEdtSampling() {
        if (!this.isActive) {
            return;
        }
        PerformanceWatcherImplKt.access$getLOG().debug("EDT sampling started");
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)new CoroutineName("EDT sampling")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            long J$0;
            int label;
            final /* synthetic */ PerformanceWatcherImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        samplingIntervalMs = 1000L;
                        if (samplingIntervalMs > 0L) ** GOTO lbl12
                        var4_5 = Unit.INSTANCE;
                        PerformanceWatcherImplKt.access$getLOG().debug("EDT sampling stopped");
                        return var4_5;
lbl12:
                        // 2 sources

                        while (true) {
                            this.J$0 = samplingIntervalMs;
                            this.label = 1;
                            v0 = DelayKt.delay((long)samplingIntervalMs, (Continuation)((Continuation)this));
                            ** if (v0 != var5_2) goto lbl20
lbl19:
                            // 1 sources

                            return var5_2;
lbl20:
                            // 1 sources

                            ** GOTO lbl27
                            break;
                        }
                    }
                    case 1: {
                        samplingIntervalMs = this.J$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl27:
                        // 2 sources

                        this.J$0 = samplingIntervalMs;
                        this.label = 2;
                        v1 = PerformanceWatcherImpl.access$samplePerformance(this.this$0, samplingIntervalMs, (Continuation)this);
                        ** if (v1 != var5_2) goto lbl32
lbl31:
                        // 1 sources

                        return var5_2;
lbl32:
                        // 1 sources

                        ** GOTO lbl39
                    }
                    case 2: {
                        samplingIntervalMs = this.J$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl39:
                            // 2 sources

                            ** continue;
                        }
                        catch (Throwable var2_4) {
                            PerformanceWatcherImplKt.access$getLOG().debug("EDT sampling stopped");
                            throw var2_4;
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object asyncInit(Continuation<? super Unit> $completion) {
        if (!($completion instanceof asyncInit.1)) ** GOTO lbl-1000
        var6_2 = $completion;
        if ((var6_2.label & -2147483648) != 0) {
            var6_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ PerformanceWatcherImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return PerformanceWatcherImpl.access$asyncInit(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var2_5 = this;
                $this$asyncInit_u24lambda_u240 = var2_5;
                $i$a$-runCatching-PerformanceWatcherImpl$asyncInit$2 = 0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$asyncInit_u24lambda_u240);
                $continuation.I$0 = $i$a$-runCatching-PerformanceWatcherImpl$asyncInit$2;
                $continuation.label = 1;
                v0 = PerformanceWatcherImplKt.access$reportCrashesIfAny((Continuation)$continuation);
                ** if (v0 != var7_4) goto lbl24
lbl23:
                // 1 sources

                return var7_4;
lbl24:
                // 1 sources

                ** GOTO lbl32
            }
            case 1: {
                $i$a$-runCatching-PerformanceWatcherImpl$asyncInit$2 = $continuation.I$0;
                $this$asyncInit_u24lambda_u240 = (PerformanceWatcherImpl)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl32:
                    // 2 sources

                    var3_6 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable var4_9) {
                    var3_6 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var4_9));
                }
                LoggerKt.getOrLogException((Object)var3_6, (Logger)PerformanceWatcherImplKt.access$getLOG());
                $continuation.L$0 = null;
                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ PerformanceWatcherImpl this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                PerformanceWatcherImplKt.access$cleanOldFiles(PerformanceWatcherImpl.access$getLogDir$p(this.this$0), 0);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var7_4) {
                    return var7_4;
                }
                ** GOTO lbl48
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl48:
                // 2 sources

                if (ApplicationInfoImpl.getShadowInstance().isEAP()) {
                    BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                        Object L$1;
                        int I$0;
                        int label;
                        private /* synthetic */ Object L$0;
                        final /* synthetic */ PerformanceWatcherImpl this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        public final Object invokeSuspend(Object $result) {
                            var2_2 = (CoroutineScope)this.L$0;
                            var6_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = ApplicationManager.getApplication();
                                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getApplication(...)");
                                    $this$serviceAsync$iv = (ComponentManager)v0;
                                    $i$f$serviceAsync = 0;
                                    this.L$0 = $this$launch;
                                    this.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$serviceAsync$iv);
                                    this.I$0 = $i$f$serviceAsync;
                                    this.label = 1;
                                    v1 = ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(RegistryManager.class, (Continuation)this);
                                    if (v1 == var6_3) {
                                        return var6_3;
                                    }
                                    ** GOTO lbl24
                                }
                                case 1: {
                                    $i$f$serviceAsync = this.I$0;
                                    $this$serviceAsync$iv = (ComponentManager)this.L$1;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v1 = $result;
lbl24:
                                    // 2 sources

                                    reasonableThreadPoolSize = ((RegistryManager)v1).get("reasonable.application.thread.pool.size");
                                    v2 = AppExecutorUtil.getAppScheduledExecutorService();
                                    Intrinsics.checkNotNull((Object)v2, (String)"null cannot be cast to non-null type com.intellij.util.concurrency.AppScheduledExecutorService");
                                    service = (AppScheduledExecutorService)v2;
                                    allAvailableProcessors = Runtime.getRuntime().availableProcessors();
                                    service.setNewThreadListener((BiConsumer<Object, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, invokeSuspend$lambda$1(kotlin.jvm.functions.Function2 java.lang.Object java.lang.Object ), (Ljava/lang/Object;Ljava/lang/Object;)V)((Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.util.concurrency.AppScheduledExecutorService com.intellij.openapi.util.registry.RegistryValue int kotlinx.coroutines.CoroutineScope com.intellij.diagnostic.PerformanceWatcherImpl java.lang.Thread java.lang.Runnable ), (Ljava/lang/Thread;Ljava/lang/Runnable;)Lkotlin/Unit;)((AppScheduledExecutorService)service, (RegistryValue)reasonableThreadPoolSize, (int)allAvailableProcessors, (CoroutineScope)$this$launch, (PerformanceWatcherImpl)this.this$0)));
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value;
                            return (Continuation)var3_3;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }

                        private static final Unit invokeSuspend$lambda$0(AppScheduledExecutorService $service, RegistryValue $reasonableThreadPoolSize, int $allAvailableProcessors, CoroutineScope $$this$launch, PerformanceWatcherImpl this$0, Thread thread, Runnable runnable2) {
                            int executorSize = $service.getBackendPoolExecutorSize();
                            if (executorSize > $reasonableThreadPoolSize.asInteger() + $allAvailableProcessors) {
                                BuildersKt.launch$default((CoroutineScope)$$this$launch, (CoroutineContext)((CoroutineContext)BlockingKt.getBlockingDispatcher()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(executorSize, $reasonableThreadPoolSize, $allAvailableProcessors, this$0, null){
                                    int label;
                                    final /* synthetic */ int $executorSize;
                                    final /* synthetic */ RegistryValue $reasonableThreadPoolSize;
                                    final /* synthetic */ int $allAvailableProcessors;
                                    final /* synthetic */ PerformanceWatcherImpl this$0;
                                    {
                                        this.$executorSize = $executorSize;
                                        this.$reasonableThreadPoolSize = $reasonableThreadPoolSize;
                                        this.$allAvailableProcessors = $allAvailableProcessors;
                                        this.this$0 = $receiver;
                                        super(2, $completion);
                                    }

                                    public final Object invokeSuspend(Object $result) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                String message = "Too many threads: " + this.$executorSize + " created in the global Application pool. (" + this.$reasonableThreadPoolSize + ", available processors: " + this.$allAvailableProcessors + ")";
                                                Path file2 = PerformanceWatcherImpl.access$dumpThreads(this.this$0, "newPooledThread/", true, message, true);
                                                Path path = file2;
                                                PerformanceWatcherImplKt.access$getLOG().info(message + (String)(path == null ? "" : "; thread dump is saved to '" + path + "'"));
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)2, null);
                            }
                            return Unit.INSTANCE;
                        }

                        private static final void invokeSuspend$lambda$1(Function2 $tmp0, Object p0, Object p1) {
                            $tmp0.invoke(p0, p1);
                        }
                    }), (int)3, null);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object processUnfinishedFreeze(@NotNull Function3<? super Path, ? super Integer, ? super Continuation<? super Unit>, ? extends Object> consumer, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof processUnfinishedFreeze.1)) ** GOTO lbl-1000
        var9_3 = $completion;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ PerformanceWatcherImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.processUnfinishedFreeze(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = consumer;
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends Path>>, Object>(this, null){
                    int label;
                    final /* synthetic */ PerformanceWatcherImpl this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                List list2;
                                ResultKt.throwOnFailure((Object)$result);
                                Closeable closeable = Files.newDirectoryStream(PerformanceWatcherImpl.access$getLogDir$p(this.this$0), arg_0 -> processUnfinishedFreeze.files.1.invokeSuspend$lambda$1(processUnfinishedFreeze.files.1::invokeSuspend$lambda$0, arg_0));
                                Throwable throwable = null;
                                try {
                                    DirectoryStream it = (DirectoryStream)closeable;
                                    boolean bl = false;
                                    Intrinsics.checkNotNull((Object)it);
                                    list2 = CollectionsKt.sorted((Iterable)it);
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                                }
                                return list2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends Path>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final boolean invokeSuspend$lambda$0(Path it) {
                        return StringsKt.startsWith$default((String)((Object)it.getFileName()).toString(), (String)"threadDumps-", (boolean)false, (int)2, null);
                    }

                    private static final boolean invokeSuspend$lambda$1(Function1 $tmp0, Object p0) {
                        return (Boolean)$tmp0.invoke(p0);
                    }
                }), (Continuation)$continuation);
                ** if (v0 != var10_5) goto lbl19
lbl18:
                // 1 sources

                return var10_5;
lbl19:
                // 1 sources

                ** GOTO lbl26
            }
            case 1: {
                consumer = (Function3)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl26:
                    // 2 sources

                    var4_6 = (List)v0;
                }
                catch (NoSuchFileException <unused var>) {
                    return Unit.INSTANCE;
                }
                files = var4_6;
                var4_6 = files.iterator();
lbl32:
                // 5 sources

                while (var4_6.hasNext()) {
                    file = (Path)var4_6.next();
                    marker = file.resolve(".duration");
                    $continuation.L$0 = consumer;
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)files);
                    $continuation.L$2 = var4_6;
                    $continuation.L$3 = file;
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)marker);
                    $continuation.label = 2;
                    v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Integer>, Object>(marker, null){
                        int label;
                        final /* synthetic */ Path $marker;
                        {
                            this.$marker = $marker;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    Object v1;
                                    ResultKt.throwOnFailure((Object)$result);
                                    if (Files.exists(this.$marker, new LinkOption[0])) {
                                        void var2_2;
                                        String string = Files.readString(this.$marker);
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
                                        Integer duration2 = StringsKt.toIntOrNull((String)string);
                                        Files.deleteIfExists(this.$marker);
                                        v1 = var2_2;
                                    } else {
                                        v1 = null;
                                    }
                                    return v1;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Integer> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    ** if (v1 != var10_5) goto lbl46
lbl45:
                    // 1 sources

                    return var10_5;
lbl46:
                    // 1 sources

                    ** GOTO lbl58
                }
                break;
            }
            case 2: {
                marker = (Path)$continuation.L$4;
                file = (Path)$continuation.L$3;
                var4_6 = (Iterator)$continuation.L$2;
                files = (List)$continuation.L$1;
                consumer = (Function3)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl58:
                // 2 sources

                v2 = (Integer)v1;
                if (v2 != null) ** GOTO lbl61
                ** GOTO lbl32
lbl61:
                // 1 sources

                duration = v2;
                Intrinsics.checkNotNull((Object)file);
                $continuation.L$0 = consumer;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)files);
                $continuation.L$2 = var4_6;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)file);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)marker);
                $continuation.I$0 = duration;
                $continuation.label = 3;
                v3 = consumer.invoke((Object)file, (Object)Boxing.boxInt((int)duration), (Object)$continuation);
                if (v3 != var10_5) ** GOTO lbl32
                return var10_5;
            }
            case 3: {
                duration = $continuation.I$0;
                marker = (Path)$continuation.L$4;
                file = (Path)$continuation.L$3;
                var4_6 = (Iterator)$continuation.L$2;
                files = (List)$continuation.L$1;
                consumer = (Function3)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
                }
                catch (Exception var7_12) {}
                ** GOTO lbl32
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object samplePerformance(long samplingIntervalMs, Continuation<? super Unit> $completion) {
        if (!($completion instanceof samplePerformance.1)) ** GOTO lbl-1000
        var13_3 = $completion;
        if ((var13_3.label & -2147483648) != 0) {
            var13_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                long J$0;
                long J$1;
                long J$2;
                /* synthetic */ Object result;
                final /* synthetic */ PerformanceWatcherImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return PerformanceWatcherImpl.access$samplePerformance(this.this$0, 0L, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                current = System.nanoTime();
                this.lastSampling = current;
                for (diffMs = TimeUnit.NANOSECONDS.toMillis(current - this.lastSampling) - samplingIntervalMs; diffMs >= 0L; diffMs -= samplingIntervalMs) {
                    this.generalApdex = this.generalApdex.withEvent(100L, diffMs);
                }
                this.jitWatcher.checkJitState();
                PerformanceWatcherImplKt.access$getLOG().trace("Scheduling EDT sample");
                v0 = CoroutinesKt.ui$default((Dispatchers)Dispatchers.INSTANCE, (CoroutineSupport.UiDispatcherKind)CoroutineSupport.UiDispatcherKind.STRICT, (boolean)false, (int)2, null);
                v1 = ModalityState.any();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"any(...)");
                $continuation.J$0 = samplingIntervalMs;
                $continuation.J$1 = current;
                $continuation.J$2 = diffMs;
                $continuation.label = 1;
                v2 = BuildersKt.withContext((CoroutineContext)v0.plus(ModalityKt.asContextElement((ModalityState)v1)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Long>, Object>(current, null){
                    int label;
                    final /* synthetic */ long $current;
                    {
                        this.$current = $current;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                PerformanceWatcherImplKt.access$getLOG().trace("Processing EDT sample");
                                return Boxing.boxLong((long)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.$current));
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Long> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v2 == var14_5) {
                    return var14_5;
                }
                ** GOTO lbl36
            }
            case 1: {
                diffMs = $continuation.J$2;
                current = $continuation.J$1;
                samplingIntervalMs = $continuation.J$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl36:
                // 2 sources

                latencyMs = ((Number)v2).longValue();
                this.swingApdex = this.swingApdex.withEvent(100L, latencyMs);
                for (PerformanceListener listener : PerformanceWatcherImplKt.access$getEP_NAME$p().getExtensionList()) {
                    listener.uiResponded(latencyMs);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public int getDumpInterval() {
        return RangesKt.coerceIn((int)5000, (int)500, (int)this.getUnresponsiveInterval());
    }

    public int getMaxDumpDuration() {
        return RangesKt.coerceIn((int)(this.getDumpInterval() * 20), (int)0, (int)40000);
    }

    @Nullable
    public String getJitProblem() {
        return this.jitWatcher.getJitProblem();
    }

    public int getUnresponsiveInterval() {
        int value = this.getUnresponsiveIntervalLazy().asInteger();
        return value <= 0 ? 0 : RangesKt.coerceIn((int)value, (int)500, (int)20000);
    }

    @NotNull
    public AccessToken smokeAndMirrors(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        PerformanceWatcherImplKt.access$getLOG().trace("Entered smokeAndMirrors phase: " + name2);
        ThreadingAssertions.assertEventDispatchThread();
        int n = this.smokeAndMirrorsCounter;
        this.smokeAndMirrorsCounter = n + 1;
        AccessToken accessToken = AccessToken.create(() -> PerformanceWatcherImpl.smokeAndMirrors$lambda$0(name2, this));
        Intrinsics.checkNotNullExpressionValue((Object)accessToken, (String)"create(...)");
        return accessToken;
    }

    @ApiStatus.Internal
    public void edtEventStarted() {
        if (!this.isActive) {
            return;
        }
        if (this.smokeAndMirrorsCounter > 0) {
            return;
        }
        this.stopCurrentTaskAndReEmit(new FreezeCheckerTask(System.nanoTime()));
    }

    @ApiStatus.Internal
    public void edtEventFinished() {
        if (!this.isActive) {
            return;
        }
        if (this.smokeAndMirrorsCounter > 0) {
            return;
        }
        this.stopCurrentTaskAndReEmit(null);
    }

    private final void stopCurrentTaskAndReEmit(FreezeCheckerTask task) {
        FreezeCheckerTask freezeCheckerTask = this.currentEdtEventChecker;
        if (freezeCheckerTask != null) {
            freezeCheckerTask.stop();
        }
        this.currentEdtEventChecker = task;
        if (!this.taskFlow.tryEmit((Object)task)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    @Nullable
    public Path dumpThreads(@NotNull String pathPrefix, boolean appendMillisecondsToFileName, boolean stripDump) {
        Intrinsics.checkNotNullParameter((Object)pathPrefix, (String)"pathPrefix");
        return this.dumpThreads(pathPrefix, appendMillisecondsToFileName, "", stripDump);
    }

    private final Path dumpThreads(String pathPrefix, boolean appendMillisecondsToFileName, String contentsPrefix, boolean stripDump) {
        String rawDump = contentsPrefix + ThreadDumper.getThreadDumpInfo((ThreadInfo[])ThreadDumper.getThreadInfos(), (boolean)stripDump).getRawDump();
        return this.dumpThreads(pathPrefix, appendMillisecondsToFileName, rawDump);
    }

    private final Path dumpThreads(String pathPrefix, boolean appendMillisecondsToFileName, String rawDump) {
        Object effectivePathPrefix = pathPrefix;
        if (!StringsKt.contains$default((CharSequence)((CharSequence)effectivePathPrefix), (char)'/', (boolean)false, (int)2, null)) {
            ZonedDateTime zonedDateTime = PerformanceWatcherImplKt.access$getIdeStartTime$p();
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"access$getIdeStartTime$p(...)");
            effectivePathPrefix = "threadDumps-" + (String)effectivePathPrefix + "-" + PerformanceWatcherImplKt.access$formatTime(zonedDateTime) + "-" + PerformanceWatcherImplKt.access$buildName() + "/";
        } else if (!StringsKt.startsWith$default((String)effectivePathPrefix, (String)"threadDumps-", (boolean)false, (int)2, null)) {
            effectivePathPrefix = "threadDumps-" + (String)effectivePathPrefix;
        }
        ZonedDateTime now = ZonedDateTime.now();
        String suffix = appendMillisecondsToFileName ? "-" + now.toInstant().toEpochMilli() : "";
        Intrinsics.checkNotNull((Object)now);
        Path file2 = this.logDir.resolve((String)effectivePathPrefix + "threadDump-" + PerformanceWatcherImplKt.access$formatTime(now) + suffix + ".txt");
        Path dir = file2.getParent();
        String memoryUsage = this.getMemoryUsage();
        if (!(((CharSequence)memoryUsage).length() == 0)) {
            PerformanceWatcherImplKt.access$getLOG().info(memoryUsage + " while dumping threads to " + file2);
        }
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            Files.writeString(file2, (CharSequence)rawDump, new OpenOption[0]);
        }
        catch (IOException e) {
            PerformanceWatcherImplKt.access$getLOG().info("Failed to write the thread dump file", (Throwable)e);
        }
        return file2;
    }

    private final String getMemoryUsage() {
        String jitProblem;
        Runtime rt = Runtime.getRuntime();
        long maxMemory = rt.maxMemory();
        long usedMemory = rt.totalMemory() - rt.freeMemory();
        long freeMemory = maxMemory - usedMemory;
        Object diagnosticInfo = "";
        if (freeMemory < maxMemory / (long)5) {
            diagnosticInfo = "High memory usage (free " + freeMemory / (long)1024 / (long)1024 + " of " + maxMemory / (long)1024 / (long)1024 + " MB)";
        }
        if ((jitProblem = this.getJitProblem()) != null) {
            if (!(((CharSequence)diagnosticInfo).length() == 0)) {
                diagnosticInfo = (String)diagnosticInfo + ", ";
            }
            diagnosticInfo = (String)diagnosticInfo + jitProblem;
        }
        return diagnosticInfo;
    }

    public void clearFreezeStacktraces() {
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ PerformanceWatcherImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        FreezeCheckerTask freezeCheckerTask = PerformanceWatcherImpl.access$getCurrentEdtEventChecker$p(this.this$0);
                        if (freezeCheckerTask == null) break;
                        this.label = 1;
                        Object object2 = freezeCheckerTask.stopDumpingAsync((Continuation<? super Unit>)((Continuation)this));
                        if (object2 == object) {
                            return object;
                        }
                        break;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        break;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    protected PerformanceWatcher.Snapshot newSnapshot() {
        return new SnapshotImpl(this);
    }

    private static final RegistryValue unresponsiveIntervalLazy_delegate$lambda$0() {
        return RegistryManager.Companion.getInstance().get("performance.watcher.unresponsive.interval.ms");
    }

    private static final void smokeAndMirrors$lambda$0(String $name, PerformanceWatcherImpl this$0) {
        PerformanceWatcherImplKt.access$getLOG().trace("Exited smokeAndMirrors phase: " + $name);
        ThreadingAssertions.assertEventDispatchThread();
        int n = this$0.smokeAndMirrorsCounter;
        this$0.smokeAndMirrorsCounter = n + -1;
    }

    public static final /* synthetic */ Object access$samplePerformance(PerformanceWatcherImpl $this, long samplingIntervalMs, Continuation $completion) {
        return $this.samplePerformance(samplingIntervalMs, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$asyncInit(PerformanceWatcherImpl $this, Continuation $completion) {
        return $this.asyncInit((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Path access$dumpThreads(PerformanceWatcherImpl $this, String pathPrefix, boolean appendMillisecondsToFileName, String contentsPrefix, boolean stripDump) {
        return $this.dumpThreads(pathPrefix, appendMillisecondsToFileName, contentsPrefix, stripDump);
    }

    public static final /* synthetic */ FreezeCheckerTask access$getCurrentEdtEventChecker$p(PerformanceWatcherImpl $this) {
        return $this.currentEdtEventChecker;
    }

    public static final /* synthetic */ Path access$dumpThreads(PerformanceWatcherImpl $this, String pathPrefix, boolean appendMillisecondsToFileName, String rawDump) {
        return $this.dumpThreads(pathPrefix, appendMillisecondsToFileName, rawDump);
    }

    public static final /* synthetic */ MutableSharedFlow access$getTaskFlow$p(PerformanceWatcherImpl $this) {
        return $this.taskFlow;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\nH\u0086@\u00a2\u0006\u0002\u0010\rJ\f\u0010\u000e\u001a\u00060\u000fR\u00020\u0010H\u0002J\u0014\u0010\u0011\u001a\u00020\n2\n\u0010\u0012\u001a\u00060\u000fR\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/diagnostic/PerformanceWatcherImpl$FreezeCheckerTask;", "", "taskStart", "", "<init>", "(Lcom/intellij/diagnostic/PerformanceWatcherImpl;J)V", "state", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/diagnostic/CheckerState;", "stop", "", "edtFrozen", "stopDumpingAsync", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startFreezeReporting", "Lcom/intellij/diagnostic/PerformanceWatcherImpl$MySamplingTask;", "Lcom/intellij/diagnostic/PerformanceWatcherImpl;", "stopFreezeReporting", "task", "intellij.platform.ide.impl"})
    private final class FreezeCheckerTask {
        private final long taskStart;
        @NotNull
        private final AtomicReference<CheckerState> state;

        public FreezeCheckerTask(long taskStart) {
            this.taskStart = taskStart;
            this.state = new AtomicReference<CheckerState.CHECKING>(CheckerState.CHECKING.INSTANCE);
        }

        public final void stop() {
            CheckerState oldState = this.state.getAndSet(CheckerState.FINISHED.INSTANCE);
            if (oldState instanceof CheckerState.FREEZE_LOGGING) {
                MySamplingTask task = ((CheckerState.FREEZE_LOGGING)oldState).getDumpDask();
                this.stopFreezeReporting(task);
            }
        }

        public final void edtFrozen() {
            if (!this.state.compareAndSet(CheckerState.CHECKING.INSTANCE, CheckerState.FREEZE_DETECTED.INSTANCE)) {
                return;
            }
            MySamplingTask dumpTask = this.startFreezeReporting();
            if (!this.state.compareAndSet(CheckerState.FREEZE_DETECTED.INSTANCE, new CheckerState.FREEZE_LOGGING(dumpTask))) {
                this.stopFreezeReporting(dumpTask);
            }
        }

        @Nullable
        public final Object stopDumpingAsync(@NotNull Continuation<? super Unit> $completion) {
            CheckerState oldState = this.state.getAndSet(CheckerState.FINISHED.INSTANCE);
            if (oldState instanceof CheckerState.FREEZE_LOGGING) {
                Object object = ((CheckerState.FREEZE_LOGGING)oldState).getDumpDask().stopDumpingThreads($completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            return Unit.INSTANCE;
        }

        private final MySamplingTask startFreezeReporting() {
            MySamplingTask dumpTask;
            block1: {
                ZonedDateTime zonedDateTime = ZonedDateTime.now();
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"now(...)");
                String freezeFolder = "threadDumps-freeze-" + PerformanceWatcherImplKt.access$formatTime(zonedDateTime) + "-" + PerformanceWatcherImplKt.access$buildName();
                Path reportDir = PerformanceWatcherImpl.this.logDir.resolve(freezeFolder);
                Files.createDirectories(reportDir, new FileAttribute[0]);
                for (PerformanceListener listener2 : PerformanceWatcherImplKt.access$getEP_NAME$p().getExtensionList()) {
                    Intrinsics.checkNotNull((Object)reportDir);
                    listener2.uiFreezeStarted(reportDir, PerformanceWatcherImpl.this.coroutineScope);
                }
                dumpTask = new MySamplingTask(freezeFolder, this.taskStart);
                IdePerformanceListener idePerformanceListener = PerformanceWatcherImplKt.access$getPublisher();
                if (idePerformanceListener == null) break block1;
                Intrinsics.checkNotNull((Object)reportDir);
                idePerformanceListener.uiFreezeStarted(reportDir);
            }
            return dumpTask;
        }

        private final void stopFreezeReporting(MySamplingTask task) {
            long taskStop = System.nanoTime();
            BuildersKt.launch$default((CoroutineScope)PerformanceWatcherImpl.this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(task, taskStop, this, PerformanceWatcherImpl.this, null){
                int label;
                final /* synthetic */ MySamplingTask $task;
                final /* synthetic */ long $taskStop;
                final /* synthetic */ FreezeCheckerTask this$0;
                final /* synthetic */ PerformanceWatcherImpl this$1;
                {
                    this.$task = $task;
                    this.$taskStop = $taskStop;
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = this.$task.stopDumpingThreads((Continuation<? super Unit>)((Continuation)this));
                            if (v0 == var9_2) {
                                return var9_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            durationMs = TimeUnit.MILLISECONDS.convert(this.$taskStop - FreezeCheckerTask.access$getTaskStart$p(this.this$0), TimeUnit.NANOSECONDS);
                            freezeFolder = this.$task.freezeFolder;
                            freezeDir = PerformanceWatcherImpl.access$getLogDir$p(this.this$1).resolve(freezeFolder);
                            for (PerformanceListener listener : PerformanceWatcherImplKt.access$getEP_NAME$p().getExtensionList()) {
                                listener.uiFreezeFinished(durationMs, freezeDir);
                            }
                            v1 = PerformanceWatcherImplKt.access$getPublisher();
                            if (v1 != null) {
                                v1.uiFreezeFinished(durationMs, freezeDir);
                            }
                            v2 = this.$task;
                            v3 = PerformanceWatcherImpl.access$getLogDir$p(this.this$1).resolve(freezeFolder);
                            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"resolve(...)");
                            reportDir = PerformanceWatcherImplKt.access$postProcessReportFolder(durationMs, v2, v3, PerformanceWatcherImpl.access$getLogDir$p(this.this$1));
                            for (PerformanceListener listener : PerformanceWatcherImplKt.access$getEP_NAME$p().getExtensionList()) {
                                listener.uiFreezeRecorded(durationMs, reportDir);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        public static final /* synthetic */ long access$getTaskStart$p(FreezeCheckerTask $this) {
            return $this.taskStart;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0094@\u00a2\u0006\u0002\u0010\fR\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/diagnostic/PerformanceWatcherImpl$MySamplingTask;", "Lcom/intellij/diagnostic/SamplingTask;", "freezeFolder", "", "taskStart", "", "<init>", "(Lcom/intellij/diagnostic/PerformanceWatcherImpl;Ljava/lang/String;J)V", "dumpedThreads", "", "threadDump", "Lcom/intellij/diagnostic/ThreadDump;", "(Lcom/intellij/diagnostic/ThreadDump;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.ide.impl"})
    public final class MySamplingTask
    extends SamplingTask {
        @JvmField
        @NotNull
        public final String freezeFolder;
        private final long taskStart;

        public MySamplingTask(String freezeFolder, long taskStart) {
            Intrinsics.checkNotNullParameter((Object)freezeFolder, (String)"freezeFolder");
            super(PerformanceWatcherImpl.this.getDumpInterval(), PerformanceWatcherImpl.this.getMaxDumpDuration(), PerformanceWatcherImpl.this.coroutineScope);
            this.freezeFolder = freezeFolder;
            this.taskStart = taskStart;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @Nullable
        protected Object dumpedThreads(@NotNull ThreadDump threadDump, @NotNull Continuation<? super Unit> $completion) {
            if (!($completion instanceof dumpedThreads.1)) ** GOTO lbl-1000
            var9_3 = $completion;
            if ((var9_3.label & -2147483648) != 0) {
                var9_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    long J$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ MySamplingTask this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.dumpedThreads(null, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = this.freezeFolder + "/";
                    v1 = threadDump.getRawDump();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getRawDump(...)");
                    v2 = PerformanceWatcherImpl.access$dumpThreads(PerformanceWatcherImpl.this, v0, false, v1);
                    if (v2 == null) {
                        return Unit.INSTANCE;
                    }
                    file = v2;
                    durationInSeconds = TimeUnit.SECONDS.convert(System.nanoTime() - this.taskStart, TimeUnit.NANOSECONDS);
                    $continuation.L$0 = threadDump;
                    $continuation.L$1 = file;
                    $continuation.J$0 = durationInSeconds;
                    $continuation.label = 1;
                    v3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Path>, Object>(file, durationInSeconds, null){
                        int label;
                        final /* synthetic */ Path $file;
                        final /* synthetic */ long $durationInSeconds;
                        {
                            this.$file = $file;
                            this.$durationInSeconds = $durationInSeconds;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Path parent = this.$file.getParent();
                                    Files.createDirectories(parent, new FileAttribute[0]);
                                    return Files.writeString(parent.resolve(".duration"), (CharSequence)String.valueOf(this.$durationInSeconds), new OpenOption[0]);
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Path> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    ** if (v3 != var10_5) goto lbl29
lbl28:
                    // 1 sources

                    return var10_5;
lbl29:
                    // 1 sources

                    ** GOTO lbl38
                }
                case 1: {
                    durationInSeconds = $continuation.J$0;
                    file = (Path)$continuation.L$1;
                    threadDump = (ThreadDump)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl38:
                        // 3 sources

                        for (PerformanceListener listener : PerformanceWatcherImplKt.access$getEP_NAME$p().getExtensionList()) {
                            JobKt.ensureActive((CoroutineContext)$continuation.getContext());
                            listener.dumpedThreads(file, threadDump);
                        }
                        JobKt.ensureActive((CoroutineContext)$continuation.getContext());
                        v4 = PerformanceWatcherImplKt.access$getPublisher();
                        if (v4 != null) {
                            v4.dumpedThreads(file, threadDump);
                        }
                    }
                    catch (IOException e) {
                        PerformanceWatcherImplKt.access$getLOG().info("Failed to write the duration file", (Throwable)e);
                    }
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\f\u001a\u00020\r2\u000b\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010H\u0016J\u001f\u0010\f\u001a\u00020\r2\u000b\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0016J\u0015\u0010\u0012\u001a\u00020\u000f2\u000b\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010H\u0016J\u001f\u0010\u0012\u001a\u00020\u000f2\u000b\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/diagnostic/PerformanceWatcherImpl$SnapshotImpl;", "Lcom/intellij/diagnostic/PerformanceWatcher$Snapshot;", "watcher", "Lcom/intellij/diagnostic/PerformanceWatcherImpl;", "<init>", "(Lcom/intellij/diagnostic/PerformanceWatcherImpl;)V", "startGeneralSnapshot", "Lcom/intellij/diagnostic/ApdexData;", "kotlin.jvm.PlatformType", "startSwingSnapshot", "startMillis", "", "logResponsivenessSinceCreation", "", "activityName", "", "Lorg/jetbrains/annotations/NonNls;", "spanName", "getLogResponsivenessSinceCreationMessage", "intellij.platform.ide.impl"})
    private static final class SnapshotImpl
    implements PerformanceWatcher.Snapshot {
        @NotNull
        private final PerformanceWatcherImpl watcher;
        private final ApdexData startGeneralSnapshot;
        private final ApdexData startSwingSnapshot;
        private final long startMillis;

        public SnapshotImpl(@NotNull PerformanceWatcherImpl watcher) {
            Intrinsics.checkNotNullParameter((Object)((Object)watcher), (String)"watcher");
            this.watcher = watcher;
            this.startGeneralSnapshot = this.watcher.generalApdex;
            this.startSwingSnapshot = this.watcher.swingApdex;
            this.startMillis = System.currentTimeMillis();
        }

        public void logResponsivenessSinceCreation(@NotNull String activityName) {
            Intrinsics.checkNotNullParameter((Object)activityName, (String)"activityName");
            this.logResponsivenessSinceCreation(activityName, null);
        }

        public void logResponsivenessSinceCreation(@NotNull String activityName, @Nullable String spanName) {
            Intrinsics.checkNotNullParameter((Object)activityName, (String)"activityName");
            PerformanceWatcherImplKt.access$getLOG().info(this.getLogResponsivenessSinceCreationMessage(activityName, spanName));
        }

        @NotNull
        public String getLogResponsivenessSinceCreationMessage(@NotNull String activityName) {
            Intrinsics.checkNotNullParameter((Object)activityName, (String)"activityName");
            return this.getLogResponsivenessSinceCreationMessage(activityName, null);
        }

        @NotNull
        public String getLogResponsivenessSinceCreationMessage(@NotNull String activityName, @Nullable String spanName) {
            Intrinsics.checkNotNullParameter((Object)activityName, (String)"activityName");
            long currentTime = System.currentTimeMillis();
            if (spanName != null) {
                TelemetryManager.Companion.getTracer(new Scope("PerformanceWatcher", null, false, 6, null)).spanBuilder(spanName).setStartTimestamp(this.startMillis, TimeUnit.MILLISECONDS).startSpan().end(currentTime, TimeUnit.MILLISECONDS);
            }
            return activityName + " took " + (currentTime - this.startMillis) + "ms; general responsiveness: " + this.watcher.generalApdex.summarizePerformanceSince(this.startGeneralSnapshot) + "; EDT responsiveness: " + this.watcher.swingApdex.summarizePerformanceSince(this.startSwingSnapshot);
        }
    }
}

