/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ijent.nio;

import com.intellij.execution.ijent.nio.IjentNioPosixFileAttributeViewWithDosAdapter;
import com.intellij.execution.ijent.nio.IjentNioPosixFileAttributesWithDosAdapter;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.platform.eel.EelUserInfo;
import com.intellij.platform.eel.EelUserPosixInfo;
import com.intellij.platform.ijent.community.impl.nio.IjentNioPath;
import com.intellij.platform.ijent.community.impl.nio.IjentNioPosixFileAttributes;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0007\u001a\u000e\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u0002H\u0001\u001aM\u0010\u0005\u001a\u0002H\u0006\"\b\b\u0000\u0010\u0006*\u00020\u0004*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00060\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000fH\u0007\u00a2\u0006\u0002\u0010\u0010\u001aE\u0010\u0011\u001a\u0002H\u0012\"\b\b\u0000\u0010\u0012*\u00020\u0013*\u00020\u00072\u0006\u0010\n\u001a\u00020\u00022\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00120\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000fH\u0007\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"getCachedFileAttributesAndWrapToDosAttributesAdapter", "Lcom/intellij/execution/ijent/nio/IjentNioPosixFileAttributesWithDosAdapter;", "Lcom/intellij/platform/ijent/community/impl/nio/IjentNioPath;", "getCachedFileAttributesAndWrapToDosAttributesAdapterIfNeeded", "Ljava/nio/file/attribute/BasicFileAttributes;", "readAttributesUsingDosAttributesAdapter", "A", "Ljava/nio/file/spi/FileSystemProvider;", "path", "Ljava/nio/file/Path;", "ijentPath", "type", "Ljava/lang/Class;", "options", "", "Ljava/nio/file/LinkOption;", "(Ljava/nio/file/spi/FileSystemProvider;Ljava/nio/file/Path;Lcom/intellij/platform/ijent/community/impl/nio/IjentNioPath;Ljava/lang/Class;[Ljava/nio/file/LinkOption;)Ljava/nio/file/attribute/BasicFileAttributes;", "getFileAttributeViewUsingDosAttributesAdapter", "V", "Ljava/nio/file/attribute/FileAttributeView;", "(Ljava/nio/file/spi/FileSystemProvider;Lcom/intellij/platform/ijent/community/impl/nio/IjentNioPath;Ljava/lang/Class;[Ljava/nio/file/LinkOption;)Ljava/nio/file/attribute/FileAttributeView;", "intellij.platform.ide.impl"})
public final class IjentNioPosixFileAttributesWithDosAdapterKt {
    @ApiStatus.Internal
    @Nullable
    public static final IjentNioPosixFileAttributesWithDosAdapter getCachedFileAttributesAndWrapToDosAttributesAdapter(@NotNull IjentNioPath $this$getCachedFileAttributesAndWrapToDosAttributesAdapter) {
        IjentNioPosixFileAttributesWithDosAdapter ijentNioPosixFileAttributesWithDosAdapter;
        Intrinsics.checkNotNullParameter((Object)$this$getCachedFileAttributesAndWrapToDosAttributesAdapter, (String)"<this>");
        IjentNioPosixFileAttributes cachedAttrs = (IjentNioPosixFileAttributes)$this$getCachedFileAttributesAndWrapToDosAttributesAdapter.get();
        if (cachedAttrs != null) {
            EelUserInfo eelUserInfo = $this$getCachedFileAttributesAndWrapToDosAttributesAdapter.getFileSystem().getIjentFs().getUser();
            Intrinsics.checkNotNull((Object)eelUserInfo, (String)"null cannot be cast to non-null type com.intellij.platform.eel.EelUserPosixInfo");
            ijentNioPosixFileAttributesWithDosAdapter = new IjentNioPosixFileAttributesWithDosAdapter((EelUserPosixInfo)eelUserInfo, (PosixFileAttributes)cachedAttrs, $this$getCachedFileAttributesAndWrapToDosAttributesAdapter.getFileName().startsWith("."));
        } else {
            ijentNioPosixFileAttributesWithDosAdapter = (IjentNioPosixFileAttributesWithDosAdapter)cachedAttrs;
        }
        return ijentNioPosixFileAttributesWithDosAdapter;
    }

    @ApiStatus.Internal
    @Nullable
    public static final BasicFileAttributes getCachedFileAttributesAndWrapToDosAttributesAdapterIfNeeded(@NotNull IjentNioPath $this$getCachedFileAttributesAndWrapToDosAttributesAdapterIfNeeded) {
        Intrinsics.checkNotNullParameter((Object)$this$getCachedFileAttributesAndWrapToDosAttributesAdapterIfNeeded, (String)"<this>");
        if (SystemInfo.isWindows) {
            return IjentNioPosixFileAttributesWithDosAdapterKt.getCachedFileAttributesAndWrapToDosAttributesAdapter($this$getCachedFileAttributesAndWrapToDosAttributesAdapterIfNeeded);
        }
        return $this$getCachedFileAttributesAndWrapToDosAttributesAdapterIfNeeded.get();
    }

    @ApiStatus.Internal
    @NotNull
    public static final <A extends BasicFileAttributes> A readAttributesUsingDosAttributesAdapter(@NotNull FileSystemProvider $this$readAttributesUsingDosAttributesAdapter, @NotNull Path path, @NotNull IjentNioPath ijentPath, @NotNull Class<A> type, LinkOption ... options2) {
        BasicFileAttributes basicFileAttributes;
        Intrinsics.checkNotNullParameter((Object)$this$readAttributesUsingDosAttributesAdapter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)ijentPath, (String)"ijentPath");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        Class actualType = DosFileAttributes.class.isAssignableFrom(type) ? PosixFileAttributes.class : type;
        PosixFileAttributes actualAttrs = $this$readAttributesUsingDosAttributesAdapter.readAttributes((Path)ijentPath, actualType, Arrays.copyOf(options2, options2.length));
        if (actualAttrs instanceof DosFileAttributes) {
            basicFileAttributes = actualAttrs;
        } else if (actualAttrs instanceof PosixFileAttributes) {
            EelUserInfo eelUserInfo = ijentPath.getFileSystem().getIjentFs().getUser();
            Intrinsics.checkNotNull((Object)eelUserInfo, (String)"null cannot be cast to non-null type com.intellij.platform.eel.EelUserPosixInfo");
            basicFileAttributes = new IjentNioPosixFileAttributesWithDosAdapter((EelUserPosixInfo)eelUserInfo, actualAttrs, StringsKt.startsWith$default((String)PathsKt.getName((Path)path), (String)".", (boolean)false, (int)2, null));
        } else {
            basicFileAttributes = actualAttrs;
        }
        PosixFileAttributes resultAttrs = basicFileAttributes;
        A a = type.cast(resultAttrs);
        Intrinsics.checkNotNullExpressionValue(a, (String)"cast(...)");
        return (A)((BasicFileAttributes)a);
    }

    @ApiStatus.Internal
    @NotNull
    public static final <V extends FileAttributeView> V getFileAttributeViewUsingDosAttributesAdapter(@NotNull FileSystemProvider $this$getFileAttributeViewUsingDosAttributesAdapter, @NotNull IjentNioPath ijentPath, @NotNull Class<V> type, LinkOption ... options2) {
        FileAttributeView fileAttributeView;
        Intrinsics.checkNotNullParameter((Object)$this$getFileAttributeViewUsingDosAttributesAdapter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ijentPath, (String)"ijentPath");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        Class actualType = DosFileAttributeView.class.isAssignableFrom(type) ? PosixFileAttributeView.class : type;
        PosixFileAttributeView actualView = $this$getFileAttributeViewUsingDosAttributesAdapter.getFileAttributeView((Path)ijentPath, actualType, Arrays.copyOf(options2, options2.length));
        if (actualView instanceof PosixFileAttributeView) {
            EelUserInfo eelUserInfo = ijentPath.getFileSystem().getIjentFs().getUser();
            Intrinsics.checkNotNull((Object)eelUserInfo, (String)"null cannot be cast to non-null type com.intellij.platform.eel.EelUserPosixInfo");
            fileAttributeView = new IjentNioPosixFileAttributeViewWithDosAdapter((EelUserPosixInfo)eelUserInfo, actualView, StringsKt.startsWith$default((String)PathsKt.getName((Path)((Path)ijentPath)), (String)".", (boolean)false, (int)2, null));
        } else {
            fileAttributeView = actualView;
        }
        PosixFileAttributeView resultAttrs = fileAttributeView;
        V v = type.cast(resultAttrs);
        Intrinsics.checkNotNullExpressionValue(v, (String)"cast(...)");
        return (V)((FileAttributeView)v);
    }
}

