/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl.ui;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001\u0019B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00022\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0002R(\u0010\t\u001a\u0004\u0018\u00010\u00022\b\u0010\b\u001a\u0004\u0018\u00010\u00028F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/execution/wsl/ui/WslDistributionComboBox;", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/execution/wsl/WSLDistribution;", "initial", "setPreferredSizeToShowLongMessagesFully", "", "<init>", "(Lcom/intellij/execution/wsl/WSLDistribution;Z)V", "value", "selected", "getSelected", "()Lcom/intellij/execution/wsl/WSLDistribution;", "setSelected", "(Lcom/intellij/execution/wsl/WSLDistribution;)V", "isSelectedValid", "()Z", "model", "Lcom/intellij/ui/CollectionComboBoxModel;", "allInstalledDistributions", "", "tryAdd", "", "distribution", "distributions", "", "WslDistributionRenderer", "intellij.platform.ide.impl"})
public final class WslDistributionComboBox
extends ComboBox<WSLDistribution> {
    @NotNull
    private final CollectionComboBoxModel<WSLDistribution> model = new CollectionComboBoxModel();
    @Nullable
    private List<? extends WSLDistribution> allInstalledDistributions;

    public WslDistributionComboBox(@Nullable WSLDistribution initial, boolean setPreferredSizeToShowLongMessagesFully) {
        this.setModel((ComboBoxModel)this.model);
        this.renderer = (ListCellRenderer)((Object)new WslDistributionRenderer());
        if (initial != null) {
            this.model.add((Object)initial);
            this.model.setSelectedItem((Object)initial);
        } else if (setPreferredSizeToShowLongMessagesFully) {
            this.allInstalledDistributions = CollectionsKt.emptyList();
            this.model.add(null);
            this.setPreferredSize(this.getPreferredSize());
            this.model.removeAll();
            this.allInstalledDistributions = null;
        }
        WslDistributionManager.getInstance().getInstalledDistributionsFuture().thenAccept(arg_0 -> WslDistributionComboBox._init_$lambda$1(arg_0 -> WslDistributionComboBox._init_$lambda$0(this, arg_0), arg_0));
    }

    @Nullable
    public final WSLDistribution getSelected() {
        return (WSLDistribution)this.model.getSelected();
    }

    public final void setSelected(@Nullable WSLDistribution value) {
        if (this.model.getElementIndex((Object)value) < 0) {
            this.model.add((Object)value);
        }
        this.setSelectedItem(value);
    }

    public final boolean isSelectedValid() {
        WSLDistribution selectedDistribution = this.getSelected();
        List<? extends WSLDistribution> installedDistributions = this.allInstalledDistributions;
        return selectedDistribution != null && (installedDistributions == null || installedDistributions.contains(selectedDistribution));
    }

    private final void tryAdd(WSLDistribution distribution, List<WSLDistribution> distributions) {
        if (distribution != null && !distributions.contains(distribution)) {
            distributions.add(distribution);
        }
    }

    private static final Unit _init_$lambda$0(WslDistributionComboBox this$0, List installedDistributions) {
        Intrinsics.checkNotNullParameter((Object)installedDistributions, (String)"installedDistributions");
        ApplicationManager.getApplication().invokeLater(() -> WslDistributionComboBox.lambda$0$0(this$0, installedDistributions), ModalityState.any());
        return Unit.INSTANCE;
    }

    private static final void lambda$0$0(WslDistributionComboBox this$0, List $installedDistributions) {
        this$0.allInstalledDistributions = $installedDistributions;
        List newDistributions = new ArrayList($installedDistributions);
        WSLDistribution selected = (WSLDistribution)this$0.model.getSelected();
        this$0.tryAdd(selected, newDistributions);
        this$0.model.removeAll();
        this$0.model.addAll(0, newDistributions);
        if (selected == null) {
            selected = (WSLDistribution)ContainerUtil.getFirstItem((List)this$0.model.getItems());
        }
        this$0.model.setSelectedItem((Object)selected);
    }

    private static final void _init_$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J<\u0010\u0005\u001a\u00020\u00062\u0010\u0010\u0007\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/execution/wsl/ui/WslDistributionComboBox$WslDistributionRenderer;", "Lcom/intellij/ui/ColoredListCellRenderer;", "Lcom/intellij/execution/wsl/WSLDistribution;", "<init>", "(Lcom/intellij/execution/wsl/ui/WslDistributionComboBox;)V", "customizeCellRenderer", "", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "hasFocus", "intellij.platform.ide.impl"})
    private final class WslDistributionRenderer
    extends ColoredListCellRenderer<WSLDistribution> {
        protected void customizeCellRenderer(@NotNull JList<? extends WSLDistribution> list2, @Nullable WSLDistribution value, int index, boolean selected, boolean hasFocus) {
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            List installedList = WslDistributionComboBox.this.allInstalledDistributions;
            if (value == null) {
                v0 = installedList != null ? this.append(IdeBundle.message((String)"wsl.no.installed.distributions", (Object[])new Object[0])) : this.append(IdeBundle.message((String)"progress.text.loading", (Object[])new Object[0]));
            } else if (installedList != null && !installedList.contains(value)) {
                Object[] objectArray = new Object[]{value.getMsId()};
                v0 = this.append(IdeBundle.message((String)"wsl.not.installed.distribution", (Object[])objectArray));
            } else {
                v0 = this.append(value.getMsId());
            }
        }
    }
}

