/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics.fusCollectors;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/featureStatistics/fusCollectors/EventsRateThrottle;", "", "amount", "", "perMillis", "", "<init>", "(IJ)V", "timestamps", "", "currentSize", "lastIndex", "tryPass", "", "now", "addTimestamp", "", "clearTimestamps", "isTimestampApplicable", "timestamp", "intellij.platform.ide.impl"})
public final class EventsRateThrottle {
    private final int amount;
    private final long perMillis;
    @NotNull
    private final long[] timestamps;
    private int currentSize;
    private int lastIndex;

    public EventsRateThrottle(int amount, long perMillis) {
        this.amount = amount;
        this.perMillis = perMillis;
        this.timestamps = new long[this.amount];
    }

    public final synchronized boolean tryPass(long now) {
        if (this.isTimestampApplicable(now)) {
            this.clearTimestamps(now);
            if (this.currentSize < this.amount) {
                this.addTimestamp(now);
                return true;
            }
        }
        return false;
    }

    private final void addTimestamp(long now) {
        this.lastIndex = (this.lastIndex + 1) % this.amount;
        this.timestamps[this.lastIndex] = now;
        if (this.currentSize < this.amount) {
            ++this.currentSize;
        }
    }

    private final void clearTimestamps(long now) {
        int headIndex = (this.amount + this.lastIndex + 1 - this.currentSize) % this.amount;
        while (this.currentSize > 0 && this.timestamps[headIndex] + this.perMillis <= now) {
            headIndex = (headIndex + 1) % this.amount;
            --this.currentSize;
        }
    }

    private final boolean isTimestampApplicable(long timestamp) {
        return this.currentSize == 0 || timestamp >= this.timestamps[this.lastIndex];
    }
}

