/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.RecentProjectListActionProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenUIManager;
import com.intellij.openapi.wm.impl.welcomeScreen.recentProjects.ProjectCollectors;
import com.intellij.openapi.wm.impl.welcomeScreen.recentProjects.RecentProjectFilteringTree;
import com.intellij.openapi.wm.impl.welcomeScreen.recentProjects.RecentProjectPanelComponentFactory;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.ListFocusTraversalPolicy;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.util.Arrays;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

final class ManageRecentProjectsAction
extends DumbAwareAction {
    private static final int DEFAULT_POPUP_HEIGHT = 485;
    private static final int DEFAULT_POPUP_WIDTH = 300;

    ManageRecentProjectsAction() {
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            ManageRecentProjectsAction.$$$reportNull$$$0(0);
        }
        if ((project2 = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        Disposable disposable = Disposer.newDisposable();
        RecentProjectFilteringTree recentProjectFilteringTree = RecentProjectPanelComponentFactory.createComponent(disposable, List.of(ProjectCollectors.INSTANCE.createRecentProjectsWithoutCurrentCollector(project2)), WelcomeScreenUIManager.getProjectsBackground(), true);
        final Tree recentProjectTree = recentProjectFilteringTree.getTree();
        TreeUtil.selectFirstNode((JTree)recentProjectTree);
        final SearchTextField searchTextField = recentProjectFilteringTree.installSearchField();
        searchTextField.setBorder(JBUI.Borders.customLineBottom((Color)WelcomeScreenUIManager.getSeparatorColor()));
        final JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)recentProjectTree, (boolean)true);
        scrollPane.setHorizontalScrollBarPolicy(31);
        ComponentContainer componentContainer = new ComponentContainer(){
            private final JBTextField textField;
            {
                this.textField = searchTextField.getTextEditor();
            }

            @NotNull
            public JComponent getComponent() {
                JPanel panel2 = new JPanel(null);
                panel2.setLayout(new BoxLayout(panel2, 1));
                panel2.setBackground(WelcomeScreenUIManager.getProjectsBackground());
                panel2.setFocusTraversalPolicy((FocusTraversalPolicy)new ListFocusTraversalPolicy(Arrays.asList(this.textField, recentProjectTree)));
                panel2.setFocusTraversalPolicyProvider(true);
                panel2.setFocusCycleRoot(true);
                panel2.add((Component)searchTextField);
                panel2.add(scrollPane);
                panel2.setPreferredSize((Dimension)JBUI.size((int)300, (int)485));
                JPanel jPanel = panel2;
                if (jPanel == null) {
                    1.$$$reportNull$$$0(0);
                }
                return jPanel;
            }

            public JComponent getPreferredFocusableComponent() {
                return this.textField;
            }

            public void dispose() {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ManageRecentProjectsAction$1", "getComponent"));
            }
        };
        PopupUtil.applyNewUIBackground((Component)componentContainer.getComponent());
        JBPopup popup2 = JBPopupFactory.getInstance().createComponentPopupBuilder(componentContainer.getComponent(), componentContainer.getPreferredFocusableComponent()).setTitle(IdeUICustomization.getInstance().projectMessage("popup.title.recent.projects", new Object[0])).setFocusable(true).setRequestFocus(true).setDimensionServiceKey(null, "manage.recent.projects.popup", false).setMovable(true).setResizable(true).setNormalWindowLevel(true).createPopup();
        Disposer.register((Disposable)popup2, (Disposable)disposable);
        popup2.showCenteredInCurrentWindow(project2);
    }

    public void update(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            ManageRecentProjectsAction.$$$reportNull$$$0(1);
        }
        boolean enable2 = (project2 = e.getProject()) != null && !RecentProjectListActionProvider.getInstance().getActionsWithoutGroups(false).isEmpty();
        e.getPresentation().setEnabledAndVisible(enable2);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ManageRecentProjectsAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ManageRecentProjectsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ManageRecentProjectsAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

