/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ProjectGroup;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.OpenProjectTaskBuilder;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.wm.impl.headertoolbar.ProjectToolbarWidgetPresentable;
import com.intellij.openapi.wm.impl.welcomeScreen.recentProjects.RecentProjectItem;
import com.intellij.platform.eel.EelMachine;
import com.intellij.platform.eel.provider.EelInitialization;
import com.intellij.platform.eel.provider.EelUnavailableException;
import com.intellij.platform.ide.progress.ModalTaskOwner;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.projectImport.ProjectOpenedCallback;
import com.intellij.util.BitUtil;
import com.intellij.util.PathUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004BQ\b\u0007\u0012\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007\u0012\r\u0010\b\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\t\u0012\r\u0010\n\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\t\u0012\u000f\b\u0002\u0010\u000b\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\t\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u001c\u0010&\u001a\u00020!2\b\b\u0001\u0010'\u001a\u00020\u00062\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J\u0010\u0010*\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010:\u001a\u00020!2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dR\u0016\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0015\u0010\u0012\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0013\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0014\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u001b\u0010\u000b\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R\u001e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010$\u001a\u00070\u0006\u00a2\u0006\u0002\b\t8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0011R\u0018\u0010\b\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\t8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0011R\u0019\u0010,\u001a\u00070\u0006\u00a2\u0006\u0002\b\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0011R\u0019\u0010.\u001a\u00070\u0006\u00a2\u0006\u0002\b\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0011R\u0019\u00100\u001a\u00070\u0006\u00a2\u0006\u0002\b\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0011R\u0014\u00102\u001a\u0002038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0016\u00106\u001a\u0004\u0018\u0001038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00105R\u0016\u0010\f\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109\u00a8\u0006;"}, d2={"Lcom/intellij/ide/ReopenProjectAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/ide/lightEdit/LightEditCompatible;", "Lcom/intellij/openapi/wm/impl/headertoolbar/ProjectToolbarWidgetPresentable;", "projectPath", "", "Lorg/jetbrains/annotations/SystemIndependent;", "projectName", "Lcom/intellij/openapi/util/NlsSafe;", "displayName", "branchName", "activationTimestamp", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;)V", "getProjectPath", "()Ljava/lang/String;", "myProjectName", "myDisplayName", "myBranchName", "myActivationTimestamp", "Ljava/lang/Long;", "getBranchName", "value", "", "isRemoved", "()Z", "projectGroup", "Lcom/intellij/ide/ProjectGroup;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "projectDisplayName", "getProjectDisplayName", "showReopenDialog", "message", "project", "Lcom/intellij/openapi/project/Project;", "actionPerformed", "getProjectName", "projectNameToDisplay", "getProjectNameToDisplay", "nameToDisplayAsText", "getNameToDisplayAsText", "projectPathToDisplay", "getProjectPathToDisplay", "projectIcon", "Ljavax/swing/Icon;", "getProjectIcon", "()Ljavax/swing/Icon;", "providerIcon", "getProviderIcon", "getActivationTimestamp", "()Ljava/lang/Long;", "setProjectGroup", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nReopenProjectAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReopenProjectAction.kt\ncom/intellij/ide/ReopenProjectAction\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 OpenProjectTask.kt\ncom/intellij/ide/impl/OpenProjectTaskKt\n+ 4 OpenProjectTask.kt\ncom/intellij/ide/impl/OpenProjectTaskBuilder\n*L\n1#1,158:1\n13#2:159\n23#2:164\n217#3:160\n174#4,3:161\n179#4,32:165\n178#4:197\n*S KotlinDebug\n*F\n+ 1 ReopenProjectAction.kt\ncom/intellij/ide/ReopenProjectAction\n*L\n63#1:159\n119#1:164\n119#1:160\n119#1:161,3\n119#1:165,32\n119#1:197\n*E\n"})
public class ReopenProjectAction
extends AnAction
implements DumbAware,
LightEditCompatible,
ProjectToolbarWidgetPresentable {
    @NotNull
    private final String projectPath;
    @Nullable
    private final String myProjectName;
    @Nullable
    private final String myDisplayName;
    @Nullable
    private final String myBranchName;
    @Nullable
    private final Long myActivationTimestamp;
    private boolean isRemoved;
    @Nullable
    private ProjectGroup projectGroup;

    @JvmOverloads
    public ReopenProjectAction(@NotNull String projectPath, @Nullable String projectName, @Nullable String displayName, @Nullable String branchName, @Nullable Long activationTimestamp) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        this.projectPath = projectPath;
        this.getTemplatePresentation().setText(IdeBundle.message((String)"action.ReopenProject.reopen.project.text", (Object[])new Object[0]));
        this.getTemplatePresentation().setApplicationScope(true);
        this.myProjectName = projectName;
        this.myDisplayName = displayName;
        this.myBranchName = branchName;
        this.myActivationTimestamp = activationTimestamp;
        if (((CharSequence)this.getProjectDisplayName()).length() == 0) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ReopenProjectAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Empty action text for projectName='" + projectName + "' displayName='" + displayName + "' path='" + this.projectPath + "'");
        }
    }

    public /* synthetic */ ReopenProjectAction(String string, String string2, String string3, String string4, Long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string4 = null;
        }
        if ((n & 0x10) != 0) {
            l = null;
        }
        this(string, string2, string3, string4, l);
    }

    @NotNull
    public final String getProjectPath() {
        return this.projectPath;
    }

    @Override
    @Nullable
    public String getBranchName() {
        return this.myBranchName;
    }

    public final boolean isRemoved() {
        return this.isRemoved;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"getPresentation(...)");
        Presentation presentation3 = presentation2;
        presentation3.setText(this.getProjectDisplayName(), false);
        presentation3.setDescription(FileUtilRt.toSystemDependentName((String)this.projectPath));
        presentation3.setEnabledAndVisible(true);
    }

    @NotNull
    public final String getProjectDisplayName() {
        String string;
        if (Intrinsics.areEqual((Object)this.projectPath, (Object)this.myDisplayName)) {
            string = FileUtil.getLocationRelativeToUserHome((String)this.projectPath);
        } else {
            String string2 = this.myDisplayName;
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        }
        String s = string;
        if (this.getBranchName() != null) {
            Object[] objectArray = new Object[]{s, this.getBranchName()};
            String string3 = IdeBundle.message((String)"action.reopen.project.display.name.with.branch", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            return string3;
        }
        Intrinsics.checkNotNull((Object)s);
        return s;
    }

    private final void showReopenDialog(@Nls String message, Project project2) {
        String[] stringArray = new String[]{CommonBundle.getOkButtonText(), IdeBundle.message((String)"button.remove.from.list", (Object[])new Object[0])};
        int exitCode2 = Messages.showDialog((Project)project2, (String)message, (String)IdeBundle.message((String)"dialog.title.reopen.project", (Object[])new Object[0]), (String[])stringArray, (int)0, (Icon)Messages.getErrorIcon());
        if (exitCode2 == 1) {
            this.isRemoved = true;
            RecentProjectsManager.Companion.getInstance().removePath(this.projectPath);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        IdeEventQueue.Companion.getInstance().getPopupManager().closeAllPopups();
        Project project2 = e.getProject();
        try {
            ModalTaskOwner modalTaskOwner = ModalTaskOwner.guess();
            Intrinsics.checkNotNullExpressionValue((Object)modalTaskOwner, (String)"guess(...)");
            String string = IdeBundle.message((String)"progress.title.project.initialization", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            EelMachine cfr_ignored_0 = (EelMachine)TasksKt.runWithModalProgressBlocking$default((ModalTaskOwner)modalTaskOwner, (String)string, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super EelMachine>, Object>(this, null){
                int label;
                final /* synthetic */ ReopenProjectAction this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = EelInitialization.INSTANCE.runEelInitialization(this.this$0.getProjectPath(), (Continuation)this);
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super EelMachine> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)4, null);
        }
        catch (EelUnavailableException e2) {
            this.showReopenDialog(e2.getMessage(), project2);
            return;
        }
        Path file2 = Path.of(this.projectPath, new String[0]).normalize();
        if (Files.notExists(file2, new LinkOption[0])) {
            Object[] objectArray = new Object[]{FileUtil.toSystemDependentName((String)this.projectPath)};
            String string = IdeBundle.message((String)"message.the.path.0.does.not.exist.maybe.on.remote", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.showReopenDialog(string, project2);
            return;
        }
        boolean $i$f$OpenProjectTask = false;
        OpenProjectTaskBuilder this_$iv$iv = new OpenProjectTaskBuilder();
        boolean $i$f$build = false;
        OpenProjectTaskBuilder $this$actionPerformed_u24lambda_u240 = this_$iv$iv;
        boolean bl = false;
        $this$actionPerformed_u24lambda_u240.setProjectToClose(project2);
        int modifiers = e.getModifiers();
        $this$actionPerformed_u24lambda_u240.setForceOpenInNewFrame(BitUtil.isSet((int)modifiers, (int)2) || BitUtil.isSet((int)modifiers, (int)1) || Intrinsics.areEqual((Object)"WelcomeScreen", (Object)e.getPlace()) || LightEdit.owns((Project)project2));
        $this$actionPerformed_u24lambda_u240.setRunConfigurators(true);
        if (this_$iv$iv.getProject() != null && this_$iv$iv.getCreateModule()) {
            OpenProjectTaskBuilder $this$thisLogger$iv$iv$iv = this_$iv$iv;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(OpenProjectTaskBuilder.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            Project project3 = this_$iv$iv.getProject();
            logger.warn("Project is explicitly set (name=" + (project3 != null ? project3.getName() : null) + "), but createModule is true");
        }
        boolean bl2 = this_$iv$iv.getForceOpenInNewFrame();
        boolean bl3 = this_$iv$iv.getForceReuseFrame();
        boolean bl4 = this_$iv$iv.getPreloadServices();
        Project project4 = this_$iv$iv.getProjectToClose();
        boolean bl5 = this_$iv$iv.isRefreshVfsNeeded();
        String string = this_$iv$iv.getProjectName();
        boolean bl6 = this_$iv$iv.isNewProject();
        Boolean bl7 = this_$iv$iv.getUseDefaultProjectAsTemplate();
        boolean bl8 = bl7 != null ? bl7.booleanValue() : this_$iv$iv.isNewProject();
        boolean bl9 = this_$iv$iv.getRunConfigurators();
        boolean bl10 = this_$iv$iv.isProjectCreatedWithWizard();
        boolean bl11 = this_$iv$iv.getRunConversionBeforeOpen();
        boolean bl12 = this_$iv$iv.getShowWelcomeScreen();
        Function2 function2 = this_$iv$iv.getBeforeOpen();
        Function1 function1 = this_$iv$iv.getBeforeInit();
        Function2 function22 = this_$iv$iv.getPreparedToOpen();
        ProjectOpenedCallback projectOpenedCallback = this_$iv$iv.getCallback();
        boolean bl13 = this_$iv$iv.getPreventIprLookup();
        Function1 function12 = this_$iv$iv.getProcessorChooser();
        String string2 = this_$iv$iv.getProjectWorkspaceId();
        Object object = this_$iv$iv.getImplOptions();
        boolean bl14 = this_$iv$iv.getCreateModule();
        int n = this_$iv$iv.getLine();
        int n2 = this_$iv$iv.getColumn();
        Project project5 = this_$iv$iv.getProject();
        Path path = this_$iv$iv.getProjectRootDir();
        OpenProjectTask options2 = new OpenProjectTask(bl2, bl3, project4, bl6, bl8, project5, string, bl12, projectOpenedCallback, n, n2, bl5, bl9, bl11, string2, bl10, bl4, function1, function2, function22, bl13, function12, object, path, bl14);
        Intrinsics.checkNotNull((Object)file2);
        RecentProjectItem.Companion.openProjectAndLogRecent(file2, options2, this.projectGroup);
    }

    @Nullable
    public final String getProjectName() {
        RecentProjectsManager manager2 = RecentProjectsManager.Companion.getInstance();
        return manager2 instanceof RecentProjectsManagerBase ? ((RecentProjectsManagerBase)manager2).getProjectName(this.projectPath) : this.myProjectName;
    }

    @Override
    @NotNull
    public String getProjectNameToDisplay() {
        RecentProjectsManager manager2 = RecentProjectsManager.Companion.getInstance();
        String string = manager2 instanceof RecentProjectsManagerBase ? ((RecentProjectsManagerBase)manager2).getDisplayName(this.projectPath) : null;
        if (string == null && (string = this.getProjectName()) == null) {
            string = this.projectPath;
        }
        return string;
    }

    @Override
    @NotNull
    public String getNameToDisplayAsText() {
        return this.getProjectDisplayName();
    }

    @Override
    @NotNull
    public String getProjectPathToDisplay() {
        String string = FileUtil.getLocationRelativeToUserHome((String)PathUtil.toSystemDependentName((String)this.projectPath), (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocationRelativeToUserHome(...)");
        return string;
    }

    @Override
    @NotNull
    public Icon getProjectIcon() {
        return RecentProjectsManagerBase.getProjectIcon$default(RecentProjectsManagerBase.Companion.getInstanceEx(), this.projectPath, true, 20, null, 8, null);
    }

    @Override
    @Nullable
    public Icon getProviderIcon() {
        return null;
    }

    @Override
    @Nullable
    public Long getActivationTimestamp() {
        return this.myActivationTimestamp;
    }

    public final void setProjectGroup(@Nullable ProjectGroup projectGroup) {
        this.projectGroup = projectGroup;
    }

    @JvmOverloads
    public ReopenProjectAction(@NotNull String projectPath, @Nullable String projectName, @Nullable String displayName, @Nullable String branchName) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        this(projectPath, projectName, displayName, branchName, null, 16, null);
    }

    @JvmOverloads
    public ReopenProjectAction(@NotNull String projectPath, @Nullable String projectName, @Nullable String displayName) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        this(projectPath, projectName, displayName, null, null, 24, null);
    }
}

