/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actionMacro;

import com.intellij.codeWithMe.ClientId;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actionMacro.ActionMacro;
import com.intellij.ide.ui.customization.ActionUrl;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionRuntimeRegistrar;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.impl.ActionConfigurationCustomizer;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.PlaybackRunner;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.Consumer;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.AnimatedIcon;
import com.intellij.util.ui.BaseButtonBehavior;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PositionTracker;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ActionMacroManager", storages={@Storage(value="macros.xml")}, category=SettingsCategory.UI)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\f\b\u0007\u0018\u0000 =2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0005=>?@AB\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0002H\u0016J\b\u0010 \u001a\u00020\u0002H\u0016J\u001a\u0010!\u001a\u00020\u001e2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010\u0012J\u0010\u0010%\u001a\u00020\u001e2\b\u0010\"\u001a\u0004\u0018\u00010#J\u0012\u0010&\u001a\u00020\u001e2\b\u0010$\u001a\u0004\u0018\u00010\u0012H\u0002J\u0006\u0010'\u001a\u00020\u001eJ\u0012\u0010(\u001a\u00020\u001e2\b\u0010)\u001a\u0004\u0018\u00010\fH\u0002J\u0006\u0010.\u001a\u00020\u001eJ\u000e\u0010/\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\fJ\u0010\u00100\u001a\u00020\u001e2\b\u0010)\u001a\u0004\u0018\u00010\fJ\u0006\u00101\u001a\u00020\bJ&\u00102\u001a\u00020\u001e2\u0006\u00103\u001a\u0002042\u0014\b\u0002\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001206H\u0007J\u001a\u00107\u001a\u00020\b2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u00108\u001a\u00020\u0012H\u0002J\u0010\u00109\u001a\u00020\u001e2\u0006\u00108\u001a\u00020\u0012H\u0002J\u0018\u0010:\u001a\u00020\u001e2\u0006\u0010;\u001a\u00020\u00122\u0006\u0010<\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000fj\b\u0012\u0004\u0012\u00020\f`\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\nR\u001e\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u0015j\b\u0012\u0004\u0012\u00020\u0016`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0018\u00010\u0019R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010*\u001a\b\u0012\u0004\u0012\u00020\f0+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006B"}, d2={"Lcom/intellij/ide/actionMacro/ActionMacroManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "value", "", "isRecording", "()Z", "lastMacro", "Lcom/intellij/ide/actionMacro/ActionMacro;", "recordingMacro", "macros", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "lastMacroName", "", "isPlaying", "lastActionInputEvent", "Ljava/util/HashSet;", "Ljava/awt/event/InputEvent;", "Lkotlin/collections/HashSet;", "widget", "Lcom/intellij/ide/actionMacro/ActionMacroManager$Widget;", "lastTyping", "isKeyProcessorAdded", "Ljava/util/concurrent/atomic/AtomicBoolean;", "loadState", "", "state", "getState", "startRecording", "project", "Lcom/intellij/openapi/project/Project;", "macroName", "stopRecording", "addRecordedMacroWithName", "playbackLastMacro", "playbackMacro", "macro", "allMacros", "", "getAllMacros", "()[Lcom/intellij/ide/actionMacro/ActionMacro;", "removeAllMacros", "addMacro", "playMacro", "hasRecentMacro", "registerActions", "actionManager", "Lcom/intellij/openapi/actionSystem/ActionManager;", "renamingMap", "", "checkCanCreateMacro", "name", "removeMacro", "notifyUser", "text", "typing", "Companion", "MyActionTuner", "Widget", "InvokeMacroAction", "KeyPostProcessor", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nActionMacroManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActionMacroManager.kt\ncom/intellij/ide/actionMacro/ActionMacroManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,537:1\n23#2:538\n23#2:539\n23#2:540\n23#2:541\n37#3,2:542\n*S KotlinDebug\n*F\n+ 1 ActionMacroManager.kt\ncom/intellij/ide/actionMacro/ActionMacroManager\n*L\n134#1:538\n144#1:539\n150#1:540\n265#1:541\n352#1:542,2\n*E\n"})
public final class ActionMacroManager
implements PersistentStateComponent<Element> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    private boolean isRecording;
    @Nullable
    private ActionMacro lastMacro;
    @Nullable
    private ActionMacro recordingMacro;
    @NotNull
    private ArrayList<ActionMacro> macros;
    @Nullable
    private String lastMacroName;
    private boolean isPlaying;
    @NotNull
    private final HashSet<InputEvent> lastActionInputEvent;
    @Nullable
    private Widget widget;
    @NotNull
    private String lastTyping;
    @NotNull
    private final AtomicBoolean isKeyProcessorAdded;
    @NotNull
    public static final String NO_NAME_NAME = "<noname>";

    public ActionMacroManager(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.macros = new ArrayList();
        this.lastActionInputEvent = new HashSet();
        this.lastTyping = "";
        this.isKeyProcessorAdded = new AtomicBoolean();
        SimpleMessageBusConnection simpleMessageBusConnection = ApplicationManager.getApplication().getMessageBus().connect(this.coroutineScope);
        Topic topic = AnActionListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        simpleMessageBusConnection.subscribe(topic, (Object)new AnActionListener(){

            public void beforeActionPerformed(AnAction action2, AnActionEvent event) {
                block4: {
                    String id2;
                    block3: {
                        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        String string = ActionManager.getInstance().getId(action2);
                        if (string == null) {
                            return;
                        }
                        id2 = string;
                        if (!Intrinsics.areEqual((Object)"StartStopMacroRecording", (Object)id2)) break block3;
                        InputEvent inputEvent = event.getInputEvent();
                        if (inputEvent == null) break block4;
                        InputEvent inputEvent2 = inputEvent;
                        ActionMacroManager actionMacroManager = this;
                        InputEvent it = inputEvent2;
                        boolean bl = false;
                        actionMacroManager.lastActionInputEvent.add(it);
                        break block4;
                    }
                    if (!this.isRecording()) break block4;
                    ActionMacro actionMacro = recordingMacro;
                    Intrinsics.checkNotNull((Object)actionMacro);
                    actionMacro.appendAction(id2);
                    String shortcut = null;
                    if (event.getInputEvent() instanceof KeyEvent) {
                        shortcut = KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStrokeForEvent((KeyEvent)event.getInputEvent()));
                    }
                    String string = shortcut;
                    this.notifyUser(id2 + (String)(string == null ? "" : " (" + string + ")"), false);
                    InputEvent inputEvent = event.getInputEvent();
                    if (inputEvent != null) {
                        InputEvent inputEvent3 = inputEvent;
                        ActionMacroManager actionMacroManager = this;
                        InputEvent it = inputEvent3;
                        boolean bl = false;
                        actionMacroManager.lastActionInputEvent.add(it);
                    }
                }
            }
        });
    }

    public final boolean isRecording() {
        return this.isRecording;
    }

    public final boolean isPlaying() {
        return this.isPlaying;
    }

    public void loadState(@NotNull Element state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        this.macros = new ArrayList();
        for (Element macroElement : state2.getChildren("macro")) {
            ActionMacro macro = new ActionMacro();
            macro.readExternal(macroElement);
            this.macros.add(macro);
        }
        ActionManager actionManager = ActionManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)actionManager, (String)"getInstance(...)");
        ActionMacroManager.registerActions$default(this, actionManager, null, 2, null);
    }

    @NotNull
    public Element getState() {
        Element element = new Element("state");
        Iterator<ActionMacro> iterator = this.macros.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<ActionMacro> iterator2 = iterator;
        while (iterator2.hasNext()) {
            ActionMacro macro;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            Element macroElement = new Element("macro");
            macro.writeExternal(macroElement);
            element.addContent(macroElement);
        }
        return element;
    }

    public final void startRecording(@Nullable Project project2, @Nullable String macroName) {
        ActionMacroManager $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(ActionMacroManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.assertTrue(!this.isRecording);
        if (this.isKeyProcessorAdded.compareAndSet(false, true)) {
            IdeEventQueue.Companion.getInstance().addPostprocessor((IdeEventQueue.EventDispatcher)new KeyPostProcessor(), this.coroutineScope);
        }
        this.isRecording = true;
        this.recordingMacro = new ActionMacro(macroName);
        IdeFrame frame = WindowManager.getInstance().getIdeFrame(project2);
        if (frame == null) {
            ActionMacroManager $this$thisLogger$iv2 = this;
            boolean $i$f$thisLogger2 = false;
            Logger logger2 = Logger.getInstance(ActionMacroManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.warn("Cannot start macro recording: ide frame not found");
            return;
        }
        StatusBar statusBar = frame.getStatusBar();
        if (statusBar == null) {
            ActionMacroManager $this$thisLogger$iv3 = this;
            boolean $i$f$thisLogger3 = false;
            Logger logger3 = Logger.getInstance(ActionMacroManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(...)");
            logger3.warn("Cannot start macro recording: status bar not found");
            return;
        }
        Widget widget2 = this.widget = new Widget(statusBar);
        Intrinsics.checkNotNull((Object)widget2);
        statusBar.addWidget((StatusBarWidget)widget2);
    }

    public final void stopRecording(@Nullable Project project2) {
        ActionMacroManager $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(ActionMacroManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.assertTrue(this.isRecording);
        if (this.widget != null) {
            Widget widget2 = this.widget;
            Intrinsics.checkNotNull((Object)widget2);
            widget2.delete();
            this.widget = null;
        }
        this.isRecording = false;
        this.lastActionInputEvent.clear();
        String macroName = "";
        do {
            if ((macroName = Messages.showInputDialog((Project)project2, (String)IdeBundle.message((String)"prompt.enter.macro.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.enter.macro.name", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)macroName, null)) == null) {
                this.recordingMacro = null;
                return;
            }
            if (!(((CharSequence)macroName).length() == 0)) continue;
            macroName = null;
        } while (macroName != null && !this.checkCanCreateMacro(project2, macroName));
        this.lastMacro = this.recordingMacro;
        this.addRecordedMacroWithName(macroName);
        ActionManager actionManager = ActionManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)actionManager, (String)"getInstance(...)");
        ActionMacroManager.registerActions$default(this, actionManager, null, 2, null);
    }

    private final void addRecordedMacroWithName(String macroName) {
        if (macroName != null) {
            ActionMacro actionMacro = this.recordingMacro;
            Intrinsics.checkNotNull((Object)actionMacro);
            actionMacro.setName(macroName);
            ActionMacro actionMacro2 = this.recordingMacro;
            Intrinsics.checkNotNull((Object)actionMacro2);
            this.macros.add(actionMacro2);
            this.recordingMacro = null;
        } else {
            int n = ((Collection)this.macros).size();
            for (int i2 = 0; i2 < n; ++i2) {
                ActionMacro macro;
                Intrinsics.checkNotNullExpressionValue((Object)this.macros.get(i2), (String)"get(...)");
                if (!Intrinsics.areEqual((Object)NO_NAME_NAME, (Object)macro.getName())) continue;
                ActionMacro actionMacro = this.recordingMacro;
                Intrinsics.checkNotNull((Object)actionMacro);
                this.macros.set(i2, actionMacro);
                this.recordingMacro = null;
                break;
            }
            if (this.recordingMacro != null) {
                ActionMacro actionMacro = this.recordingMacro;
                Intrinsics.checkNotNull((Object)actionMacro);
                this.macros.add(actionMacro);
                this.recordingMacro = null;
            }
        }
    }

    public final void playbackLastMacro() {
        if (this.lastMacro != null) {
            this.playbackMacro(this.lastMacro);
        }
    }

    private final void playbackMacro(ActionMacro macro) {
        IdeFrame ideFrame = WindowManager.getInstance().getIdeFrame(null);
        Intrinsics.checkNotNull((Object)ideFrame);
        IdeFrame frame = ideFrame;
        StringBuffer script = new StringBuffer();
        ActionMacro actionMacro = macro;
        Intrinsics.checkNotNull((Object)actionMacro);
        ActionMacro.ActionDescriptor[] actions = actionMacro.getActions();
        Intrinsics.checkNotNull((Object)actions);
        for (ActionMacro.ActionDescriptor each : actions) {
            each.generateTo(script);
        }
        PlaybackRunner runner2 = new PlaybackRunner(script.toString(), new PlaybackRunner.StatusCallback.Edt(frame){
            final /* synthetic */ IdeFrame $frame;
            {
                this.$frame = $frame;
            }

            public void messageEdt(PlaybackContext context, String text2, PlaybackRunner.StatusCallback.Type type) {
                StatusBar statusBar;
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                String text3 = text2;
                if ((type == PlaybackRunner.StatusCallback.Type.message || type == PlaybackRunner.StatusCallback.Type.error) && (statusBar = this.$frame.getStatusBar()) != null) {
                    if (context != null) {
                        Object[] objectArray = new Object[]{context.getCurrentLine(), text3};
                        text3 = IdeBundle.message((String)"status.bar.message.at.line", (Object[])objectArray);
                    }
                    statusBar.setInfo(text3);
                }
            }
        }, Registry.Companion.is("actionSystem.playback.useDirectActionCall"), true, Registry.Companion.is("actionSystem.playback.useTypingTargets"));
        this.isPlaying = true;
        ((CompletableFuture)runner2.run().thenRun(() -> ActionMacroManager.playbackMacro$lambda$0(frame))).whenComplete((arg_0, arg_1) -> ActionMacroManager.playbackMacro$lambda$1(this, arg_0, arg_1));
    }

    @NotNull
    public final ActionMacro[] getAllMacros() {
        Collection $this$toTypedArray$iv = this.macros;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new ActionMacro[0]);
    }

    public final void removeAllMacros() {
        if (this.lastMacro != null) {
            ActionMacro actionMacro = this.lastMacro;
            Intrinsics.checkNotNull((Object)actionMacro);
            this.lastMacroName = actionMacro.getName();
            this.lastMacro = null;
        }
        this.macros = new ArrayList();
    }

    public final void addMacro(@NotNull ActionMacro macro) {
        Intrinsics.checkNotNullParameter((Object)macro, (String)"macro");
        this.macros.add(macro);
        if (this.lastMacroName != null && Intrinsics.areEqual((Object)this.lastMacroName, (Object)macro.getName())) {
            this.lastMacro = macro;
            this.lastMacroName = null;
        }
    }

    public final void playMacro(@Nullable ActionMacro macro) {
        this.playbackMacro(macro);
        this.lastMacro = macro;
    }

    public final boolean hasRecentMacro() {
        return this.lastMacro != null;
    }

    @JvmOverloads
    public final void registerActions(@NotNull ActionManager actionManager, @NotNull Map<String, String> renamingMap) {
        Object newId;
        Intrinsics.checkNotNullParameter((Object)actionManager, (String)"actionManager");
        Intrinsics.checkNotNullParameter(renamingMap, (String)"renamingMap");
        HashMap<ActionMacro[], Icon> icons = new HashMap<ActionMacro[], Icon>();
        for (ActionMacro[] oldId : actionManager.getActionIdList("Macro.")) {
            Icon icon2;
            AnAction action2 = actionManager.getAction((String)oldId);
            if (action2 != null && (icon2 = action2.getTemplatePresentation().getIcon()) != null) {
                ActionMacro[] actionMacroArray = newId = renamingMap.get(oldId);
                if (newId == null) {
                    actionMacroArray = oldId;
                }
                icons.put(actionMacroArray, icon2);
            }
            actionManager.unregisterAction((String)oldId);
        }
        HashSet<String> registeredIds = new HashSet<String>();
        for (ActionMacro macro : this.getAllMacros()) {
            String actionId = macro.getActionId();
            if (registeredIds.contains(actionId)) continue;
            registeredIds.add(actionId);
            InvokeMacroAction action3 = new InvokeMacroAction(macro);
            Icon icon3 = (Icon)icons.get(actionId);
            if (icon3 != null) {
                action3.getTemplatePresentation().setIcon(icon3);
            }
            actionManager.registerAction(actionId, (AnAction)action3);
        }
        CustomActionsSchema customActionsSchema = CustomActionsSchema.Companion.getInstance();
        for (ActionUrl actionUrl : customActionsSchema.getActions()) {
            newId = renamingMap.get(actionUrl.getComponentId());
            if (newId == null) continue;
            actionUrl.setComponent(newId);
        }
        for (Map.Entry entry : renamingMap.entrySet()) {
            String oldId = (String)entry.getKey();
            String newId2 = (String)entry.getValue();
            String path = customActionsSchema.getIconPath(oldId);
            if (((CharSequence)path).length() == 0) continue;
            customActionsSchema.removeIconCustomization(oldId);
            customActionsSchema.addIconCustomization(newId2, path);
        }
        if (!renamingMap.isEmpty()) {
            customActionsSchema.setCustomizationSchemaForCurrentProjects();
        }
    }

    public static /* synthetic */ void registerActions$default(ActionMacroManager actionMacroManager, ActionManager actionManager, Map map2, int n, Object object) {
        if ((n & 2) != 0) {
            map2 = MapsKt.emptyMap();
        }
        actionMacroManager.registerActions(actionManager, map2);
    }

    private final boolean checkCanCreateMacro(Project project2, String name2) {
        String actionId;
        ActionManager actionManager = ActionManager.getInstance();
        if (actionManager.getAction(actionId = "Macro." + name2) != null) {
            String string = IdeBundle.message((String)"title.macro.name.already.used", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            Object[] objectArray = new Object[]{name2};
            String string2 = IdeBundle.message((String)"message.macro.exists", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            if (!((MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(string, string2).icon(Messages.getWarningIcon())).ask(project2)) {
                return false;
            }
            actionManager.unregisterAction(actionId);
            this.removeMacro(name2);
        }
        return true;
    }

    private final void removeMacro(String name2) {
        int n = ((Collection)this.macros).size();
        for (int i2 = 0; i2 < n; ++i2) {
            ActionMacro macro;
            Intrinsics.checkNotNullExpressionValue((Object)this.macros.get(i2), (String)"get(...)");
            if (!Intrinsics.areEqual((Object)name2, (Object)macro.getName())) continue;
            this.macros.remove(i2);
            break;
        }
    }

    private final void notifyUser(String text2, boolean typing) {
        block3: {
            String actualText = text2;
            if (typing) {
                int maxLength = 20;
                this.lastTyping = this.lastTyping + text2;
                if (this.lastTyping.length() > maxLength) {
                    String string = this.lastTyping.substring(this.lastTyping.length() - maxLength);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    this.lastTyping = "..." + string;
                }
                actualText = this.lastTyping;
            } else {
                this.lastTyping = "";
            }
            Widget widget2 = this.widget;
            if (widget2 == null) break block3;
            Object[] objectArray = new Object[]{actualText};
            widget2.notifyUser(IdeBundle.message((String)"status.bar.text.macro.recorded", (Object[])objectArray));
        }
    }

    @JvmOverloads
    public final void registerActions(@NotNull ActionManager actionManager) {
        Intrinsics.checkNotNullParameter((Object)actionManager, (String)"actionManager");
        ActionMacroManager.registerActions$default(this, actionManager, null, 2, null);
    }

    private static final void playbackMacro$lambda$0(IdeFrame $frame) {
        StatusBar statusBar = $frame.getStatusBar();
        Intrinsics.checkNotNull((Object)statusBar);
        StatusBar statusBar2 = statusBar;
        statusBar2.setInfo(IdeBundle.message((String)"status.bar.text.script.execution.finished", (Object[])new Object[0]));
    }

    private static final void playbackMacro$lambda$1(ActionMacroManager this$0, Void unused, Throwable throwable) {
        this$0.isPlaying = false;
    }

    @JvmStatic
    @NotNull
    public static final ActionMacroManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/actionMacro/ActionMacroManager$Companion;", "", "<init>", "()V", "NO_NAME_NAME", "", "getInstance", "Lcom/intellij/ide/actionMacro/ActionMacroManager;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nActionMacroManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActionMacroManager.kt\ncom/intellij/ide/actionMacro/ActionMacroManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,537:1\n42#2,3:538\n*S KotlinDebug\n*F\n+ 1 ActionMacroManager.kt\ncom/intellij/ide/actionMacro/ActionMacroManager$Companion\n*L\n80#1:538,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ActionMacroManager getInstance() {
            boolean $i$f$service = false;
            Class<ActionMacroManager> serviceClass$iv = ActionMacroManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (ActionMacroManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\r\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ide/actionMacro/ActionMacroManager$InvokeMacroAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "macro", "Lcom/intellij/ide/actionMacro/ActionMacro;", "<init>", "(Lcom/intellij/ide/actionMacro/ActionMacro;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getActionName", "", "Lcom/intellij/openapi/util/NlsSafe;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nActionMacroManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActionMacroManager.kt\ncom/intellij/ide/actionMacro/ActionMacroManager$InvokeMacroAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,537:1\n1#2:538\n*E\n"})
    private static final class InvokeMacroAction
    extends AnAction {
        @NotNull
        private final ActionMacro macro;

        public InvokeMacroAction(@NotNull ActionMacro macro) {
            Intrinsics.checkNotNullParameter((Object)macro, (String)"macro");
            this.macro = macro;
            this.getTemplatePresentation().setText(this.getActionName(), false);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        private final String getActionName() {
            String string;
            block4: {
                block3: {
                    String string2;
                    string = this.macro.getName();
                    if (string == null) break block3;
                    String it = string2 = string;
                    boolean bl = false;
                    string = ((CharSequence)it).length() > 0 ? string2 : null;
                    if (string != null) break block4;
                }
                String string3 = IdeBundle.message((String)"action.invoke.macro.text", (Object[])new Object[0]);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            }
            return string;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            IdeEventQueue.Companion.getInstance().doWhenReady(() -> InvokeMacroAction.actionPerformed$lambda$0(this));
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setText(this.getActionName(), false);
            e.getPresentation().setEnabled(!Companion.getInstance().isPlaying());
        }

        private static final void actionPerformed$lambda$0(InvokeMacroAction this$0) {
            Companion.getInstance().playMacro(this$0.macro);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/actionMacro/ActionMacroManager$KeyPostProcessor;", "Lcom/intellij/ide/IdeEventQueue$EventDispatcher;", "<init>", "(Lcom/intellij/ide/actionMacro/ActionMacroManager;)V", "dispatch", "", "e", "Ljava/awt/AWTEvent;", "postProcessKeyEvent", "", "Ljava/awt/event/KeyEvent;", "intellij.platform.ide.impl"})
    private final class KeyPostProcessor
    implements IdeEventQueue.EventDispatcher {
        @Override
        public boolean dispatch(@NotNull AWTEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (ActionMacroManager.this.isRecording() && e instanceof KeyEvent) {
                this.postProcessKeyEvent((KeyEvent)e);
            }
            return false;
        }

        public final void postProcessKeyEvent(@NotNull KeyEvent e) {
            boolean isEnter;
            boolean modifierKeyIsPressed;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (e.getID() != 401) {
                return;
            }
            if (ActionMacroManager.this.lastActionInputEvent.contains(e)) {
                ActionMacroManager.this.lastActionInputEvent.remove(e);
                return;
            }
            boolean bl = modifierKeyIsPressed = e.getKeyCode() == 17 || e.getKeyCode() == 18 || e.getKeyCode() == 157 || e.getKeyCode() == 16;
            if (modifierKeyIsPressed) {
                return;
            }
            boolean ready = IdeEventQueue.Companion.getInstance().getKeyEventDispatcher().isReady();
            boolean isChar = UIUtil.isReallyTypedEvent((KeyEvent)e);
            boolean hasActionModifiers = e.isAltDown() || e.isControlDown() || e.isMetaDown();
            boolean plainType = isChar && !hasActionModifiers;
            boolean bl2 = isEnter = e.getKeyCode() == 10;
            if (plainType && ready && !isEnter) {
                ActionMacro actionMacro = ActionMacroManager.this.recordingMacro;
                Intrinsics.checkNotNull((Object)actionMacro);
                actionMacro.appendKeyPressed(e.getKeyChar(), e.getKeyCode(), e.getModifiers());
                ActionMacroManager.this.notifyUser(String.valueOf(Character.valueOf(e.getKeyChar())), true);
            } else if (!plainType && ready || isEnter) {
                String string = KeyStroke.getKeyStrokeForEvent(e).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String stroke = string;
                int pressed = StringsKt.indexOf$default((CharSequence)stroke, (String)"pressed", (int)0, (boolean)false, (int)6, null);
                String string2 = stroke.substring(pressed + 7);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String key = string2;
                String string3 = stroke.substring(0, pressed);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                String modifiers = string3;
                String shortcut = ((Object)StringsKt.trim((CharSequence)(((Object)StringsKt.trim((CharSequence)StringsKt.replace$default((String)modifiers, (String)"ctrl", (String)"control", (boolean)false, (int)4, null))).toString() + " " + ((Object)StringsKt.trim((CharSequence)key)).toString()))).toString();
                ActionMacro actionMacro = ActionMacroManager.this.recordingMacro;
                Intrinsics.checkNotNull((Object)actionMacro);
                actionMacro.appendShortcut(shortcut);
                String string4 = KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStrokeForEvent(e));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getKeystrokeText(...)");
                ActionMacroManager.this.notifyUser(string4, false);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0096@\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/ide/actionMacro/ActionMacroManager$MyActionTuner;", "Lcom/intellij/openapi/actionSystem/impl/ActionConfigurationCustomizer;", "Lcom/intellij/openapi/actionSystem/impl/ActionConfigurationCustomizer$AsyncLightCustomizeStrategy;", "<init>", "()V", "customize", "", "actionRegistrar", "Lcom/intellij/openapi/actionSystem/ex/ActionRuntimeRegistrar;", "(Lcom/intellij/openapi/actionSystem/ex/ActionRuntimeRegistrar;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nActionMacroManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActionMacroManager.kt\ncom/intellij/ide/actionMacro/ActionMacroManager$MyActionTuner\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,537:1\n70#2,6:538\n*S KotlinDebug\n*F\n+ 1 ActionMacroManager.kt\ncom/intellij/ide/actionMacro/ActionMacroManager$MyActionTuner\n*L\n109#1:538,6\n*E\n"})
    public static final class MyActionTuner
    implements ActionConfigurationCustomizer,
    ActionConfigurationCustomizer.AsyncLightCustomizeStrategy {
        @Override
        @Nullable
        public Object customize(@NotNull ActionRuntimeRegistrar actionRegistrar, @NotNull Continuation<? super Unit> $completion) {
            boolean $i$f$serviceAsync = false;
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$serviceAsync$iv$iv = (ComponentManager)application;
            boolean $i$f$serviceAsync2 = false;
            Object object = ((ComponentManagerEx)$this$serviceAsync$iv$iv).getServiceAsync(ActionMacroManager.class, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\b\u0010\u001a\u001a\u00020\u000bH\u0016J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u001c\u001a\u00020\u0013H\u0016J\u0006\u0010\u001d\u001a\u00020\u0013J\u0015\u0010\u001e\u001a\u00020\u00132\r\u0010\u001f\u001a\t\u0018\u00010\u0017\u00a2\u0006\u0002\b R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/ide/actionMacro/ActionMacroManager$Widget;", "Lcom/intellij/openapi/wm/CustomStatusBarWidget;", "Lcom/intellij/util/Consumer;", "Ljava/awt/event/MouseEvent;", "statusBar", "Lcom/intellij/openapi/wm/StatusBar;", "<init>", "(Lcom/intellij/ide/actionMacro/ActionMacroManager;Lcom/intellij/openapi/wm/StatusBar;)V", "icon", "Lcom/intellij/util/ui/AnimatedIcon;", "presentation", "Lcom/intellij/openapi/wm/StatusBarWidget$WidgetPresentation;", "balloonComponent", "Ljavax/swing/JPanel;", "balloon", "Lcom/intellij/openapi/ui/popup/Balloon;", "myText", "Ljavax/swing/JLabel;", "showBalloon", "", "getComponent", "Ljavax/swing/JComponent;", "ID", "", "consume", "mouseEvent", "getPresentation", "install", "dispose", "delete", "notifyUser", "text", "Lorg/jetbrains/annotations/Nls;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nActionMacroManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActionMacroManager.kt\ncom/intellij/ide/actionMacro/ActionMacroManager$Widget\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,537:1\n37#2,2:538\n*S KotlinDebug\n*F\n+ 1 ActionMacroManager.kt\ncom/intellij/ide/actionMacro/ActionMacroManager$Widget\n*L\n160#1:538,2\n*E\n"})
    private final class Widget
    implements CustomStatusBarWidget,
    Consumer<MouseEvent> {
        @NotNull
        private final StatusBar statusBar;
        @NotNull
        private final AnimatedIcon icon;
        @NotNull
        private final StatusBarWidget.WidgetPresentation presentation;
        @NotNull
        private final JPanel balloonComponent;
        @Nullable
        private Balloon balloon;
        @NotNull
        private final JLabel myText;

        public Widget(StatusBar statusBar) {
            Intrinsics.checkNotNullParameter((Object)statusBar, (String)"statusBar");
            this.statusBar = statusBar;
            List list2 = AnimatedIcon.Recording.ICONS;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"ICONS");
            Collection $this$toTypedArray$iv = list2;
            boolean $i$f$toTypedArray22 = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            this.icon = new AnimatedIcon("Macro recording", thisCollection$iv.toArray(new Icon[0]), AllIcons.Ide.Macro.Recording_1, 250 * AnimatedIcon.Recording.ICONS.size());
            this.icon.setBorder(JBUI.CurrentTheme.StatusBar.Widget.iconBorder());
            this.presentation = new StatusBarWidget.WidgetPresentation(){

                public String getTooltipText() {
                    String string = IdeBundle.message((String)"tooltip.macro.is.being.recorded.now", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    return string;
                }

                public Widget getClickConsumer() {
                    return this;
                }
            };
            AnimatedIcon $i$f$toTypedArray22 = this.icon;
            BaseButtonBehavior behavior2 = new BaseButtonBehavior(this, $i$f$toTypedArray22){
                final /* synthetic */ Widget this$0;
                {
                    this.this$0 = $receiver;
                    super((JComponent)$super_call_param$1, null);
                }

                protected void execute(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Widget.access$showBalloon(this.this$0);
                }
            };
            behavior2.setupListeners();
            this.balloonComponent = (JPanel)new NonOpaquePanel((LayoutManager)new BorderLayout());
            ActionManager actionManager = ActionManager.getInstance();
            AnAction stopAction = actionManager.getAction("StartStopMacroRecording");
            DefaultActionGroup group2 = new DefaultActionGroup();
            group2.add(stopAction);
            ActionToolbar actionToolbar2 = actionManager.createActionToolbar("StatusBarPlace", (ActionGroup)group2, true);
            Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"createActionToolbar(...)");
            ActionToolbar tb = actionToolbar2;
            tb.setMiniMode(true);
            NonOpaquePanel top = new NonOpaquePanel((LayoutManager)new BorderLayout());
            top.add((Component)tb.getComponent(), (Object)"West");
            Object[] objectArray = new Object[]{"...WWWWWWWWWWWWWWWWWWWW"};
            this.myText = new JLabel(IdeBundle.message((String)"status.bar.text.macro.recorded", (Object[])objectArray), 2);
            Dimension preferredSize = this.myText.getPreferredSize();
            this.myText.setPreferredSize(preferredSize);
            this.myText.setText(IdeBundle.message((String)"label.macro.recording.started", (Object[])new Object[0]));
            ActionMacroManager.this.lastTyping = "";
            top.add((Component)this.myText, (Object)"Center");
            this.balloonComponent.add((Component)top, "Center");
        }

        private final void showBalloon() {
            Balloon balloon = this.balloon;
            if (balloon != null) {
                Balloon it = balloon;
                boolean bl = false;
                Disposer.dispose((Disposable)((Disposable)it));
                return;
            }
            Balloon balloon2 = this.balloon = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)this.balloonComponent).setAnimationCycle(200).setCloseButtonEnabled(true).setHideOnAction(false).setHideOnClickOutside(false).setHideOnFrameResize(false).setHideOnKeyOutside(false).setSmallVariant(true).setShadow(true).createBalloon();
            Intrinsics.checkNotNull((Object)balloon2);
            Disposer.register((Disposable)((Disposable)balloon2), () -> Widget.showBalloon$lambda$1(this));
            Balloon balloon3 = this.balloon;
            Intrinsics.checkNotNull((Object)balloon3);
            balloon3.addListener(new JBPopupListener(this){
                final /* synthetic */ Widget this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onClosed(LightweightWindowEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (Widget.access$getBalloon$p(this.this$0) != null) {
                        Balloon balloon = Widget.access$getBalloon$p(this.this$0);
                        Intrinsics.checkNotNull((Object)balloon);
                        Disposer.dispose((Disposable)((Disposable)balloon));
                    }
                }
            });
            Balloon balloon4 = this.balloon;
            Intrinsics.checkNotNull((Object)balloon4);
            AnimatedIcon animatedIcon = this.icon;
            balloon4.show((PositionTracker)new PositionTracker<Balloon>(this, animatedIcon){
                final /* synthetic */ Widget this$0;
                {
                    this.this$0 = $receiver;
                    super((Component)$super_call_param$1);
                }

                public RelativePoint recalculateLocation(Balloon object) {
                    Intrinsics.checkNotNullParameter((Object)object, (String)"object");
                    return new RelativePoint((Component)Widget.access$getIcon$p(this.this$0), new Point(Widget.access$getIcon$p((Widget)this.this$0).getSize().width / 2, 4));
                }
            }, Balloon.Position.above);
        }

        @NotNull
        public JComponent getComponent() {
            return (JComponent)this.icon;
        }

        @NotNull
        public String ID() {
            return "MacroRecording";
        }

        public void consume(@NotNull MouseEvent mouseEvent) {
            Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
        }

        @NotNull
        public StatusBarWidget.WidgetPresentation getPresentation() {
            return this.presentation;
        }

        public void install(@NotNull StatusBar statusBar) {
            Intrinsics.checkNotNullParameter((Object)statusBar, (String)"statusBar");
            this.showBalloon();
        }

        public void dispose() {
            block0: {
                Disposer.dispose((Disposable)((Disposable)this.icon));
                Balloon balloon = this.balloon;
                if (balloon == null) break block0;
                Balloon it = balloon;
                boolean bl = false;
                Disposer.dispose((Disposable)((Disposable)it));
            }
        }

        public final void delete() {
            Balloon balloon = this.balloon;
            if (balloon != null) {
                Balloon it = balloon;
                boolean bl = false;
                Disposer.dispose((Disposable)((Disposable)it));
            }
            this.statusBar.removeWidget(this.ID());
        }

        public final void notifyUser(@Nullable String text2) {
            this.myText.setText(text2);
            this.myText.revalidate();
            this.myText.repaint();
        }

        private static final void showBalloon$lambda$1(Widget this$0) {
            this$0.balloon = null;
        }

        public static final /* synthetic */ Balloon access$getBalloon$p(Widget $this) {
            return $this.balloon;
        }

        public static final /* synthetic */ AnimatedIcon access$getIcon$p(Widget $this) {
            return $this.icon;
        }

        public static final /* synthetic */ void access$showBalloon(Widget $this) {
            $this.showBalloon();
        }
    }
}

