/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.OpenModuleSettingsAction;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableWithText;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.util.OpenSourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseNavigateToSourceAction
extends DumbAwareAction {
    private final boolean myFocusEditor;

    protected BaseNavigateToSourceAction(boolean focusEditor) {
        this.myFocusEditor = focusEditor;
        this.setInjectedContext(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            BaseNavigateToSourceAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            BaseNavigateToSourceAction.$$$reportNull$$$0(1);
        }
        DataContext dataContext2 = e.getDataContext();
        OpenSourceUtil.navigate((boolean)this.myFocusEditor, (Navigatable[])this.getNavigatables(dataContext2));
    }

    public void update(@NotNull AnActionEvent e) {
        String navigateActionText;
        boolean enabled2;
        if (e == null) {
            BaseNavigateToSourceAction.$$$reportNull$$$0(2);
        }
        boolean inPopup = e.isFromContextMenu();
        Navigatable target = this.findTargetForUpdate(e.getDataContext());
        boolean bl = enabled2 = target != null;
        if (inPopup && !(this instanceof OpenModuleSettingsAction) && OpenModuleSettingsAction.isModuleInProjectViewPopup(e)) {
            e.getPresentation().setVisible(false);
            return;
        }
        e.getPresentation().setVisible(!(!enabled2 && inPopup || !this.myFocusEditor && target instanceof NavigatableWithText));
        e.getPresentation().setEnabled(enabled2);
        String string = navigateActionText = this.myFocusEditor && target instanceof NavigatableWithText ? ((NavigatableWithText)target).getNavigateActionText(true) : null;
        if (navigateActionText != null) {
            e.getPresentation().setText(navigateActionText);
        } else {
            e.getPresentation().setTextWithMnemonic(this.getTemplatePresentation().getTextWithPossibleMnemonic());
        }
    }

    @Nullable
    private Navigatable findTargetForUpdate(@NotNull DataContext dataContext2) {
        Navigatable[] navigatables;
        if (dataContext2 == null) {
            BaseNavigateToSourceAction.$$$reportNull$$$0(3);
        }
        if ((navigatables = this.getNavigatables(dataContext2)) == null) {
            return null;
        }
        for (Navigatable navigatable : navigatables) {
            if (!navigatable.canNavigate()) continue;
            return navigatable instanceof PomTargetPsiElement ? ((PomTargetPsiElement)navigatable).getTarget() : navigatable;
        }
        return null;
    }

    protected Navigatable @Nullable [] getNavigatables(DataContext dataContext2) {
        return (Navigatable[])CommonDataKeys.NAVIGATABLE_ARRAY.getData(dataContext2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/BaseNavigateToSourceAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/BaseNavigateToSourceAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findTargetForUpdate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

