/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.DynamicBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.updateSettings.impl.ExternalUpdateManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.AppUIUtilKt;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Restarter;
import com.intellij.util.system.OS;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CreateDesktopEntryAction
extends DumbAwareAction
implements ActionRemoteBehaviorSpecification.Disabled {
    private static final Logger LOG = Logger.getInstance(CreateDesktopEntryAction.class);

    public static boolean isAvailable() {
        return OS.isGenericUnix() && !ExternalUpdateManager.isCreatingDesktopEntries() && PathEnvironmentVariableUtil.isOnPath((String)"xdg-desktop-menu");
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            CreateDesktopEntryAction.$$$reportNull$$$0(0);
        }
        event.getPresentation().setEnabledAndVisible(CreateDesktopEntryAction.isAvailable());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            CreateDesktopEntryAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            CreateDesktopEntryAction.$$$reportNull$$$0(2);
        }
        if (!CreateDesktopEntryAction.isAvailable()) {
            return;
        }
        Project project2 = event.getProject();
        CreateDesktopEntryDialog dialog2 = new CreateDesktopEntryDialog(project2);
        if (!dialog2.showAndGet()) {
            return;
        }
        final boolean globalEntry = dialog2.myGlobalEntryCheckBox.isSelected();
        new Task.Backgroundable(this, project2, ApplicationBundle.message((String)"desktop.entry.progress", (Object[])new Object[0])){

            public void run(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    CreateDesktopEntryAction.createDesktopEntry(globalEntry);
                    String title2 = IdeBundle.message((String)"notification.title.desktop.entry.created", (Object[])new Object[0]);
                    String message = ApplicationBundle.message((String)"desktop.entry.success", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()});
                    new Notification("System Messages", title2, message, NotificationType.INFORMATION).notify(this.getProject());
                }
                catch (Exception e) {
                    CreateDesktopEntryAction.reportFailure(e, this.getProject());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/actions/CreateDesktopEntryAction$1", "run"));
            }
        }.queue();
    }

    @NotNull
    public static String getDesktopEntryName() {
        String string = AppUIUtil.INSTANCE.getFrameClass() + ".desktop";
        if (string == null) {
            CreateDesktopEntryAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static void createDesktopEntry(boolean globalEntry) throws Exception {
        if (!CreateDesktopEntryAction.isAvailable()) {
            return;
        }
        CreateDesktopEntryAction.check();
        Path entry = CreateDesktopEntryAction.prepare();
        try {
            CreateDesktopEntryAction.install(entry, globalEntry);
        }
        finally {
            Files.delete(entry);
        }
    }

    private static void reportFailure(Exception e, @Nullable Project project2) {
        LOG.warn((Throwable)e);
        String title2 = IdeBundle.message((String)"notification.title.desktop.entry.creation.failed", (Object[])new Object[0]);
        String message = ExceptionUtil.getNonEmptyMessage((Throwable)e, (String)IdeBundle.message((String)"notification.content.internal error", (Object[])new Object[0]));
        new Notification("System Messages", title2, message, NotificationType.ERROR).notify(project2);
    }

    private static void check() throws ExecutionException, InterruptedException {
        int result2 = new GeneralCommandLine(new String[]{"which", "xdg-desktop-menu"}).createProcess().waitFor();
        if (result2 != 0) {
            throw new RuntimeException(ApplicationBundle.message((String)"desktop.entry.xdg.missing", (Object[])new Object[0]));
        }
    }

    private static Path prepare() throws IOException {
        Path binDir = PathManager.getBinDir();
        assert (Files.isDirectory(binDir, new LinkOption[0])) : "Invalid bin directory: '" + String.valueOf(binDir) + "'";
        String iconPath = AppUIUtilKt.findAppIcon();
        if (iconPath == null) {
            throw new RuntimeException(ApplicationBundle.message((String)"desktop.entry.icon.missing", (Object[])new Object[]{binDir}));
        }
        Path starter = Restarter.getIdeStarter();
        if (starter == null) {
            throw new RuntimeException(ApplicationBundle.message((String)"desktop.entry.script.missing", (Object[])new Object[]{binDir}));
        }
        ApplicationNamesInfo names = ApplicationNamesInfo.getInstance();
        String name2 = names.getFullProductNameWithEdition();
        String content2 = ExecUtil.loadTemplate((ClassLoader)CreateDesktopEntryAction.class.getClassLoader(), (String)"entry.desktop", Map.of("$NAME$", name2, "$SCRIPT$", StringUtil.wrapWithDoubleQuote((String)starter.toString()), "$ICON$", iconPath, "$COMMENT$", StringUtil.notNullize((String)names.getMotto(), (String)name2), "$WM_CLASS$", AppUIUtil.INSTANCE.getFrameClass()));
        Path entryFile = PathManager.getTempDir().resolve(CreateDesktopEntryAction.getDesktopEntryName());
        Files.writeString(entryFile, (CharSequence)content2, new OpenOption[0]);
        return entryFile;
    }

    private static void install(Path entryFile, boolean globalEntry) throws IOException, ExecutionException {
        if (globalEntry) {
            File script = ExecUtil.createTempExecutableScript((String)"create_desktop_entry_", (String)".sh", (String)("#!/bin/sh\nxdg-desktop-menu install --mode system '" + String.valueOf(entryFile) + "' && xdg-desktop-menu forceupdate --mode system\n"));
            try {
                CreateDesktopEntryAction.exec(new GeneralCommandLine(new String[]{script.getPath()}), ApplicationBundle.message((String)"desktop.entry.sudo.prompt", (Object[])new Object[0]));
            }
            finally {
                Files.delete(script.toPath());
            }
        } else {
            CreateDesktopEntryAction.exec(new GeneralCommandLine(new String[]{"xdg-desktop-menu", "install", "--mode", "user", entryFile.toString()}), null);
            CreateDesktopEntryAction.exec(new GeneralCommandLine(new String[]{"xdg-desktop-menu", "forceupdate", "--mode", "user"}), null);
        }
    }

    private static void exec(GeneralCommandLine command, @Nls @Nullable String prompt) throws IOException, ExecutionException {
        command.withRedirectErrorStream(true);
        ProcessOutput result2 = new CapturingProcessHandler(prompt != null ? ExecUtil.sudoCommand((GeneralCommandLine)command, (String)prompt) : command).runProcess();
        int exitCode2 = result2.getExitCode();
        if (exitCode2 != 0) {
            String message = "Command '" + (prompt != null ? "sudo " : "") + command.getCommandLineString() + "' returned " + exitCode2;
            String output = result2.getStdout();
            if (!output.isBlank()) {
                message = message + "\nOutput: " + output.trim();
            }
            throw new RuntimeException(message);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/CreateDesktopEntryAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/CreateDesktopEntryAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDesktopEntryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }

    public static final class CreateDesktopEntryDialog
    extends DialogWrapper {
        @NlsSafe
        private static final String APP_NAME_PLACEHOLDER = "$APP_NAME$";
        private JPanel myContentPane;
        private JLabel myLabel;
        private JCheckBox myGlobalEntryCheckBox;

        public CreateDesktopEntryDialog(Project project2) {
            super(project2);
            this.$$$setupUI$$$();
            this.init();
            this.setTitle(ApplicationBundle.message((String)"desktop.entry.title", (Object[])new Object[0]));
            this.myLabel.setText(this.myLabel.getText().replace(APP_NAME_PLACEHOLDER, ApplicationNamesInfo.getInstance().getProductName()));
        }

        protected JComponent createCenterPanel() {
            return this.myContentPane;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JLabel jLabel;
            JCheckBox jCheckBox;
            JPanel jPanel;
            this.myContentPane = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
            this.myGlobalEntryCheckBox = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/IdeBundle", CreateDesktopEntryDialog.class).getString("checkbox.create.the.entry.for.all.users.requires.superuser.privileges"));
            jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myLabel = jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/IdeBundle", CreateDesktopEntryDialog.class).getString("label.you.can.create.a.desktop.entry"));
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myContentPane;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int j = 0; j < string.length(); ++j) {
                if (string.charAt(j) == '&') {
                    if (++j == string.length()) break;
                    if (!bl && string.charAt(j) != '&') {
                        bl = true;
                        c = string.charAt(j);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(j));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int j = 0; j < string.length(); ++j) {
                if (string.charAt(j) == '&') {
                    if (++j == string.length()) break;
                    if (!bl && string.charAt(j) != '&') {
                        bl = true;
                        c = string.charAt(j);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(j));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

