/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.CustomLayoutsActionGroupKt;
import com.intellij.ide.actions.DeleteNamedLayoutAction;
import com.intellij.ide.actions.NamedLayoutListBasedCache;
import com.intellij.ide.actions.RenameLayoutAction;
import com.intellij.ide.actions.StoreNamedLayoutAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionWrapper;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.toolWindow.ToolWindowDefaultLayoutManager;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ide/actions/CustomLayoutsActionGroup;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Frontend;", "<init>", "()V", "childrenCache", "Lcom/intellij/ide/actions/NamedLayoutListBasedCache;", "Lcom/intellij/openapi/actionSystem/AnAction;", "getChildren", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "CustomLayoutActionGroup", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class CustomLayoutsActionGroup
extends ActionGroup
implements DumbAware,
ActionRemoteBehaviorSpecification.Frontend {
    @NotNull
    private final NamedLayoutListBasedCache<AnAction> childrenCache = new NamedLayoutListBasedCache(CollectionsKt.emptyList(), 0, CustomLayoutsActionGroup::childrenCache$lambda$0);

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray;
        if (e == null) {
            AnAction[] anActionArray2 = AnAction.EMPTY_ARRAY;
            Intrinsics.checkNotNull((Object)anActionArray2);
            anActionArray = anActionArray2;
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)AnAction.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            anActionArray = this.childrenCache.getCachedOrUpdatedArray((AnAction[])((Object[])AnAction.EMPTY_ARRAY));
        }
        return anActionArray;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        e.getPresentation().setVisible(!Intrinsics.areEqual((Object)e.getPlace(), (Object)"GoToAction"));
        e.getPresentation().setPopupGroup(!Intrinsics.areEqual((Object)e.getPlace(), (Object)"MainMenu"));
    }

    private static final AnAction childrenCache$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (AnAction)new CustomLayoutActionGroup(it);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0004\u0017\u0018\u0019\u001aB\u0011\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ide/actions/CustomLayoutsActionGroup$CustomLayoutActionGroup;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/actionSystem/Toggleable;", "layoutName", "", "<init>", "(Ljava/lang/String;)V", "commonChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "currentLayoutChildren", "", "[Lcom/intellij/openapi/actionSystem/AnAction;", "nonCurrentLayoutChildren", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getChildren", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "Apply", "Restore", "Save", "Delete", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nCustomLayoutsActionGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomLayoutsActionGroup.kt\ncom/intellij/ide/actions/CustomLayoutsActionGroup$CustomLayoutActionGroup\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,112:1\n37#2,2:113\n37#2,2:115\n*S KotlinDebug\n*F\n+ 1 CustomLayoutsActionGroup.kt\ncom/intellij/ide/actions/CustomLayoutsActionGroup$CustomLayoutActionGroup\n*L\n50#1:113,2\n54#1:115,2\n*E\n"})
    private static final class CustomLayoutActionGroup
    extends ActionGroup
    implements DumbAware,
    Toggleable {
        @NotNull
        private final String layoutName;
        @NotNull
        private final List<AnAction> commonChildren;
        @NotNull
        private final AnAction[] currentLayoutChildren;
        @NotNull
        private final AnAction[] nonCurrentLayoutChildren;

        public CustomLayoutActionGroup(@NlsSafe @NotNull String layoutName) {
            Intrinsics.checkNotNullParameter((Object)layoutName, (String)"layoutName");
            super(ActionsBundle.message((String)"group.CustomLayoutActionsGroup.text", (Object[])new Object[0]), true);
            this.layoutName = layoutName;
            Object[] objectArray = new AnAction[]{new RenameLayoutAction(this.layoutName), new Separator(), new Delete(this.layoutName)};
            this.commonChildren = CollectionsKt.listOf((Object[])objectArray);
            objectArray = new AnAction[]{new Restore(), new Save(this.layoutName)};
            Collection $this$toTypedArray$iv = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)this.commonChildren);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            this.currentLayoutChildren = thisCollection$iv.toArray(new AnAction[0]);
            $this$toTypedArray$iv = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)((Object)new Apply(this.layoutName))), (Iterable)this.commonChildren);
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            this.nonCurrentLayoutChildren = thisCollection$iv.toArray(new AnAction[0]);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setText(this.layoutName, false);
            e.getPresentation().setVisible(!StringsKt.isBlank((CharSequence)this.layoutName));
            Toggleable.setSelected((Presentation)e.getPresentation(), (boolean)Intrinsics.areEqual((Object)CustomLayoutsActionGroupKt.access$getManager().getActiveLayoutName(), (Object)this.layoutName));
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            return Intrinsics.areEqual((Object)CustomLayoutsActionGroupKt.access$getManager().getActiveLayoutName(), (Object)this.layoutName) ? this.currentLayoutChildren : this.nonCurrentLayoutChildren;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/actions/CustomLayoutsActionGroup$CustomLayoutActionGroup$Apply;", "Lcom/intellij/openapi/project/DumbAwareAction;", "layoutName", "", "<init>", "(Ljava/lang/String;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.ide.impl"})
        private static final class Apply
        extends DumbAwareAction {
            @NotNull
            private final String layoutName;

            public Apply(@NotNull String layoutName) {
                Intrinsics.checkNotNullParameter((Object)layoutName, (String)"layoutName");
                this.layoutName = layoutName;
                this.getTemplatePresentation().setText(ActionsBundle.message((String)"action.CustomLayoutActionsGroup.Apply.text", (Object[])new Object[0]));
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Project project2 = e.getProject();
                if (project2 == null) {
                    return;
                }
                Project project3 = project2;
                ToolWindowDefaultLayoutManager layoutManager = ToolWindowDefaultLayoutManager.Companion.getInstance();
                layoutManager.setActiveLayoutName(this.layoutName);
                ToolWindowManagerEx.Companion.getInstanceEx(project3).setLayout(layoutManager.getLayoutCopy());
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ide/actions/CustomLayoutsActionGroup$CustomLayoutActionGroup$Delete;", "Lcom/intellij/ide/actions/DeleteNamedLayoutAction;", "layoutName", "", "<init>", "(Ljava/lang/String;)V", "intellij.platform.ide.impl"})
        private static final class Delete
        extends DeleteNamedLayoutAction {
            public Delete(@NotNull String layoutName) {
                Intrinsics.checkNotNullParameter((Object)layoutName, (String)"layoutName");
                super(layoutName);
                this.getTemplatePresentation().setText(ActionsBundle.message((String)"action.CustomLayoutActionsGroup.Delete.text", (Object[])new Object[0]));
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/actions/CustomLayoutsActionGroup$CustomLayoutActionGroup$Restore;", "Lcom/intellij/openapi/actionSystem/AnActionWrapper;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.ide.impl"})
        private static final class Restore
        extends AnActionWrapper {
            public Restore() {
                AnAction anAction = ActionManager.getInstance().getAction("RestoreDefaultLayout");
                Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"getAction(...)");
                super(anAction);
            }

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                super.update(e);
                e.getPresentation().setVisible(true);
                e.getPresentation().setText(ActionsBundle.message((String)"action.CustomLayoutActionsGroup.Restore.text", (Object[])new Object[0]));
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ide/actions/CustomLayoutsActionGroup$CustomLayoutActionGroup$Save;", "Lcom/intellij/ide/actions/StoreNamedLayoutAction;", "layoutName", "", "<init>", "(Ljava/lang/String;)V", "intellij.platform.ide.impl"})
        private static final class Save
        extends StoreNamedLayoutAction {
            public Save(@NotNull String layoutName) {
                Intrinsics.checkNotNullParameter((Object)layoutName, (String)"layoutName");
                super(layoutName);
                this.getTemplatePresentation().setText(ActionsBundle.message((String)"action.CustomLayoutActionsGroup.Save.text", (Object[])new Object[0]));
            }
        }
    }
}

