/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.configurationStore.ProjectStorePathManager;
import com.intellij.ide.ui.ProductIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.util.SystemProperties;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenProjectFileChooserDescriptor
extends FileChooserDescriptor {
    public OpenProjectFileChooserDescriptor(boolean chooseFiles) {
        this(chooseFiles, chooseFiles);
    }

    public OpenProjectFileChooserDescriptor(boolean chooseFiles, boolean chooseJars) {
        super(chooseFiles, true, chooseJars, chooseJars, false, false);
        this.setHideIgnored(false);
    }

    public boolean isFileSelectable(@Nullable VirtualFile file2) {
        return file2 != null && (OpenProjectFileChooserDescriptor.isProjectDirectory(file2) || OpenProjectFileChooserDescriptor.isProjectFile(file2));
    }

    public Icon getIcon(VirtualFile file2) {
        if (OpenProjectFileChooserDescriptor.canInspectDirectory(file2)) {
            if (OpenProjectFileChooserDescriptor.isIprFile(file2) || OpenProjectFileChooserDescriptor.isIdeaDirectory(file2)) {
                return OpenProjectFileChooserDescriptor.dressIcon((VirtualFile)file2, (Icon)ProductIcons.getInstance().getProjectNodeIcon());
            }
            Icon icon2 = OpenProjectFileChooserDescriptor.getImporterIcon(file2);
            if (icon2 != null) {
                return OpenProjectFileChooserDescriptor.dressIcon((VirtualFile)file2, (Icon)icon2);
            }
        }
        return super.getIcon(file2);
    }

    private static boolean canInspectDirectory(VirtualFile file2) {
        if (file2.isInLocalFileSystem()) {
            try {
                Path path = file2.getFileSystem().getNioPath(file2);
                if (path == null || !path.startsWith(Path.of(SystemProperties.getUserHome(), new String[0]))) {
                    return false;
                }
            }
            catch (InvalidPathException e) {
                Logger.getInstance(OpenProjectFileChooserDescriptor.class).error((Throwable)e);
                return false;
            }
        }
        return true;
    }

    @Nullable
    private static Icon getImporterIcon(VirtualFile file2) {
        ProjectOpenProcessor provider = ProjectOpenProcessor.getImportProvider((VirtualFile)file2);
        return provider == null ? null : (file2.isDirectory() && provider.lookForProjectsInDirectory() ? ProductIcons.getInstance().getProjectNodeIcon() : provider.getIcon(file2));
    }

    public static boolean isProjectFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            OpenProjectFileChooserDescriptor.$$$reportNull$$$0(0);
        }
        return !file2.isDirectory() && file2.isValid() && (OpenProjectFileChooserDescriptor.isIprFile(file2) || OpenProjectFileChooserDescriptor.hasImportProvider(file2));
    }

    private static boolean isProjectDirectory(VirtualFile file2) {
        return file2.isDirectory() && file2.isValid() && (OpenProjectFileChooserDescriptor.isIdeaDirectory(file2) || OpenProjectFileChooserDescriptor.hasImportProvider(file2));
    }

    private static boolean isIprFile(VirtualFile file2) {
        return "ipr".equalsIgnoreCase(file2.getExtension());
    }

    private static boolean isIdeaDirectory(VirtualFile file2) {
        return ProjectStorePathManager.Companion.getInstance().testStoreDirectoryExistsForProjectRoot(file2);
    }

    private static boolean hasImportProvider(VirtualFile file2) {
        return ProjectOpenProcessor.getImportProvider((VirtualFile)file2) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/actions/OpenProjectFileChooserDescriptor", "isProjectFile"));
    }
}

