/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.dnd.aware;

import com.intellij.ide.dnd.DnDAware;
import com.intellij.ide.dnd.TransferableList;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.tree.ui.DefaultTreeUI;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DnDAwareTree
extends Tree
implements DnDAware {
    private static final TransferHandler DEFAULT_TRANSFER_HANDLER = new TransferHandler(){

        @Override
        protected Transferable createTransferable(JComponent component2) {
            JTree tree2;
            TreePath[] selection;
            if (component2 instanceof JTree && (selection = (tree2 = (JTree)component2).getSelectionPaths()) != null && selection.length > 0) {
                return new TransferableList<TreePath>(this, selection){

                    @Override
                    protected String toString(TreePath path) {
                        return String.valueOf(path.getLastPathComponent());
                    }
                };
            }
            return null;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }
    };

    public DnDAwareTree() {
        this.initDnD();
    }

    public DnDAwareTree(TreeModel treemodel) {
        super(treemodel);
        this.initDnD();
    }

    public DnDAwareTree(TreeNode root) {
        super(root);
        this.initDnD();
    }

    public void processMouseEvent(MouseEvent e) {
        if (this.getToolTipText() == null && e.getID() == 504) {
            return;
        }
        super.processMouseEvent(e);
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        if (ClientSystemInfo.isMac() && SwingUtilities.isRightMouseButton(e) && e.getID() == 506) {
            return;
        }
        super.processMouseMotionEvent(e);
    }

    public final boolean isOverSelection(Point point) {
        TreePath path = TreeUtil.getPathForLocation((JTree)((Object)this), (int)point.x, (int)point.y);
        if (path == null) {
            return false;
        }
        return this.isPathSelected(path);
    }

    @ApiStatus.Internal
    public final boolean isOverExpandControl(@NotNull Point point) {
        TreeUI ui;
        if (point == null) {
            DnDAwareTree.$$$reportNull$$$0(0);
        }
        if ((ui = this.getUI()) instanceof DefaultTreeUI) {
            DefaultTreeUI treeUI = (DefaultTreeUI)ui;
            return treeUI.isLocationInExpandControl(point);
        }
        return false;
    }

    public void dropSelectionButUnderPoint(Point point) {
        TreeUtil.dropSelectionButUnderPoint((JTree)((Object)this), (Point)point);
    }

    @NotNull
    public final JComponent getComponent() {
        DnDAwareTree dnDAwareTree = this;
        if (dnDAwareTree == null) {
            DnDAwareTree.$$$reportNull$$$0(1);
        }
        return dnDAwareTree;
    }

    @NotNull
    public static Pair<Image, Point> getDragImage(@NotNull Tree dndAwareTree, @NotNull TreePath path, @NotNull Point dragOrigin) {
        if (dndAwareTree == null) {
            DnDAwareTree.$$$reportNull$$$0(2);
        }
        if (path == null) {
            DnDAwareTree.$$$reportNull$$$0(3);
        }
        if (dragOrigin == null) {
            DnDAwareTree.$$$reportNull$$$0(4);
        }
        int row2 = dndAwareTree.getRowForPath(path);
        Component comp = dndAwareTree.getCellRenderer().getTreeCellRendererComponent((JTree)dndAwareTree, path.getLastPathComponent(), false, true, true, row2, false);
        return DnDAwareTree.createDragImage(dndAwareTree, comp, dragOrigin, true);
    }

    @NotNull
    public static Pair<Image, Point> getDragImage(@NotNull Tree dndAwareTree, @NotNull @Nls String text2, @Nullable Point dragOrigin) {
        if (dndAwareTree == null) {
            DnDAwareTree.$$$reportNull$$$0(5);
        }
        if (text2 == null) {
            DnDAwareTree.$$$reportNull$$$0(6);
        }
        return DnDAwareTree.createDragImage(dndAwareTree, new JLabel(text2), dragOrigin, false);
    }

    @NotNull
    private static Pair<Image, Point> createDragImage(@NotNull Tree tree2, @NotNull Component c, @Nullable Point dragOrigin, boolean adjustToPathUnderDragOrigin) {
        TreePath path;
        if (tree2 == null) {
            DnDAwareTree.$$$reportNull$$$0(7);
        }
        if (c == null) {
            DnDAwareTree.$$$reportNull$$$0(8);
        }
        if (c instanceof JComponent) {
            ((JComponent)c).setOpaque(true);
        }
        c.setForeground(RenderingUtil.getForeground((JTree)tree2));
        c.setBackground(RenderingUtil.getBackground((JTree)tree2));
        c.setFont(tree2.getFont());
        c.setSize(c.getPreferredSize());
        BufferedImage image2 = UIUtil.createImage((Component)c, (int)c.getWidth(), (int)c.getHeight(), (int)2);
        Graphics2D g2 = (Graphics2D)image2.getGraphics();
        g2.setComposite(AlphaComposite.getInstance(3, 0.7f));
        c.paint(g2);
        g2.dispose();
        Point point = new Point(image2.getWidth(null) / 2, image2.getHeight(null) / 2);
        if (adjustToPathUnderDragOrigin && (path = tree2.getPathForLocation(dragOrigin.x, dragOrigin.y)) != null) {
            Rectangle bounds = tree2.getPathBounds(path);
            point = new Point(dragOrigin.x - bounds.x, dragOrigin.y - bounds.y);
        }
        return new Pair((Object)image2, (Object)point);
    }

    private void initDnD() {
        if (!GraphicsEnvironment.isHeadless()) {
            this.setDragEnabled(true);
            this.setTransferHandler(DEFAULT_TRANSFER_HANDLER);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/dnd/aware/DnDAwareTree";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dndAwareTree";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dragOrigin";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/dnd/aware/DnDAwareTree";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isOverExpandControl";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDragImage";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDragImage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

