/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CustomizedDataContext;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@ApiStatus.NonExtendable
public class HeadlessDataManager
extends DataManagerImpl {
    private volatile DataProvider myTestDataProvider;
    private volatile boolean myUseProductionDataManager = false;

    @TestOnly
    public void setTestDataProvider(@Nullable DataProvider provider) {
        this.myTestDataProvider = provider;
    }

    @TestOnly
    public void setTestDataProvider(@Nullable DataProvider provider, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            HeadlessDataManager.$$$reportNull$$$0(0);
        }
        DataProvider previous = this.myTestDataProvider;
        this.myTestDataProvider = provider;
        Disposer.register((Disposable)parentDisposable, () -> {
            this.myTestDataProvider = previous;
        });
    }

    @TestOnly
    public static void fallbackToProductionDataManager(@NotNull Disposable disposable) {
        if (disposable == null) {
            HeadlessDataManager.$$$reportNull$$$0(1);
        }
        HeadlessDataManager manager2 = (HeadlessDataManager)DataManager.getInstance();
        if (manager2.myUseProductionDataManager) {
            throw new IllegalStateException("Already called and still not disposed.");
        }
        Disposer.register((Disposable)disposable, () -> {
            manager2.myUseProductionDataManager = false;
        });
        manager2.myUseProductionDataManager = true;
    }

    @NotNull
    public DataContext getDataContext() {
        return new HeadlessContext(this.productionDataContext(() -> super.getDataContext()), this.myTestDataProvider);
    }

    @NotNull
    public Promise<DataContext> getDataContextFromFocusAsync() {
        AsyncPromise promise = new AsyncPromise();
        promise.setResult((Object)this.getDataContext());
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            HeadlessDataManager.$$$reportNull$$$0(2);
        }
        return asyncPromise;
    }

    @NotNull
    public DataContext getDataContext(Component component2) {
        return new HeadlessContext(this.productionDataContext(() -> super.getDataContext(component2)), this.myTestDataProvider);
    }

    @NotNull
    public DataContext getDataContext(@NotNull Component component2, int x, int y) {
        if (component2 == null) {
            HeadlessDataManager.$$$reportNull$$$0(3);
        }
        return new HeadlessContext(this.productionDataContext(() -> super.getDataContext(component2, x, y)), this.myTestDataProvider);
    }

    @Nullable
    private DataContext productionDataContext(@NotNull @NotNull Supplier<? extends @NotNull DataContext> dataContextSupplier) {
        if (dataContextSupplier == null) {
            HeadlessDataManager.$$$reportNull$$$0(4);
        }
        return this.myUseProductionDataManager ? dataContextSupplier.get() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/impl/HeadlessDataManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContextSupplier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/impl/HeadlessDataManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataContextFromFocusAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setTestDataProvider";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fallbackToProductionDataManager";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDataContext";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "productionDataContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static final class HeadlessContext
    extends CustomizedDataContext
    implements UserDataHolder {
        HeadlessContext(@Nullable DataContext parent, @Nullable DataProvider provider) {
            super(parent == null ? EMPTY_CONTEXT : parent, provider == null ? o -> null : provider, (UserDataHolder)new MyUserDataHolder());
        }
    }

    private static class MyUserDataHolder
    implements UserDataHolder {
        private Map<Key<?>, Object> myUserData;

        private MyUserDataHolder() {
        }

        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                MyUserDataHolder.$$$reportNull$$$0(0);
            }
            return (T)this.getOrCreateMap().get(key);
        }

        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
            if (key == null) {
                MyUserDataHolder.$$$reportNull$$$0(1);
            }
            this.getOrCreateMap().put(key, value);
        }

        @NotNull
        private Map<Key<?>, Object> getOrCreateMap() {
            Map userData = this.myUserData;
            if (userData == null) {
                this.myUserData = userData = ContainerUtil.createWeakValueMap();
            }
            Map map2 = userData;
            if (map2 == null) {
                MyUserDataHolder.$$$reportNull$$$0(2);
            }
            return map2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/impl/HeadlessDataManager$MyUserDataHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/impl/HeadlessDataManager$MyUserDataHolder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCreateMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getUserData";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "putUserData";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

