/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit;

import com.intellij.ide.lightEdit.LightEditServiceImpl;
import com.intellij.ide.lightEdit.LightEditorInfo;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.concurrency.NonUrgentExecutor;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0002\u001a\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0012"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "appName", "", "getAppName", "()Ljava/lang/String;", "doWhenActionManagerInitialized", "", "callback", "Lkotlin/Function0;", "invokeOnEdt", "Ljava/lang/Runnable;", "getFileTitle", "editorInfo", "Lcom/intellij/ide/lightEdit/LightEditorInfo;", "getPresentablePath", "truncateUrl", "url", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nLightEditServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LightEditServiceImpl.kt\ncom/intellij/ide/lightEdit/LightEditServiceImplKt\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,513:1\n55#2:514\n13#3:515\n*S KotlinDebug\n*F\n+ 1 LightEditServiceImpl.kt\ncom/intellij/ide/lightEdit/LightEditServiceImplKt\n*L\n451#1:514\n445#1:515\n*E\n"})
public final class LightEditServiceImplKt {
    @NotNull
    private static final Logger LOG;

    private static final String getAppName() {
        String string = ApplicationInfo.getInstance().getVersionName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVersionName(...)");
        return string;
    }

    private static final void doWhenActionManagerInitialized(Function0<Unit> callback) {
        boolean $i$f$serviceIfCreated = false;
        Application application = ApplicationManager.getApplication();
        ActionManager created2 = (ActionManager)(application != null ? application.getServiceIfCreated(ActionManager.class) : null);
        if (created2 == null) {
            NonUrgentExecutor.getInstance().execute(() -> LightEditServiceImplKt.doWhenActionManagerInitialized$lambda$0(callback));
        } else {
            LightEditServiceImplKt.invokeOnEdt(() -> LightEditServiceImplKt.doWhenActionManagerInitialized$lambda$1(callback));
        }
    }

    private static final void invokeOnEdt(Runnable callback) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            callback.run();
        } else {
            ApplicationManager.getApplication().invokeLater(callback);
        }
    }

    private static final String getFileTitle(LightEditorInfo editorInfo) {
        VirtualFile virtualFile = editorInfo.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        VirtualFile file2 = virtualFile;
        StringBuilder titleBuilder = new StringBuilder();
        titleBuilder.append(file2.getPresentableName());
        String parentPath = LightEditServiceImplKt.getPresentablePath(editorInfo);
        if (parentPath != null) {
            titleBuilder.append(" - ").append(LightEditServiceImplKt.truncateUrl(parentPath));
        }
        String string = titleBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final String getPresentablePath(LightEditorInfo editorInfo) {
        VirtualFile virtualFile = editorInfo.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        VirtualFile file2 = virtualFile;
        if (file2 instanceof LightVirtualFile) {
            Path path;
            Path preferredPath = editorInfo.getPreferredSavePath();
            if (preferredPath != null && (path = preferredPath.getParent()) != null) {
                Path it = path;
                boolean bl = false;
                return ((Object)it).toString();
            }
        } else {
            VirtualFile virtualFile2 = file2.getParent();
            if (virtualFile2 != null) {
                VirtualFile it = virtualFile2;
                boolean bl = false;
                return it.getPresentableUrl();
            }
        }
        return null;
    }

    private static final String truncateUrl(String url) {
        String withoutLast;
        int prevSlashPos;
        int slashPos = Math.max(StringsKt.lastIndexOf$default((CharSequence)url, (char)'\\', (int)0, (boolean)false, (int)6, null), StringsKt.lastIndexOf$default((CharSequence)url, (char)'/', (int)0, (boolean)false, (int)6, null));
        if (slashPos >= 0 && (prevSlashPos = Math.max(StringsKt.lastIndexOf$default((CharSequence)(withoutLast = StringsKt.take((String)url, (int)slashPos)), (char)'\\', (int)0, (boolean)false, (int)6, null), StringsKt.lastIndexOf$default((CharSequence)withoutLast, (char)'/', (int)0, (boolean)false, (int)6, null))) >= 0) {
            String string = url.substring(prevSlashPos);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String truncated = string;
            if (!Intrinsics.areEqual((Object)url, (Object)truncated)) {
                String string2 = url.substring(prevSlashPos);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                return "..." + string2;
            }
        }
        return url;
    }

    private static final void doWhenActionManagerInitialized$lambda$0(Function0 $callback) {
        ActionManager.getInstance();
        LightEditServiceImplKt.invokeOnEdt(() -> LightEditServiceImplKt.doWhenActionManagerInitialized$lambda$0$0($callback));
    }

    private static final void doWhenActionManagerInitialized$lambda$0$0(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final void doWhenActionManagerInitialized$lambda$1(Function0 $tmp0) {
        $tmp0.invoke();
    }

    public static final /* synthetic */ void access$invokeOnEdt(Runnable callback) {
        LightEditServiceImplKt.invokeOnEdt(callback);
    }

    public static final /* synthetic */ void access$doWhenActionManagerInitialized(Function0 callback) {
        LightEditServiceImplKt.doWhenActionManagerInitialized((Function0<Unit>)callback);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ String access$getAppName() {
        return LightEditServiceImplKt.getAppName();
    }

    public static final /* synthetic */ String access$getFileTitle(LightEditorInfo editorInfo) {
        return LightEditServiceImplKt.getFileTitle(editorInfo);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LightEditServiceImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

