/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.DynamicPluginVfsListener;
import com.intellij.ide.plugins.DynamicPluginVfsListenerKt;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginMainDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/plugins/DynamicPluginVfsListener;", "Lcom/intellij/openapi/vfs/AsyncFileListener;", "<init>", "()V", "prepareChange", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "findPluginByPath", "Lcom/intellij/ide/plugins/PluginMainDescriptor;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nDynamicPluginVfsListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DynamicPluginVfsListener.kt\ncom/intellij/ide/plugins/DynamicPluginVfsListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n774#2:137\n865#2,2:138\n295#2,2:140\n*S KotlinDebug\n*F\n+ 1 DynamicPluginVfsListener.kt\ncom/intellij/ide/plugins/DynamicPluginVfsListener\n*L\n79#1:137\n79#1:138,2\n119#1:140,2\n*E\n"})
final class DynamicPluginVfsListener
implements AsyncFileListener {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(events, (String)"events");
        if (!Boolean.getBoolean("idea.auto.reload.plugins")) {
            return null;
        }
        if (!DynamicPluginVfsListenerKt.access$getInitialRefreshDone$p()) {
            return null;
        }
        HashSet<PluginMainDescriptor> pluginsToReload = new HashSet<PluginMainDescriptor>();
        for (VFileEvent vFileEvent : events) {
            PluginMainDescriptor it;
            if (!vFileEvent.isFromRefresh() || !(vFileEvent instanceof VFileContentChangeEvent)) continue;
            VirtualFile virtualFile = ((VFileContentChangeEvent)vFileEvent).getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            if (this.findPluginByPath(virtualFile) == null) continue;
            boolean bl = false;
            DynamicPluginVfsListenerKt.access$getLOG().info("Detected plugin .jar file change " + ((VFileContentChangeEvent)vFileEvent).getPath() + ", reloading plugin");
            pluginsToReload.add(it);
        }
        Iterable iterable = pluginsToReload;
        boolean $i$f$filter = false;
        Iterable iterable2 = iterable;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PluginMainDescriptor it = (PluginMainDescriptor)element$iv$iv;
            boolean bl = false;
            if (!(it.isEnabled() && DynamicPlugins.allowLoadUnloadWithoutRestart$default((IdeaPluginDescriptorImpl)it, null, null, 6, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List descriptorsToReload = (List)destination$iv$iv;
        if (descriptorsToReload.isEmpty()) {
            return null;
        }
        return new AsyncFileListener.ChangeApplier(descriptorsToReload){
            final /* synthetic */ List<PluginMainDescriptor> $descriptorsToReload;
            {
                this.$descriptorsToReload = $descriptorsToReload;
            }

            public void afterVfsChange() {
                ApplicationManager.getApplication().invokeLater(() -> prepareChange.2.afterVfsChange$lambda$0(this.$descriptorsToReload));
            }

            private static final void afterVfsChange$lambda$0(List $descriptorsToReload) {
                List reloaded2 = new ArrayList<E>();
                List unloadFailed = new ArrayList<E>();
                for (PluginMainDescriptor pluginDescriptor : $descriptorsToReload) {
                    if (!DynamicPlugins.INSTANCE.unloadPlugin(pluginDescriptor, new DynamicPlugins.UnloadPluginOptions(false, true, false, false, true, false, null, 109, null))) {
                        unloadFailed.add(pluginDescriptor.getName());
                        continue;
                    }
                    reloaded2.add(pluginDescriptor.getName());
                    DynamicPlugins.loadPlugin$default(DynamicPlugins.INSTANCE, pluginDescriptor, null, 2, null);
                }
                if (!((Collection)unloadFailed).isEmpty()) {
                    var4_4 = new Object[]{CollectionsKt.joinToString$default((Iterable)unloadFailed, null, null, null, (int)0, null, null, (int)63, null)};
                    String string = IdeBundle.message((String)"failed.to.unload.modified.plugins", (Object[])var4_4);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    AnAction[] anActionArray = new AnAction[1];
                    var4_4 = IdeBundle.message((String)"ide.restart.action", (Object[])new Object[0]);
                    anActionArray[0] = new AnAction((String)var4_4){

                        public void actionPerformed(AnActionEvent e) {
                            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                            ApplicationManager.getApplication().restart();
                        }
                    };
                    DynamicPlugins.INSTANCE.notify$intellij_platform_ide_impl(string, NotificationType.INFORMATION, anActionArray);
                } else if (!((Collection)reloaded2).isEmpty()) {
                    var4_4 = new Object[]{CollectionsKt.joinToString$default((Iterable)reloaded2, null, null, null, (int)0, null, null, (int)63, null)};
                    String string = IdeBundle.message((String)"plugins.reloaded.successfully", (Object[])var4_4);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    DynamicPlugins.INSTANCE.notify$intellij_platform_ide_impl(string, NotificationType.INFORMATION, new AnAction[0]);
                }
            }
        };
    }

    private final PluginMainDescriptor findPluginByPath(VirtualFile file2) {
        Object v0;
        block2: {
            if (!VfsUtilCore.isAncestorOrSelf((String)PathManager.getPluginsPath(), (VirtualFile)file2)) {
                return null;
            }
            Iterable $this$firstOrNull$iv = PluginManagerCore.getPluginSet().allPlugins;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PluginMainDescriptor it = (PluginMainDescriptor)element$iv;
                boolean bl = false;
                if (!VfsUtilCore.isAncestorOrSelf((String)((Object)it.getPluginPath().toAbsolutePath()).toString(), (VirtualFile)file2)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }
}

