/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.CommonBundle;
import com.intellij.core.CoreBundle;
import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.BrokenPluginFileKt;
import com.intellij.ide.plugins.CustomPluginRepositoryService;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDependency;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.InstalledPluginsTableModel;
import com.intellij.ide.plugins.PathResolver;
import com.intellij.ide.plugins.PendingDynamicPluginInstall;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginInstallCallbackData;
import com.intellij.ide.plugins.PluginInstallOperation;
import com.intellij.ide.plugins.PluginMainDescriptor;
import com.intellij.ide.plugins.PluginManagementPolicy;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerCoreKt;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNonLoadReason;
import com.intellij.ide.plugins.PluginSet;
import com.intellij.ide.plugins.PluginStateListener;
import com.intellij.ide.plugins.PluginStateManager;
import com.intellij.ide.plugins.PluginXmlPathResolver;
import com.intellij.ide.plugins.marketplace.MarketplacePluginDownloadService;
import com.intellij.ide.plugins.marketplace.PluginSignatureChecker;
import com.intellij.ide.plugins.marketplace.statistics.PluginManagerUsageCollector;
import com.intellij.ide.plugins.marketplace.statistics.enums.InstallationSourceEnum;
import com.intellij.ide.plugins.newui.PluginManagerSession;
import com.intellij.ide.plugins.newui.PluginManagerSessionService;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.Decompressor;
import com.intellij.util.io.zip.JBZipEntry;
import com.intellij.util.io.zip.JBZipFile;
import com.intellij.util.ui.IoErrorText;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginInstaller {
    private static final Logger LOG = Logger.getInstance(PluginInstaller.class);
    private static final boolean DROP_DISABLED_FLAG_OF_REINSTALLED_PLUGINS = SystemProperties.getBooleanProperty((String)"plugins.drop-disabled-flag-of-uninstalled-plugins", (boolean)true);
    public static final String UNKNOWN_HOST_MARKER = "__unknown_repository__";
    static final Object ourLock = new Object();

    private PluginInstaller() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static boolean prepareToUninstall(@NotNull IdeaPluginDescriptorImpl pluginDescriptor) throws IOException {
        if (pluginDescriptor == null) {
            PluginInstaller.$$$reportNull$$$0(0);
        }
        Object object = ourLock;
        synchronized (object) {
            if (PluginManagerCore.isPluginInstalled((PluginId)pluginDescriptor.getPluginId())) {
                boolean needRestart;
                if (pluginDescriptor.isBundled()) {
                    throw new IllegalArgumentException("Plugin is bundled: " + String.valueOf(pluginDescriptor.getPluginId()));
                }
                boolean bl = needRestart = pluginDescriptor.isEnabled() && !DynamicPlugins.allowLoadUnloadWithoutRestart(pluginDescriptor);
                if (needRestart) {
                    PluginInstaller.uninstallAfterRestart((IdeaPluginDescriptor)pluginDescriptor);
                }
                PluginStateManager.fireState((IdeaPluginDescriptor)pluginDescriptor, false);
                return needRestart;
            }
        }
        return false;
    }

    @ApiStatus.Internal
    public static void uninstallAfterRestart(@NotNull IdeaPluginDescriptor pluginDescriptor) throws IOException {
        if (pluginDescriptor == null) {
            PluginInstaller.$$$reportNull$$$0(1);
        }
        if (pluginDescriptor.isBundled()) {
            throw new IllegalArgumentException("Plugin is bundled: " + String.valueOf(pluginDescriptor.getPluginId()));
        }
        LOG.debug("Scheduling uninstallation of plugin " + String.valueOf(pluginDescriptor) + " after restart");
        if (pluginDescriptor.getPluginId().equals((Object)PluginManagerCore.MARKETPLACE_PLUGIN_ID)) {
            StartupActionScriptManager.setMarketplacePluginUpdateActionScript(List.of(new StartupActionScriptManager.DeleteCommand(pluginDescriptor.getPluginPath())));
        } else {
            StartupActionScriptManager.addActionCommandsToBeginning(List.of(new StartupActionScriptManager.DeleteCommand(pluginDescriptor.getPluginPath())));
        }
    }

    @ApiStatus.Internal
    public static boolean unloadDynamicPlugin(@Nullable JComponent parentComponent, @NotNull PluginMainDescriptor pluginDescriptor, boolean isUpdate) {
        if (pluginDescriptor == null) {
            PluginInstaller.$$$reportNull$$$0(2);
        }
        DynamicPlugins.UnloadPluginOptions options2 = new DynamicPlugins.UnloadPluginOptions().withDisable(false).withWaitForClassloaderUnload(true).withUpdate(isUpdate);
        return parentComponent != null ? DynamicPlugins.INSTANCE.unloadPluginWithProgress(null, parentComponent, pluginDescriptor, options2) : DynamicPlugins.INSTANCE.unloadPlugin(pluginDescriptor, options2);
    }

    @ApiStatus.Internal
    public static boolean uninstallDynamicPlugin(@Nullable JComponent parentComponent, @NotNull PluginMainDescriptor pluginDescriptor, boolean isUpdate) {
        boolean uninstalledWithoutRestart;
        if (pluginDescriptor == null) {
            PluginInstaller.$$$reportNull$$$0(3);
        }
        if (pluginDescriptor.isBundled()) {
            throw new IllegalArgumentException("Plugin is bundled: " + String.valueOf(pluginDescriptor.getPluginId()));
        }
        boolean bl = uninstalledWithoutRestart = !pluginDescriptor.isEnabled() || PluginInstaller.unloadDynamicPlugin(parentComponent, pluginDescriptor, isUpdate);
        if (uninstalledWithoutRestart) {
            try {
                LOG.debug("Deleting dynamic plugin from disk: " + String.valueOf(pluginDescriptor.getPluginPath()));
                NioFiles.deleteRecursively((Path)pluginDescriptor.getPluginPath());
            }
            catch (IOException e) {
                LOG.info("Failed to delete jar of dynamic plugin", (Throwable)e);
                uninstalledWithoutRestart = false;
            }
        }
        if (!uninstalledWithoutRestart) {
            try {
                PluginInstaller.uninstallAfterRestart((IdeaPluginDescriptor)pluginDescriptor);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return uninstalledWithoutRestart;
    }

    @ApiStatus.Internal
    public static void installAfterRestartAndKeepIfNecessary(@NotNull IdeaPluginDescriptor newDescriptor, @NotNull Path newPluginPath, @Nullable Path oldPluginPath) throws IOException {
        if (newDescriptor == null) {
            PluginInstaller.$$$reportNull$$$0(4);
        }
        if (newPluginPath == null) {
            PluginInstaller.$$$reportNull$$$0(5);
        }
        PluginInstaller.installAfterRestart(newDescriptor, newPluginPath, oldPluginPath, !PluginInstaller.keepArchive());
    }

    @ApiStatus.Internal
    public static void installAfterRestart(@NotNull IdeaPluginDescriptor descriptor2, @NotNull Path sourceFile, @Nullable Path existingPlugin, boolean deleteSourceFile) throws IOException {
        if (descriptor2 == null) {
            PluginInstaller.$$$reportNull$$$0(6);
        }
        if (sourceFile == null) {
            PluginInstaller.$$$reportNull$$$0(7);
        }
        LOG.debug("Scheduling installation of plugin " + String.valueOf(descriptor2) + " after restart");
        ArrayList<StartupActionScriptManager.ActionCommand> commands = new ArrayList<StartupActionScriptManager.ActionCommand>();
        if (existingPlugin != null) {
            commands.add(new StartupActionScriptManager.DeleteCommand(existingPlugin));
        }
        Path pluginsPath = PluginInstaller.getPluginsPath();
        if (sourceFile.getFileName().toString().endsWith(".jar")) {
            commands.add(new StartupActionScriptManager.CopyCommand(sourceFile, pluginsPath.resolve(sourceFile.getFileName())));
        } else {
            commands.add(new StartupActionScriptManager.DeleteCommand(pluginsPath.resolve(PluginInstaller.rootEntryName(sourceFile))));
            commands.add(new StartupActionScriptManager.UnzipCommand(sourceFile, pluginsPath));
        }
        if (deleteSourceFile) {
            commands.add(new StartupActionScriptManager.DeleteCommand(sourceFile));
        }
        if (descriptor2.getPluginId().equals((Object)PluginManagerCore.MARKETPLACE_PLUGIN_ID)) {
            StartupActionScriptManager.setMarketplacePluginUpdateActionScript(commands);
        } else {
            StartupActionScriptManager.addActionCommands(commands);
        }
        PluginStateManager.fireState(descriptor2, true);
    }

    @Nullable
    private static Path installWithoutRestart(final Path sourceFile, IdeaPluginDescriptorImpl descriptor2, @Nullable JComponent parent) {
        Path result2;
        try {
            Task.WithResult<Path, IOException> task = new Task.WithResult<Path, IOException>(null, parent, IdeBundle.message((String)"progress.title.installing.plugin", (Object[])new Object[]{descriptor2.getName()}), false){

                protected Path compute(@NotNull ProgressIndicator indicator2) throws IOException {
                    if (indicator2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return PluginInstaller.unpackPlugin(sourceFile, PluginInstaller.getPluginsPath());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/plugins/PluginInstaller$1", "compute"));
                }
            };
            result2 = (Path)ProgressManager.getInstance().run((Task.WithResult)task);
        }
        catch (Throwable throwable) {
            LOG.warn("Plugin " + String.valueOf(descriptor2) + " failed to install without restart. " + throwable.getMessage(), throwable);
            result2 = null;
        }
        PluginStateManager.fireState((IdeaPluginDescriptor)descriptor2, true);
        return result2;
    }

    @NotNull
    public static Path unpackPlugin(@NotNull Path sourceFile, @NotNull Path targetPath) throws IOException {
        Path target;
        if (sourceFile == null) {
            PluginInstaller.$$$reportNull$$$0(8);
        }
        if (targetPath == null) {
            PluginInstaller.$$$reportNull$$$0(9);
        }
        LOG.debug("Unpacking " + String.valueOf(sourceFile) + " to " + String.valueOf(targetPath));
        if (sourceFile.getFileName().toString().endsWith(".jar")) {
            target = targetPath.resolve(sourceFile.getFileName().toString());
            NioFiles.createDirectories((Path)targetPath);
            Files.copy(sourceFile, target, StandardCopyOption.REPLACE_EXISTING);
        } else {
            target = targetPath.resolve(PluginInstaller.rootEntryName(sourceFile));
            NioFiles.deleteRecursively((Path)target);
            new Decompressor.Zip(sourceFile).withZipExtensions().extract(targetPath);
        }
        Path path = target;
        if (path == null) {
            PluginInstaller.$$$reportNull$$$0(10);
        }
        return path;
    }

    public static String rootEntryName(@NotNull Path zip) throws IOException {
        if (zip == null) {
            PluginInstaller.$$$reportNull$$$0(11);
        }
        try (JBZipFile zipFile = new JBZipFile(zip);){
            for (JBZipEntry zipEntry : zipFile.getEntries()) {
                String name2 = zipEntry.getName();
                int i2 = name2.indexOf(47);
                if (i2 <= 0) continue;
                String string = name2.substring(0, i2);
                return string;
            }
        }
        throw new IOException("Corrupted archive (no file entries): " + String.valueOf(zip));
    }

    public static void addStateListener(@NotNull PluginStateListener listener2) {
        if (listener2 == null) {
            PluginInstaller.$$$reportNull$$$0(12);
        }
        PluginStateManager.addStateListener(listener2);
    }

    @RequiresEdt
    static void installFromDisk(@NotNull InstalledPluginsTableModel model2, final @NotNull PluginEnabler pluginEnabler, @NotNull Path file2, @Nullable Project project2, @Nullable JComponent parent, @NotNull Consumer<? super PluginInstallCallbackData> callback) {
        if (model2 == null) {
            PluginInstaller.$$$reportNull$$$0(13);
        }
        if (pluginEnabler == null) {
            PluginInstaller.$$$reportNull$$$0(14);
        }
        if (file2 == null) {
            PluginInstaller.$$$reportNull$$$0(15);
        }
        if (callback == null) {
            PluginInstaller.$$$reportNull$$$0(16);
        }
        ThreadingAssertions.assertEventDispatchThread();
        try {
            Object session;
            final PluginMainDescriptor pluginDescriptor = (PluginMainDescriptor)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> PluginDescriptorLoader.loadDescriptorFromArtifact((Path)file2, null), IdeBundle.message((String)"action.InstallFromDiskAction.progress.text", (Object[])new Object[0]), true, project2);
            if (pluginDescriptor == null) {
                MessagesEx.showErrorDialog(parent, IdeBundle.message((String)"dialog.message.fail.to.load.plugin.descriptor.from.file", (Object[])new Object[]{file2.getFileName()}), CommonBundle.getErrorTitle());
                return;
            }
            if (!PluginManagerMain.checkThirdPartyPluginsAllowed(List.of(pluginDescriptor))) {
                return;
            }
            if (!PluginManagementPolicy.getInstance().canInstallPlugin((IdeaPluginDescriptor)pluginDescriptor)) {
                String message = IdeBundle.message((String)"dialog.message.plugin.is.not.allowed", (Object[])new Object[]{pluginDescriptor.getName()});
                MessagesEx.showWarningDialog(parent, message, IdeBundle.message((String)"dialog.title.install.plugin", (Object[])new Object[0]));
                return;
            }
            InstalledPluginsState ourState = InstalledPluginsState.getInstance();
            if (ourState.wasInstalled(pluginDescriptor.getPluginId())) {
                String message = IdeBundle.message((String)"dialog.message.plugin.was.already.installed", (Object[])new Object[]{pluginDescriptor.getName()});
                MessagesEx.showWarningDialog(parent, message, IdeBundle.message((String)"dialog.title.install.plugin", (Object[])new Object[0]));
                return;
            }
            PluginNonLoadReason error = PluginManagerCore.checkBuildNumberCompatibility((IdeaPluginDescriptor)pluginDescriptor, (BuildNumber)PluginManagerCore.getBuildNumber());
            if (error != null) {
                MessagesEx.showErrorDialog(parent, error.getDetailedMessage(), CommonBundle.getErrorTitle());
                return;
            }
            if (BrokenPluginFileKt.isBrokenPlugin((IdeaPluginDescriptor)pluginDescriptor)) {
                String message = CoreBundle.message((String)"plugin.loading.error.long.marked.as.broken", (Object[])new Object[]{pluginDescriptor.getName(), pluginDescriptor.getVersion()});
                MessagesEx.showErrorDialog(parent, message, CommonBundle.getErrorTitle());
                return;
            }
            IdeaPluginDescriptor installedPlugin = PluginManagerCore.getPlugin((PluginId)pluginDescriptor.getPluginId());
            if (installedPlugin != null && ApplicationInfoEx.getInstanceEx().isEssentialPlugin(installedPlugin.getPluginId())) {
                String message = IdeBundle.message((String)"dialog.message.plugin.core.part", (Object[])new Object[]{pluginDescriptor.getName(), ApplicationNamesInfo.getInstance().getFullProductName()});
                MessagesEx.showErrorDialog(parent, message, CommonBundle.getErrorTitle());
                return;
            }
            String previousVersion = installedPlugin != null ? installedPlugin.getVersion() : null;
            PluginManagerUsageCollector.pluginInstallationStarted((IdeaPluginDescriptor)pluginDescriptor, InstallationSourceEnum.FROM_DISK, previousVersion);
            if (!PluginSignatureChecker.verifyIfRequired((IdeaPluginDescriptor)pluginDescriptor, file2, false, true)) {
                return;
            }
            Task.WithResult<Pair<PluginInstallOperation, ? extends IdeaPluginDescriptor>, RuntimeException> task = new Task.WithResult<Pair<PluginInstallOperation, ? extends IdeaPluginDescriptor>, RuntimeException>(null, parent, IdeBundle.message((String)"progress.title.checking.plugin.dependencies", (Object[])new Object[0]), true){

                @NotNull
                protected Pair<PluginInstallOperation, ? extends IdeaPluginDescriptor> compute(@NotNull ProgressIndicator indicator2) {
                    if (indicator2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    Collection<PluginUiModel> repositoryPlugins = CustomPluginRepositoryService.getInstance().getCustomRepositoryPlugins();
                    PluginInstallOperation operation2 = new PluginInstallOperation(List.of(), repositoryPlugins, indicator2, pluginEnabler);
                    operation2.setAllowInstallWithoutRestart(true);
                    Pair pair = operation2.checkMissingDependencies((IdeaPluginDescriptor)pluginDescriptor, null) ? new Pair((Object)operation2, (Object)operation2.checkDependenciesAndReplacements((IdeaPluginDescriptor)pluginDescriptor)) : Pair.empty();
                    if (pair == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return pair;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "indicator";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ide/plugins/PluginInstaller$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ide/plugins/PluginInstaller$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "compute";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "compute";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            };
            Pair pair = (Pair)ProgressManager.getInstance().run((Task.WithResult)task);
            PluginInstallOperation operation2 = (PluginInstallOperation)pair.getFirst();
            if (operation2 == null) {
                return;
            }
            Path oldFile = installedPlugin != null && !installedPlugin.isBundled() ? installedPlugin.getPluginPath() : null;
            boolean isRestartRequired = oldFile != null || !DynamicPlugins.allowLoadUnloadWithoutRestart((IdeaPluginDescriptorImpl)pluginDescriptor) || operation2.isRestartRequired();
            for (PendingDynamicPluginInstall dynamicPluginInstall : operation2.getPendingDynamicPluginInstalls()) {
                boolean installed = PluginInstaller.installAndLoadDynamicPlugin(dynamicPluginInstall.getFile(), parent, dynamicPluginInstall.getPluginDescriptor());
                if (installed) continue;
                isRestartRequired = true;
            }
            if (isRestartRequired) {
                PluginInstaller.installAfterRestart((IdeaPluginDescriptor)pluginDescriptor, file2, oldFile, false);
            }
            ourState.onPluginInstall((IdeaPluginDescriptor)pluginDescriptor, installedPlugin != null, isRestartRequired);
            IdeaPluginDescriptor toDisable = (IdeaPluginDescriptor)pair.getSecond();
            if (toDisable != null) {
                pluginEnabler.disable(Set.of(toDisable));
            }
            Set<PluginInstallCallbackData> installedDependencies = operation2.getInstalledDependentPlugins();
            ArrayList<Object> installedPlugins = new ArrayList<Object>();
            installedPlugins.add(pluginDescriptor);
            for (PluginInstallCallbackData plugin : installedDependencies) {
                installedPlugins.add(plugin.getPluginDescriptor());
            }
            Set installedDependencyIds = ContainerUtil.map2Set(installedPlugins, PluginDescriptor::getPluginId);
            Set<String> notInstalled = PluginInstaller.findNotInstalledPluginDependencies(pluginDescriptor.getDependencies(), model2, installedDependencyIds);
            if (!notInstalled.isEmpty()) {
                String message = IdeBundle.message((String)"dialog.message.plugin.depends.on.unknown.plugin", (Object[])new Object[]{pluginDescriptor.getName(), notInstalled.size(), StringUtil.join(notInstalled, (String)", ")});
                MessagesEx.showWarningDialog(parent, message, IdeBundle.message((String)"dialog.title.install.plugin", (Object[])new Object[0]));
            }
            PluginManagerMain.suggestToEnableInstalledDependantPlugins(pluginEnabler, installedPlugins);
            if (!isRestartRequired && (session = PluginManagerSessionService.getInstance().getSession(model2.mySessionId.toString())) != null) {
                ((PluginManagerSession)session).getDynamicPluginsToInstall().put(pluginDescriptor.getPluginId(), new PendingDynamicPluginInstall(file2, (IdeaPluginDescriptorImpl)pluginDescriptor));
            }
            callback.accept(new PluginInstallCallbackData(file2, (IdeaPluginDescriptor)pluginDescriptor, isRestartRequired));
            for (PluginInstallCallbackData callbackData : installedDependencies) {
                if (callbackData.getPluginDescriptor().getPluginId().equals((Object)pluginDescriptor.getPluginId())) continue;
                callback.accept(callbackData);
            }
            if (file2.toString().endsWith(".zip") && PluginInstaller.keepArchive()) {
                Path tempFile = MarketplacePluginDownloadService.getPluginTempFile();
                Files.copy(file2, tempFile, StandardCopyOption.REPLACE_EXISTING);
                MarketplacePluginDownloadService.renameFileToZipRoot(tempFile);
            }
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex);
            MessagesEx.showErrorDialog(parent, IoErrorText.message((Throwable)ex), CommonBundle.getErrorTitle());
        }
    }

    public static boolean installAndLoadDynamicPlugin(@NotNull Path file2, @NotNull IdeaPluginDescriptorImpl descriptor2) {
        if (file2 == null) {
            PluginInstaller.$$$reportNull$$$0(17);
        }
        if (descriptor2 == null) {
            PluginInstaller.$$$reportNull$$$0(18);
        }
        return PluginInstaller.installAndLoadDynamicPlugin(file2, null, descriptor2);
    }

    public static boolean installAndLoadDynamicPlugin(@NotNull Path file2, @Nullable JComponent parent, @NotNull IdeaPluginDescriptorImpl descriptor2) {
        boolean wasInstalledBefore;
        Path targetFile;
        if (file2 == null) {
            PluginInstaller.$$$reportNull$$$0(19);
        }
        if (descriptor2 == null) {
            PluginInstaller.$$$reportNull$$$0(20);
        }
        if ((targetFile = PluginInstaller.installWithoutRestart(file2, descriptor2, parent)) == null) {
            return false;
        }
        PluginMainDescriptor targetDescriptor = PluginDescriptorLoader.loadDescriptor((Path)targetFile, (boolean)false, (PathResolver)PluginXmlPathResolver.DEFAULT_PATH_RESOLVER);
        if (targetDescriptor == null) {
            return false;
        }
        PluginId targetPluginId = targetDescriptor.getPluginId();
        IdeaPluginDescriptorImpl loadedPlugin = PluginManagerCore.findPlugin((PluginId)targetPluginId);
        if (loadedPlugin != null && PluginManagerCore.isLoaded((PluginDescriptor)loadedPlugin)) {
            LOG.warn("Plugin " + String.valueOf(loadedPlugin) + " is still loaded, restart is required");
            return false;
        }
        PluginSet pluginSet = PluginManagerCore.getPluginSet();
        Map contentModuleIdMap = pluginSet.buildContentModuleIdMap();
        Map pluginMap = pluginSet.buildPluginIdMap();
        if (PluginManagerCoreKt.pluginRequiresUltimatePluginButItsDisabled((IdeaPluginDescriptorImpl)targetDescriptor, (Map)pluginMap, (Map)contentModuleIdMap)) {
            LOG.warn("Plugin " + String.valueOf(targetPluginId) + " requires Ultimate plugin, but it's disabled");
            return false;
        }
        if (DROP_DISABLED_FLAG_OF_REINSTALLED_PLUGINS && PluginEnabler.HEADLESS.isDisabled(targetPluginId) && !(wasInstalledBefore = pluginSet.isPluginInstalled(targetPluginId))) {
            targetDescriptor.setMarkedForLoading(true);
            boolean result2 = DynamicPlugins.INSTANCE.loadPlugin(targetDescriptor);
            PluginEnabler.HEADLESS.enable(Set.of(targetDescriptor));
            return result2;
        }
        return PluginEnabler.HEADLESS.isDisabled(targetPluginId) || DynamicPlugins.INSTANCE.loadPlugin(targetDescriptor);
    }

    private static boolean keepArchive() {
        return !LoadingState.COMPONENTS_LOADED.isOccurred() || RegistryManager.getInstance().is("ide.plugins.keep.archive");
    }

    private static Set<String> findNotInstalledPluginDependencies(List<? extends IdeaPluginDependency> dependencies, InstalledPluginsTableModel model2, Set<PluginId> installedDependencies) {
        HashSet<String> notInstalled = new HashSet<String>();
        for (IdeaPluginDependency ideaPluginDependency : dependencies) {
            PluginId pluginId;
            if (ideaPluginDependency.isOptional() || installedDependencies.contains(pluginId = ideaPluginDependency.getPluginId()) || model2.isLoaded(pluginId) || PluginManagerCore.looksLikePlatformPluginAlias((PluginId)pluginId) || PluginManagerCore.findPluginByPlatformAlias((PluginId)pluginId) != null) continue;
            notInstalled.add(pluginId.getIdString());
        }
        return notInstalled;
    }

    private static Path getPluginsPath() {
        return Path.of(PathManager.getPluginsPath(), new String[0]);
    }

    @RequiresEdt
    static void installPluginFromCallbackData(@NotNull PluginInstallCallbackData callbackData) {
        if (callbackData == null) {
            PluginInstaller.$$$reportNull$$$0(21);
        }
        ThreadingAssertions.assertEventDispatchThread();
        IdeaPluginDescriptor ideaPluginDescriptor = callbackData.getPluginDescriptor();
        if (ideaPluginDescriptor instanceof IdeaPluginDescriptorImpl) {
            IdeaPluginDescriptorImpl descriptor2 = (IdeaPluginDescriptorImpl)ideaPluginDescriptor;
            if (callbackData.getFile() != null) {
                if (callbackData.getRestartNeeded()) {
                    PluginInstaller.shutdownOrRestartAppAfterInstall(descriptor2);
                } else {
                    boolean loaded = PluginInstaller.installAndLoadDynamicPlugin(callbackData.getFile(), descriptor2);
                    if (!loaded) {
                        PluginInstaller.shutdownOrRestartAppAfterInstall(descriptor2);
                    }
                }
            }
        }
    }

    private static void shutdownOrRestartAppAfterInstall(IdeaPluginDescriptorImpl descriptor2) {
        PluginManagerConfigurable.shutdownOrRestartAppAfterInstall(PluginManagerConfigurable.getUpdatesDialogTitle(), action2 -> IdeBundle.message((String)"plugin.installed.ide.restart.required.message", (Object[])new Object[]{descriptor2.getName(), action2, ApplicationNamesInfo.getInstance().getFullProductName()}));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDescriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPluginPath";
                break;
            }
            case 6: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginInstaller";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zip";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginEnabler";
                break;
            }
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callbackData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginInstaller";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "unpackPlugin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "prepareToUninstall";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "uninstallAfterRestart";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "unloadDynamicPlugin";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "uninstallDynamicPlugin";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "installAfterRestartAndKeepIfNecessary";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "installAfterRestart";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "unpackPlugin";
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "rootEntryName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addStateListener";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "installFromDisk";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "installAndLoadDynamicPlugin";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "installPluginFromCallbackData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10 -> new IllegalStateException(string);
        };
    }
}

