/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.plugins.CountComponent;
import com.intellij.ide.plugins.CountIcon;
import com.intellij.ide.plugins.CreateInstalledPanelModel;
import com.intellij.ide.plugins.CreateMarketplacePanelModel;
import com.intellij.ide.plugins.CustomPluginRepositoryService;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstallFromDiskAction;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.ListPluginModel;
import com.intellij.ide.plugins.MultiPanel;
import com.intellij.ide.plugins.PluginHostsConfigurable;
import com.intellij.ide.plugins.PluginInstallCallbackData;
import com.intellij.ide.plugins.PluginManagementPolicy;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCoroutineScopeHolder;
import com.intellij.ide.plugins.PluginManagerPanelFactory;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.plugins.certificates.PluginCertificateManager;
import com.intellij.ide.plugins.enums.PluginsGroupType;
import com.intellij.ide.plugins.enums.SortBy;
import com.intellij.ide.plugins.marketplace.CheckErrorsResult;
import com.intellij.ide.plugins.marketplace.PluginSearchResult;
import com.intellij.ide.plugins.marketplace.ranking.MarketplaceLocalRanker;
import com.intellij.ide.plugins.marketplace.statistics.PluginManagerUsageCollector;
import com.intellij.ide.plugins.newui.LinkComponent;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ide.plugins.newui.MultiSelectionEventHandler;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.NoOpPluginsViewCustomizer;
import com.intellij.ide.plugins.newui.PluginDetailsPageComponent;
import com.intellij.ide.plugins.newui.PluginInstallationState;
import com.intellij.ide.plugins.newui.PluginLogo;
import com.intellij.ide.plugins.newui.PluginManagerCustomizer;
import com.intellij.ide.plugins.newui.PluginModelAsyncOperationsExecutor;
import com.intellij.ide.plugins.newui.PluginModelFacade;
import com.intellij.ide.plugins.newui.PluginPriceService;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.ide.plugins.newui.PluginUiModelAdapter;
import com.intellij.ide.plugins.newui.PluginUiModelKt;
import com.intellij.ide.plugins.newui.PluginUpdatesService;
import com.intellij.ide.plugins.newui.PluginsGroup;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.ide.plugins.newui.PluginsGroupComponentWithProgress;
import com.intellij.ide.plugins.newui.PluginsTab;
import com.intellij.ide.plugins.newui.PluginsViewCustomizer;
import com.intellij.ide.plugins.newui.PluginsViewCustomizerKt;
import com.intellij.ide.plugins.newui.SearchPopup;
import com.intellij.ide.plugins.newui.SearchQueryParser;
import com.intellij.ide.plugins.newui.SearchResultPanel;
import com.intellij.ide.plugins.newui.SearchUpDownPopupController;
import com.intellij.ide.plugins.newui.SearchWords;
import com.intellij.ide.plugins.newui.TabbedPaneHeaderComponent;
import com.intellij.ide.plugins.newui.UIPluginGroup;
import com.intellij.ide.plugins.newui.UiPluginManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.AppMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CheckedActionGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeepPopupOnPerform;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.updateSettings.impl.PluginAutoUpdateListener;
import com.intellij.openapi.updateSettings.impl.UpdateOptions;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.FUSEventSource;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiserStartupActivityKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WelcomeScreen;
import com.intellij.openapi.wm.impl.welcomeScreen.PluginsTabFactory;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenEventCollector;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.GotItTooltip;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.popup.ActionPopupOptions;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.CoroutineScopeKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.TextTransferable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NonNull;

@ApiStatus.Internal
public final class PluginManagerConfigurablePanel
implements Disposable {
    private static final Logger LOG = Logger.getInstance(PluginManagerConfigurablePanel.class);
    private static final int MARKETPLACE_TAB = 0;
    private static final int INSTALLED_TAB = 1;
    public static final int ITEMS_PER_GROUP = 9;
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MMM dd, yyyy");
    private TabbedPaneHeaderComponent myTabHeaderComponent;
    private MultiPanel myCardPanel;
    private PluginsTab myMarketplaceTab;
    private PluginsTab myInstalledTab;
    private PluginsGroupComponentWithProgress myMarketplacePanel;
    private PluginsGroupComponentWithProgress myInstalledPanel;
    private final PluginsGroup myBundledUpdateGroup = new PluginsGroup(IdeBundle.message((String)"plugins.configurable.bundled.updates", (Object[])new Object[0]), PluginsGroupType.BUNDLED_UPDATE);
    private Runnable myMarketplaceRunnable;
    private SearchResultPanel myMarketplaceSearchPanel;
    private SearchResultPanel myInstalledSearchPanel;
    private final LinkLabel<Object> myUpdateAll = new LinkLabelButton<Object>(IdeBundle.message((String)"plugin.manager.update.all", (Object[])new Object[0]), null);
    private final LinkLabel<Object> myUpdateAllBundled = new LinkLabelButton<Object>(IdeBundle.message((String)"plugin.manager.update.all", (Object[])new Object[0]), null);
    private final JLabel myUpdateCounter = new CountComponent();
    private final JLabel myUpdateCounterBundled = new CountComponent();
    private final CountIcon myCountIcon = new CountIcon();
    private final CoroutineScope myCoroutineScope;
    private final PluginModelFacade myPluginModelFacade = new PluginModelFacade(new MyPluginModel(null));
    private PluginUpdatesService myPluginUpdatesService;
    private PluginManagerCustomizer myPluginManagerCustomizer = PluginManagerCustomizer.getInstance();
    private List<String> myTagsSorted;
    private List<String> myVendorsSorted;
    private DefaultActionGroup myMarketplaceSortByGroup;
    private Consumer<MarketplaceSortByAction> myMarketplaceSortByCallback;
    private LinkComponent myMarketplaceSortByAction;
    private DefaultActionGroup myInstalledSearchGroup;
    private Consumer<InstalledSearchOptionAction> myInstalledSearchCallback;
    private boolean myInstalledSearchSetState = true;
    private String myLaterSearchQuery;
    private boolean myForceShowInstalledTabForTag = false;
    private boolean myShowMarketplaceTab;
    private Boolean myPluginsAutoUpdateEnabled;
    private volatile Boolean myDisposeStarted = false;

    public PluginManagerConfigurablePanel() {
        CoroutineScope parentScope = ((PluginManagerCoroutineScopeHolder)ApplicationManager.getApplication().getService(PluginManagerCoroutineScopeHolder.class)).getCoroutineScope();
        CoroutineScope childScope = com.intellij.platform.util.coroutines.CoroutineScopeKt.childScope((CoroutineScope)parentScope, (String)this.getClass().getName(), (CoroutineContext)Dispatchers.getIO(), (boolean)true);
        this.myPluginModelFacade.getModel().setCoroutineScope(childScope);
        this.myCoroutineScope = childScope;
    }

    @NotNull
    public JComponent getCenterComponent(@NotNull Configurable.TopComponentController controller) {
        if (controller == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(0);
        }
        this.myPluginModelFacade.getModel().setTopController(controller);
        TabbedPaneHeaderComponent tabbedPaneHeaderComponent = this.myTabHeaderComponent;
        if (tabbedPaneHeaderComponent == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(1);
        }
        return tabbedPaneHeaderComponent;
    }

    @NotNull
    public JComponent getTopComponent() {
        JComponent jComponent = this.getCenterComponent(Configurable.TopComponentController.EMPTY);
        if (jComponent == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    public void init(@Nullable String searchQuery) {
        this.myTabHeaderComponent = new TabbedPaneHeaderComponent(this.createGearActions(), index -> {
            this.myCardPanel.select(index, true);
            PluginManagerConfigurablePanel.storeSelectionTab(index);
            String query = (index == 0 ? this.myInstalledTab : this.myMarketplaceTab).getSearchQuery();
            (index == 0 ? this.myMarketplaceTab : this.myInstalledTab).setSearchQuery(query);
        }){

            @Override
            public void uiDataSnapshot(@NotNull DataSink sink) {
                if (sink == null) {
                    1.$$$reportNull$$$0(0);
                }
                sink.set(PluginManagerConfigurable.PLUGIN_INSTALL_CALLBACK_DATA_KEY, PluginManagerConfigurablePanel.this::onPluginInstalledFromDisk);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/ide/plugins/PluginManagerConfigurablePanel$1", "uiDataSnapshot"));
            }
        };
        this.createGearGotIt();
        this.myLaterSearchQuery = searchQuery;
        this.myUpdateAll.setVisible(false);
        this.myUpdateAllBundled.setVisible(false);
        this.myUpdateCounter.setVisible(false);
        this.myUpdateCounterBundled.setVisible(false);
        this.myTabHeaderComponent.addTab(IdeBundle.message((String)"plugin.manager.tab.marketplace", (Object[])new Object[0]), null);
        this.myTabHeaderComponent.addTab(IdeBundle.message((String)"plugin.manager.tab.installed", (Object[])new Object[0]), this.myCountIcon);
        CustomPluginRepositoryService.getInstance().clearCache();
        this.myPluginUpdatesService = UiPluginManager.getInstance().subscribeToUpdatesCount(this.myPluginModelFacade.getModel().getSessionId(), (Function1<? super Integer, Unit>)((Function1)countValue -> {
            ApplicationManager.getApplication().invokeLater(() -> this.onUpdateCountReceived((Integer)countValue));
            return null;
        }));
        this.myPluginModelFacade.getModel().setPluginUpdatesService(this.myPluginUpdatesService);
        UiPluginManager.getInstance().updateDescriptorsForInstalledPlugins();
        this.createMarketplaceTab();
        this.createInstalledTab();
        PluginManagerUsageCollector.sessionStarted();
        this.myCardPanel = new MultiPanel(){

            @Override
            protected JComponent create(Integer key) {
                if (key == 0) {
                    return PluginManagerConfigurablePanel.this.myMarketplaceTab.createPanel();
                }
                if (key == 1) {
                    return PluginManagerConfigurablePanel.this.myInstalledTab.createPanel();
                }
                return super.create(key);
            }
        };
        this.myCardPanel.setMinimumSize((Dimension)new JBDimension(580, 380));
        this.myCardPanel.setPreferredSize((Dimension)new JBDimension(800, 600));
        this.myTabHeaderComponent.setListener();
        int selectionTab = PluginManagerConfigurablePanel.getStoredSelectionTab();
        this.myTabHeaderComponent.setSelection(selectionTab);
        this.myCardPanel.select(selectionTab, true);
        if (this.myLaterSearchQuery != null) {
            Runnable search = this.enableSearch(this.myLaterSearchQuery, this.myForceShowInstalledTabForTag);
            if (search != null) {
                ApplicationManager.getApplication().invokeLater(search, ModalityState.any());
            }
            this.myLaterSearchQuery = null;
            this.myForceShowInstalledTabForTag = false;
        }
        if (this.myPluginManagerCustomizer != null) {
            this.myPluginManagerCustomizer.initCustomizer(this.myCardPanel);
        }
    }

    public JComponent getComponent() {
        return this.myCardPanel;
    }

    public boolean isMarketplaceTabShowing() {
        return this.myTabHeaderComponent.getSelectionTab() == 0;
    }

    public boolean isInstalledTabShowing() {
        return this.myTabHeaderComponent.getSelectionTab() == 1;
    }

    @NotNull
    private DefaultActionGroup createGearActions() {
        DefaultActionGroup actions = new DefaultActionGroup();
        if (PluginManagementPolicy.getInstance().isPluginAutoUpdateAllowed()) {
            final UpdateOptions state2 = UpdateSettings.getInstance().getState();
            this.myPluginsAutoUpdateEnabled = state2.isPluginsAutoUpdateEnabled();
            MessageBusConnection connect = ApplicationManager.getApplication().getMessageBus().connect(CoroutineScopeKt.asDisposable((CoroutineScope)this.myCoroutineScope));
            connect.subscribe(PluginAutoUpdateListener.Companion.getTOPIC(), (Object)new PluginAutoUpdateListener(){

                @Override
                public void settingsChanged() {
                    PluginManagerConfigurablePanel.this.myPluginsAutoUpdateEnabled = state2.isPluginsAutoUpdateEnabled();
                }
            });
            actions.add((AnAction)new DumbAwareToggleAction(IdeBundle.message((String)"updates.plugins.autoupdate.settings.action", (Object[])new Object[0])){

                public boolean isSelected(@NotNull AnActionEvent e) {
                    if (e == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return PluginManagerConfigurablePanel.this.myPluginsAutoUpdateEnabled;
                }

                public void setSelected(@NotNull AnActionEvent e, boolean state2) {
                    if (e == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    PluginManagerConfigurablePanel.this.myPluginsAutoUpdateEnabled = state2;
                }

                @NotNull
                public ActionUpdateThread getActionUpdateThread() {
                    ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                    if (actionUpdateThread == null) {
                        4.$$$reportNull$$$0(2);
                    }
                    return actionUpdateThread;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 2 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "e";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurablePanel$4";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurablePanel$4";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getActionUpdateThread";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "isSelected";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "setSelected";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 2 -> new IllegalStateException(string);
                    };
                }
            });
            actions.addSeparator();
        }
        actions.add((AnAction)new DumbAwareAction(IdeBundle.message((String)"plugin.manager.repositories", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (ShowSettingsUtil.getInstance().editConfigurable((Component)PluginManagerConfigurablePanel.this.myCardPanel, (Configurable)new PluginHostsConfigurable())) {
                    PluginManagerCustomizer customizer;
                    if (PluginManagerConfigurablePanel.this.myPluginManagerCustomizer == null) {
                        PluginManagerConfigurablePanel.this.resetPanels();
                    }
                    if ((customizer = PluginManagerCustomizer.getInstance()) != null) {
                        customizer.updateCustomRepositories(UpdateSettings.getInstance().getStoredPluginHosts(), (Function0<Unit>)((Function0)() -> {
                            PluginManagerConfigurablePanel.this.resetPanels();
                            return null;
                        }));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/PluginManagerConfigurablePanel$5", "actionPerformed"));
            }
        });
        actions.add((AnAction)new DumbAwareAction(IdeBundle.message((String)"button.http.proxy.settings", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (HttpConfigurable.editConfigurable((JComponent)PluginManagerConfigurablePanel.this.myCardPanel)) {
                    PluginManagerConfigurablePanel.this.resetPanels();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/PluginManagerConfigurablePanel$6", "actionPerformed"));
            }
        });
        actions.addSeparator();
        actions.add((AnAction)new DumbAwareAction(IdeBundle.message((String)"plugin.manager.custom.certificates", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (ShowSettingsUtil.getInstance().editConfigurable((Component)PluginManagerConfigurablePanel.this.myCardPanel, (Configurable)new PluginCertificateManager())) {
                    PluginManagerConfigurablePanel.this.resetPanels();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/PluginManagerConfigurablePanel$7", "actionPerformed"));
            }
        });
        actions.add((AnAction)new InstallFromDiskAction(this.myPluginModelFacade.getModel(), this.myPluginModelFacade.getModel(), this.myCardPanel){

            @Override
            @RequiresEdt
            protected void onPluginInstalledFromDisk(@NotNull PluginInstallCallbackData callbackData, @Nullable Project project2) {
                if (callbackData == null) {
                    8.$$$reportNull$$$0(0);
                }
                ThreadingAssertions.assertEventDispatchThread();
                if (PluginManagerConfigurablePanel.this.myPluginManagerCustomizer != null) {
                    PluginManagerConfigurablePanel.this.myPluginManagerCustomizer.updateAfterModification((Function0<Unit>)((Function0)() -> {
                        PluginManagerConfigurablePanel.this.onPluginInstalledFromDisk(callbackData);
                        return null;
                    }));
                    return;
                }
                PluginManagerConfigurablePanel.this.onPluginInstalledFromDisk(callbackData);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callbackData", "com/intellij/ide/plugins/PluginManagerConfigurablePanel$8", "onPluginInstalledFromDisk"));
            }
        });
        if (this.myPluginManagerCustomizer != null) {
            actions.addAll(this.myPluginManagerCustomizer.getExtraPluginsActions());
        }
        actions.addSeparator();
        actions.add((AnAction)new ChangePluginStateAction(false));
        actions.add((AnAction)new ChangePluginStateAction(true));
        if (ApplicationManager.getApplication().isInternal()) {
            actions.addSeparator();
            actions.add((AnAction)new DumbAwareAction(IdeBundle.message((String)"plugin.manager.refresh", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        9.$$$reportNull$$$0(0);
                    }
                    PluginManagerConfigurablePanel.this.resetPanels();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/PluginManagerConfigurablePanel$9", "actionPerformed"));
                }
            });
        }
        DefaultActionGroup defaultActionGroup = actions;
        if (defaultActionGroup == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(3);
        }
        return defaultActionGroup;
    }

    private void createGearGotIt() {
        if (!PluginManagementPolicy.getInstance().isPluginAutoUpdateAllowed() || UpdateSettings.getInstance().getState().isPluginsAutoUpdateEnabled() || AppMode.isRemoteDevHost()) {
            return;
        }
        String title2 = IdeBundle.message((String)"plugin.manager.plugins.auto.update.title", (Object[])new Object[0]);
        GotItTooltip tooltip = new GotItTooltip(title2, IdeBundle.message((String)"plugin.manager.plugins.auto.update.description", (Object[])new Object[0]), (Disposable)this);
        tooltip.withHeader(title2);
        tooltip.show((JComponent)this.myTabHeaderComponent.getComponent(1), (Function2<? super Component, ? super Balloon, ? extends Point>)((Function2)(component2, balloon) -> new Point(component2.getWidth() / 2, ((JComponent)component2).getVisibleRect().height)));
    }

    private static void showRightBottomPopup(final @NotNull Component component2, @NotNull @Nls String title2, @NotNull ActionGroup group2) {
        if (component2 == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(4);
        }
        if (title2 == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(5);
        }
        if (group2 == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(6);
        }
        GroupByActionGroup actions = new GroupByActionGroup();
        actions.addSeparator("  " + title2);
        actions.addAll(group2);
        DataContext context = DataManager.getInstance().getDataContext(component2);
        final PopupFactoryImpl.ActionGroupPopup popup2 = new PopupFactoryImpl.ActionGroupPopup(null, null, (ActionGroup)actions, context, "popup", new PresentationFactory(), ActionPopupOptions.honorMnemonics(), null){};
        popup2.addListener(new JBPopupListener(){

            public void beforeShown(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    11.$$$reportNull$$$0(0);
                }
                Point location = component2.getLocationOnScreen();
                Dimension size2 = popup2.getSize();
                popup2.setLocation(new Point(location.x + component2.getWidth() - size2.width, location.y + component2.getHeight()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/plugins/PluginManagerConfigurablePanel$11", "beforeShown"));
            }
        });
        popup2.show(component2);
    }

    private void resetPanels() {
        CustomPluginRepositoryService.getInstance().clearCache();
        this.myTagsSorted = null;
        this.myVendorsSorted = null;
        this.myPluginUpdatesService.recalculateUpdates();
        if (this.myMarketplacePanel == null) {
            return;
        }
        int selectionTab = this.myTabHeaderComponent.getSelectionTab();
        if (selectionTab == 0) {
            this.myMarketplaceRunnable.run();
        } else {
            this.myMarketplacePanel.setVisibleRunnable(this.myMarketplaceRunnable);
        }
    }

    private void onUpdateCountReceived(Integer countValue) {
        int count = countValue == null ? 0 : countValue;
        String text2 = Integer.toString(count);
        boolean visible = count > 0;
        String tooltip = PluginUpdatesService.getUpdatesTooltip();
        this.myTabHeaderComponent.setTabTooltip(1, tooltip);
        this.myUpdateAll.setEnabled(true);
        this.myUpdateAllBundled.setEnabled(true);
        this.myUpdateAll.setVisible(visible && this.myBundledUpdateGroup.ui == null);
        this.myUpdateAllBundled.setVisible(visible);
        this.myUpdateCounter.setText(text2);
        this.myUpdateCounter.setToolTipText(tooltip);
        this.myUpdateCounterBundled.setText(text2);
        this.myUpdateCounterBundled.setToolTipText(tooltip);
        this.myUpdateCounter.setVisible(visible && this.myBundledUpdateGroup.ui == null);
        this.myUpdateCounterBundled.setVisible(visible);
        this.myCountIcon.setText(text2);
        this.myTabHeaderComponent.update();
    }

    private static int getStoredSelectionTab() {
        int value = PropertiesComponent.getInstance().getInt("PluginConfigurable.selectionTab", 0);
        return value < 0 || value > 1 ? 0 : value;
    }

    private static void storeSelectionTab(int value) {
        PropertiesComponent.getInstance().setValue("PluginConfigurable.selectionTab", value, 0);
    }

    private void createMarketplaceTab() {
        this.myMarketplaceTab = new PluginsTab(){

            @Override
            protected void createSearchTextField(int flyDelay) {
                super.createSearchTextField(250);
                this.searchTextField.setHistoryPropertyName("MarketplacePluginsSearchHistory");
            }

            @Override
            @NotNull
            protected PluginDetailsPageComponent createDetailsPanel(@NotNull LinkListener<Object> searchListener) {
                if (searchListener == null) {
                    12.$$$reportNull$$$0(0);
                }
                PluginDetailsPageComponent detailPanel = new PluginDetailsPageComponent(PluginManagerConfigurablePanel.this.myPluginModelFacade, searchListener, true);
                PluginManagerConfigurablePanel.this.myPluginModelFacade.getModel().addDetailPanel(detailPanel);
                PluginDetailsPageComponent pluginDetailsPageComponent = detailPanel;
                if (pluginDetailsPageComponent == null) {
                    12.$$$reportNull$$$0(1);
                }
                return pluginDetailsPageComponent;
            }

            @Override
            @NotNull
            protected JComponent createPluginsPanel(@NotNull Consumer<? super PluginsGroupComponent> selectionListener2) {
                if (selectionListener2 == null) {
                    12.$$$reportNull$$$0(2);
                }
                MultiSelectionEventHandler eventHandler = new MultiSelectionEventHandler();
                PluginManagerConfigurablePanel.this.myMarketplacePanel = new PluginsGroupComponentWithProgress(eventHandler){

                    @Override
                    @NotNull
                    protected ListPluginComponent createListComponent(@NotNull PluginUiModel model2, @NotNull PluginsGroup group2, @NotNull ListPluginModel listPluginModel) {
                        if (model2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (group2 == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (listPluginModel == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return new ListPluginComponent(PluginManagerConfigurablePanel.this.myPluginModelFacade, model2, group2, listPluginModel, (LinkListener<Object>)searchListener, PluginManagerConfigurablePanel.this.myCoroutineScope, true);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "model";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "group";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[0] = "listPluginModel";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/ide/plugins/PluginManagerConfigurablePanel$12$1";
                        objectArray[2] = "createListComponent";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                PluginManagerConfigurablePanel.this.myMarketplacePanel.setSelectionListener(selectionListener2);
                PluginManagerConfigurablePanel.this.myMarketplacePanel.getAccessibleContext().setAccessibleName(IdeBundle.message((String)"plugin.manager.marketplace.panel.accessible.name", (Object[])new Object[0]));
                PluginManagerConfigurablePanel.registerCopyProvider(PluginManagerConfigurablePanel.this.myMarketplacePanel);
                ((SearchUpDownPopupController)PluginManagerConfigurablePanel.this.myMarketplaceSearchPanel.controller).setEventHandler(eventHandler);
                Project project2 = ProjectUtil.getActiveProject();
                PluginManagerConfigurablePanel.this.myMarketplaceRunnable = () -> {
                    PluginManagerConfigurablePanel.this.myMarketplacePanel.clear();
                    PluginManagerConfigurablePanel.this.myMarketplacePanel.startLoading();
                    this.doCreateMarketplaceTab(selectionListener2, project2);
                };
                PluginManagerConfigurablePanel.this.myMarketplacePanel.getEmptyText().setText(IdeBundle.message((String)"plugins.configurable.marketplace.plugins.not.loaded", (Object[])new Object[0])).appendSecondaryText(IdeBundle.message((String)"message.check.the.internet.connection.and", (Object[])new Object[0]) + " ", StatusText.DEFAULT_ATTRIBUTES, null).appendSecondaryText(IdeBundle.message((String)"message.link.refresh", (Object[])new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, e -> PluginManagerConfigurablePanel.this.myMarketplaceRunnable.run());
                this.doCreateMarketplaceTab(selectionListener2, project2);
                JComponent jComponent = PluginManagerConfigurablePanel.createScrollPane(PluginManagerConfigurablePanel.this.myMarketplacePanel, false);
                if (jComponent == null) {
                    12.$$$reportNull$$$0(3);
                }
                return jComponent;
            }

            private void doCreateMarketplaceTab(@NotNull Consumer<? super PluginsGroupComponent> selectionListener2, Project project2) {
                if (selectionListener2 == null) {
                    12.$$$reportNull$$$0(4);
                }
                PluginManagerPanelFactory.INSTANCE.createMarketplacePanel(PluginManagerConfigurablePanel.this.myCoroutineScope, PluginManagerConfigurablePanel.this.myPluginModelFacade.getModel(), project2, (Function1<? super CreateMarketplacePanelModel, Unit>)((Function1)model2 -> {
                    ArrayList groups = new ArrayList();
                    try {
                        try {
                            PluginsViewCustomizer.PluginsGroupDescriptor internalPluginsGroupDescriptor;
                            if (project2 != null) {
                                PluginManagerConfigurablePanel.this.addSuggestedGroup(groups, model2.getErrors(), model2.getSuggestedPlugins(), model2.getInstalledPlugins(), model2.getInstallationStates());
                            }
                            if ((internalPluginsGroupDescriptor = model2.getInternalPluginsGroupDescriptor()) != null) {
                                List customPlugins2 = ContainerUtil.map(internalPluginsGroupDescriptor.getPlugins(), it -> new PluginUiModelAdapter((IdeaPluginDescriptor)it));
                                PluginManagerConfigurablePanel.this.addGroup(groups, internalPluginsGroupDescriptor.getName(), PluginsGroupType.INTERNAL, SearchWords.INTERNAL.getValue(), customPlugins2, group2 -> customPlugins2.size() >= 9, model2.getErrors(), model2.getInstalledPlugins(), model2.getInstallationStates());
                            }
                            Map<String, PluginSearchResult> marketplaceData = model2.getMarketplaceData();
                            PluginManagerConfigurablePanel.this.addGroupViaLightDescriptor(groups, IdeBundle.message((String)"plugins.configurable.staff.picks", (Object[])new Object[0]), PluginsGroupType.STAFF_PICKS, "is_featured_search=true", SearchWords.STAFF_PICKS.getValue(), marketplaceData, model2.getErrors(), model2.getInstalledPlugins(), model2.getInstallationStates());
                            PluginManagerConfigurablePanel.this.addGroupViaLightDescriptor(groups, IdeBundle.message((String)"plugins.configurable.new.and.updated", (Object[])new Object[0]), PluginsGroupType.NEW_AND_UPDATED, "orderBy=update+date", "/sortBy:updated", marketplaceData, model2.getErrors(), model2.getInstalledPlugins(), model2.getInstallationStates());
                            PluginManagerConfigurablePanel.this.addGroupViaLightDescriptor(groups, IdeBundle.message((String)"plugins.configurable.top.downloads", (Object[])new Object[0]), PluginsGroupType.TOP_DOWNLOADS, "orderBy=downloads", "/sortBy:downloads", marketplaceData, model2.getErrors(), model2.getInstalledPlugins(), model2.getInstallationStates());
                            PluginManagerConfigurablePanel.this.addGroupViaLightDescriptor(groups, IdeBundle.message((String)"plugins.configurable.top.rated", (Object[])new Object[0]), PluginsGroupType.TOP_RATED, "orderBy=rating", "/sortBy:rating", marketplaceData, model2.getErrors(), model2.getInstalledPlugins(), model2.getInstallationStates());
                        }
                        catch (IOException e) {
                            LOG.info("Main plugin repository is not available ('" + e.getMessage() + "'). Please check your network settings.");
                        }
                        for (String host : RepositoryHelper.getCustomPluginRepositoryHosts()) {
                            List<PluginUiModel> allDescriptors = model2.getCustomRepositories().get(host);
                            if (allDescriptors == null) continue;
                            String groupName = IdeBundle.message((String)"plugins.configurable.repository.0", (Object[])new Object[]{host});
                            LOG.info("Marketplace tab: '" + groupName + "' group load started");
                            PluginManagerConfigurablePanel.this.addGroup(groups, groupName, PluginsGroupType.CUSTOM_REPOSITORY, "/repository:\"" + host + "\"", allDescriptors, group2 -> {
                                PluginsGroup.sortByName(group2.getModels());
                                return allDescriptors.size() > 9;
                            }, model2.getErrors(), model2.getInstalledPlugins(), model2.getInstallationStates());
                        }
                        if (PluginManagerConfigurablePanel.this.myPluginManagerCustomizer != null) {
                            PluginManagerConfigurablePanel.this.myPluginManagerCustomizer.ensurePluginStatesLoaded();
                        }
                    }
                    finally {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            PluginManagerConfigurablePanel.this.myMarketplacePanel.stopLoading();
                            try {
                                PluginLogo.startBatchMode();
                                for (PluginsGroup group2 : groups) {
                                    PluginManagerConfigurablePanel.this.myMarketplacePanel.addGroup(group2);
                                }
                            }
                            finally {
                                PluginLogo.endBatchMode();
                            }
                            PluginManagerConfigurablePanel.this.myMarketplacePanel.doLayout();
                            PluginManagerConfigurablePanel.this.myMarketplacePanel.initialSelection();
                            PluginManagerConfigurablePanel.this.myPluginUpdatesService.calculateUpdates(updates -> {
                                if (ContainerUtil.isEmpty((Collection)updates)) {
                                    PluginManagerConfigurablePanel.clearUpdates(PluginManagerConfigurablePanel.this.myMarketplacePanel);
                                    PluginManagerConfigurablePanel.clearUpdates(PluginManagerConfigurablePanel.this.myMarketplaceSearchPanel.getPanel());
                                } else {
                                    PluginManagerConfigurablePanel.applyUpdates(PluginManagerConfigurablePanel.this.myMarketplacePanel, updates);
                                    PluginManagerConfigurablePanel.applyUpdates(PluginManagerConfigurablePanel.this.myMarketplaceSearchPanel.getPanel(), updates);
                                }
                                selectionListener2.accept(PluginManagerConfigurablePanel.this.myMarketplacePanel);
                                selectionListener2.accept(PluginManagerConfigurablePanel.this.myMarketplaceSearchPanel.getPanel());
                            });
                        }, ModalityState.any());
                    }
                    return null;
                }));
            }

            @Override
            protected void updateMainSelection(@NotNull Consumer<? super PluginsGroupComponent> selectionListener2) {
                if (selectionListener2 == null) {
                    12.$$$reportNull$$$0(5);
                }
                selectionListener2.accept(PluginManagerConfigurablePanel.this.myMarketplacePanel);
            }

            @Override
            @NotNull
            protected SearchResultPanel createSearchPanel(final @NotNull Consumer<? super PluginsGroupComponent> selectionListener2) {
                if (selectionListener2 == null) {
                    12.$$$reportNull$$$0(6);
                }
                SearchUpDownPopupController marketplaceController = new SearchUpDownPopupController(this.searchTextField){

                    @Override
                    @NotNull
                    protected List<String> getAttributes() {
                        ArrayList<String> attributes = new ArrayList<String>();
                        attributes.add(SearchWords.TAG.getValue());
                        attributes.add(SearchWords.SORT_BY.getValue());
                        attributes.add(SearchWords.VENDOR.getValue());
                        if (!RepositoryHelper.getCustomPluginRepositoryHosts().isEmpty()) {
                            attributes.add(SearchWords.REPOSITORY.getValue());
                        }
                        attributes.add(SearchWords.STAFF_PICKS.getValue());
                        attributes.add(SearchWords.SUGGESTED.getValue());
                        if (PluginsViewCustomizerKt.getPluginsViewCustomizer() != NoOpPluginsViewCustomizer.INSTANCE) {
                            attributes.add(SearchWords.INTERNAL.getValue());
                        }
                        ArrayList<String> arrayList = attributes;
                        if (arrayList == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        return arrayList;
                    }

                    @Nullable
                    protected List<String> getValues(@NotNull String attribute) {
                        SearchWords word;
                        if (attribute == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        SearchWords searchWords = word = SearchWords.find(attribute);
                        int n = 0;
                        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"TAG", "SORT_BY", "VENDOR", "REPOSITORY", "INTERNAL", "SUGGESTED", "STAFF_PICKS"}, (SearchWords)searchWords, n)) {
                            default -> throw new MatchException(null, null);
                            case 0 -> {
                                if (PluginManagerConfigurablePanel.this.myTagsSorted == null || PluginManagerConfigurablePanel.this.myTagsSorted.isEmpty()) {
                                    HashSet<String> allTags = new HashSet<String>();
                                    Set<String> customRepoTags = UiPluginManager.getInstance().getCustomRepoTags();
                                    if (!customRepoTags.isEmpty()) {
                                        allTags.addAll(customRepoTags);
                                    }
                                    try {
                                        ProcessIOExecutorService.INSTANCE.submit(() -> allTags.addAll(UiPluginManager.getInstance().getAllPluginsTags())).get();
                                    }
                                    catch (InterruptedException | ExecutionException e) {
                                        LOG.error("Error while getting tags from marketplace", (Throwable)e);
                                    }
                                    PluginManagerConfigurablePanel.this.myTagsSorted = ContainerUtil.sorted(allTags, String::compareToIgnoreCase);
                                }
                                List<String> var5_10 = PluginManagerConfigurablePanel.this.myTagsSorted;
                                yield var5_10;
                            }
                            case 1 -> {
                                List var5_11;
                                yield var5_11 = ContainerUtil.map(Arrays.asList(SortBy.DOWNLOADS, SortBy.NAME, SortBy.RATING, SortBy.UPDATE_DATE), sort -> sort.getQuery());
                            }
                            case 2 -> {
                                if (PluginManagerConfigurablePanel.this.myVendorsSorted == null || PluginManagerConfigurablePanel.this.myVendorsSorted.isEmpty()) {
                                    LinkedHashSet vendors = new LinkedHashSet();
                                    try {
                                        ProcessIOExecutorService.INSTANCE.submit(() -> vendors.addAll(UiPluginManager.getInstance().getAllVendors())).get();
                                    }
                                    catch (InterruptedException | ExecutionException e) {
                                        LOG.error("Error while getting vendors from marketplace", (Throwable)e);
                                    }
                                    PluginManagerConfigurablePanel.this.myVendorsSorted = new ArrayList<String>(vendors);
                                }
                                List<String> var5_12 = PluginManagerConfigurablePanel.this.myVendorsSorted;
                                yield var5_12;
                            }
                            case 3 -> {
                                List var5_13;
                                yield var5_13 = RepositoryHelper.getCustomPluginRepositoryHosts();
                            }
                            case 4, 5, 6 -> {
                                Object var5_14 = null;
                                yield var5_14;
                            }
                            case -1 -> {
                                Object var5_15 = null;
                                yield var5_15;
                            }
                        };
                    }

                    @Override
                    protected void showPopupForQuery() {
                        this.showSearchPanel(searchTextField.getText());
                    }

                    @Override
                    protected void handleEnter() {
                        if (!searchTextField.getText().isEmpty()) {
                            this.handleTrigger("marketplace.suggest.popup.enter");
                        }
                    }

                    @Override
                    protected void handlePopupListFirstSelection() {
                        this.handleTrigger("marketplace.suggest.popup.select");
                    }

                    private void handleTrigger(@NonNls String key) {
                        if (this.myPopup != null && this.myPopup.type == SearchPopup.Type.SearchQuery) {
                            FeatureUsageTracker.getInstance().triggerFeatureUsed(key);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 2;
                            case 1 -> 3;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurablePanel$12$2";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "attribute";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getAttributes";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurablePanel$12$2";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                break;
                            }
                            case 1: {
                                objectArray = objectArray;
                                objectArray[2] = "getValues";
                                break;
                            }
                        }
                        String string = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalStateException(string);
                            case 1 -> new IllegalArgumentException(string);
                        };
                    }
                };
                PluginManagerConfigurablePanel.this.myMarketplaceSortByGroup = new DefaultActionGroup();
                for (SortBy option2 : SortBy.getEntries()) {
                    PluginManagerConfigurablePanel.this.myMarketplaceSortByGroup.addAction((AnAction)new MarketplaceSortByAction(option2));
                }
                PluginManagerConfigurablePanel.this.myMarketplaceSortByAction = new LinkComponent(){

                    protected boolean isInClickableArea(Point pt) {
                        return true;
                    }

                    public AccessibleContext getAccessibleContext() {
                        if (this.accessibleContext == null) {
                            this.accessibleContext = new AccessibleLinkComponent();
                        }
                        return this.accessibleContext;
                    }

                    protected class AccessibleLinkComponent
                    extends LinkLabel.AccessibleLinkLabel {
                        protected AccessibleLinkComponent() {
                            super((LinkLabel)this);
                        }

                        public AccessibleRole getAccessibleRole() {
                            return AccessibleRole.COMBO_BOX;
                        }
                    }
                };
                PluginManagerConfigurablePanel.this.myMarketplaceSortByAction.setIcon(new Icon(this){

                    @Override
                    public void paintIcon(Component c, Graphics g, int x, int y) {
                        4.getIcon().paintIcon(c, g, x, y + 1);
                    }

                    @Override
                    public int getIconWidth() {
                        return 4.getIcon().getIconWidth();
                    }

                    @Override
                    public int getIconHeight() {
                        return 4.getIcon().getIconHeight();
                    }

                    @NotNull
                    private static Icon getIcon() {
                        Icon icon2 = AllIcons.General.ButtonDropTriangle;
                        if (icon2 == null) {
                            4.$$$reportNull$$$0(0);
                        }
                        return icon2;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerConfigurablePanel$12$4", "getIcon"));
                    }
                });
                PluginManagerConfigurablePanel.this.myMarketplaceSortByAction.setPaintUnderline(false);
                PluginManagerConfigurablePanel.this.myMarketplaceSortByAction.setIconTextGap(JBUIScale.scale((int)4));
                PluginManagerConfigurablePanel.this.myMarketplaceSortByAction.setHorizontalTextPosition(2);
                PluginManagerConfigurablePanel.this.myMarketplaceSortByAction.setForeground(PluginsGroupComponent.SECTION_HEADER_FOREGROUND);
                PluginManagerConfigurablePanel.this.myMarketplaceSortByAction.setListener((component2, __) -> PluginManagerConfigurablePanel.showRightBottomPopup(component2.getParent().getParent(), IdeBundle.message((String)"plugins.configurable.sort.by", (Object[])new Object[0]), (ActionGroup)PluginManagerConfigurablePanel.this.myMarketplaceSortByGroup), null);
                DumbAwareAction.create(event -> PluginManagerConfigurablePanel.this.myMarketplaceSortByAction.doClick()).registerCustomShortcutSet(40, 0, (JComponent)((Object)PluginManagerConfigurablePanel.this.myMarketplaceSortByAction));
                PluginManagerConfigurablePanel.this.myMarketplaceSortByCallback = updateAction2 -> {
                    String query;
                    String query2;
                    MarketplaceSortByAction removeAction = null;
                    MarketplaceSortByAction addAction = null;
                    if (updateAction2.myState) {
                        for (AnAction action2 : PluginManagerConfigurablePanel.this.myMarketplaceSortByGroup.getChildren(ActionManager.getInstance())) {
                            MarketplaceSortByAction sortByAction = (MarketplaceSortByAction)action2;
                            if (sortByAction == updateAction2 || !sortByAction.myState) continue;
                            sortByAction.myState = false;
                            removeAction = sortByAction;
                            break;
                        }
                        addAction = updateAction2;
                    } else {
                        if (updateAction2.myOption == SortBy.RELEVANCE) {
                            updateAction2.myState = true;
                            return;
                        }
                        for (AnAction action3 : PluginManagerConfigurablePanel.this.myMarketplaceSortByGroup.getChildren(ActionManager.getInstance())) {
                            MarketplaceSortByAction sortByAction = (MarketplaceSortByAction)action3;
                            if (sortByAction.myOption != SortBy.RELEVANCE) continue;
                            sortByAction.myState = true;
                            break;
                        }
                        removeAction = updateAction2;
                    }
                    final ArrayList<String> queries = new ArrayList<String>();
                    new SearchQueryParser.Marketplace(this, this.searchTextField.getText()){

                        @Override
                        protected void addToSearchQuery(@NotNull String query) {
                            if (query == null) {
                                5.$$$reportNull$$$0(0);
                            }
                            queries.add(query);
                        }

                        @Override
                        protected void handleAttribute(@NotNull String name2, @NotNull String value) {
                            if (name2 == null) {
                                5.$$$reportNull$$$0(1);
                            }
                            if (value == null) {
                                5.$$$reportNull$$$0(2);
                            }
                            queries.add(name2 + SearchQueryParser.wrapAttribute(value));
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "query";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "name";
                                    break;
                                }
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "value";
                                    break;
                                }
                            }
                            objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurablePanel$12$5";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "addToSearchQuery";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "handleAttribute";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    };
                    if (removeAction != null && (query2 = removeAction.getQuery()) != null) {
                        queries.remove(query2);
                    }
                    if (addAction != null && (query = addAction.getQuery()) != null) {
                        queries.add(query);
                    }
                    String query3 = StringUtil.join(queries, (String)" ");
                    this.searchTextField.setTextIgnoreEvents(query3);
                    if (query3.isEmpty()) {
                        PluginManagerConfigurablePanel.this.myMarketplaceTab.hideSearchPanel();
                    } else {
                        PluginManagerConfigurablePanel.this.myMarketplaceTab.showSearchPanel(query3);
                    }
                };
                MultiSelectionEventHandler eventHandler = new MultiSelectionEventHandler();
                marketplaceController.setSearchResultEventHandler(eventHandler);
                PluginsGroupComponentWithProgress panel2 = new PluginsGroupComponentWithProgress(eventHandler){

                    @Override
                    @NotNull
                    protected ListPluginComponent createListComponent(@NotNull PluginUiModel model2, @NotNull PluginsGroup group2, @NotNull ListPluginModel listPluginModel) {
                        if (model2 == null) {
                            6.$$$reportNull$$$0(0);
                        }
                        if (group2 == null) {
                            6.$$$reportNull$$$0(1);
                        }
                        if (listPluginModel == null) {
                            6.$$$reportNull$$$0(2);
                        }
                        return new ListPluginComponent(PluginManagerConfigurablePanel.this.myPluginModelFacade, model2, group2, listPluginModel, (LinkListener<Object>)searchListener, PluginManagerConfigurablePanel.this.myCoroutineScope, true);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "model";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "group";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[0] = "listPluginModel";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/ide/plugins/PluginManagerConfigurablePanel$12$6";
                        objectArray[2] = "createListComponent";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                panel2.setSelectionListener(selectionListener2);
                PluginManagerConfigurablePanel.registerCopyProvider(panel2);
                final Project project2 = ProjectUtil.getActiveProject();
                SearchResultPanel searchResultPanel = PluginManagerConfigurablePanel.this.myMarketplaceSearchPanel = new SearchResultPanel(marketplaceController, panel2, true, 0, 0){

                    @Override
                    protected void handleQuery(@NotNull String query, @NotNull PluginsGroup result2, AtomicBoolean runQuery) {
                        if (query == null) {
                            7.$$$reportNull$$$0(0);
                        }
                        if (result2 == null) {
                            7.$$$reportNull$$$0(1);
                        }
                        int searchIndex = PluginManagerUsageCollector.updateAndGetSearchIndex();
                        SearchQueryParser.Marketplace parser = new SearchQueryParser.Marketplace(query);
                        Map pluginToScore = null;
                        if (parser.internal) {
                            try {
                                PluginsViewCustomizer.PluginsGroupDescriptor groupDescriptor = PluginsViewCustomizerKt.getPluginsViewCustomizer().getInternalPluginsGroupDescriptor();
                                if (groupDescriptor != null) {
                                    if (parser.searchQuery == null) {
                                        result2.addDescriptors(groupDescriptor.getPlugins());
                                    } else {
                                        for (IdeaPluginDescriptor pluginDescriptor : groupDescriptor.getPlugins()) {
                                            if (!StringUtil.containsIgnoreCase((String)pluginDescriptor.getName(), (String)parser.searchQuery)) continue;
                                            result2.addDescriptor(pluginDescriptor);
                                        }
                                    }
                                    result2.removeDuplicates();
                                    result2.sortByName();
                                    return;
                                }
                            }
                            catch (Exception e) {
                                LOG.error("Error while loading internal plugins group", (Throwable)e);
                            }
                        }
                        PluginModelAsyncOperationsExecutor.INSTANCE.getCustomRepositoriesPluginMap(PluginManagerConfigurablePanel.this.myCoroutineScope, (Function1<? super Map<String, ? extends List<? extends PluginUiModel>>, Unit>)((Function1)map2 -> {
                            Map customRepositoriesMap = map2;
                            if (parser.suggested && project2 != null) {
                                List<@NotNull PluginUiModel> plugins2 = PluginsAdvertiserStartupActivityKt.findSuggestedPlugins(project2, customRepositoriesMap);
                                result2.addModels(plugins2);
                                this.updateSearchPanel(result2, runQuery, plugins2);
                            } else if (!parser.repositories.isEmpty()) {
                                for (String repository : parser.repositories) {
                                    List descriptors2 = (List)customRepositoriesMap.get(repository);
                                    if (descriptors2 == null) continue;
                                    if (parser.searchQuery == null) {
                                        result2.addModels(descriptors2);
                                        continue;
                                    }
                                    for (PluginUiModel descriptor2 : descriptors2) {
                                        if (!StringUtil.containsIgnoreCase((String)descriptor2.getName(), (String)parser.searchQuery)) continue;
                                        result2.addModel(descriptor2);
                                    }
                                }
                                result2.removeDuplicates();
                                result2.sortByName();
                                this.updateSearchPanel(result2, runQuery, result2.getModels());
                            } else {
                                PluginModelAsyncOperationsExecutor.INSTANCE.performMarketplaceSearch(PluginManagerConfigurablePanel.this.myCoroutineScope, parser.getUrlQuery(), !result2.getModels().isEmpty(), (Function2<? super PluginSearchResult, ? super List<? extends PluginUiModel>, Unit>)((Function2)(searchResult, updates) -> {
                                    this.applySearchResult(result2, (PluginSearchResult)searchResult, (List<PluginUiModel>)updates, customRepositoriesMap, parser, pluginToScore, searchIndex);
                                    this.updatePanel(runQuery);
                                    return null;
                                }));
                            }
                            return null;
                        }));
                    }

                    private void updateSearchPanel(@NonNull PluginsGroup result2, AtomicBoolean runQuery, List<@NotNull PluginUiModel> plugins2) {
                        Set<PluginId> ids = plugins2.stream().map(it -> it.getPluginId()).collect(Collectors.toSet());
                        result2.getPreloadedModel().setInstalledPlugins(UiPluginManager.getInstance().findInstalledPluginsSync(ids));
                        result2.getPreloadedModel().setPluginInstallationStates(UiPluginManager.getInstance().getInstallationStatesSync());
                        this.updatePanel(runQuery);
                    }

                    private void applySearchResult(@NotNull PluginsGroup result2, PluginSearchResult searchResult, List<PluginUiModel> updates, Map<String, List<PluginUiModel>> customRepositoriesMap, SearchQueryParser.Marketplace parser, Map<PluginUiModel, Double> pluginToScore, int searchIndex) {
                        if (result2 == null) {
                            7.$$$reportNull$$$0(2);
                        }
                        if (searchResult.getError() != null) {
                            ApplicationManager.getApplication().invokeLater(() -> this.myPanel.getEmptyText().setText(IdeBundle.message((String)"plugins.configurable.search.result.not.loaded", (Object[])new Object[0])).appendSecondaryText(IdeBundle.message((String)"plugins.configurable.check.internet", (Object[])new Object[0]), StatusText.DEFAULT_ATTRIBUTES, null), ModalityState.any());
                        }
                        List customPlugins2 = ContainerUtil.flatten(customRepositoriesMap.values());
                        Collection<PluginUiModel> plugins2 = RepositoryHelper.mergePluginModelsFromRepositories(searchResult.getPlugins(), customPlugins2, false);
                        result2.addModels(0, new ArrayList<PluginUiModel>(plugins2));
                        if (parser.searchQuery != null) {
                            List descriptors2 = ContainerUtil.filter((Collection)customPlugins2, descriptor2 -> StringUtil.containsIgnoreCase((String)descriptor2.getName(), (String)parser.searchQuery));
                            result2.addModels(0, descriptors2);
                        }
                        result2.removeDuplicates();
                        MarketplaceLocalRanker localRanker = MarketplaceLocalRanker.getInstanceIfEnabled();
                        if (localRanker != null) {
                            pluginToScore = localRanker.rankPlugins(parser, result2.getModels());
                        }
                        if (!result2.getModels().isEmpty()) {
                            String title2 = IdeBundle.message((String)"plugin.manager.action.label.sort.by.1", (Object[])new Object[0]);
                            for (AnAction action2 : PluginManagerConfigurablePanel.this.myMarketplaceSortByGroup.getChildren(ActionManager.getInstance())) {
                                MarketplaceSortByAction sortByAction = (MarketplaceSortByAction)action2;
                                sortByAction.setState(parser);
                                if (!sortByAction.myState) continue;
                                title2 = IdeBundle.message((String)"plugin.manager.action.label.sort.by", (Object[])new Object[]{sortByAction.myOption.getPresentableNameSupplier().get()});
                            }
                            PluginManagerConfigurablePanel.this.myMarketplaceSortByAction.setText(title2);
                            result2.addRightAction((JComponent)((Object)PluginManagerConfigurablePanel.this.myMarketplaceSortByAction));
                            if (!ContainerUtil.isEmpty(updates)) {
                                this.myPostFillGroupCallback = () -> {
                                    PluginManagerConfigurablePanel.applyUpdates(this.myPanel, updates);
                                    selectionListener2.accept(PluginManagerConfigurablePanel.this.myMarketplacePanel);
                                    selectionListener2.accept(PluginManagerConfigurablePanel.this.myMarketplaceSearchPanel.getPanel());
                                };
                            }
                        }
                        Set<PluginId> ids = result2.getModels().stream().map(it -> it.getPluginId()).collect(Collectors.toSet());
                        result2.getPreloadedModel().setInstalledPlugins(UiPluginManager.getInstance().findInstalledPluginsSync(ids));
                        result2.getPreloadedModel().setPluginInstallationStates(UiPluginManager.getInstance().getInstallationStatesSync());
                        PluginManagerUsageCollector.INSTANCE.performMarketplaceSearch(ProjectUtil.getActiveProject(), parser, result2.getModels(), searchIndex, pluginToScore);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "query";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "result";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurablePanel$12$7";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "handleQuery";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "applySearchResult";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                if (searchResultPanel == null) {
                    12.$$$reportNull$$$0(7);
                }
                return searchResultPanel;
            }

            @Override
            protected void onSearchReset() {
                PluginManagerUsageCollector.INSTANCE.searchReset();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 3, 7 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "searchListener";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurablePanel$12";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "selectionListener";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurablePanel$12";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createDetailsPanel";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createPluginsPanel";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createSearchPanel";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createDetailsPanel";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 7: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "createPluginsPanel";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "doCreateMarketplaceTab";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "updateMainSelection";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "createSearchPanel";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 3, 7 -> new IllegalStateException(string);
                };
            }
        };
    }

    private void createInstalledTab() {
        this.myInstalledSearchGroup = new DefaultActionGroup();
        for (InstalledSearchOption option2 : InstalledSearchOption.values()) {
            this.myInstalledSearchGroup.add((AnAction)new InstalledSearchOptionAction(option2));
        }
        this.myInstalledTab = new PluginsTab(){

            @Override
            protected void createSearchTextField(int flyDelay) {
                super.createSearchTextField(flyDelay);
                JBTextField textField2 = this.searchTextField.getTextEditor();
                textField2.putClientProperty((Object)"search.extension", (Object)ExtendableTextComponent.Extension.create((Icon)AllIcons.Actions.More, (Icon)AllIcons.Actions.More, (String)IdeBundle.message((String)"plugins.configurable.search.options", (Object[])new Object[0]), (boolean)true, () -> PluginManagerConfigurablePanel.showRightBottomPopup((Component)textField2, IdeBundle.message((String)"plugins.configurable.show", (Object[])new Object[0]), (ActionGroup)PluginManagerConfigurablePanel.this.myInstalledSearchGroup)));
                textField2.putClientProperty((Object)"JTextField.variant", null);
                textField2.putClientProperty((Object)"JTextField.variant", (Object)"search");
                this.searchTextField.setHistoryPropertyName("InstalledPluginsSearchHistory");
            }

            @Override
            @NotNull
            protected PluginDetailsPageComponent createDetailsPanel(@NotNull LinkListener<Object> searchListener) {
                if (searchListener == null) {
                    13.$$$reportNull$$$0(0);
                }
                PluginDetailsPageComponent detailPanel = new PluginDetailsPageComponent(PluginManagerConfigurablePanel.this.myPluginModelFacade, searchListener, false);
                PluginManagerConfigurablePanel.this.myPluginModelFacade.getModel().addDetailPanel(detailPanel);
                PluginDetailsPageComponent pluginDetailsPageComponent = detailPanel;
                if (pluginDetailsPageComponent == null) {
                    13.$$$reportNull$$$0(1);
                }
                return pluginDetailsPageComponent;
            }

            @Override
            @NotNull
            protected JComponent createPluginsPanel(@NotNull Consumer<? super PluginsGroupComponent> selectionListener2) {
                if (selectionListener2 == null) {
                    13.$$$reportNull$$$0(2);
                }
                MultiSelectionEventHandler eventHandler = new MultiSelectionEventHandler();
                PluginManagerConfigurablePanel.this.myInstalledPanel = new PluginsGroupComponentWithProgress(eventHandler){

                    @Override
                    @NotNull
                    protected ListPluginComponent createListComponent(@NotNull PluginUiModel model2, @NotNull PluginsGroup group2, @NotNull ListPluginModel listPluginModel) {
                        if (model2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (group2 == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (listPluginModel == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return new ListPluginComponent(PluginManagerConfigurablePanel.this.myPluginModelFacade, model2, group2, listPluginModel, (LinkListener<Object>)searchListener, PluginManagerConfigurablePanel.this.myCoroutineScope, false);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "model";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "group";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[0] = "listPluginModel";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/ide/plugins/PluginManagerConfigurablePanel$13$1";
                        objectArray[2] = "createListComponent";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                PluginManagerConfigurablePanel.this.myInstalledPanel.setSelectionListener(selectionListener2);
                PluginManagerConfigurablePanel.this.myInstalledPanel.getAccessibleContext().setAccessibleName(IdeBundle.message((String)"plugin.manager.installed.panel.accessible.name", (Object[])new Object[0]));
                PluginManagerConfigurablePanel.registerCopyProvider(PluginManagerConfigurablePanel.this.myInstalledPanel);
                ((SearchUpDownPopupController)PluginManagerConfigurablePanel.this.myInstalledSearchPanel.controller).setEventHandler(eventHandler);
                PluginManagerConfigurablePanel.this.myInstalledPanel.startLoading();
                PluginsGroup downloaded = new PluginsGroup(IdeBundle.message((String)"plugins.configurable.downloaded", (Object[])new Object[0]), PluginsGroupType.INSTALLED);
                PluginsGroup installing = new PluginsGroup(IdeBundle.message((String)"plugins.configurable.installing", (Object[])new Object[0]), PluginsGroupType.INSTALLING);
                PluginManagerPanelFactory.INSTANCE.createInstalledPanel(PluginManagerConfigurablePanel.this.myCoroutineScope, PluginManagerConfigurablePanel.this.myPluginModelFacade.getModel(), (Function1<? super CreateInstalledPanelModel, Unit>)((Function1)model2 -> {
                    try {
                        PluginManagerConfigurablePanel.this.myPluginModelFacade.getModel().setDownloadedGroup(PluginManagerConfigurablePanel.this.myInstalledPanel, downloaded, installing);
                        installing.getPreloadedModel().setErrors(model2.getErrors());
                        installing.getPreloadedModel().setPluginInstallationStates(model2.getInstallationStates());
                        installing.addModels(MyPluginModel.getInstallingPlugins());
                        if (!installing.getModels().isEmpty()) {
                            installing.sortByName();
                            installing.titleWithCount();
                            PluginManagerConfigurablePanel.this.myInstalledPanel.addGroup(installing);
                        }
                        downloaded.getPreloadedModel().setErrors(model2.getErrors());
                        downloaded.getPreloadedModel().setPluginInstallationStates(model2.getInstallationStates());
                        downloaded.addModels(model2.getInstalledPlugins());
                        PluginManagerConfigurablePanel.this.myBundledUpdateGroup.getPreloadedModel().setErrors(model2.getErrors());
                        PluginManagerConfigurablePanel.this.myBundledUpdateGroup.getPreloadedModel().setPluginInstallationStates(model2.getInstallationStates());
                        Map<Boolean, List<PluginUiModel>> visiblePlugins = model2.getVisiblePlugins().stream().collect(Collectors.partitioningBy(plugin -> plugin.isBundled() || plugin.isBundledUpdate()));
                        List<PluginUiModel> visibleNonBundledPlugins = visiblePlugins.get(Boolean.FALSE);
                        List<PluginUiModel> visibleBundledPlugins = visiblePlugins.get(Boolean.TRUE);
                        List installedPluginIds = ContainerUtil.map(model2.getInstalledPlugins(), it -> it.getPluginId());
                        List nonBundledPlugins = ContainerUtil.filter(visibleNonBundledPlugins, it -> !installedPluginIds.contains(it.getPluginId()));
                        downloaded.addModels(nonBundledPlugins);
                        LinkListener<Object> updateAllListener = new LinkListener<Object>(){

                            public void linkSelected(LinkLabel<Object> aSource, Object aLinkData) {
                                PluginManagerConfigurablePanel.this.myUpdateAll.setEnabled(false);
                                PluginManagerConfigurablePanel.this.myUpdateAllBundled.setEnabled(false);
                                for (UIPluginGroup group2 : PluginManagerConfigurablePanel.this.getInstalledGroups()) {
                                    if (group2.excluded) continue;
                                    for (ListPluginComponent plugin : group2.plugins) {
                                        plugin.updatePlugin();
                                    }
                                }
                            }
                        };
                        PluginManagerConfigurablePanel.this.myUpdateAll.setListener((LinkListener)updateAllListener, null);
                        downloaded.addRightAction((JComponent)PluginManagerConfigurablePanel.this.myUpdateAll);
                        downloaded.addRightAction(PluginManagerConfigurablePanel.this.myUpdateCounter);
                        if (!downloaded.getModels().isEmpty()) {
                            downloaded.sortByName();
                            long enabledNonBundledCount = nonBundledPlugins.stream().filter(descriptor2 -> !PluginManagerConfigurablePanel.this.myPluginModelFacade.getModel().isDisabled(descriptor2.getPluginId())).count();
                            downloaded.titleWithCount(Math.toIntExact(enabledNonBundledCount));
                            if (downloaded.ui == null) {
                                PluginManagerConfigurablePanel.this.myInstalledPanel.addGroup(downloaded);
                            }
                            PluginManagerConfigurablePanel.this.myPluginModelFacade.getModel().addEnabledGroup(downloaded);
                        }
                        String defaultCategory = IdeBundle.message((String)"plugins.configurable.other.bundled", (Object[])new Object[0]);
                        visibleBundledPlugins.stream().collect(Collectors.groupingBy(descriptor2 -> StringUtil.defaultIfEmpty((String)descriptor2.getDisplayCategory(), (String)defaultCategory))).entrySet().stream().map(entry -> new ComparablePluginsGroup((String)entry.getKey(), (List)entry.getValue(), model2.getVisiblePluginsRequiresUltimate())).sorted((o1, o2) -> defaultCategory.equals(o1.title) ? 1 : (defaultCategory.equals(o2.title) ? -1 : o1.compareTo((ComparablePluginsGroup)o2))).forEachOrdered(group2 -> {
                            group2.getPreloadedModel().setErrors(model2.getErrors());
                            group2.getPreloadedModel().setPluginInstallationStates(model2.getInstallationStates());
                            PluginManagerConfigurablePanel.this.myInstalledPanel.addGroup((PluginsGroup)group2);
                            PluginManagerConfigurablePanel.this.myPluginModelFacade.getModel().addEnabledGroup((PluginsGroup)group2);
                        });
                        PluginManagerConfigurablePanel.this.myUpdateAllBundled.setListener((LinkListener)updateAllListener, null);
                        PluginManagerConfigurablePanel.this.myBundledUpdateGroup.addRightAction((JComponent)PluginManagerConfigurablePanel.this.myUpdateAllBundled);
                        PluginManagerConfigurablePanel.this.myBundledUpdateGroup.addRightAction(PluginManagerConfigurablePanel.this.myUpdateCounterBundled);
                        PluginManagerConfigurablePanel.this.myPluginUpdatesService.calculateUpdates(updates -> {
                            if (ContainerUtil.isEmpty((Collection)updates)) {
                                PluginManagerConfigurablePanel.clearUpdates(PluginManagerConfigurablePanel.this.myInstalledPanel);
                                PluginManagerConfigurablePanel.clearUpdates(PluginManagerConfigurablePanel.this.myInstalledSearchPanel.getPanel());
                            } else {
                                PluginManagerConfigurablePanel.applyUpdates(PluginManagerConfigurablePanel.this.myInstalledPanel, updates);
                                PluginManagerConfigurablePanel.applyUpdates(PluginManagerConfigurablePanel.this.myInstalledSearchPanel.getPanel(), updates);
                            }
                            PluginManagerConfigurablePanel.this.applyBundledUpdates((Collection<? extends PluginUiModel>)updates);
                            selectionListener2.accept(PluginManagerConfigurablePanel.this.myInstalledPanel);
                            selectionListener2.accept(PluginManagerConfigurablePanel.this.myInstalledSearchPanel.getPanel());
                        });
                    }
                    finally {
                        PluginManagerConfigurablePanel.this.myInstalledPanel.stopLoading();
                    }
                    return null;
                }));
                JComponent jComponent = PluginManagerConfigurablePanel.createScrollPane(PluginManagerConfigurablePanel.this.myInstalledPanel, true);
                if (jComponent == null) {
                    13.$$$reportNull$$$0(3);
                }
                return jComponent;
            }

            @Override
            protected void updateMainSelection(@NotNull Consumer<? super PluginsGroupComponent> selectionListener2) {
                if (selectionListener2 == null) {
                    13.$$$reportNull$$$0(4);
                }
                selectionListener2.accept(PluginManagerConfigurablePanel.this.myInstalledPanel);
            }

            @Override
            public void hideSearchPanel() {
                super.hideSearchPanel();
                if (PluginManagerConfigurablePanel.this.myInstalledSearchSetState) {
                    for (AnAction action2 : PluginManagerConfigurablePanel.this.myInstalledSearchGroup.getChildren(ActionManager.getInstance())) {
                        ((InstalledSearchOptionAction)action2).setState(null);
                    }
                }
                PluginManagerConfigurablePanel.this.myPluginModelFacade.getModel().setInvalidFixCallback(null);
            }

            @Override
            protected void onSearchReset() {
                PluginManagerUsageCollector.INSTANCE.searchReset();
            }

            @Override
            @NotNull
            protected SearchResultPanel createSearchPanel(final @NotNull Consumer<? super PluginsGroupComponent> selectionListener2) {
                if (selectionListener2 == null) {
                    13.$$$reportNull$$$0(5);
                }
                SearchUpDownPopupController installedController = new SearchUpDownPopupController(this.searchTextField){

                    @Override
                    @NotNull
                    @NonNls
                    protected List<String> getAttributes() {
                        List<String> list2 = Arrays.asList("/downloaded", "/outdated", "/enabled", "/disabled", "/invalid", "/bundled", SearchWords.VENDOR.getValue(), SearchWords.TAG.getValue());
                        if (list2 == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        return list2;
                    }

                    @Nullable
                    protected SortedSet<String> getValues(@NotNull String attribute) {
                        if (attribute == null) {
                            3.$$$reportNull$$$0(1);
                        }
                        return SearchWords.VENDOR.getValue().equals(attribute) ? PluginManagerConfigurablePanel.this.myPluginModelFacade.getModel().getVendors() : (SearchWords.TAG.getValue().equals(attribute) ? PluginManagerConfigurablePanel.this.myPluginModelFacade.getModel().getTags() : null);
                    }

                    @Override
                    protected void showPopupForQuery() {
                        this.showSearchPanel(searchTextField.getText());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 2;
                            case 1 -> 3;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurablePanel$13$3";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "attribute";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getAttributes";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurablePanel$13$3";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                break;
                            }
                            case 1: {
                                objectArray = objectArray;
                                objectArray[2] = "getValues";
                                break;
                            }
                        }
                        String string = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalStateException(string);
                            case 1 -> new IllegalArgumentException(string);
                        };
                    }
                };
                MultiSelectionEventHandler eventHandler = new MultiSelectionEventHandler();
                installedController.setSearchResultEventHandler(eventHandler);
                PluginsGroupComponentWithProgress panel2 = new PluginsGroupComponentWithProgress(eventHandler){

                    @Override
                    @NotNull
                    protected ListPluginComponent createListComponent(@NotNull PluginUiModel model2, @NotNull PluginsGroup group2, @NotNull ListPluginModel listPluginModel) {
                        if (model2 == null) {
                            4.$$$reportNull$$$0(0);
                        }
                        if (group2 == null) {
                            4.$$$reportNull$$$0(1);
                        }
                        if (listPluginModel == null) {
                            4.$$$reportNull$$$0(2);
                        }
                        return new ListPluginComponent(PluginManagerConfigurablePanel.this.myPluginModelFacade, model2, group2, listPluginModel, (LinkListener<Object>)searchListener, PluginManagerConfigurablePanel.this.myCoroutineScope, false);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "model";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "group";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[0] = "listPluginModel";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/ide/plugins/PluginManagerConfigurablePanel$13$4";
                        objectArray[2] = "createListComponent";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                panel2.setSelectionListener(selectionListener2);
                PluginManagerConfigurablePanel.registerCopyProvider(panel2);
                PluginManagerConfigurablePanel.this.myInstalledSearchCallback = updateAction2 -> {
                    final ArrayList<String> queries = new ArrayList<String>();
                    new SearchQueryParser.Installed(this, this.searchTextField.getText(), (InstalledSearchOptionAction)((Object)updateAction2)){
                        final /* synthetic */ InstalledSearchOptionAction val$updateAction;
                        {
                            this.val$updateAction = installedSearchOptionAction;
                            super(query);
                        }

                        @Override
                        protected void addToSearchQuery(@NotNull String query) {
                            if (query == null) {
                                5.$$$reportNull$$$0(0);
                            }
                            queries.add(query);
                        }

                        @Override
                        protected void handleAttribute(@NotNull String name2, @NotNull String value) {
                            if (name2 == null) {
                                5.$$$reportNull$$$0(1);
                            }
                            if (value == null) {
                                5.$$$reportNull$$$0(2);
                            }
                            if (!this.val$updateAction.myState) {
                                queries.add(name2 + (value.isEmpty() ? "" : SearchQueryParser.wrapAttribute(value)));
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "query";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "name";
                                    break;
                                }
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "value";
                                    break;
                                }
                            }
                            objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurablePanel$13$5";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "addToSearchQuery";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "handleAttribute";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    };
                    if (updateAction2.myState) {
                        for (AnAction action2 : PluginManagerConfigurablePanel.this.myInstalledSearchGroup.getChildren(ActionManager.getInstance())) {
                            if (action2 == updateAction2) continue;
                            ((InstalledSearchOptionAction)action2).myState = false;
                        }
                        queries.add(updateAction2.getQuery());
                    } else {
                        queries.remove(updateAction2.getQuery());
                    }
                    try {
                        PluginManagerConfigurablePanel.this.myInstalledSearchSetState = false;
                        String query = StringUtil.join(queries, (String)" ");
                        this.searchTextField.setTextIgnoreEvents(query);
                        if (query.isEmpty()) {
                            PluginManagerConfigurablePanel.this.myInstalledTab.hideSearchPanel();
                        } else {
                            PluginManagerConfigurablePanel.this.myInstalledTab.showSearchPanel(query);
                        }
                    }
                    finally {
                        PluginManagerConfigurablePanel.this.myInstalledSearchSetState = true;
                    }
                };
                SearchResultPanel searchResultPanel = PluginManagerConfigurablePanel.this.myInstalledSearchPanel = new SearchResultPanel(installedController, panel2, false, 0, 0){

                    @Override
                    protected void setEmptyText(@NotNull String query) {
                        if (query == null) {
                            6.$$$reportNull$$$0(0);
                        }
                        this.myPanel.getEmptyText().setText(IdeBundle.message((String)"plugins.configurable.nothing.found", (Object[])new Object[0]));
                        if (query.contains("/downloaded") || query.contains("/outdated") || query.contains("/enabled") || query.contains("/disabled") || query.contains("/invalid") || query.contains("/bundled")) {
                            return;
                        }
                        this.myPanel.getEmptyText().appendSecondaryText(IdeBundle.message((String)"plugins.configurable.search.in.marketplace", (Object[])new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, e -> PluginManagerConfigurablePanel.this.myTabHeaderComponent.setSelectionWithEvents(0));
                    }

                    @Override
                    protected void handleQuery(@NotNull String query, @NotNull PluginsGroup result2, AtomicBoolean runQuery) {
                        if (query == null) {
                            6.$$$reportNull$$$0(1);
                        }
                        if (result2 == null) {
                            6.$$$reportNull$$$0(2);
                        }
                        int searchIndex = PluginManagerUsageCollector.updateAndGetSearchIndex();
                        PluginManagerConfigurablePanel.this.myPluginModelFacade.getModel().setInvalidFixCallback(null);
                        SearchQueryParser.Installed parser = new SearchQueryParser.Installed(query);
                        if (PluginManagerConfigurablePanel.this.myInstalledSearchSetState) {
                            for (AnAction action2 : PluginManagerConfigurablePanel.this.myInstalledSearchGroup.getChildren(ActionManager.getInstance())) {
                                ((InstalledSearchOptionAction)action2).setState(parser);
                            }
                        }
                        List<PluginUiModel> descriptors2 = PluginManagerConfigurablePanel.this.myPluginModelFacade.getModel().getInstalledDescriptors();
                        if (!parser.vendors.isEmpty()) {
                            Iterator<PluginUiModel> I = descriptors2.iterator();
                            while (I.hasNext()) {
                                if (MyPluginModel.isVendor(I.next(), parser.vendors)) continue;
                                I.remove();
                            }
                        }
                        if (!parser.tags.isEmpty()) {
                            String sessionId = PluginManagerConfigurablePanel.this.myPluginModelFacade.getModel().getSessionId();
                            Iterator<PluginUiModel> I = descriptors2.iterator();
                            while (I.hasNext()) {
                                if (ContainerUtil.intersects(PluginUiModelKt.calculateTags(I.next(), sessionId), parser.tags)) continue;
                                I.remove();
                            }
                        }
                        Iterator<PluginUiModel> I = descriptors2.iterator();
                        while (I.hasNext()) {
                            PluginUiModel descriptor2 = I.next();
                            if (parser.attributes) {
                                if (!(!parser.enabled || PluginManagerConfigurablePanel.this.myPluginModelFacade.isEnabled(descriptor2) && PluginManagerConfigurablePanel.this.myPluginModelFacade.getErrors(descriptor2).isEmpty())) {
                                    I.remove();
                                    continue;
                                }
                                if (parser.disabled && (PluginManagerConfigurablePanel.this.myPluginModelFacade.isEnabled(descriptor2) || !PluginManagerConfigurablePanel.this.myPluginModelFacade.getErrors(descriptor2).isEmpty())) {
                                    I.remove();
                                    continue;
                                }
                                if (parser.bundled && !descriptor2.isBundled()) {
                                    I.remove();
                                    continue;
                                }
                                if (parser.downloaded && descriptor2.isBundled()) {
                                    I.remove();
                                    continue;
                                }
                                if (parser.invalid && PluginManagerConfigurablePanel.this.myPluginModelFacade.getErrors(descriptor2).isEmpty()) {
                                    I.remove();
                                    continue;
                                }
                                if (parser.needUpdate && !UiPluginManager.getInstance().isNeedUpdate(descriptor2.getPluginId())) {
                                    I.remove();
                                    continue;
                                }
                            }
                            if (parser.searchQuery == null || PluginManagerConfigurablePanel.containsQuery(descriptor2, parser.searchQuery)) continue;
                            I.remove();
                        }
                        result2.addModels(descriptors2);
                        Map<PluginId, CheckErrorsResult> errors = UiPluginManager.getInstance().loadErrors(PluginManagerConfigurablePanel.this.myPluginModelFacade.getModel().mySessionId.toString(), ContainerUtil.map(descriptors2, PluginUiModel::getPluginId));
                        result2.getPreloadedModel().setErrors(MyPluginModel.getErrors(errors));
                        result2.getPreloadedModel().setPluginInstallationStates(UiPluginManager.getInstance().getInstallationStatesSync());
                        PluginManagerUsageCollector.performInstalledTabSearch(ProjectUtil.getActiveProject(), parser, result2.getModels(), searchIndex, null);
                        if (!result2.getModels().isEmpty()) {
                            if (parser.invalid) {
                                PluginManagerConfigurablePanel.this.myPluginModelFacade.getModel().setInvalidFixCallback(() -> {
                                    PluginsGroup group2 = PluginManagerConfigurablePanel.this.myInstalledSearchPanel.getGroup();
                                    if (group2.ui == null) {
                                        PluginManagerConfigurablePanel.this.myPluginModelFacade.getModel().setInvalidFixCallback(null);
                                        return;
                                    }
                                    PluginsGroupComponent resultPanel = PluginManagerConfigurablePanel.this.myInstalledSearchPanel.getPanel();
                                    for (PluginUiModel descriptor2 : new ArrayList<PluginUiModel>(group2.getModels())) {
                                        if (!PluginManagerConfigurablePanel.this.myPluginModelFacade.getErrors(descriptor2).isEmpty()) continue;
                                        resultPanel.removeFromGroup(group2, descriptor2);
                                    }
                                    group2.titleWithCount();
                                    PluginManagerConfigurablePanel.this.myInstalledSearchPanel.fullRepaint();
                                    if (group2.getModels().isEmpty()) {
                                        PluginManagerConfigurablePanel.this.myPluginModelFacade.getModel().setInvalidFixCallback(null);
                                        PluginManagerConfigurablePanel.this.myInstalledSearchPanel.removeGroup();
                                    }
                                });
                            } else if (parser.needUpdate) {
                                result2.rightAction = new LinkLabelButton<Object>(IdeBundle.message((String)"plugin.manager.update.all", (Object[])new Object[0]), null, (__, ___) -> {
                                    result2.rightAction.setEnabled(false);
                                    for (ListPluginComponent plugin : result2.ui.plugins) {
                                        plugin.updatePlugin();
                                    }
                                });
                            }
                            PluginModelAsyncOperationsExecutor.INSTANCE.loadUpdates(PluginManagerConfigurablePanel.this.myCoroutineScope, (Function1<? super List<? extends PluginUiModel>, Unit>)((Function1)updates -> {
                                if (!ContainerUtil.isEmpty((Collection)updates)) {
                                    this.myPostFillGroupCallback = () -> {
                                        PluginManagerConfigurablePanel.applyUpdates(this.myPanel, updates);
                                        selectionListener2.accept(PluginManagerConfigurablePanel.this.myInstalledPanel);
                                        selectionListener2.accept(PluginManagerConfigurablePanel.this.myInstalledSearchPanel.getPanel());
                                    };
                                }
                                return null;
                            }));
                        }
                        this.updatePanel(runQuery);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "query";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "result";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurablePanel$13$6";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "setEmptyText";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "handleQuery";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                if (searchResultPanel == null) {
                    13.$$$reportNull$$$0(6);
                }
                return searchResultPanel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 3, 6 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "searchListener";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurablePanel$13";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "selectionListener";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurablePanel$13";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createDetailsPanel";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createPluginsPanel";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createSearchPanel";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createDetailsPanel";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "createPluginsPanel";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "updateMainSelection";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "createSearchPanel";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 3, 6 -> new IllegalStateException(string);
                };
            }
        };
        this.myPluginModelFacade.getModel().setCancelInstallCallback((Function1<? super PluginUiModel, Unit>)((Function1)descriptor2 -> {
            if (this.myInstalledSearchPanel == null) {
                return null;
            }
            PluginsGroup group2 = this.myInstalledSearchPanel.getGroup();
            if (group2.ui != null && group2.ui.findComponent(descriptor2.getPluginId()) != null) {
                this.myInstalledSearchPanel.getPanel().removeFromGroup(group2, (PluginUiModel)descriptor2);
                group2.titleWithCount();
                this.myInstalledSearchPanel.fullRepaint();
                if (group2.getModels().isEmpty()) {
                    this.myInstalledSearchPanel.removeGroup();
                }
            }
            return null;
        }));
    }

    private void addSuggestedGroup(@NotNull List<? super PluginsGroup> groups, @NotNull @NotNull Map<@NotNull PluginId, @NotNull List<@NotNull HtmlChunk>> errors, @NotNull @NotNull List<@NotNull PluginUiModel> plugins2, @NotNull @NotNull Map<@NotNull PluginId, @NotNull PluginUiModel> installedPlugins, @NotNull @NotNull Map<@NotNull PluginId, @NotNull PluginInstallationState> installationStates) {
        if (groups == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(7);
        }
        if (errors == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(8);
        }
        if (plugins2 == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(9);
        }
        if (installedPlugins == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(10);
        }
        if (installationStates == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(11);
        }
        String groupName = IdeBundle.message((String)"plugins.configurable.suggested", (Object[])new Object[0]);
        LOG.info("Marketplace tab: '" + groupName + "' group load started");
        for (PluginUiModel plugin : plugins2) {
            if (plugin.isFromMarketplace()) {
                plugin.setInstallSource(FUSEventSource.PLUGINS_SUGGESTED_GROUP);
            }
            FUSEventSource.PLUGINS_SUGGESTED_GROUP.logPluginSuggested(plugin.getPluginId());
        }
        this.addGroup(groups, groupName, PluginsGroupType.SUGGESTED, "", plugins2, group2 -> false, errors, installedPlugins, installationStates);
    }

    private static void setState(PluginModelFacade pluginModelFacade, Collection<PluginUiModel> models, boolean isEnable) {
        if (models.isEmpty()) {
            return;
        }
        List<PluginId> pluginsRequiringUltimate = UiPluginManager.getInstance().filterPluginsRequiringUltimateButItsDisabled(ContainerUtil.map(models, PluginUiModel::getPluginId));
        List<PluginUiModel> suitableDescriptors = models.stream().filter(descriptor2 -> !pluginsRequiringUltimate.contains(descriptor2.getPluginId())).toList();
        if (suitableDescriptors.isEmpty()) {
            return;
        }
        if (isEnable) {
            pluginModelFacade.enable(suitableDescriptors);
        } else {
            pluginModelFacade.disable(suitableDescriptors);
        }
    }

    private static boolean containsQuery(PluginUiModel descriptor2, String searchQuery) {
        if (descriptor2.getName() == null) {
            return false;
        }
        if (StringUtil.containsIgnoreCase((String)descriptor2.getName(), (String)searchQuery)) {
            return true;
        }
        String description = descriptor2.getDescription();
        return description != null && StringUtil.containsIgnoreCase((String)description, (String)searchQuery);
    }

    private static void clearUpdates(@NotNull PluginsGroupComponent panel2) {
        if (panel2 == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(12);
        }
        for (UIPluginGroup group2 : panel2.getGroups()) {
            for (ListPluginComponent plugin : group2.plugins) {
                plugin.setUpdateDescriptor((IdeaPluginDescriptor)null);
            }
        }
    }

    private static void applyUpdates(@NotNull PluginsGroupComponent panel2, @NotNull Collection<PluginUiModel> updates) {
        if (panel2 == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(13);
        }
        if (updates == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(14);
        }
        block0: for (PluginUiModel descriptor2 : updates) {
            for (UIPluginGroup group2 : panel2.getGroups()) {
                ListPluginComponent component2 = group2.findComponent(descriptor2.getPluginId());
                if (component2 == null) continue;
                component2.setUpdateDescriptor(descriptor2);
                continue block0;
            }
        }
    }

    private void applyBundledUpdates(@Nullable Collection<? extends PluginUiModel> updates) {
        if (ContainerUtil.isEmpty(updates)) {
            if (this.myBundledUpdateGroup.ui != null) {
                this.myInstalledPanel.removeGroup(this.myBundledUpdateGroup);
                this.myInstalledPanel.doLayout();
            }
        } else if (this.myBundledUpdateGroup.ui == null) {
            block0: for (PluginUiModel pluginUiModel : updates) {
                for (UIPluginGroup group2 : this.myInstalledPanel.getGroups()) {
                    ListPluginComponent component2 = group2.findComponent(pluginUiModel.getPluginId());
                    if (component2 == null || !component2.getPluginModel().isBundled()) continue;
                    this.myBundledUpdateGroup.addModel(component2.getPluginModel());
                    continue block0;
                }
            }
            if (!this.myBundledUpdateGroup.getModels().isEmpty()) {
                this.myInstalledPanel.addGroup(this.myBundledUpdateGroup, 0);
                this.myBundledUpdateGroup.ui.excluded = true;
                for (PluginUiModel pluginUiModel : updates) {
                    ListPluginComponent listPluginComponent = this.myBundledUpdateGroup.ui.findComponent(pluginUiModel.getPluginId());
                    if (listPluginComponent == null) continue;
                    listPluginComponent.setUpdateDescriptor(pluginUiModel);
                }
                this.myInstalledPanel.doLayout();
            }
        } else {
            ArrayList<ListPluginComponent> toDelete = new ArrayList<ListPluginComponent>();
            for (ListPluginComponent listPluginComponent : this.myBundledUpdateGroup.ui.plugins) {
                boolean exist = false;
                for (PluginUiModel pluginUiModel : updates) {
                    if (!listPluginComponent.getPluginModel().getPluginId().equals((Object)pluginUiModel.getPluginId())) continue;
                    exist = true;
                    break;
                }
                if (exist) continue;
                toDelete.add(listPluginComponent);
            }
            for (ListPluginComponent listPluginComponent : toDelete) {
                this.myInstalledPanel.removeFromGroup(this.myBundledUpdateGroup, listPluginComponent.getPluginModel());
            }
            block6: for (PluginUiModel pluginUiModel : updates) {
                ListPluginComponent exist = this.myBundledUpdateGroup.ui.findComponent(pluginUiModel.getPluginId());
                if (exist != null) continue;
                for (UIPluginGroup uIPluginGroup : this.myInstalledPanel.getGroups()) {
                    ListPluginComponent component5;
                    if (uIPluginGroup == this.myBundledUpdateGroup.ui || (component5 = uIPluginGroup.findComponent(pluginUiModel.getPluginId())) == null || !component5.getPluginModel().isBundled()) continue;
                    this.myInstalledPanel.addToGroup(this.myBundledUpdateGroup, component5.getPluginModel());
                    continue block6;
                }
            }
            if (this.myBundledUpdateGroup.getModels().isEmpty()) {
                this.myInstalledPanel.removeGroup(this.myBundledUpdateGroup);
            } else {
                for (PluginUiModel pluginUiModel : updates) {
                    ListPluginComponent component6 = this.myBundledUpdateGroup.ui.findComponent(pluginUiModel.getPluginId());
                    if (component6 == null) continue;
                    component6.setUpdateDescriptor(pluginUiModel);
                }
            }
            this.myInstalledPanel.doLayout();
        }
        this.myUpdateAll.setVisible(this.myUpdateAll.isVisible() && this.myBundledUpdateGroup.ui == null);
        this.myUpdateCounter.setVisible(this.myUpdateCounter.isVisible() && this.myBundledUpdateGroup.ui == null);
    }

    public static void registerCopyProvider(final @NotNull PluginsGroupComponent component2) {
        if (component2 == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(15);
        }
        CopyProvider copyProvider = new CopyProvider(){

            public void performCopy(@NotNull DataContext dataContext2) {
                if (dataContext2 == null) {
                    14.$$$reportNull$$$0(0);
                }
                String text2 = StringUtil.join(component2.getSelection(), pluginComponent -> {
                    PluginUiModel model2 = pluginComponent.getPluginModel();
                    return String.format("%s (%s)", model2.getName(), model2.getVersion());
                }, (String)"\n");
                CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable(text2));
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    14.$$$reportNull$$$0(1);
                }
                return actionUpdateThread;
            }

            public boolean isCopyEnabled(@NotNull DataContext dataContext2) {
                if (dataContext2 == null) {
                    14.$$$reportNull$$$0(2);
                }
                return !component2.getSelection().isEmpty();
            }

            public boolean isCopyVisible(@NotNull DataContext dataContext2) {
                if (dataContext2 == null) {
                    14.$$$reportNull$$$0(3);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataContext";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurablePanel$14";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurablePanel$14";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "performCopy";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isCopyEnabled";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "isCopyVisible";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        DataManager.registerDataProvider((JComponent)((Object)component2), dataId -> PlatformDataKeys.COPY_PROVIDER.is(dataId) ? copyProvider : null);
    }

    void setInstallSource(@Nullable FUSEventSource source) {
        this.myPluginModelFacade.getModel().setInstallSource(source);
    }

    @NotNull
    public static JComponent createScrollPane(@NotNull PluginsGroupComponent panel2, boolean initSelection) {
        if (panel2 == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(16);
        }
        JBScrollPane pane2 = new JBScrollPane((Component)((Object)panel2), 20, 31);
        pane2.setBorder((Border)JBUI.Borders.empty());
        if (initSelection) {
            panel2.initialSelection();
        }
        JBScrollPane jBScrollPane = pane2;
        if (jBScrollPane == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(17);
        }
        return jBScrollPane;
    }

    private void addGroup(@NotNull List<? super PluginsGroup> groups, @NotNull @Nls String name2, @NotNull PluginsGroupType type, @NotNull String showAllQuery, @NotNull List<PluginUiModel> customPlugins2, @NotNull Predicate<? super PluginsGroup> showAllPredicate, @NotNull Map<PluginId, List<HtmlChunk>> errors, @NotNull Map<PluginId, PluginUiModel> installedPlugins, @NotNull Map<PluginId, PluginInstallationState> installationStates) {
        if (groups == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(18);
        }
        if (name2 == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(19);
        }
        if (type == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(20);
        }
        if (showAllQuery == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(21);
        }
        if (customPlugins2 == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(22);
        }
        if (showAllPredicate == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(23);
        }
        if (errors == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(24);
        }
        if (installedPlugins == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(25);
        }
        if (installationStates == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(26);
        }
        PluginsGroup group2 = new PluginsGroup(name2, type);
        group2.getPreloadedModel().setErrors(errors);
        group2.getPreloadedModel().setInstalledPlugins(installedPlugins);
        group2.getPreloadedModel().setPluginInstallationStates(installationStates);
        Iterator<PluginUiModel> iterator = customPlugins2.iterator();
        for (int i2 = 0; iterator.hasNext() && i2 < 9; ++i2) {
            group2.addModel(iterator.next());
        }
        if (showAllPredicate.test(group2)) {
            group2.rightAction = new LinkLabelButton<String>(IdeBundle.message((String)"plugins.configurable.show.all", (Object[])new Object[0]), null, this.myMarketplaceTab.searchListener, showAllQuery);
            group2.rightAction.setBorder((Border)JBUI.Borders.emptyRight((int)5));
        }
        if (!group2.getModels().isEmpty()) {
            groups.add(group2);
        }
        LOG.info("Marketplace tab: '" + name2 + "' group load finished");
    }

    private void addGroupViaLightDescriptor(@NotNull List<? super PluginsGroup> groups, @NotNull @Nls String name2, @NotNull PluginsGroupType type, @NotNull @NonNls String query, @NotNull @NonNls String showAllQuery, @NotNull Map<String, PluginSearchResult> marketplaceData, @NotNull Map<PluginId, List<HtmlChunk>> errors, @NotNull Map<PluginId, PluginUiModel> installedPluginIds, @NotNull Map<PluginId, PluginInstallationState> installationStates) throws IOException {
        if (groups == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(27);
        }
        if (name2 == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(28);
        }
        if (type == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(29);
        }
        if (query == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(30);
        }
        if (showAllQuery == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(31);
        }
        if (marketplaceData == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(32);
        }
        if (errors == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(33);
        }
        if (installedPluginIds == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(34);
        }
        if (installationStates == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(35);
        }
        LOG.info("Marketplace tab: '" + name2 + "' group load started");
        PluginSearchResult searchResult = marketplaceData.get(query);
        if (searchResult.getError() != null) {
            throw new IOException(searchResult.getError());
        }
        List<PluginUiModel> plugins2 = searchResult.getPlugins();
        for (PluginUiModel plugin : plugins2) {
            plugin.setInstallSource(FUSEventSource.PLUGINS_STAFF_PICKS_GROUP);
            FUSEventSource.PLUGINS_STAFF_PICKS_GROUP.logPluginSuggested(plugin.getPluginId());
        }
        this.addGroup(groups, name2, type, showAllQuery, plugins2, __ -> plugins2.size() >= 9, errors, installedPluginIds, installationStates);
    }

    public void dispose() {
        this.myDisposeStarted = true;
        if (ComponentUtil.getParentOfType(WelcomeScreen.class, (Component)this.myCardPanel) != null && this.isModified()) {
            this.scheduleApply();
        }
        InstalledPluginsState pluginsState = InstalledPluginsState.getInstance();
        if (this.myPluginModelFacade.getModel().toBackground()) {
            pluginsState.clearShutdownCallback();
        }
        if (this.myMarketplaceTab != null) {
            this.myMarketplaceTab.dispose();
        }
        if (this.myInstalledTab != null) {
            this.myInstalledTab.dispose();
        }
        if (this.myMarketplacePanel != null) {
            this.myMarketplacePanel.dispose();
        }
        if (this.myMarketplaceSearchPanel != null) {
            this.myMarketplaceSearchPanel.dispose();
        }
        if (this.myInstalledSearchPanel != null) {
            this.myInstalledSearchPanel.dispose();
        }
        this.myPluginUpdatesService.dispose();
        PluginPriceService.cancel();
        pluginsState.runShutdownCallback();
        pluginsState.resetChangesAppliedWithoutRestart();
        Disposer.dispose((Disposable)this);
        kotlinx.coroutines.CoroutineScopeKt.cancel((CoroutineScope)this.myCoroutineScope, null);
    }

    public void cancel() {
        this.myPluginModelFacade.getModel().cancel(this.myCardPanel, true);
        this.myPluginModelFacade.closeSession();
    }

    public boolean isModified() {
        if (this.myPluginsAutoUpdateEnabled != null && UpdateSettings.getInstance().getState().isPluginsAutoUpdateEnabled() != this.myPluginsAutoUpdateEnabled.booleanValue()) {
            return true;
        }
        return this.myPluginModelFacade.getModel().isModified();
    }

    public void scheduleApply() {
        ApplicationManager.getApplication().invokeLater(() -> {
            try {
                this.apply();
                WelcomeScreenEventCollector.logPluginsModified();
                if (this.myDisposeStarted.booleanValue()) {
                    InstalledPluginsState.getInstance().runShutdownCallback();
                }
            }
            catch (ConfigurationException exception) {
                Logger.getInstance(PluginsTabFactory.class).error((Throwable)exception);
            }
        }, ModalityState.nonModal());
    }

    public void apply() throws ConfigurationException {
        UpdateOptions state2;
        if (this.myPluginsAutoUpdateEnabled != null && (state2 = UpdateSettings.getInstance().getState()).isPluginsAutoUpdateEnabled() != this.myPluginsAutoUpdateEnabled.booleanValue()) {
            UiPluginManager.getInstance().setPluginsAutoUpdateEnabled(this.myPluginsAutoUpdateEnabled);
        }
        this.myPluginModelFacade.getModel().applyWithCallback(this.myCardPanel, installedWithoutRestart -> {
            if (installedWithoutRestart.booleanValue()) {
                return;
            }
            InstalledPluginsState installedPluginsState = InstalledPluginsState.getInstance();
            if (this.myPluginModelFacade.getModel().createShutdownCallback) {
                installedPluginsState.setShutdownCallback(() -> ApplicationManager.getApplication().invokeLater(() -> {
                    if (ApplicationManager.getApplication().isExitInProgress()) {
                        return;
                    }
                    if (this.myPluginManagerCustomizer != null) {
                        this.myPluginManagerCustomizer.requestRestart(this.myPluginModelFacade, this.myTabHeaderComponent);
                        return;
                    }
                    this.myPluginModelFacade.closeSession();
                    PluginManagerConfigurable.shutdownOrRestartApp();
                }));
            }
            if (this.myDisposeStarted.booleanValue()) {
                installedPluginsState.runShutdownCallback();
            }
        });
    }

    public void reset() {
        if (this.myPluginsAutoUpdateEnabled != null) {
            this.myPluginsAutoUpdateEnabled = UpdateSettings.getInstance().getState().isPluginsAutoUpdateEnabled();
        }
        this.myPluginModelFacade.getModel().clear(this.myCardPanel);
    }

    void selectAndEnable(@NotNull Set<? extends IdeaPluginDescriptor> descriptors2) {
        if (descriptors2 == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(36);
        }
        this.myPluginModelFacade.getModel().enable(descriptors2);
        this.select(ContainerUtil.map(descriptors2, PluginDescriptor::getPluginId));
    }

    void select(@NotNull Collection<PluginId> pluginIds) {
        if (pluginIds == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(37);
        }
        this.updateSelectionTab(1);
        ArrayList<ListPluginComponent> components = new ArrayList<ListPluginComponent>();
        for (PluginId pluginId : pluginIds) {
            ListPluginComponent component2 = this.findInstalledPluginById(pluginId);
            if (component2 == null) continue;
            components.add(component2);
        }
        if (!components.isEmpty()) {
            this.myInstalledPanel.setSelection(components);
        }
    }

    @Nullable
    public Runnable enableSearch(String option2) {
        return this.enableSearch(option2, false);
    }

    @Nullable
    public Runnable enableSearch(String option2, boolean ignoreTagMarketplaceTab) {
        if (StringUtil.isEmpty((String)option2) && (this.myTabHeaderComponent.getSelectionTab() == 0 || this.myInstalledSearchPanel.isEmpty())) {
            return null;
        }
        return () -> {
            boolean marketplace;
            boolean bl = marketplace = !ignoreTagMarketplaceTab && option2 != null && option2.startsWith(SearchWords.TAG.getValue());
            if (this.myShowMarketplaceTab) {
                marketplace = true;
                this.myShowMarketplaceTab = false;
            }
            this.updateSelectionTab(marketplace ? 0 : 1);
            PluginsTab tab = marketplace ? this.myMarketplaceTab : this.myInstalledTab;
            tab.clearSearchPanel(option2);
            if (!StringUtil.isEmpty((String)option2)) {
                tab.showSearchPanel(option2);
            }
        };
    }

    public void openMarketplaceTab(@NotNull String option2) {
        if (option2 == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(38);
        }
        this.myLaterSearchQuery = option2;
        this.myShowMarketplaceTab = true;
        if (this.myTabHeaderComponent != null) {
            this.updateSelectionTab(0);
        }
        if (this.myMarketplaceTab != null) {
            this.myMarketplaceTab.clearSearchPanel(option2);
            this.myMarketplaceTab.showSearchPanel(option2);
        }
    }

    public void openInstalledTab(@NotNull String option2) {
        if (option2 == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(39);
        }
        this.myLaterSearchQuery = option2;
        this.myShowMarketplaceTab = false;
        this.myForceShowInstalledTabForTag = true;
        if (this.myTabHeaderComponent != null) {
            this.updateSelectionTab(1);
        }
    }

    @RequiresEdt
    private void onPluginInstalledFromDisk(@NotNull PluginInstallCallbackData callbackData) {
        if (callbackData == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(40);
        }
        ThreadingAssertions.assertEventDispatchThread();
        PluginModelAsyncOperationsExecutor.INSTANCE.updateErrors(this.myCoroutineScope, this.myPluginModelFacade.getModel().getSessionId(), callbackData.getPluginDescriptor().getPluginId(), (Function1<? super List<? extends HtmlChunk>, Unit>)((Function1)errors -> {
            this.updateAfterPluginInstalledFromDisk(callbackData, (List<HtmlChunk>)errors);
            return null;
        }));
    }

    private void updateAfterPluginInstalledFromDisk(@NotNull PluginInstallCallbackData callbackData, List<HtmlChunk> errors) {
        ListPluginComponent component2;
        if (callbackData == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(41);
        }
        this.myPluginModelFacade.getModel().pluginInstalledFromDisk(callbackData, errors);
        boolean select = this.myInstalledPanel == null;
        this.updateSelectionTab(1);
        this.myInstalledTab.clearSearchPanel("");
        ListPluginComponent listPluginComponent = component2 = select ? this.findInstalledPluginById(callbackData.getPluginDescriptor().getPluginId()) : null;
        if (component2 != null) {
            this.myInstalledPanel.setSelection(component2);
        }
    }

    private void updateSelectionTab(int tab) {
        if (this.myTabHeaderComponent.getSelectionTab() != tab) {
            this.myTabHeaderComponent.setSelectionWithEvents(tab);
        }
    }

    @NotNull
    private List<UIPluginGroup> getInstalledGroups() {
        List<UIPluginGroup> list2 = this.myInstalledPanel.getGroups();
        if (list2 == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(42);
        }
        return list2;
    }

    @Nullable
    private ListPluginComponent findInstalledPluginById(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            PluginManagerConfigurablePanel.$$$reportNull$$$0(43);
        }
        for (UIPluginGroup group2 : this.getInstalledGroups()) {
            ListPluginComponent component2 = group2.findComponent(pluginId);
            if (component2 == null) continue;
            return component2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 17, 42 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 17: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurablePanel";
                break;
            }
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 7: 
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 8: 
            case 24: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 10: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installedPlugins";
                break;
            }
            case 11: 
            case 26: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installationStates";
                break;
            }
            case 12: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updates";
                break;
            }
            case 19: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 20: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 21: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "showAllQuery";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customPlugins";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "showAllPredicate";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marketplaceData";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installedPluginIds";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIds";
                break;
            }
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callbackData";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurablePanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCenterComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createGearActions";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createScrollPane";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledGroups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCenterComponent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 17: 
            case 42: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showRightBottomPopup";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addSuggestedGroup";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "clearUpdates";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "applyUpdates";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "registerCopyProvider";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createScrollPane";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addGroup";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addGroupViaLightDescriptor";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "selectAndEnable";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "openMarketplaceTab";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "openInstalledTab";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "onPluginInstalledFromDisk";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "updateAfterPluginInstalledFromDisk";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "findInstalledPluginById";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 17, 42 -> new IllegalStateException(string);
        };
    }

    private static class LinkLabelButton<T>
    extends LinkLabel<T> {
        private LinkLabelButton(@NlsContexts.LinkLabel String text2, @Nullable Icon icon2) {
            super(text2, icon2);
        }

        private LinkLabelButton(@NlsContexts.LinkLabel String text2, @Nullable Icon icon2, @Nullable LinkListener<T> aListener) {
            super(text2, icon2, aListener);
        }

        private LinkLabelButton(@NlsContexts.LinkLabel String text2, @Nullable Icon icon2, @Nullable LinkListener<T> aListener, @Nullable T aLinkData) {
            super(text2, icon2, aListener, aLinkData);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleLinkLabelButton();
            }
            return this.accessibleContext;
        }

        protected class AccessibleLinkLabelButton
        extends LinkLabel.AccessibleLinkLabel {
            protected AccessibleLinkLabelButton() {
                super((LinkLabel)LinkLabelButton.this);
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.PUSH_BUTTON;
            }
        }
    }

    private final class ChangePluginStateAction
    extends DumbAwareAction {
        private final boolean myEnable;

        private ChangePluginStateAction(boolean enable2) {
            super(enable2 ? IdeBundle.message((String)"plugins.configurable.enable.all.downloaded", (Object[])new Object[0]) : IdeBundle.message((String)"plugins.configurable.disable.all.downloaded", (Object[])new Object[0]));
            this.myEnable = enable2;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ChangePluginStateAction.$$$reportNull$$$0(0);
            }
            PluginModelAsyncOperationsExecutor.INSTANCE.switchPlugins(PluginManagerConfigurablePanel.this.myCoroutineScope, PluginManagerConfigurablePanel.this.myPluginModelFacade, this.myEnable, (Function1<? super List<? extends PluginUiModel>, Unit>)((Function1)models -> {
                PluginManagerConfigurablePanel.setState(PluginManagerConfigurablePanel.this.myPluginModelFacade, models, this.myEnable);
                return null;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/PluginManagerConfigurablePanel$ChangePluginStateAction", "actionPerformed"));
        }
    }

    private static final class GroupByActionGroup
    extends DefaultActionGroup
    implements CheckedActionGroup {
        private GroupByActionGroup() {
        }
    }

    private static enum InstalledSearchOption {
        Downloaded(IdeBundle.messagePointer((String)"plugins.configurable.InstalledSearchOption.Downloaded", (Object[])new Object[0])),
        NeedUpdate(IdeBundle.messagePointer((String)"plugins.configurable.InstalledSearchOption.NeedUpdate", (Object[])new Object[0])),
        Enabled(IdeBundle.messagePointer((String)"plugins.configurable.InstalledSearchOption.Enabled", (Object[])new Object[0])),
        Disabled(IdeBundle.messagePointer((String)"plugins.configurable.InstalledSearchOption.Disabled", (Object[])new Object[0])),
        Invalid(IdeBundle.messagePointer((String)"plugins.configurable.InstalledSearchOption.Invalid", (Object[])new Object[0])),
        Bundled(IdeBundle.messagePointer((String)"plugins.configurable.InstalledSearchOption.Bundled", (Object[])new Object[0]));

        private final Supplier<@Nls String> myPresentableNameSupplier;

        private InstalledSearchOption(Supplier<String> name2) {
            this.myPresentableNameSupplier = name2;
        }
    }

    private final class InstalledSearchOptionAction
    extends ToggleAction
    implements DumbAware {
        private final InstalledSearchOption myOption;
        private boolean myState;

        private InstalledSearchOptionAction(InstalledSearchOption option2) {
            if (option2 == null) {
                InstalledSearchOptionAction.$$$reportNull$$$0(0);
            }
            super(option2.myPresentableNameSupplier);
            this.getTemplatePresentation().setKeepPopupOnPerform(KeepPopupOnPerform.IfRequested);
            this.myOption = option2;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                InstalledSearchOptionAction.$$$reportNull$$$0(1);
            }
            return this.myState;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state2) {
            if (e == null) {
                InstalledSearchOptionAction.$$$reportNull$$$0(2);
            }
            this.myState = state2;
            PluginManagerConfigurablePanel.this.myInstalledSearchCallback.accept(this);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                InstalledSearchOptionAction.$$$reportNull$$$0(3);
            }
            return actionUpdateThread;
        }

        public void setState(@Nullable SearchQueryParser.Installed parser) {
            if (parser == null) {
                this.myState = false;
                return;
            }
            this.myState = switch (this.myOption.ordinal()) {
                default -> throw new MatchException(null, null);
                case 2 -> parser.enabled;
                case 3 -> parser.disabled;
                case 0 -> parser.downloaded;
                case 5 -> parser.bundled;
                case 4 -> parser.invalid;
                case 1 -> parser.needUpdate;
            };
        }

        @NotNull
        public String getQuery() {
            Object object = this.myOption == InstalledSearchOption.NeedUpdate ? "/outdated" : "/" + StringUtil.decapitalize((String)this.myOption.name());
            if (object == null) {
                InstalledSearchOptionAction.$$$reportNull$$$0(4);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "option";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurablePanel$InstalledSearchOptionAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurablePanel$InstalledSearchOptionAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQuery";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    private final class MarketplaceSortByAction
    extends ToggleAction
    implements DumbAware {
        private final SortBy myOption;
        private boolean myState;
        private boolean myVisible;

        private MarketplaceSortByAction(SortBy option2) {
            if (option2 == null) {
                MarketplaceSortByAction.$$$reportNull$$$0(0);
            }
            super(option2.getPresentableNameSupplier());
            this.getTemplatePresentation().setKeepPopupOnPerform(KeepPopupOnPerform.IfRequested);
            this.myOption = option2;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MarketplaceSortByAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            e.getPresentation().setVisible(this.myVisible);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MarketplaceSortByAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MarketplaceSortByAction.$$$reportNull$$$0(3);
            }
            return this.myState;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state2) {
            if (e == null) {
                MarketplaceSortByAction.$$$reportNull$$$0(4);
            }
            this.myState = state2;
            PluginManagerConfigurablePanel.this.myMarketplaceSortByCallback.accept(this);
        }

        public void setState(@NotNull SearchQueryParser.Marketplace parser) {
            if (parser == null) {
                MarketplaceSortByAction.$$$reportNull$$$0(5);
            }
            if (this.myOption == SortBy.RELEVANCE) {
                this.myState = parser.sortBy == null;
                this.myVisible = parser.sortBy == null || !parser.tags.isEmpty() || !parser.vendors.isEmpty() || parser.searchQuery != null;
            } else {
                this.myState = parser.sortBy != null && this.myOption == parser.sortBy;
                this.myVisible = true;
            }
        }

        @Nullable
        public String getQuery() {
            if (this.myOption == SortBy.RELEVANCE) {
                return null;
            }
            return SearchWords.SORT_BY.getValue() + this.myOption.getQuery();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "option";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurablePanel$MarketplaceSortByAction";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurablePanel$MarketplaceSortByAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setState";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private final class ComparablePluginsGroup
    extends PluginsGroup
    implements Comparable<ComparablePluginsGroup> {
        private boolean myIsEnable;

        private ComparablePluginsGroup(@NotNull String category, @NotNull List<PluginUiModel> descriptors2, Map<PluginId, Boolean> pluginsRequiresUltimate) {
            if (category == null) {
                ComparablePluginsGroup.$$$reportNull$$$0(0);
            }
            if (descriptors2 == null) {
                ComparablePluginsGroup.$$$reportNull$$$0(1);
            }
            if (pluginsRequiresUltimate == null) {
                ComparablePluginsGroup.$$$reportNull$$$0(2);
            }
            super(category, PluginsGroupType.INSTALLED);
            this.myIsEnable = false;
            this.addModels(descriptors2);
            this.sortByName();
            this.rightAction = new LinkLabelButton("", null, (__, ___) -> this.setEnabledState());
            boolean hasPluginsAvailableForEnableDisable = ContainerUtil.exists(descriptors2, it -> (Boolean)pluginsRequiresUltimate.get(it.getPluginId()) == false);
            this.rightAction.setVisible(hasPluginsAvailableForEnableDisable);
            this.titleWithEnabled(PluginManagerConfigurablePanel.this.myPluginModelFacade);
        }

        @Override
        public int compareTo(@NotNull ComparablePluginsGroup other) {
            if (other == null) {
                ComparablePluginsGroup.$$$reportNull$$$0(3);
            }
            return StringUtil.compare((String)this.title, (String)other.title, (boolean)true);
        }

        @Override
        public void titleWithCount(int enabled2) {
            this.myIsEnable = enabled2 == 0;
            String key = this.myIsEnable ? "plugins.configurable.enable.all" : "plugins.configurable.disable.all";
            this.rightAction.setText(IdeBundle.message((String)key, (Object[])new Object[0]));
        }

        private void setEnabledState() {
            PluginManagerConfigurablePanel.setState(PluginManagerConfigurablePanel.this.myPluginModelFacade, this.getModels(), this.myIsEnable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "category";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptors";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginsRequiresUltimate";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurablePanel$ComparablePluginsGroup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

