/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginMainDescriptor;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/plugins/StartupPluginLoadingErrorReporter;", "", "<init>", "()V", "onEnable", "", "enabled", "onEvent", "", "description", "", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class StartupPluginLoadingErrorReporter {
    @NotNull
    public static final StartupPluginLoadingErrorReporter INSTANCE = new StartupPluginLoadingErrorReporter();

    private StartupPluginLoadingErrorReporter() {
    }

    @JvmStatic
    public static final synchronized boolean onEnable(boolean enabled2) {
        Set pluginIds;
        Pair pair = PluginManagerCore.INSTANCE.consumeStartupActionsPluginsToEnableDisable();
        Set pluginsToEnable = (Set)pair.component1();
        Set pluginsToDisable = (Set)pair.component2();
        Set set = pluginIds = enabled2 ? pluginsToEnable : pluginsToDisable;
        if (pluginIds.isEmpty()) {
            return false;
        }
        ArrayList<PluginMainDescriptor> descriptors2 = new ArrayList<PluginMainDescriptor>();
        for (PluginMainDescriptor descriptor2 : PluginManagerCore.getPluginSet().allPlugins) {
            if (!pluginIds.contains(descriptor2.getPluginId())) continue;
            descriptor2.setMarkedForLoading(enabled2);
            descriptors2.add(descriptor2);
        }
        PluginEnabler pluginEnabler = PluginEnabler.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)pluginEnabler, (String)"getInstance(...)");
        PluginEnabler pluginEnabler2 = pluginEnabler;
        boolean bl = enabled2 ? pluginEnabler2.enable((Collection)descriptors2) : pluginEnabler2.disable((Collection)descriptors2);
        return true;
    }

    @ApiStatus.Internal
    public final void onEvent(@NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        switch (description) {
            case "disable": {
                StartupPluginLoadingErrorReporter.onEnable(false);
                break;
            }
            case "enable": {
                if (!StartupPluginLoadingErrorReporter.onEnable(true)) break;
                PluginManagerMain.notifyPluginsUpdated(null);
                break;
            }
            case "edit": {
                IdeFrame frame;
                IdeFrame ideFrame = frame = WindowManagerEx.getInstanceEx().findFrameFor(null);
                PluginManagerConfigurable.showPluginConfigurable(ideFrame != null ? ideFrame.getComponent() : null, null, new ArrayList());
            }
        }
    }
}

