/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.marketplace;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.plugins.auth.PluginRepositoryAuthService;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.RequestBuilder;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\f\u001a\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0004H\u0002\u001a\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u001a\u001c\u0010\u0018\u001a\u00020\u0012*\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "PLUGIN_NAMES_IN_COMMUNITY_EDITION", "", "", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "objectMapper$delegate", "Lkotlin/Lazy;", "setHeadersViaTuner", "Lcom/intellij/util/io/RequestBuilder;", "loadETagForFile", "file", "Ljava/nio/file/Path;", "getETagFile", "saveETagForFile", "", "eTag", "isNotModified", "", "urlConnection", "Ljava/net/URLConnection;", "infoOrDebug", "message", "throwable", "", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nMarketplaceRequests.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarketplaceRequests.kt\ncom/intellij/ide/plugins/marketplace/MarketplaceRequestsKt\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,982:1\n50#2:983\n1#3:984\n13#4:985\n*S KotlinDebug\n*F\n+ 1 MarketplaceRequests.kt\ncom/intellij/ide/plugins/marketplace/MarketplaceRequestsKt\n*L\n909#1:983\n79#1:985\n*E\n"})
public final class MarketplaceRequestsKt {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Map<String, String> PLUGIN_NAMES_IN_COMMUNITY_EDITION;
    @NotNull
    private static final Lazy objectMapper$delegate;

    private static final ObjectMapper getObjectMapper() {
        Lazy lazy = objectMapper$delegate;
        return (ObjectMapper)lazy.getValue();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final RequestBuilder setHeadersViaTuner(@NotNull RequestBuilder $this$setHeadersViaTuner) {
        HttpRequests.ConnectionTuner connectionTuner;
        RequestBuilder requestBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$setHeadersViaTuner, (String)"<this>");
        if (!LoadingState.COMPONENTS_REGISTERED.isOccurred()) {
            requestBuilder = $this$setHeadersViaTuner;
            return requestBuilder;
        }
        boolean $i$f$serviceOrNull = false;
        Application application = ApplicationManager.getApplication();
        PluginRepositoryAuthService pluginRepositoryAuthService = (PluginRepositoryAuthService)(application != null ? application.getService(PluginRepositoryAuthService.class) : null);
        if (pluginRepositoryAuthService != null && (connectionTuner = pluginRepositoryAuthService.getConnectionTuner()) != null) {
            HttpRequests.ConnectionTuner p0 = connectionTuner;
            boolean bl = false;
            RequestBuilder requestBuilder2 = $this$setHeadersViaTuner.tuner(p0);
            if (requestBuilder2 != null) {
                requestBuilder = requestBuilder2;
                return requestBuilder;
            }
        }
        requestBuilder = $this$setHeadersViaTuner;
        return requestBuilder;
    }

    private static final String loadETagForFile(Path file2) {
        Path eTagFile = MarketplaceRequestsKt.getETagFile(file2);
        try {
            List<String> lines = Files.readAllLines(eTagFile);
            if (lines.size() == 1) {
                String string = lines.get(0);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
                return string;
            }
            LOG.warn("Can't load ETag from '" + eTagFile + "'. Unexpected number of lines: " + lines.size());
            Files.deleteIfExists(eTagFile);
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException e) {
            LOG.warn("Can't load ETag from '" + eTagFile + "'", (Throwable)e);
        }
        return "";
    }

    private static final Path getETagFile(Path file2) {
        Path path = file2.getParent().resolve(file2.getFileName() + ".etag");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private static final void saveETagForFile(Path file2, String eTag) {
        Path eTagFile = MarketplaceRequestsKt.getETagFile(file2);
        try {
            PathKt.write$default((Path)eTagFile, (CharSequence)eTag, null, (boolean)false, (int)6, null);
        }
        catch (IOException e) {
            LOG.warn("Can't save ETag to '" + eTagFile + "'", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isNotModified(URLConnection urlConnection, Path file2) {
        if (file2 == null) return false;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(file2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return false;
        if (Files.size(file2) <= 0L) return false;
        if (!(urlConnection instanceof HttpURLConnection)) return false;
        if (((HttpURLConnection)urlConnection).getResponseCode() != 304) return false;
        return true;
    }

    private static final void infoOrDebug(Logger $this$infoOrDebug, String message, Throwable throwable) {
        if ($this$infoOrDebug.isDebugEnabled()) {
            $this$infoOrDebug.debug(message, throwable);
        } else {
            $this$infoOrDebug.info(message + ": " + throwable.getMessage());
        }
    }

    private static final ObjectMapper objectMapper_delegate$lambda$0() {
        return new ObjectMapper();
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ void access$infoOrDebug(Logger $receiver, String message, Throwable throwable) {
        MarketplaceRequestsKt.infoOrDebug($receiver, message, throwable);
    }

    public static final /* synthetic */ ObjectMapper access$getObjectMapper() {
        return MarketplaceRequestsKt.getObjectMapper();
    }

    public static final /* synthetic */ String access$loadETagForFile(Path file2) {
        return MarketplaceRequestsKt.loadETagForFile(file2);
    }

    public static final /* synthetic */ boolean access$isNotModified(URLConnection urlConnection, Path file2) {
        return MarketplaceRequestsKt.isNotModified(urlConnection, file2);
    }

    public static final /* synthetic */ void access$saveETagForFile(Path file2, String eTag) {
        MarketplaceRequestsKt.saveETagForFile(file2, eTag);
    }

    public static final /* synthetic */ Map access$getPLUGIN_NAMES_IN_COMMUNITY_EDITION$p() {
        return PLUGIN_NAMES_IN_COMMUNITY_EDITION;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MarketplaceRequests.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        PLUGIN_NAMES_IN_COMMUNITY_EDITION = MapsKt.mapOf((Pair)TuplesKt.to((Object)"com.intellij.database", (Object)"Database Tools and SQL"));
        objectMapper$delegate = LazyKt.lazy(MarketplaceRequestsKt::objectMapper_delegate$lambda$0);
    }
}

