/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.util.io.Decompressor;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StartupActionScriptManager {
    @ApiStatus.Internal
    public static final String EARLY_ACTION_SCRIPT_FILE = "early.action.script";
    @ApiStatus.Internal
    public static final String ACTION_SCRIPT_FILE = "action.script";

    private StartupActionScriptManager() {
    }

    @ApiStatus.Internal
    public static synchronized void executeActionScript() throws IOException {
        StartupActionScriptManager.executeActionScriptImpl(StartupActionScriptManager.getActionScriptFile());
    }

    @ApiStatus.Internal
    public static synchronized void executeEarlyActionScript() throws IOException {
        StartupActionScriptManager.executeActionScriptImpl(StartupActionScriptManager.getEarlyActionScriptFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeActionScriptImpl(@NotNull Path scriptFile) throws IOException {
        if (scriptFile == null) {
            StartupActionScriptManager.$$$reportNull$$$0(0);
        }
        try {
            List<ActionCommand> commands = StartupActionScriptManager.loadActionScript(scriptFile);
            for (ActionCommand command : commands) {
                command.execute();
            }
        }
        finally {
            Files.deleteIfExists(scriptFile);
        }
    }

    @ApiStatus.Internal
    public static void executeActionScriptCommands(@NotNull List<? extends ActionCommand> commands, @NotNull Path oldTarget, @NotNull Path newTarget) throws IOException {
        if (commands == null) {
            StartupActionScriptManager.$$$reportNull$$$0(1);
        }
        if (oldTarget == null) {
            StartupActionScriptManager.$$$reportNull$$$0(2);
        }
        if (newTarget == null) {
            StartupActionScriptManager.$$$reportNull$$$0(3);
        }
        FileSystem fs = oldTarget.getFileSystem();
        for (ActionCommand actionCommand : commands) {
            ActionCommand toExecute = StartupActionScriptManager.mapPaths(actionCommand, oldTarget, newTarget);
            if (toExecute == null) continue;
            toExecute.execute(fs);
        }
    }

    public static synchronized void addActionCommand(@NotNull ActionCommand command) throws IOException {
        if (command == null) {
            StartupActionScriptManager.$$$reportNull$$$0(4);
        }
        StartupActionScriptManager.addActionCommands(List.of(command));
    }

    public static synchronized void addActionCommands(@NotNull List<? extends ActionCommand> commands) throws IOException {
        if (commands == null) {
            StartupActionScriptManager.$$$reportNull$$$0(5);
        }
        StartupActionScriptManager.addActionCommands(StartupActionScriptManager.getActionScriptFile(), commands, true);
    }

    @ApiStatus.Experimental
    public static synchronized void addActionCommandsToBeginning(@NotNull List<? extends ActionCommand> commands) throws IOException {
        if (commands == null) {
            StartupActionScriptManager.$$$reportNull$$$0(6);
        }
        StartupActionScriptManager.addActionCommands(StartupActionScriptManager.getActionScriptFile(), commands, false);
    }

    @ApiStatus.Internal
    public static synchronized void setMarketplacePluginUpdateActionScript(@NotNull List<? extends ActionCommand> commands) throws IOException {
        if (commands == null) {
            StartupActionScriptManager.$$$reportNull$$$0(7);
        }
        StartupActionScriptManager.saveActionScript(commands, StartupActionScriptManager.getEarlyActionScriptFile());
    }

    private static synchronized void addActionCommands(@NotNull Path scriptFile, @NotNull List<? extends ActionCommand> commands, boolean toEndOfScript) throws IOException {
        if (scriptFile == null) {
            StartupActionScriptManager.$$$reportNull$$$0(8);
        }
        if (commands == null) {
            StartupActionScriptManager.$$$reportNull$$$0(9);
        }
        ArrayList<ActionCommand> script = new ArrayList<ActionCommand>();
        List<ActionCommand> originalScript = null;
        if (Files.exists(scriptFile, new LinkOption[0])) {
            originalScript = StartupActionScriptManager.loadActionScript(scriptFile);
            script.addAll(originalScript);
        }
        if (toEndOfScript) {
            script.addAll(commands);
        } else {
            script.addAll(0, commands);
        }
        try {
            StartupActionScriptManager.saveActionScript(script, scriptFile);
        }
        catch (Throwable t) {
            if (originalScript != null) {
                try {
                    StartupActionScriptManager.saveActionScript(originalScript, scriptFile);
                }
                catch (Throwable tt) {
                    t.addSuppressed(tt);
                }
            }
            throw t;
        }
    }

    private static Path getActionScriptFile() {
        return PathManager.getStartupScriptDir().resolve(ACTION_SCRIPT_FILE);
    }

    private static Path getEarlyActionScriptFile() {
        return PathManager.getStartupScriptDir().resolve(EARLY_ACTION_SCRIPT_FILE);
    }

    /*
     * Loose catch block
     */
    @ApiStatus.Internal
    @NotNull
    public static List<ActionCommand> loadActionScript(@NotNull Path scriptFile) throws IOException {
        Object data2;
        ObjectInputStream ois;
        block12: {
            if (scriptFile == null) {
                StartupActionScriptManager.$$$reportNull$$$0(10);
            }
            ois = new ObjectInputStream(Files.newInputStream(scriptFile, new OpenOption[0]));
            data2 = ois.readObject();
            if (!(data2 instanceof ActionCommand[])) break block12;
            List<ActionCommand> list2 = Arrays.asList((ActionCommand[])data2);
            ois.close();
            List<ActionCommand> list3 = list2;
            if (list3 == null) {
                StartupActionScriptManager.$$$reportNull$$$0(11);
            }
            return list3;
        }
        try {
            throw new IOException("An unexpected object: " + String.valueOf(data2) + "/" + String.valueOf(data2.getClass()) + " in " + String.valueOf(scriptFile));
            {
                catch (Throwable throwable) {
                    try {
                        ois.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        catch (AccessDeniedException | NoSuchFileException e) {
            List<ActionCommand> list4 = List.of();
            if (list4 == null) {
                StartupActionScriptManager.$$$reportNull$$$0(12);
            }
            return list4;
        }
        catch (ReflectiveOperationException e) {
            throw (StreamCorruptedException)new StreamCorruptedException("Stream error: " + String.valueOf(scriptFile)).initCause(e);
        }
    }

    @ApiStatus.Internal
    public static void saveActionScript(@NotNull List<? extends ActionCommand> commands, @NotNull Path scriptFile) throws IOException {
        if (commands == null) {
            StartupActionScriptManager.$$$reportNull$$$0(13);
        }
        if (scriptFile == null) {
            StartupActionScriptManager.$$$reportNull$$$0(14);
        }
        Files.createDirectories(scriptFile.getParent(), new FileAttribute[0]);
        try (ObjectOutputStream oos = new ObjectOutputStream(Files.newOutputStream(scriptFile, new OpenOption[0]));){
            oos.writeObject(commands.toArray(new ActionCommand[0]));
        }
        catch (Throwable t) {
            try {
                Files.deleteIfExists(scriptFile);
            }
            catch (IOException e) {
                t.addSuppressed(e);
            }
            throw t;
        }
    }

    @Nullable
    private static ActionCommand mapPaths(ActionCommand command, Path oldTarget, Path newTarget) {
        if (command instanceof CopyCommand) {
            CopyCommand copyCommand = (CopyCommand)command;
            Path destination = StartupActionScriptManager.mapPath(copyCommand.myDestination, oldTarget, newTarget);
            if (destination != null) {
                return new CopyCommand(oldTarget.getFileSystem().getPath(copyCommand.mySource, new String[0]), destination);
            }
        } else if (command instanceof UnzipCommand) {
            UnzipCommand unzipCommand = (UnzipCommand)command;
            Path destination = StartupActionScriptManager.mapPath(unzipCommand.myDestination, oldTarget, newTarget);
            if (destination != null) {
                return new UnzipCommand(oldTarget.getFileSystem().getPath(unzipCommand.mySource, new String[0]), destination, unzipCommand.myFilenameFilter);
            }
        } else if (command instanceof DeleteCommand) {
            DeleteCommand deleteCommand = (DeleteCommand)command;
            Path source = StartupActionScriptManager.mapPath(deleteCommand.mySource, oldTarget, newTarget);
            if (source != null) {
                return new DeleteCommand(source);
            }
        }
        return null;
    }

    @Nullable
    private static Path mapPath(String path, Path oldTarget, Path newTarget) {
        Path fsPath = oldTarget.getFileSystem().getPath(path, new String[0]);
        return fsPath.startsWith(oldTarget) ? newTarget.resolve(oldTarget.relativize(fsPath)) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptFile";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldTarget";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTarget";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/startup/StartupActionScriptManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/startup/StartupActionScriptManager";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "loadActionScript";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "executeActionScriptImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "executeActionScriptCommands";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addActionCommand";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addActionCommands";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addActionCommandsToBeginning";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setMarketplacePluginUpdateActionScript";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadActionScript";
                break;
            }
            case 11: 
            case 12: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "saveActionScript";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12 -> new IllegalStateException(string);
        };
    }

    public static interface ActionCommand {
        @Deprecated(forRemoval=true)
        default public void execute() throws IOException {
            this.execute(FileSystems.getDefault());
        }

        public void execute(@NotNull FileSystem var1) throws IOException;
    }

    public static final class CopyCommand
    implements Serializable,
    ActionCommand {
        private static final long serialVersionUID = 201708031943L;
        private final String mySource;
        private final String myDestination;

        public CopyCommand(@NotNull Path source, @NotNull Path destination) {
            if (source == null) {
                CopyCommand.$$$reportNull$$$0(0);
            }
            if (destination == null) {
                CopyCommand.$$$reportNull$$$0(1);
            }
            this.mySource = source.toAbsolutePath().toString();
            this.myDestination = destination.toAbsolutePath().toString();
        }

        @Deprecated(forRemoval=true)
        public CopyCommand(@NotNull File source, @NotNull File destination) {
            if (source == null) {
                CopyCommand.$$$reportNull$$$0(2);
            }
            if (destination == null) {
                CopyCommand.$$$reportNull$$$0(3);
            }
            this.mySource = source.getAbsolutePath();
            this.myDestination = destination.getAbsolutePath();
        }

        @Override
        public void execute(@NotNull FileSystem fs) throws IOException {
            if (fs == null) {
                CopyCommand.$$$reportNull$$$0(4);
            }
            Path source = fs.getPath(this.mySource, new String[0]);
            Path destination = fs.getPath(this.myDestination, new String[0]);
            if (!Files.isRegularFile(source, new LinkOption[0])) {
                throw new IOException("Source file missing: " + this.mySource);
            }
            Files.createDirectories(destination.getParent(), new FileAttribute[0]);
            Files.copy(source, destination, new CopyOption[0]);
        }

        public String toString() {
            return "copy[" + this.mySource + "," + this.myDestination + "]";
        }

        public String getSource() {
            return this.mySource;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "destination";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fs";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/startup/StartupActionScriptManager$CopyCommand";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class UnzipCommand
    implements Serializable,
    ActionCommand {
        private static final long serialVersionUID = 201708031943L;
        private final String mySource;
        private final String myDestination;
        @Nullable
        private final Predicate<? super String> myFilenameFilter;

        public UnzipCommand(@NotNull Path source, @NotNull Path destination) {
            if (source == null) {
                UnzipCommand.$$$reportNull$$$0(0);
            }
            if (destination == null) {
                UnzipCommand.$$$reportNull$$$0(1);
            }
            this(source, destination, null);
        }

        @Deprecated(forRemoval=true)
        public UnzipCommand(@NotNull File source, @NotNull File destination) {
            if (source == null) {
                UnzipCommand.$$$reportNull$$$0(2);
            }
            if (destination == null) {
                UnzipCommand.$$$reportNull$$$0(3);
            }
            this(source.toPath(), destination.toPath());
        }

        public UnzipCommand(@NotNull Path source, @NotNull Path destination, @Nullable Predicate<? super String> filenameFilter) {
            if (source == null) {
                UnzipCommand.$$$reportNull$$$0(4);
            }
            if (destination == null) {
                UnzipCommand.$$$reportNull$$$0(5);
            }
            this.mySource = source.toAbsolutePath().toString();
            this.myDestination = destination.toAbsolutePath().toString();
            this.myFilenameFilter = filenameFilter;
        }

        @Override
        public void execute(@NotNull FileSystem fs) throws IOException {
            if (fs == null) {
                UnzipCommand.$$$reportNull$$$0(6);
            }
            Path source = fs.getPath(this.mySource, new String[0]);
            Path destination = fs.getPath(this.myDestination, new String[0]);
            if (!Files.isRegularFile(source, new LinkOption[0])) {
                throw new IOException("Source file missing: " + this.mySource);
            }
            Files.createDirectories(destination, new FileAttribute[0]);
            new Decompressor.Zip(source).withZipExtensions().filter(this.myFilenameFilter).extract(destination);
        }

        public String toString() {
            return "unzip[" + this.mySource + "," + this.myDestination + "," + String.valueOf(this.myFilenameFilter) + "]";
        }

        public String getSource() {
            return this.mySource;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "destination";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fs";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/startup/StartupActionScriptManager$UnzipCommand";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class DeleteCommand
    implements Serializable,
    ActionCommand {
        private static final long serialVersionUID = 201708031943L;
        private final String mySource;

        public DeleteCommand(@NotNull Path source) {
            if (source == null) {
                DeleteCommand.$$$reportNull$$$0(0);
            }
            this.mySource = source.toAbsolutePath().toString();
        }

        @Deprecated(forRemoval=true)
        public DeleteCommand(@NotNull File source) {
            if (source == null) {
                DeleteCommand.$$$reportNull$$$0(1);
            }
            this.mySource = source.getAbsolutePath();
        }

        @Override
        public void execute(@NotNull FileSystem fs) throws IOException {
            if (fs == null) {
                DeleteCommand.$$$reportNull$$$0(2);
            }
            NioFiles.deleteRecursively((Path)fs.getPath(this.mySource, new String[0]));
        }

        public String toString() {
            return "delete[" + this.mySource + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fs";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/startup/StartupActionScriptManager$DeleteCommand";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

