/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.NewThemeCheckboxPatcher;
import com.intellij.ide.ui.UIThemeBean;
import com.intellij.ide.ui.UiThemePaletteCheckBoxScopeKt;
import com.intellij.ide.ui.UiThemePaletteScope;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.svg.SvgAttributePatcher;
import com.intellij.util.InsecureHashBuilder;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000bj\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\u000bj\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ide/ui/UiThemePaletteCheckBoxScope;", "Lcom/intellij/ide/ui/UiThemePaletteScope;", "theme", "Lcom/intellij/ide/ui/UIThemeBean;", "<init>", "(Lcom/intellij/ide/ui/UIThemeBean;)V", "themeName", "", "isDarkTheme", "", "palette", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "alphas", "", "svgColorIconPatcher", "Lcom/intellij/ui/svg/SvgAttributePatcher;", "getSvgColorIconPatcher", "()Lcom/intellij/ui/svg/SvgAttributePatcher;", "lazySvgColorIconPatcher", "Ljava/util/function/Supplier;", "registerPalette", "", "colorKey", "color", "", "updateHash", "insecureHashBuilder", "Lcom/intellij/util/InsecureHashBuilder;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nUiThemePaletteCheckBoxScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UiThemePaletteCheckBoxScope.kt\ncom/intellij/ide/ui/UiThemePaletteCheckBoxScope\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,139:1\n23#2:140\n23#2:141\n*S KotlinDebug\n*F\n+ 1 UiThemePaletteCheckBoxScope.kt\ncom/intellij/ide/ui/UiThemePaletteCheckBoxScope\n*L\n74#1:140\n79#1:141\n*E\n"})
public final class UiThemePaletteCheckBoxScope
implements UiThemePaletteScope {
    @Nullable
    private final String themeName;
    private final boolean isDarkTheme;
    @NotNull
    private final HashMap<String, String> palette;
    @NotNull
    private final HashMap<String, Integer> alphas;
    @NotNull
    private final Supplier<SvgAttributePatcher> lazySvgColorIconPatcher;

    public UiThemePaletteCheckBoxScope(@NotNull UIThemeBean theme) {
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.themeName = theme.name;
        this.isDarkTheme = theme.dark;
        this.palette = new HashMap();
        this.alphas = new HashMap();
        this.lazySvgColorIconPatcher = (Supplier)new SynchronizedClearableLazy(() -> UiThemePaletteCheckBoxScope.lazySvgColorIconPatcher$lambda$0(this));
    }

    @Override
    @Nullable
    public SvgAttributePatcher getSvgColorIconPatcher() {
        return this.lazySvgColorIconPatcher.get();
    }

    public final void registerPalette(@NotNull String colorKey, @Nullable Object color) {
        Intrinsics.checkNotNullParameter((Object)colorKey, (String)"colorKey");
        String key = null;
        key = this.isDarkTheme && StringsKt.endsWith$default((String)colorKey, (String)".Dark", (boolean)false, (int)2, null) ? StringsKt.removeSuffix((String)colorKey, (CharSequence)".Dark") : colorKey;
        if (!UiThemePaletteCheckBoxScopeKt.access$getPaletteNames$p().contains(key)) {
            UiThemePaletteCheckBoxScope $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(UiThemePaletteCheckBoxScope.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Theme " + this.themeName + ": color key " + colorKey + " is not supported and therefore ignored");
            return;
        }
        if (!Intrinsics.areEqual((Object)key, (Object)colorKey)) {
            UiThemePaletteCheckBoxScope $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(UiThemePaletteCheckBoxScope.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Theme " + this.themeName + ": " + colorKey + " is deprecated for new UI themes, use " + key + " instead");
        }
        if (color instanceof Color) {
            String colorHex = "#" + ColorUtil.toHex((Color)((Color)color), (boolean)false);
            ((Map)this.palette).put(key, colorHex);
            ((Map)this.alphas).put(key, ((Color)color).getAlpha());
        }
    }

    @Override
    public void updateHash(@NotNull InsecureHashBuilder insecureHashBuilder) {
        Intrinsics.checkNotNullParameter((Object)insecureHashBuilder, (String)"insecureHashBuilder");
        String string = this.themeName;
        if (string == null) {
            string = "";
        }
        insecureHashBuilder.putString(string).putBoolean(this.isDarkTheme).putStringMap((Map)this.palette).putStringIntMap((Map)this.alphas);
    }

    private static final SvgAttributePatcher lazySvgColorIconPatcher$lambda$0(UiThemePaletteCheckBoxScope this$0) {
        if (this$0.palette.isEmpty()) {
            return null;
        }
        return new NewThemeCheckboxPatcher((Map<String, String>)this$0.palette, (Map<String, Integer>)this$0.alphas);
    }
}

