/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.IJColorUIResource;
import com.intellij.ide.ui.UITheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.ColorHexUtil;
import com.intellij.ui.icons.ImageDataByPathLoaderKt;
import com.intellij.util.ui.GrayFilter;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Iterator;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a@\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u001a\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\n0\bH\u0000\u001a\u001c\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0004\u001a\u00020\u00032\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0000\u001a\u0018\u0010\r\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u001a\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u00142\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0004\u001a\u00020\u00032\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a6\u0010 \u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u001a\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\n0\bH\u0000\"\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"parseUiThemeValue", "", "key", "", "value", "classLoader", "Ljava/lang/ClassLoader;", "warn", "Lkotlin/Function2;", "", "", "parseColorOrNull", "Ljava/awt/Color;", "parseImageFile", "parseBorder", "LOOKUP", "Ljava/lang/invoke/MethodHandles$Lookup;", "kotlin.jvm.PlatformType", "parseBorderColorOrBorderClass", "parseMultiValue", "Lkotlin/sequences/Sequence;", "getIntegerOrFloat", "", "parseSize", "Ljava/awt/Dimension;", "parseInsets", "Ljava/awt/Insets;", "isColorLike", "", "text", "createColorResource", "color", "parseStringValue", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nuiThemeParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 uiThemeParser.kt\ncom/intellij/ide/ui/UiThemeParserKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,191:1\n13#2:192\n13#2:193\n13#2:194\n13#2:195\n13#2:196\n13#2:197\n13#2:198\n*S KotlinDebug\n*F\n+ 1 uiThemeParser.kt\ncom/intellij/ide/ui/UiThemeParserKt\n*L\n45#1:192\n50#1:193\n60#1:194\n71#1:195\n105#1:196\n134#1:197\n171#1:198\n*E\n"})
public final class UiThemeParserKt {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();

    @Nullable
    public static final Object parseUiThemeValue(@NotNull String key, @Nullable Object value, @NotNull ClassLoader classLoader, @NotNull Function2<? super String, ? super Throwable, Unit> warn) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Intrinsics.checkNotNullParameter(warn, (String)"warn");
        if (!(value instanceof String)) {
            return value;
        }
        try {
            Object object;
            String baseKey = StringsKt.removeSuffix((String)key, (CharSequence)".compact");
            if (StringsKt.endsWith$default((String)((String)value), (String)".png", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)((String)value), (String)".svg", (boolean)false, (int)2, null)) {
                object = UiThemeParserKt.parseImageFile((String)value, classLoader);
            } else if (StringsKt.endsWith$default((String)baseKey, (String)"Border", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)baseKey, (String)"border", (boolean)false, (int)2, null)) {
                object = UiThemeParserKt.parseBorder((String)value, classLoader);
            } else if (StringsKt.endsWith$default((String)baseKey, (String)"Width", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)baseKey, (String)"Height", (boolean)false, (int)2, null)) {
                object = UiThemeParserKt.getIntegerOrFloat((String)value, key);
            } else if (StringsKt.startsWith$default((String)((String)value), (String)"AllIcons.", (boolean)false, (int)2, null)) {
                object = arg_0 -> UiThemeParserKt.parseUiThemeValue$lambda$0(value, classLoader, arg_0);
            } else if (StringsKt.endsWith$default((String)baseKey, (String)"UI", (boolean)false, (int)2, null)) {
                object = value;
            } else {
                Object it = UiThemeParserKt.parseStringValue((String)value, key, warn);
                boolean bl = false;
                if (!(it instanceof String)) {
                    return it;
                }
                Serializable serializable = UiThemeParserKt.getIntegerOrFloat((String)value, null);
                if (serializable != null) {
                    Number it2 = serializable;
                    boolean bl2 = false;
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(UITheme.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn(key + " has numeric value but specified as string");
                    return it2;
                }
                if (((String)value).length() <= 8 && (serializable = UiThemeParserKt.parseColorOrNull((String)value, null)) != null) {
                    Serializable it3 = serializable;
                    boolean bl3 = false;
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(UITheme.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn(key + " has color value but doesn't have # prefix");
                    return it3;
                }
                object = value;
            }
            return object;
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(UITheme.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Can't parse '" + value + "' for key '" + key + "'");
            return value;
        }
    }

    @Nullable
    public static final Color parseColorOrNull(@NotNull String value, @Nullable String key) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            return ColorHexUtil.fromHexOrNull((String)value);
        }
        catch (Exception e) {
            if (key != null) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(UITheme.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn(key + "=" + value + " has # prefix but cannot be parsed as color");
            }
            return null;
        }
    }

    private static final Object parseImageFile(String value, ClassLoader classLoader) {
        return arg_0 -> UiThemeParserKt.parseImageFile$lambda$0(value, classLoader, arg_0);
    }

    private static final Object parseBorder(String value, ClassLoader classLoader) {
        try {
            Iterator parsedValues = UiThemeParserKt.parseMultiValue(value).iterator();
            String v1 = (String)parsedValues.next();
            if (parsedValues.hasNext()) {
                String v2 = (String)parsedValues.next();
                String v3 = (String)parsedValues.next();
                String v4 = (String)parsedValues.next();
                if (parsedValues.hasNext()) {
                    return JBUI.asUIResource((Border)JBUI.Borders.customLine((Color)ColorHexUtil.fromHex((String)((String)parsedValues.next())), (int)Integer.parseInt(v1), (int)Integer.parseInt(v2), (int)Integer.parseInt(v3), (int)Integer.parseInt(v4)));
                }
                return new BorderUIResource.EmptyBorderUIResource((Insets)new JBInsets(Integer.parseInt(v1), Integer.parseInt(v2), Integer.parseInt(v3), Integer.parseInt(v4)).asUIResource());
            }
            ClassLoader classLoader2 = classLoader;
            return classLoader2 == null ? value : UiThemeParserKt.parseBorderColorOrBorderClass(value, classLoader2);
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(UITheme.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn((Throwable)e);
            return null;
        }
    }

    private static final Object parseBorderColorOrBorderClass(String value, ClassLoader classLoader) {
        Color color = UiThemeParserKt.parseColorOrNull(value, null);
        if (color == null) {
            return arg_0 -> UiThemeParserKt.parseBorderColorOrBorderClass$lambda$0(classLoader, value, arg_0);
        }
        return JBUI.asUIResource((Border)JBUI.Borders.customLine((Color)color, (int)1));
    }

    private static final Sequence<String> parseMultiValue(String value) {
        char[] cArray = new char[]{','};
        return SequencesKt.filter((Sequence)SequencesKt.map((Sequence)StringsKt.splitToSequence$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null), UiThemeParserKt::parseMultiValue$lambda$0), UiThemeParserKt::parseMultiValue$lambda$1);
    }

    private static final Number getIntegerOrFloat(String value, String key) {
        try {
            return StringsKt.contains$default((CharSequence)value, (char)'.', (boolean)false, (int)2, null) ? (Number)Float.valueOf(Float.parseFloat(value)) : (Number)Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            if (key != null) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(UITheme.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Can't parse: " + key + " = " + value);
            }
            return null;
        }
    }

    private static final Dimension parseSize(String value) {
        Iterator numbers = UiThemeParserKt.parseMultiValue(value).iterator();
        JBDimension.JBDimensionUIResource jBDimensionUIResource = new JBDimension(Integer.parseInt((String)numbers.next()), Integer.parseInt((String)numbers.next())).asUIResource();
        Intrinsics.checkNotNullExpressionValue((Object)jBDimensionUIResource, (String)"asUIResource(...)");
        return (Dimension)jBDimensionUIResource;
    }

    private static final Insets parseInsets(String value) {
        Iterator numbers = UiThemeParserKt.parseMultiValue(value).iterator();
        JBInsets.JBInsetsUIResource jBInsetsUIResource = new JBInsets(Integer.parseInt((String)numbers.next()), Integer.parseInt((String)numbers.next()), Integer.parseInt((String)numbers.next()), Integer.parseInt((String)numbers.next())).asUIResource();
        Intrinsics.checkNotNullExpressionValue((Object)jBInsetsUIResource, (String)"asUIResource(...)");
        return (Insets)jBInsetsUIResource;
    }

    public static final boolean isColorLike(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return text2.length() <= 9 && StringsKt.startsWith$default((CharSequence)text2, (char)'#', (boolean)false, (int)2, null);
    }

    @NotNull
    public static final Color createColorResource(@NotNull Color color, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (StringsKt.startsWith$default((String)key, (String)"*.", (boolean)false, (int)2, null)) {
            return color;
        }
        return (Color)((Object)new IJColorUIResource(color, key));
    }

    @Nullable
    public static final Object parseStringValue(@NotNull String value, @NotNull String key, @NotNull Function2<? super String, ? super Throwable, Unit> warn) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(warn, (String)"warn");
        try {
            Object object;
            String baseKey = StringsKt.removeSuffix((String)key, (CharSequence)".compact");
            if (StringsKt.endsWith$default((String)baseKey, (String)"Insets", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)baseKey, (String)".insets", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)baseKey, (String)"padding", (boolean)false, (int)2, null)) {
                object = UiThemeParserKt.parseInsets(value);
            } else if (StringsKt.endsWith$default((String)baseKey, (String)"Size", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)baseKey, (String)".size", (boolean)false, (int)2, null)) {
                object = UiThemeParserKt.parseSize(value);
            } else if (StringsKt.endsWith$default((String)baseKey, (String)"Border", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)baseKey, (String)"border", (boolean)false, (int)2, null)) {
                object = UiThemeParserKt.parseBorder(value, null);
            } else if (UiThemeParserKt.isColorLike(value)) {
                Color color = UiThemeParserKt.parseColorOrNull(value, null);
                if (color == null) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(UITheme.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn(key + "=" + value + " has # prefix but cannot be parsed as color");
                    object = (Serializable)((Object)value);
                } else {
                    object = UiThemeParserKt.createColorResource(color, key);
                }
            } else if (StringsKt.endsWith$default((String)baseKey, (String)"grayFilter", (boolean)false, (int)2, null)) {
                Iterator numbers = UiThemeParserKt.parseMultiValue(value).iterator();
                object = GrayFilter.asUIResource((int)Integer.parseInt((String)numbers.next()), (int)Integer.parseInt((String)numbers.next()), (int)Integer.parseInt((String)numbers.next()));
            } else {
                object = value;
            }
            return object;
        }
        catch (Throwable e) {
            warn.invoke((Object)("Cannot parse " + value + " for " + key), (Object)e);
            return null;
        }
    }

    private static final Object parseUiThemeValue$lambda$0(Object $value, ClassLoader $classLoader, UIDefaults it) {
        return ImageDataByPathLoaderKt.getReflectiveIcon((String)((String)$value), (ClassLoader)$classLoader);
    }

    private static final Object parseImageFile$lambda$0(String $value, ClassLoader $classLoader, UIDefaults it) {
        return ImageDataByPathLoaderKt.findIconByPath((String)$value, (ClassLoader)$classLoader, null, null);
    }

    private static final Object parseBorderColorOrBorderClass$lambda$0(ClassLoader $classLoader, String $value, UIDefaults it) {
        Class<?> aClass = $classLoader.loadClass($value);
        MethodHandle constructor = MethodHandles.privateLookupIn(aClass, LOOKUP).findConstructor(aClass, MethodType.methodType(Void.TYPE));
        return constructor.invoke();
    }

    private static final String parseMultiValue$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)StringsKt.trim((CharSequence)it)).toString();
    }

    private static final boolean parseMultiValue$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((CharSequence)it).length() > 0;
    }
}

