/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.customization;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.customization.ActionIconInfo;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.ui.customization.CustomActionsSchemaKt;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionStubBase;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.util.IconLoaderKt;
import com.intellij.ui.icons.CachedImageIcon;
import com.intellij.util.text.StringKt;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007H\u0000\u001a\u001c\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0002\u001a\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007H\u0000\u001a\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\u00a8\u0006\u0011"}, d2={"NONE", "Lcom/intellij/ide/ui/customization/ActionIconInfo;", "getNONE", "()Lcom/intellij/ide/ui/customization/ActionIconInfo;", "SEPARATOR", "getSEPARATOR", "getDefaultIcons", "", "getIconInfo", "icon", "Ljavax/swing/Icon;", "text", "", "getAvailableIcons", "getCustomIcons", "schema", "Lcom/intellij/ide/ui/customization/CustomActionsSchema;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nActionIconInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActionIconInfo.kt\ncom/intellij/ide/ui/customization/ActionIconInfoKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,89:1\n1#2:90\n1#2:101\n1#2:114\n1617#3,9:91\n1869#3:100\n1870#3:102\n1626#3:103\n136#4,9:104\n216#4:113\n217#4:115\n145#4:116\n*S KotlinDebug\n*F\n+ 1 ActionIconInfo.kt\ncom/intellij/ide/ui/customization/ActionIconInfoKt\n*L\n58#1:101\n73#1:114\n58#1:91,9\n58#1:100\n58#1:102\n58#1:103\n73#1:104,9\n73#1:113\n73#1:115\n73#1:116\n*E\n"})
public final class ActionIconInfoKt {
    @NotNull
    private static final ActionIconInfo NONE;
    @NotNull
    private static final ActionIconInfo SEPARATOR;

    @NotNull
    public static final ActionIconInfo getNONE() {
        return NONE;
    }

    @NotNull
    public static final ActionIconInfo getSEPARATOR() {
        return SEPARATOR;
    }

    @NotNull
    public static final List<ActionIconInfo> getDefaultIcons() {
        Object[] objectArray = new ActionIconInfo[10];
        Icon icon2 = AllIcons.Toolbar.Unknown;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Unknown");
        String string = IdeBundle.message((String)"default.icons.unknown.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        objectArray[0] = ActionIconInfoKt.getIconInfo(icon2, string);
        Icon icon3 = AllIcons.General.Add;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Add");
        String string2 = IdeBundle.message((String)"default.icons.add.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        objectArray[1] = ActionIconInfoKt.getIconInfo(icon3, string2);
        Icon icon4 = AllIcons.General.Remove;
        Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Remove");
        String string3 = IdeBundle.message((String)"default.icons.remove.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        objectArray[2] = ActionIconInfoKt.getIconInfo(icon4, string3);
        Icon icon5 = AllIcons.Actions.Edit;
        Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"Edit");
        String string4 = IdeBundle.message((String)"default.icons.edit.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        objectArray[3] = ActionIconInfoKt.getIconInfo(icon5, string4);
        Icon icon6 = AllIcons.General.Filter;
        Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"Filter");
        String string5 = IdeBundle.message((String)"default.icons.filter.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        objectArray[4] = ActionIconInfoKt.getIconInfo(icon6, string5);
        Icon icon7 = AllIcons.Actions.Find;
        Intrinsics.checkNotNullExpressionValue((Object)icon7, (String)"Find");
        String string6 = IdeBundle.message((String)"default.icons.find.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
        objectArray[5] = ActionIconInfoKt.getIconInfo(icon7, string6);
        Icon icon8 = AllIcons.General.GearPlain;
        Intrinsics.checkNotNullExpressionValue((Object)icon8, (String)"GearPlain");
        String string7 = IdeBundle.message((String)"default.icons.gear.plain.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
        objectArray[6] = ActionIconInfoKt.getIconInfo(icon8, string7);
        Icon icon9 = AllIcons.Actions.ListFiles;
        Intrinsics.checkNotNullExpressionValue((Object)icon9, (String)"ListFiles");
        String string8 = IdeBundle.message((String)"default.icons.list.files.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"message(...)");
        objectArray[7] = ActionIconInfoKt.getIconInfo(icon9, string8);
        Icon icon10 = AllIcons.ToolbarDecorator.Export;
        Intrinsics.checkNotNullExpressionValue((Object)icon10, (String)"Export");
        String string9 = IdeBundle.message((String)"default.icons.export.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"message(...)");
        objectArray[8] = ActionIconInfoKt.getIconInfo(icon10, string9);
        Icon icon11 = AllIcons.ToolbarDecorator.Import;
        Intrinsics.checkNotNullExpressionValue((Object)icon11, (String)"Import");
        String string10 = IdeBundle.message((String)"default.icons.import.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"message(...)");
        objectArray[9] = ActionIconInfoKt.getIconInfo(icon11, string10);
        List icons = CollectionsKt.listOf((Object[])objectArray);
        return CollectionsKt.filterNotNull((Iterable)icons);
    }

    private static final ActionIconInfo getIconInfo(Icon icon2, @Nls String text2) {
        ActionIconInfo actionIconInfo;
        URL iconUrl;
        CachedImageIcon cachedImageIcon = icon2 instanceof CachedImageIcon ? (CachedImageIcon)icon2 : null;
        URL uRL = iconUrl = cachedImageIcon != null ? cachedImageIcon.getUrl() : null;
        if (uRL != null) {
            URL it = uRL;
            boolean bl = false;
            actionIconInfo = new ActionIconInfo(icon2, text2, null, it.toString());
        } else {
            actionIconInfo = null;
        }
        return actionIconInfo;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ActionIconInfo> getAvailableIcons() {
        void $this$mapNotNullTo$iv$iv;
        ActionManager actionManager = ActionManager.getInstance();
        List list2 = actionManager.getActionIdList("");
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getActionIdList(...)");
        Iterable $this$mapNotNull$iv = list2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ActionIconInfo actionIconInfo;
            block6: {
                Icon icon2;
                AnAction action2;
                String actionId;
                block9: {
                    Presentation presentation2;
                    Icon icon3;
                    block7: {
                        String string;
                        block8: {
                            block5: {
                                Object element$iv$iv$iv;
                                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                                boolean bl = false;
                                actionId = (String)element$iv$iv;
                                boolean bl2 = false;
                                if (actionManager.getActionOrStub(actionId) != null) break block5;
                                actionIconInfo = null;
                                break block6;
                            }
                            if (!(action2 instanceof ActionStubBase)) break block7;
                            string = ((ActionStubBase)action2).getIconPath();
                            if (string != null) break block8;
                            actionIconInfo = null;
                            break block6;
                        }
                        ClassLoader classLoader = ((ActionStubBase)action2).getPlugin().getClassLoader();
                        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
                        icon3 = IconLoaderKt.findIconUsingNewImplementation$default((String)string, (ClassLoader)classLoader, null, (int)4, null);
                        break block9;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)action2.getTemplatePresentation(), (String)"getTemplatePresentation(...)");
                    icon3 = (Icon)presentation2.getClientProperty(CustomActionsSchema.PROP_ORIGINAL_ICON);
                    if (icon3 == null) {
                        icon3 = icon2 = presentation2.getIcon();
                    }
                }
                if (icon2 != null) {
                    Icon it;
                    boolean bl = false;
                    String string = StringKt.nullize$default((String)action2.getTemplateText(), (boolean)false, (int)1, null);
                    if (string == null) {
                        string = actionId;
                    }
                    String string2 = string;
                    Intrinsics.checkNotNull((Object)string2);
                    actionIconInfo = new ActionIconInfo(it, string2, actionId, null);
                } else {
                    actionIconInfo = null;
                }
            }
            if (actionIconInfo == null) continue;
            ActionIconInfo it$iv$iv = actionIconInfo;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ActionIconInfo> getCustomIcons(@NotNull CustomActionsSchema schema) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        ActionManager actionManager = ActionManager.getInstance();
        Map<String, String> $this$mapNotNull$iv = schema.getIconCustomizations();
        boolean $i$f$mapNotNull = false;
        Map<String, String> map2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            ActionIconInfo actionIconInfo;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            String actionId = (String)entry.getKey();
            String iconReference = (String)entry.getValue();
            if (iconReference == null) {
                actionIconInfo = null;
            } else {
                AnAction action2 = actionManager.getAction(iconReference);
                if (action2 == null) {
                    ActionIconInfo actionIconInfo2;
                    try {
                        Icon icon2 = CustomActionsSchemaKt.loadCustomIcon(iconReference);
                        actionIconInfo2 = new ActionIconInfo(icon2, StringsKt.substringAfterLast$default((String)iconReference, (char)'/', null, (int)2, null), actionId, iconReference);
                    }
                    catch (IOException ex) {
                        actionIconInfo2 = null;
                    }
                    actionIconInfo = actionIconInfo2;
                } else {
                    actionIconInfo = null;
                }
            }
            if (actionIconInfo == null) continue;
            ActionIconInfo it$iv$iv = actionIconInfo;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    static {
        String string = IdeBundle.message((String)"default.icons.none.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        NONE = new ActionIconInfo(null, string, "", null);
        SEPARATOR = new ActionIconInfo(null, "", "", null);
    }
}

