/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.customization;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.customization.ActionIconInfo;
import com.intellij.ide.ui.customization.ActionIconInfoKt;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.ui.customization.CustomActionsSchemaKt;
import com.intellij.ide.ui.customization.CustomizableActionsPanel;
import com.intellij.ide.ui.laf.darcula.ui.DarculaComboBoxUI;
import com.intellij.ide.ui.laf.darcula.ui.DarculaSeparatorUI;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.icons.CachedImageIcon;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.FileNotFoundException;
import java.nio.file.NoSuchFileException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u0000 '2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002&'B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0015H\u0002J\u000e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001c\u0010\u001d\u001a\u00020\b2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u001fH\u0002J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0015H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/ide/ui/customization/BrowseIconsComboBox;", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/ide/ui/customization/ActionIconInfo;", "customActionsSchema", "Lcom/intellij/ide/ui/customization/CustomActionsSchema;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "withNoneItem", "", "<init>", "(Lcom/intellij/ide/ui/customization/CustomActionsSchema;Lcom/intellij/openapi/Disposable;Z)V", "iconsLoadedFuture", "Ljava/util/concurrent/CompletableFuture;", "loadIconsAsync", "createIconList", "", "createEditor", "Ljavax/swing/ComboBoxEditor;", "createRenderer", "Ljavax/swing/ListCellRenderer;", "installSelectedIconValidator", "", "createBrowseIconExtension", "Lcom/intellij/ui/components/fields/ExtendableTextComponent$Extension;", "browseIconAndSelect", "selectIconForNode", "node", "Ljavax/swing/tree/DefaultMutableTreeNode;", "doSelectIconForNode", "selectByCondition", "predicate", "Lkotlin/Function1;", "getModel", "Ljavax/swing/DefaultComboBoxModel;", "setSelectedIndex", "anIndex", "", "updateUI", "IconWrapper", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nBrowseIconsComboBox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrowseIconsComboBox.kt\ncom/intellij/ide/ui/customization/BrowseIconsComboBox\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,332:1\n23#2:333\n1#3:334\n37#4,2:335\n*S KotlinDebug\n*F\n+ 1 BrowseIconsComboBox.kt\ncom/intellij/ide/ui/customization/BrowseIconsComboBox\n*L\n208#1:333\n63#1:335,2\n*E\n"})
public final class BrowseIconsComboBox
extends ComboBox<ActionIconInfo> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CustomActionsSchema customActionsSchema;
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private final CompletableFuture<Boolean> iconsLoadedFuture;

    public BrowseIconsComboBox(@NotNull CustomActionsSchema customActionsSchema, @NotNull Disposable parentDisposable, boolean withNoneItem) {
        Intrinsics.checkNotNullParameter((Object)customActionsSchema, (String)"customActionsSchema");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.customActionsSchema = customActionsSchema;
        this.parentDisposable = parentDisposable;
        this.iconsLoadedFuture = this.loadIconsAsync(withNoneItem);
        this.setSwingPopup(false);
        this.setEditable(true);
        this.setEditor(this.createEditor());
        this.setRenderer(this.createRenderer());
        this.installSelectedIconValidator();
        ComboboxSpeedSearch.installSpeedSearch((JComboBox)((Object)this), arg_0 -> BrowseIconsComboBox._init_$lambda$1(BrowseIconsComboBox::_init_$lambda$0, arg_0));
    }

    private final CompletableFuture<Boolean> loadIconsAsync(boolean withNoneItem) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        ReadAction.nonBlocking(() -> BrowseIconsComboBox.loadIconsAsync$lambda$0(this, withNoneItem)).expireWith(this.parentDisposable).finishOnUiThread(ModalityState.any(), arg_0 -> BrowseIconsComboBox.loadIconsAsync$lambda$1(this, future, arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
        return future;
    }

    private final List<ActionIconInfo> createIconList(boolean withNoneItem) {
        List<ActionIconInfo> defaultIcons = ActionIconInfoKt.getDefaultIcons();
        Sequence customIcons = SequencesKt.filter((Sequence)SequencesKt.distinctBy((Sequence)CollectionsKt.asSequence((Iterable)ActionIconInfoKt.getCustomIcons(this.customActionsSchema)), BrowseIconsComboBox::createIconList$lambda$0), arg_0 -> BrowseIconsComboBox.createIconList$lambda$1(defaultIcons, arg_0));
        Sequence availableIcons = SequencesKt.sortedWith((Sequence)SequencesKt.filter((Sequence)SequencesKt.distinctBy((Sequence)CollectionsKt.asSequence((Iterable)ActionIconInfoKt.getAvailableIcons()), BrowseIconsComboBox::createIconList$lambda$2), arg_0 -> BrowseIconsComboBox.createIconList$lambda$3(defaultIcons, arg_0)), BrowseIconsComboBox::createIconList$lambda$4);
        List icons = new LinkedList();
        if (withNoneItem) {
            icons.add(ActionIconInfoKt.getNONE());
        }
        icons.addAll((Collection)defaultIcons);
        icons.add(ActionIconInfoKt.getSEPARATOR());
        CollectionsKt.addAll((Collection)icons, (Sequence)customIcons);
        CollectionsKt.addAll((Collection)icons, (Sequence)availableIcons);
        return icons;
    }

    private final ComboBoxEditor createEditor() {
        return new BasicComboBoxEditor(this){
            final /* synthetic */ BrowseIconsComboBox this$0;
            {
                this.this$0 = $receiver;
            }

            protected JTextField createEditorComponent() {
                ExtendableTextField textField2 = new ExtendableTextField(this.this$0){
                    final /* synthetic */ BrowseIconsComboBox this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void requestFocus() {
                        this.this$0.requestFocus();
                    }
                };
                textField2.setBorder(null);
                textField2.setEditable(false);
                textField2.addExtension(BrowseIconsComboBox.access$createBrowseIconExtension(this.this$0));
                textField2.addExtension(new ExtendableTextComponent.Extension(this.this$0){
                    final /* synthetic */ BrowseIconsComboBox this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public Icon getIcon(boolean hovered) {
                        Object object = this.this$0.getSelectedItem();
                        ActionIconInfo actionIconInfo = object instanceof ActionIconInfo ? (ActionIconInfo)object : null;
                        return actionIconInfo != null ? actionIconInfo.getIcon() : null;
                    }

                    public boolean isIconBeforeText() {
                        return true;
                    }
                });
                return (JTextField)textField2;
            }
        };
    }

    private final ListCellRenderer<ActionIconInfo> createRenderer() {
        return (ListCellRenderer)new ColoredListCellRenderer<ActionIconInfo>(){

            public Component getListCellRendererComponent(JList<? extends ActionIconInfo> list2, ActionIconInfo value, int index, boolean selected, boolean hasFocus) {
                Component component2;
                Intrinsics.checkNotNullParameter(list2, (String)"list");
                if (value == ActionIconInfoKt.getSEPARATOR()) {
                    component2 = new JSeparator(){

                        public void updateUI() {
                            this.setUI(new DarculaSeparatorUI(){

                                protected int getStripeIndent() {
                                    return 0;
                                }

                                public JBDimension getPreferredSize(JComponent c) {
                                    Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                                    JBDimension jBDimension = JBUI.size((int)0, (int)1);
                                    Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"size(...)");
                                    return jBDimension;
                                }
                            });
                        }
                    };
                } else {
                    Component component3 = super.getListCellRendererComponent(list2, (Object)value, index, selected, hasFocus);
                    component2 = component3;
                    Intrinsics.checkNotNullExpressionValue((Object)component3, (String)"getListCellRendererComponent(...)");
                }
                return component2;
            }

            protected void customizeCellRenderer(JList<? extends ActionIconInfo> list2, ActionIconInfo value, int index, boolean selected, boolean hasFocus) {
                Intrinsics.checkNotNullParameter(list2, (String)"list");
                if (value != null) {
                    this.setIcon(value.getIcon());
                    this.append(value.getText());
                }
            }
        };
    }

    private final void installSelectedIconValidator() {
        new ComponentValidator(this.parentDisposable).withValidator(() -> BrowseIconsComboBox.installSelectedIconValidator$lambda$0(this)).installOn((JComponent)((Object)this));
        this.addActionListener(arg_0 -> BrowseIconsComboBox.installSelectedIconValidator$lambda$1(this, arg_0));
    }

    private final ExtendableTextComponent.Extension createBrowseIconExtension() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 64);
        String tooltip = UIBundle.message((String)"component.with.browse.button.browse.button.tooltip.text", (Object[])new Object[0]) + " (" + KeymapUtil.getKeystrokeText((KeyStroke)keyStroke) + ")";
        ExtendableTextComponent.Extension browseExtension = ExtendableTextComponent.Extension.create((Icon)AllIcons.General.OpenDisk, (Icon)AllIcons.General.OpenDiskHover, (String)tooltip, this::browseIconAndSelect);
        new DumbAwareAction(this){
            final /* synthetic */ BrowseIconsComboBox this$0;
            {
                this.this$0 = $receiver;
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                BrowseIconsComboBox.access$browseIconAndSelect(this.this$0);
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(keyStroke), (JComponent)((Object)this), this.parentDisposable);
        Intrinsics.checkNotNull((Object)browseExtension);
        return browseExtension;
    }

    private final void browseIconAndSelect() {
        String[] stringArray = new String[]{"svg", "png"};
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withExtensionFilter(IdeBundle.message((String)"icon.file.filter.label", (Object[])new Object[0]), stringArray);
        descriptor2.setTitle(IdeBundle.message((String)"title.browse.icon", (Object[])new Object[0]));
        descriptor2.setDescription(IdeBundle.message((String)"prompt.browse.icon.for.selected.action", (Object[])new Object[0]));
        VirtualFile iconFile = FileChooser.chooseFile((FileChooserDescriptor)descriptor2, null, null);
        if (iconFile != null) {
            Icon icon2;
            try {
                String string = iconFile.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                icon2 = CustomActionsSchemaKt.loadCustomIcon(string);
            }
            catch (Throwable t) {
                BrowseIconsComboBox $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(BrowseIconsComboBox.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Failed to load icon from disk, path: " + iconFile.getPath(), t);
                icon2 = IconManager.Companion.getInstance().getPlatformIcon(PlatformIcons.Stub);
            }
            Icon icon3 = icon2;
            String string = iconFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            ActionIconInfo info = new ActionIconInfo(icon3, string, null, iconFile.getPath());
            int separatorInd = ((DefaultComboBoxModel)this.getModel()).getIndexOf(ActionIconInfoKt.getSEPARATOR());
            ((DefaultComboBoxModel)this.getModel()).insertElementAt(info, separatorInd + 1);
            this.setSelectedIndex(separatorInd + 1);
        }
    }

    public final void selectIconForNode(@NotNull DefaultMutableTreeNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.iconsLoadedFuture.isDone()) {
            this.doSelectIconForNode(node);
        } else {
            this.iconsLoadedFuture.thenAccept(arg_0 -> BrowseIconsComboBox.selectIconForNode$lambda$1(arg_0 -> BrowseIconsComboBox.selectIconForNode$lambda$0(this, node, arg_0), arg_0));
        }
    }

    private final void doSelectIconForNode(DefaultMutableTreeNode node) {
        String customIconRef;
        com.intellij.openapi.util.Pair<String, Icon> pair = CustomizableActionsPanel.getActionIdAndIcon(node);
        Intrinsics.checkNotNullExpressionValue(pair, (String)"getActionIdAndIcon(...)");
        com.intellij.openapi.util.Pair<String, Icon> pair2 = pair;
        Pair pair3 = TuplesKt.to((Object)pair2.first, (Object)pair2.second);
        String actionId = (String)pair3.component1();
        Icon icon2 = (Icon)pair3.component2();
        if (actionId != null && icon2 != null && (StringUtil.isNotEmpty((String)(customIconRef = this.customActionsSchema.getIconPath(actionId))) && this.selectByCondition((Function1<? super ActionIconInfo, Boolean>)((Function1)arg_0 -> BrowseIconsComboBox.doSelectIconForNode$lambda$0(customIconRef, arg_0))) || this.selectByCondition((Function1<? super ActionIconInfo, Boolean>)((Function1)arg_0 -> BrowseIconsComboBox.doSelectIconForNode$lambda$1(actionId, arg_0))) || this.selectByCondition((Function1<? super ActionIconInfo, Boolean>)((Function1)arg_0 -> BrowseIconsComboBox.doSelectIconForNode$lambda$2(icon2, arg_0))))) {
            return;
        }
        this.setSelectedIndex(0);
    }

    private final boolean selectByCondition(Function1<? super ActionIconInfo, Boolean> predicate) {
        boolean bl;
        Object v1;
        block2: {
            Iterable iterable = (Iterable)RangesKt.until((int)0, (int)((DefaultComboBoxModel)this.getModel()).getSize());
            for (Object t : iterable) {
                int it = ((Number)t).intValue();
                boolean bl2 = false;
                Object e = ((DefaultComboBoxModel)this.getModel()).getElementAt(it);
                Intrinsics.checkNotNullExpressionValue(e, (String)"getElementAt(...)");
                if (!((Boolean)predicate.invoke(e)).booleanValue()) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        Integer ind = v1;
        boolean it = bl = ind != null;
        boolean bl3 = false;
        if (it) {
            Integer n = ind;
            Intrinsics.checkNotNull((Object)n);
            this.setSelectedIndex(n);
        }
        return bl;
    }

    @NotNull
    public DefaultComboBoxModel<ActionIconInfo> getModel() {
        ComboBoxModel comboBoxModel = super.getModel();
        Intrinsics.checkNotNull((Object)comboBoxModel, (String)"null cannot be cast to non-null type javax.swing.DefaultComboBoxModel<com.intellij.ide.ui.customization.ActionIconInfo>");
        return (DefaultComboBoxModel)comboBoxModel;
    }

    public void setSelectedIndex(int anIndex) {
        if (anIndex == -1) {
            this.setSelectedItem(null);
        } else {
            if (anIndex < 0 || anIndex >= this.dataModel.getSize()) {
                throw new IllegalArgumentException("setSelectedIndex: " + anIndex + " out of bounds");
            }
            ActionIconInfo item = (ActionIconInfo)this.dataModel.getElementAt(anIndex);
            if (item != ActionIconInfoKt.getSEPARATOR()) {
                this.setSelectedItem(item);
            }
        }
    }

    public void updateUI() {
        this.setUI(new DarculaComboBoxUI(){

            protected void selectNextPossibleValue() {
                int curInd = this.comboBox.isPopupVisible() ? this.listBox.getSelectedIndex() : this.comboBox.getSelectedIndex();
                this.selectPossibleValue(curInd, true);
            }

            protected void selectPreviousPossibleValue() {
                int curInd = this.comboBox.isPopupVisible() ? this.listBox.getSelectedIndex() : this.comboBox.getSelectedIndex();
                this.selectPossibleValue(curInd, false);
            }

            protected boolean isNewBorderSupported(JComboBox<?> comboBox) {
                Intrinsics.checkNotNullParameter(comboBox, (String)"comboBox");
                return true;
            }

            private final void selectPossibleValue(int curInd, boolean next) {
                if (next && curInd < this.comboBox.getModel().getSize() - 1) {
                    this.trySelectValue(curInd + 1, true);
                } else if (!next && curInd > 0) {
                    this.trySelectValue(curInd - 1, false);
                }
            }

            private final void trySelectValue(int ind, boolean next) {
                E item = this.comboBox.getItemAt(ind);
                if (item != ActionIconInfoKt.getSEPARATOR()) {
                    this.listBox.setSelectedIndex(ind);
                    this.listBox.ensureIndexIsVisible(ind);
                    if (this.comboBox.isPopupVisible()) {
                        this.comboBox.setSelectedIndex(ind);
                    }
                    this.comboBox.repaint();
                } else {
                    this.selectPossibleValue(ind, next);
                }
            }
        });
    }

    private static final String _init_$lambda$0(ActionIconInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        return info.getText();
    }

    private static final String _init_$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final List loadIconsAsync$lambda$0(BrowseIconsComboBox this$0, boolean $withNoneItem) {
        return this$0.createIconList($withNoneItem);
    }

    private static final void loadIconsAsync$lambda$1(BrowseIconsComboBox this$0, CompletableFuture $future, List icons) {
        Intrinsics.checkNotNull((Object)icons);
        Collection $this$toTypedArray$iv = icons;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this$0.setModel(new DefaultComboBoxModel<ActionIconInfo>(thisCollection$iv.toArray(new ActionIconInfo[0])));
        $future.complete(true);
    }

    private static final String createIconList$lambda$0(ActionIconInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getIconPath();
    }

    private static final boolean createIconList$lambda$1(List $defaultIcons, ActionIconInfo info) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Iterable iterable = $defaultIcons;
            for (Object t : iterable) {
                ActionIconInfo it = (ActionIconInfo)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getIconPath(), (Object)info.getIconPath())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0 == null;
    }

    private static final IconWrapper createIconList$lambda$2(ActionIconInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Icon icon2 = it.getIcon();
        Intrinsics.checkNotNull((Object)icon2);
        return new IconWrapper(icon2);
    }

    private static final boolean createIconList$lambda$3(List $defaultIcons, ActionIconInfo info) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Iterable iterable = $defaultIcons;
            for (Object t : iterable) {
                ActionIconInfo it = (ActionIconInfo)t;
                boolean bl = false;
                if (!(it.getIcon() == info.getIcon())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0 == null;
    }

    private static final int createIconList$lambda$4(ActionIconInfo a, ActionIconInfo b) {
        return StringsKt.compareTo((String)a.getText(), (String)b.getText(), (boolean)true);
    }

    private static final ValidationInfo installSelectedIconValidator$lambda$0(BrowseIconsComboBox this$0) {
        ValidationInfo validationInfo;
        Object object = this$0.getSelectedItem();
        Object object2 = object instanceof ActionIconInfo ? (ActionIconInfo)object : null;
        if (object2 == null || (object2 = ((ActionIconInfo)object2).getIconPath()) == null) {
            return null;
        }
        Object path = object2;
        try {
            CustomActionsSchemaKt.loadCustomIcon((String)path);
            validationInfo = null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            validationInfo = new ValidationInfo(IdeBundle.message((String)"icon.validation.message.not.found", (Object[])new Object[0]), (JComponent)((Object)this$0));
        }
        catch (NoSuchFileException noSuchFileException) {
            validationInfo = new ValidationInfo(IdeBundle.message((String)"icon.validation.message.not.found", (Object[])new Object[0]), (JComponent)((Object)this$0));
        }
        catch (Throwable throwable) {
            validationInfo = new ValidationInfo(IdeBundle.message((String)"icon.validation.message.format", (Object[])new Object[0]), (JComponent)((Object)this$0));
        }
        return validationInfo;
    }

    private static final void installSelectedIconValidator$lambda$1(BrowseIconsComboBox this$0, ActionEvent it) {
        ComponentValidator.getInstance((JComponent)((JComponent)((Object)this$0))).ifPresent(arg_0 -> BrowseIconsComboBox.installSelectedIconValidator$lambda$1$1(BrowseIconsComboBox::installSelectedIconValidator$lambda$1$0, arg_0));
    }

    private static final Unit installSelectedIconValidator$lambda$1$0(ComponentValidator validator2) {
        Intrinsics.checkNotNullParameter((Object)validator2, (String)"validator");
        validator2.updateInfo(null);
        return Unit.INSTANCE;
    }

    private static final void installSelectedIconValidator$lambda$1$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit selectIconForNode$lambda$0(BrowseIconsComboBox this$0, DefaultMutableTreeNode $node, Boolean it) {
        this$0.doSelectIconForNode($node);
        return Unit.INSTANCE;
    }

    private static final void selectIconForNode$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean doSelectIconForNode$lambda$0(String $customIconRef, ActionIconInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        return Intrinsics.areEqual((Object)info.getIconReference(), (Object)$customIconRef);
    }

    private static final boolean doSelectIconForNode$lambda$1(String $actionId, ActionIconInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        return Intrinsics.areEqual((Object)info.getActionId(), (Object)$actionId);
    }

    private static final boolean doSelectIconForNode$lambda$2(Icon $icon, ActionIconInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        return BrowseIconsComboBox.Companion.isSameIcons(info.getIcon(), $icon);
    }

    public static final /* synthetic */ ExtendableTextComponent.Extension access$createBrowseIconExtension(BrowseIconsComboBox $this) {
        return $this.createBrowseIconExtension();
    }

    public static final /* synthetic */ void access$browseIconAndSelect(BrowseIconsComboBox $this) {
        $this.browseIconAndSelect();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/ui/customization/BrowseIconsComboBox$Companion;", "", "<init>", "()V", "isSameIcons", "", "icon1", "Ljavax/swing/Icon;", "icon2", "getActualIcon", "icon", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isSameIcons(Icon icon1, Icon icon2) {
            Icon actualIcon2;
            if (icon1 == icon2) {
                return true;
            }
            if (icon1 == null || icon2 == null) {
                return false;
            }
            Icon actualIcon1 = this.getActualIcon(icon1);
            if (actualIcon1 == (actualIcon2 = this.getActualIcon(icon2))) {
                return true;
            }
            CachedImageIcon cachedImageIcon = actualIcon1 instanceof CachedImageIcon ? (CachedImageIcon)actualIcon1 : null;
            CachedImageIcon cachedImageIcon2 = actualIcon2 instanceof CachedImageIcon ? (CachedImageIcon)actualIcon2 : null;
            return Intrinsics.areEqual((Object)(cachedImageIcon != null ? cachedImageIcon.getOriginalPath() : null), (Object)(cachedImageIcon2 != null ? cachedImageIcon2.getOriginalPath() : null));
        }

        private final Icon getActualIcon(Icon icon2) {
            Icon cur = icon2;
            while (cur instanceof RetrievableIcon) {
                Intrinsics.checkNotNullExpressionValue((Object)((RetrievableIcon)cur).retrieveIcon(), (String)"retrieveIcon(...)");
            }
            return cur;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/ui/customization/BrowseIconsComboBox$IconWrapper;", "", "icon", "Ljavax/swing/Icon;", "<init>", "(Ljavax/swing/Icon;)V", "equals", "", "other", "hashCode", "", "intellij.platform.ide.impl"})
    private static final class IconWrapper {
        @NotNull
        private final Icon icon;

        public IconWrapper(@NotNull Icon icon2) {
            Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
            this.icon = icon2;
        }

        public boolean equals(@Nullable Object other) {
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Object object2 = other;
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.ide.ui.customization.BrowseIconsComboBox.IconWrapper");
            return Companion.isSameIcons(this.icon, ((IconWrapper)object2).icon);
        }

        public int hashCode() {
            Icon actualIcon = Companion.getActualIcon(this.icon);
            return actualIcon instanceof CachedImageIcon ? Objects.hashCode(((CachedImageIcon)actualIcon).getOriginalPath()) : actualIcon.hashCode();
        }
    }
}

