/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.diagnostic.DialogAppender;
import com.intellij.diagnostic.JsonLogHandler;
import com.intellij.idea.IdeaLogger;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.JulLogger;
import com.intellij.openapi.diagnostic.Logger;
import java.nio.file.Path;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LoggerFactory
implements Logger.Factory {
    public static final String LOG_FILE_NAME = "idea.log";

    @NotNull
    public static Path getLogFilePath() {
        Path path = PathManager.getLogDir().resolve(LOG_FILE_NAME);
        if (path == null) {
            LoggerFactory.$$$reportNull$$$0(0);
        }
        return path;
    }

    public LoggerFactory() {
        JulLogger.clearHandlers();
        Logger rootLogger = Logger.getLogger("");
        rootLogger.setLevel(Level.INFO);
        boolean logToJsonStdout = Boolean.getBoolean("intellij.log.to.json.stdout");
        if (logToJsonStdout) {
            System.setProperty("intellij.log.stdout", "false");
            JsonLogHandler jsonLogHandler = new JsonLogHandler();
            rootLogger.addHandler(jsonLogHandler);
        }
        boolean enableConsoleLogger = !logToJsonStdout && Boolean.parseBoolean(System.getProperty("idea.log.console", "true"));
        boolean append = Boolean.parseBoolean(System.getProperty("idea.log.append", "true"));
        boolean writeAttachments = Boolean.parseBoolean(System.getProperty("idea.log.persist.attachments", System.getProperty("idea.is.internal")));
        JulLogger.configureLogFileAndConsole((Path)LoggerFactory.getLogFilePath(), (boolean)append, (boolean)enableConsoleLogger, (boolean)true, (boolean)writeAttachments, () -> IdeaLogger.dropFrequentExceptionsCaches(), null, null);
        DialogAppender dialogAppender = new DialogAppender();
        dialogAppender.setLevel(Level.SEVERE);
        rootLogger.addHandler(dialogAppender);
        LoggerFactory.configureLoggersFromSystemProperties();
    }

    private static void configureLoggersFromSystemProperties() {
        LoggerFactory.setLevelsForCategories(System.getProperty("idea.log.debug.categories"), Level.FINE);
        LoggerFactory.setLevelsForCategories(System.getProperty("idea.log.trace.categories"), Level.FINER);
        LoggerFactory.setLevelsForCategories(System.getProperty("idea.log.all.categories"), Level.ALL);
    }

    private static void setLevelsForCategories(@Nullable String categories, Level level) {
        if (categories == null) {
            return;
        }
        int lastSeparator = -1;
        for (int i2 = 0; i2 <= categories.length(); ++i2) {
            if (i2 != categories.length() && categories.charAt(i2) != ',' && categories.charAt(i2) != '#') continue;
            if (lastSeparator + 1 < i2) {
                String category = categories.substring(lastSeparator + 1, i2);
                Logger.getLogger(category).setLevel(level);
                Logger.getLogger("#" + category).setLevel(level);
            }
            lastSeparator = i2;
        }
    }

    @NotNull
    public com.intellij.openapi.diagnostic.Logger getLoggerInstance(@NotNull String name2) {
        if (name2 == null) {
            LoggerFactory.$$$reportNull$$$0(1);
        }
        return new IdeaLogger(Logger.getLogger(name2));
    }

    public void flushHandlers() {
        for (Handler handler : Logger.getLogger("").getHandlers()) {
            handler.flush();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/idea/LoggerFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogFilePath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/idea/LoggerFactory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLoggerInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

