/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.ui;

import com.intellij.internal.statistic.collectors.fus.ui.ListValidationRule;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.events.ClassEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.ui.ExitActionType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010 \u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u0011\u0010\u001e\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001b\u00a8\u0006!"}, d2={"Lcom/intellij/internal/statistic/collectors/fus/ui/DialogsCounterUsagesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "EXIT_CODE", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "", "getEXIT_CODE", "()Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "DIALOG_CLASS", "Lcom/intellij/internal/statistic/eventLog/events/ClassEventField;", "getDIALOG_CLASS", "()Lcom/intellij/internal/statistic/eventLog/events/ClassEventField;", "INVOCATION_PLACE", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "getINVOCATION_PLACE", "()Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "EXIT_ACTION_TYPE", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lcom/intellij/openapi/ui/ExitActionType;", "getEXIT_ACTION_TYPE", "()Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "SHOW", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "getSHOW", "()Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "CLOSE", "getCLOSE", "HELP", "getHELP", "getGroup", "intellij.platform.ide.impl"})
public final class DialogsCounterUsagesCollector
extends CounterUsagesCollector {
    @NotNull
    public static final DialogsCounterUsagesCollector INSTANCE = new DialogsCounterUsagesCollector();
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("ui.dialogs", 63, null, 4, null);
    @NotNull
    private static final PrimitiveEventField<Integer> EXIT_CODE = (PrimitiveEventField)new PrimitiveEventField<Integer>(){
        private final String name;
        {
            this.name = "code";
        }

        public String getName() {
            return this.name;
        }

        public List<String> getValidationRule() {
            return CollectionsKt.listOf((Object)"{enum:0|1|2}");
        }

        public void addData(FeatureUsageData fuData, int value) {
            Intrinsics.checkNotNullParameter((Object)fuData, (String)"fuData");
            int toReport = this.getExitCodeToReport(value);
            fuData.addData(this.getName(), toReport);
        }

        private final int getExitCodeToReport(int exitCode2) {
            switch (exitCode2) {
                case 0: 
                case 1: {
                    return exitCode2;
                }
            }
            return 2;
        }
    };
    @NotNull
    private static final ClassEventField DIALOG_CLASS = EventFields.Class((String)"dialog_class");
    @NotNull
    private static final StringEventField INVOCATION_PLACE = EventFields.StringValidatedByCustomRule((String)"dialog_invocation_place", ListValidationRule.class);
    @NotNull
    private static final EnumEventField<ExitActionType> EXIT_ACTION_TYPE = new EnumEventField("exit_action_type", ExitActionType.class, DialogsCounterUsagesCollector::EXIT_ACTION_TYPE$lambda$0);
    @NotNull
    private static final VarargEventId SHOW;
    @NotNull
    private static final VarargEventId CLOSE;
    @NotNull
    private static final VarargEventId HELP;

    private DialogsCounterUsagesCollector() {
    }

    @NotNull
    public final PrimitiveEventField<Integer> getEXIT_CODE() {
        return EXIT_CODE;
    }

    @NotNull
    public final ClassEventField getDIALOG_CLASS() {
        return DIALOG_CLASS;
    }

    @NotNull
    public final StringEventField getINVOCATION_PLACE() {
        return INVOCATION_PLACE;
    }

    @NotNull
    public final EnumEventField<ExitActionType> getEXIT_ACTION_TYPE() {
        return EXIT_ACTION_TYPE;
    }

    @NotNull
    public final VarargEventId getSHOW() {
        return SHOW;
    }

    @NotNull
    public final VarargEventId getCLOSE() {
        return CLOSE;
    }

    @NotNull
    public final VarargEventId getHELP() {
        return HELP;
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    private static final String EXIT_ACTION_TYPE$lambda$0(ExitActionType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.name();
    }

    static {
        EventField[] eventFieldArray = new EventField[3];
        eventFieldArray[0] = DIALOG_CLASS;
        eventFieldArray[1] = INVOCATION_PLACE;
        eventFieldArray[2] = EventFields.PluginInfo;
        SHOW = GROUP.registerVarargEvent("show", eventFieldArray);
        eventFieldArray = new EventField[5];
        eventFieldArray[0] = DIALOG_CLASS;
        eventFieldArray[1] = INVOCATION_PLACE;
        eventFieldArray[2] = EXIT_ACTION_TYPE;
        eventFieldArray[3] = EXIT_CODE;
        eventFieldArray[4] = EventFields.PluginInfo;
        CLOSE = GROUP.registerVarargEvent("close", eventFieldArray);
        eventFieldArray = new EventField[3];
        eventFieldArray[0] = DIALOG_CLASS;
        eventFieldArray[1] = INVOCATION_PLACE;
        eventFieldArray[2] = EventFields.PluginInfo;
        HELP = GROUP.registerVarargEvent("help.clicked", eventFieldArray);
    }
}

