/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.ui;

import com.intellij.notification.impl.ui.MySplitter;
import com.intellij.notification.impl.ui.NotificationGroupComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.ui.JBUI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0006\u0010\u0010\u001a\u00020\rJ\b\u0010\u0011\u001a\u00020\rH\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/notification/impl/ui/AutoProportionController;", "Ljava/beans/PropertyChangeListener;", "splitter", "Lcom/intellij/notification/impl/ui/MySplitter;", "suggestions", "Lcom/intellij/notification/impl/ui/NotificationGroupComponent;", "timeline", "<init>", "(Lcom/intellij/notification/impl/ui/MySplitter;Lcom/intellij/notification/impl/ui/NotificationGroupComponent;Lcom/intellij/notification/impl/ui/NotificationGroupComponent;)V", "myEvent", "", "myEnabled", "propertyChange", "", "evt", "Ljava/beans/PropertyChangeEvent;", "update", "doUpdate", "setProportion", "value", "", "intellij.platform.ide.impl"})
final class AutoProportionController
implements PropertyChangeListener {
    @NotNull
    private final MySplitter splitter;
    @NotNull
    private final NotificationGroupComponent suggestions;
    @NotNull
    private final NotificationGroupComponent timeline;
    private boolean myEvent;
    private boolean myEnabled;

    public AutoProportionController(@NotNull MySplitter splitter2, @NotNull NotificationGroupComponent suggestions, @NotNull NotificationGroupComponent timeline) {
        Intrinsics.checkNotNullParameter((Object)((Object)splitter2), (String)"splitter");
        Intrinsics.checkNotNullParameter((Object)((Object)suggestions), (String)"suggestions");
        Intrinsics.checkNotNullParameter((Object)((Object)timeline), (String)"timeline");
        this.splitter = splitter2;
        this.suggestions = suggestions;
        this.timeline = timeline;
        this.myEnabled = true;
        this.splitter.addPropertyChangeListener("proportion", this);
    }

    @Override
    public void propertyChange(@Nullable PropertyChangeEvent evt) {
        if (!this.myEvent) {
            this.myEnabled = false;
            this.splitter.removePropertyChangeListener("proportion", this);
        }
    }

    public final void update() {
        ApplicationManager.getApplication().invokeLater(this::doUpdate);
    }

    private final void doUpdate() {
        if (!this.myEnabled || this.suggestions.isEmpty() || this.timeline.isEmpty()) {
            return;
        }
        int height = this.splitter.getHeight();
        if (height == 0) {
            return;
        }
        int firstHeight = this.suggestions.getPreferredSize().height + JBUI.scale((int)10);
        if (firstHeight < height / 2) {
            this.setProportion((float)firstHeight / (float)height);
        } else {
            this.setProportion(0.5f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setProportion(float value) {
        try {
            this.myEvent = true;
            this.splitter.setProportion(value);
        }
        finally {
            this.myEvent = false;
        }
    }
}

