/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl.islands;

import com.intellij.ide.ProjectGradients;
import com.intellij.ide.ProjectWidgetGradientLocationService;
import com.intellij.ide.ProjectWindowCustomizerService;
import com.intellij.ide.ui.GradientTextureCache;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.IdeGlassPaneEx;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.CustomWindowHeaderUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a8\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a(\u0010\u0015\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0016"}, d2={"islandsGradientPaint", "", "frame", "Lcom/intellij/openapi/wm/IdeFrame;", "mainColor", "Ljava/awt/Color;", "projectWindowCustomizer", "Lcom/intellij/ide/ProjectWindowCustomizerService;", "component", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics2D;", "doGradientPaint", "project", "Lcom/intellij/openapi/project/Project;", "getGradientCache", "Lcom/intellij/ide/ui/GradientTextureCache;", "root", "Ljavax/swing/JComponent;", "key", "", "doColorGradientPaint", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nIslandsGradientPainter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IslandsGradientPainter.kt\ncom/intellij/openapi/application/impl/islands/IslandsGradientPainterKt\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,160:1\n30#2,2:161\n*S KotlinDebug\n*F\n+ 1 IslandsGradientPainter.kt\ncom/intellij/openapi/application/impl/islands/IslandsGradientPainterKt\n*L\n84#1:161,2\n*E\n"})
public final class IslandsGradientPainterKt {
    public static final void islandsGradientPaint(@NotNull IdeFrame frame, @NotNull Color mainColor, @NotNull ProjectWindowCustomizerService projectWindowCustomizer, @NotNull Component component2, @NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)mainColor, (String)"mainColor");
        Intrinsics.checkNotNullParameter((Object)projectWindowCustomizer, (String)"projectWindowCustomizer");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (CustomWindowHeaderUtil.INSTANCE.isCompactHeader$intellij_platform_ide_impl()) {
            return;
        }
        if (component2 instanceof IdeGlassPaneEx && !((IdeGlassPaneEx)((Object)component2)).isColorfulToolbar()) {
            return;
        }
        Project project2 = frame.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        if (Registry.Companion.is("idea.islands.color.gradient.enabled", false)) {
            IslandsGradientPainterKt.doColorGradientPaint(project3, projectWindowCustomizer, component2, g);
        } else {
            IslandsGradientPainterKt.doGradientPaint(frame, mainColor, project3, projectWindowCustomizer, component2, g);
        }
    }

    private static final void doGradientPaint(IdeFrame frame, Color mainColor, Project project2, ProjectWindowCustomizerService projectWindowCustomizer, Component component2, Graphics2D g) {
        Color centerColor = projectWindowCustomizer.getGradientProjectColor(project2);
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<ProjectWidgetGradientLocationService> serviceClass$iv = ProjectWidgetGradientLocationService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        float centerX = ((ProjectWidgetGradientLocationService)object).getGradientOffsetRelativeToRootPane();
        Color color = ColorUtil.blendColorsInRgb((Color)mainColor, (Color)centerColor, (double)(0.85 * ((double)centerColor.getAlpha() / (double)255)));
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"blendColorsInRgb(...)");
        Color blendedColor = color;
        ScaleContext ctx = ScaleContext.Companion.create(g);
        int length = JBUI.getInt((String)"RecentProject.MainToolbarGradient.width", (int)700);
        int height = JBUI.getInt((String)"RecentProject.MainToolbarGradient.height", (int)200);
        int leftWidth = PaintUtil.alignIntToInt((int)((int)centerX), (ScaleContext)ctx, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.CEIL, null);
        int rightWidth = PaintUtil.alignIntToInt((int)length, (ScaleContext)ctx, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.CEIL, null);
        int totalWidth = PaintUtil.alignIntToInt((int)(leftWidth + rightWidth), (ScaleContext)ctx, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.CEIL, null);
        JComponent root = frame.getComponent();
        Intrinsics.checkNotNull((Object)root);
        TexturePaint leftGradientTexture = GradientTextureCache.getHorizontalTexture$default(IslandsGradientPainterKt.getGradientCache(root, "LeftGradientCache"), g, leftWidth, mainColor, blendedColor, 0, 0, 48, null);
        TexturePaint rightGradientTexture = GradientTextureCache.getHorizontalTexture$default(IslandsGradientPainterKt.getGradientCache(root, "RightGradientCache"), g, rightWidth, blendedColor, mainColor, leftWidth, 0, 32, null);
        g.setColor(mainColor);
        g.fillRect(0, 0, component2.getWidth(), component2.getHeight());
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        PaintUtil.alignTxToInt((Graphics2D)g, null, (boolean)true, (boolean)false, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.FLOOR);
        g.setPaint(leftGradientTexture);
        g.fillRect(0, 0, leftWidth, height);
        g.setPaint(rightGradientTexture);
        g.fillRect(leftWidth, 0, rightWidth, height);
        PaintUtil.alignTxToInt((Graphics2D)g, null, (boolean)false, (boolean)true, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.FLOOR);
        Color startColor = ClientSystemInfo.Companion.isMac() ? Gray.TRANSPARENT : ColorUtil.toAlpha((Color)mainColor, (int)0);
        g.setPaint(new GradientPaint(0.0f, 0.0f, startColor, 0.0f, height, mainColor));
        g.fillRect(0, 0, totalWidth, height);
    }

    private static final GradientTextureCache getGradientCache(JComponent root, String key) {
        Object gradientCache = root.getClientProperty(key);
        if (gradientCache instanceof GradientTextureCache) {
            return (GradientTextureCache)gradientCache;
        }
        GradientTextureCache newValue = new GradientTextureCache();
        root.putClientProperty(key, newValue);
        return newValue;
    }

    private static final void doColorGradientPaint(Project project2, ProjectWindowCustomizerService projectWindowCustomizer, Component component2, Graphics2D g) {
        ProjectGradients info = projectWindowCustomizer.getProjectGradients$intellij_platform_ide_impl(project2);
        Object[] objectArray = new float[]{info.getDiagonalFraction1(0.0f), info.getDiagonalFraction2(0.13f), info.getDiagonalFraction3(0.3f), info.getDiagonalFraction4(1.0f)};
        float[] fArray = objectArray;
        objectArray = new JBColor[4];
        objectArray[0] = (float)info.getDiagonalColor1();
        objectArray[1] = (float)info.getDiagonalColor2();
        objectArray[2] = (float)info.getDiagonalColor3();
        objectArray[3] = (float)info.getDiagonalColor4();
        g.setPaint(new LinearGradientPaint(0.0f, 0.0f, component2.getWidth(), component2.getHeight(), fArray, (Color[])objectArray));
        g.fillRect(0, 0, component2.getWidth(), component2.getHeight());
        float ovalRadius = (float)component2.getWidth() / 4.0f;
        int ovalWidth = component2.getWidth() / 2;
        float ovalCenterX = (float)component2.getWidth() * 0.2f;
        float ovalCenterY = 36.0f;
        Object[] objectArray2 = new float[]{0.0f, 1.0f};
        float[] fArray2 = objectArray2;
        objectArray2 = new JBColor[2];
        objectArray2[0] = (float)info.getRadialColor1();
        objectArray2[1] = (float)info.getRadialColor2();
        g.setPaint(new RadialGradientPaint(ovalCenterX, ovalCenterY, ovalRadius, fArray2, (Color[])objectArray2));
        g.fillOval((int)(ovalCenterX - ovalRadius), (int)(ovalCenterY - ovalRadius), ovalWidth, ovalWidth);
        g.setPaint(new GradientPaint(0.0f, 0.0f, (Color)info.getHorizontalColor1(), component2.getWidth(), 0.0f, (Color)info.getHorizontalColor2()));
        g.fillRect(0, 0, component2.getWidth(), component2.getHeight());
        g.setPaint(new GradientPaint(0.0f, 0.0f, (Color)info.getVerticalColor1(), 0.0f, component2.getHeight(), (Color)info.getVerticalColor2()));
        g.fillRect(0, 0, component2.getWidth(), component2.getHeight());
    }
}

