/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.CmdEvent;
import com.intellij.openapi.command.impl.CommandId;
import com.intellij.openapi.command.impl.EditorAndState;
import com.intellij.openapi.command.impl.ForeignEditorProvider;
import com.intellij.openapi.command.impl.MentionOnlyUndoableAction;
import com.intellij.openapi.command.impl.PerformedCommand;
import com.intellij.openapi.command.impl.UndoAffectedDocuments;
import com.intellij.openapi.command.impl.UndoDocumentUtil;
import com.intellij.openapi.command.impl.UndoIllegalStateException;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.impl.CurrentEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ExternalChangeActionUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CommandBuilder {
    private static final Logger LOG = Logger.getInstance(CommandBuilder.class);
    @Nullable
    private final Project undoProject;
    private final boolean isTransparentSupported;
    private final boolean isGroupIdChangeSupported;
    @NotNull
    private CmdEvent cmdEvent;
    @Nullable
    private Throwable tracedStartCommand;
    @NotNull
    private CurrentEditorProvider editorProvider;
    @Nullable
    private EditorAndState editorStateBefore;
    @Nullable
    private EditorAndState editorStateAfter;
    @Nullable
    private DocumentReference originalDocument;
    @NotNull
    private Collection<UndoableAction> undoableActions;
    @NotNull
    private UndoAffectedDocuments affectedDocuments;
    @NotNull
    private UndoAffectedDocuments additionalAffectedDocuments;
    private boolean isForcedGlobal;
    private boolean isValid;
    private boolean isInsideCommand;

    CommandBuilder(@Nullable Project undoProject, boolean isTransparentSupported, boolean isGroupIdChangeSupported) {
        this.undoProject = undoProject;
        this.isTransparentSupported = isTransparentSupported;
        this.isGroupIdChangeSupported = isGroupIdChangeSupported;
        this.reset();
    }

    boolean isInsideCommand() {
        return this.isInsideCommand;
    }

    boolean isActive() {
        return this.isInsideCommand() && this.cmdEvent.project() == this.undoProject;
    }

    boolean hasActions() {
        this.assertInsideCommand();
        return !this.undoableActions.isEmpty();
    }

    void commandStarted(@NotNull CmdEvent cmdEvent, @NotNull CurrentEditorProvider editorProvider) {
        if (cmdEvent == null) {
            CommandBuilder.$$$reportNull$$$0(0);
        }
        if (editorProvider == null) {
            CommandBuilder.$$$reportNull$$$0(1);
        }
        this.assertOutsideCommand(cmdEvent);
        if (LOG.isTraceEnabled() || ApplicationManager.getApplication().isUnitTestMode()) {
            this.tracedStartCommand = new Throwable();
        }
        this.cmdEvent = cmdEvent;
        this.editorProvider = editorProvider;
        this.editorStateBefore = this.currentEditorState();
        this.originalDocument = this.cmdEvent.recordOriginalDocument() ? this.originalDocument() : null;
        this.isInsideCommand = true;
    }

    void addUndoableAction(@NotNull UndoableAction action2) {
        if (action2 == null) {
            CommandBuilder.$$$reportNull$$$0(2);
        }
        this.assertInsideCommand();
        if (CommandBuilder.isRefresh()) {
            this.originalDocument = null;
        }
        this.undoableActions.add(action2);
        this.affectedDocuments.addAffected(action2.getAffectedDocuments());
        this.isForcedGlobal = this.isForcedGlobal || action2.isGlobal();
    }

    void addDocumentAsAffected(@NotNull DocumentReference docRef) {
        if (docRef == null) {
            CommandBuilder.$$$reportNull$$$0(3);
        }
        this.assertInsideCommand();
        if (!this.hasChangesOf(docRef)) {
            DocumentReference[] refs = new DocumentReference[]{docRef};
            this.addUndoableAction(new MentionOnlyUndoableAction(refs));
        }
    }

    void addAffectedDocuments(Document ... docs) {
        if (docs == null) {
            CommandBuilder.$$$reportNull$$$0(4);
        }
        this.assertInsideCommand();
        this.additionalAffectedDocuments.addAffected(docs);
    }

    void addAffectedFiles(VirtualFile ... files2) {
        if (files2 == null) {
            CommandBuilder.$$$reportNull$$$0(5);
        }
        this.assertInsideCommand();
        this.additionalAffectedDocuments.addAffected(files2);
    }

    void markAsGlobal() {
        this.assertInsideCommand();
        this.isForcedGlobal = true;
    }

    void invalidateIfAffects(@NotNull DocumentReference docRef) {
        if (docRef == null) {
            CommandBuilder.$$$reportNull$$$0(6);
        }
        this.assertInsideCommand();
        if (this.affectedDocuments.affects(docRef)) {
            this.isValid = false;
        }
    }

    @NotNull
    PerformedCommand commandFinished(@NotNull CmdEvent cmdEvent) {
        if (cmdEvent == null) {
            CommandBuilder.$$$reportNull$$$0(7);
        }
        this.assertInsideCommand(cmdEvent);
        if (this.isGroupIdChangeSupported) {
            this.cmdEvent = cmdEvent;
        }
        this.editorStateAfter = this.currentEditorState();
        if (this.originalDocument != null && this.hasActions() && !this.isTransparent() && this.affectedDocuments.affectsOnlyPhysical()) {
            this.addDocumentAsAffected(Objects.requireNonNull(this.originalDocument));
        }
        return this.buildAndReset();
    }

    void assertOutsideCommand() {
        this.assertOutsideCommand(null);
    }

    @Nullable
    DocumentReference getOriginalDocument() {
        return this.originalDocument;
    }

    private void assertInsideCommand() {
        this.assertInsideCommand(null);
    }

    private void assertOutsideCommand(@Nullable CmdEvent cmdEvent) {
        if (this.isInsideCommand) {
            String startEvent = cmdEvent == null ? "" : ", startEvent: " + String.valueOf(cmdEvent);
            throw new UndoIllegalStateException("Nested command detected, please report the stacktrace" + startEvent, this.tracedStartCommand);
        }
    }

    private void assertInsideCommand(@Nullable CmdEvent cmdEvent) {
        if (!this.isInsideCommand) {
            String finishEvent = cmdEvent == null ? "" : ", finishEvent: " + String.valueOf(cmdEvent);
            throw new UndoIllegalStateException("Must be called inside a command" + finishEvent);
        }
    }

    @NotNull
    private PerformedCommand buildAndReset() {
        PerformedCommand performedCommand = new PerformedCommand(this.cmdEvent.id(), this.cmdEvent.name(), this.cmdEvent.groupId(), this.cmdEvent.confirmationPolicy(), this.editorStateBefore, this.editorStateAfter, this.undoableActions, this.affectedDocuments, this.additionalAffectedDocuments, this.isTransparent(), this.isForcedGlobal, this.isGlobal(), this.isValid);
        this.reset();
        PerformedCommand performedCommand2 = performedCommand;
        if (performedCommand2 == null) {
            CommandBuilder.$$$reportNull$$$0(8);
        }
        return performedCommand2;
    }

    @Nullable
    private EditorAndState currentEditorState() {
        try {
            return EditorAndState.getStateFor(this.undoProject, this.editorProvider);
        }
        catch (Throwable ex) {
            LOG.error("Failed to retrieve editor state", ex);
            return null;
        }
    }

    @Nullable
    private DocumentReference originalDocument() {
        if (this.undoProject != null && this.undoProject == this.cmdEvent.project()) {
            CurrentEditorProvider currentEditorProvider = this.editorProvider;
            if (currentEditorProvider instanceof ForeignEditorProvider) {
                ForeignEditorProvider foreignEditorProvider = (ForeignEditorProvider)currentEditorProvider;
                return foreignEditorProvider.originator();
            }
            return UndoDocumentUtil.getDocReference(this.undoProject, this.editorProvider);
        }
        return null;
    }

    private boolean isTransparent() {
        if (this.isTransparentSupported) {
            return this.cmdEvent.isTransparent();
        }
        return this.cmdEvent.isTransparent() && !this.hasActions();
    }

    private boolean hasChangesOf(@NotNull DocumentReference ref2) {
        if (ref2 == null) {
            CommandBuilder.$$$reportNull$$$0(9);
        }
        for (UndoableAction action2 : this.undoableActions) {
            Object[] refs = action2.getAffectedDocuments();
            if (refs == null || !ArrayUtil.contains((Object)ref2, (Object[])refs)) continue;
            return true;
        }
        return this.hasActions() && this.additionalAffectedDocuments.affects(ref2);
    }

    private boolean isGlobal() {
        return this.isForcedGlobal || this.affectedDocuments.affectsMultiplePhysical();
    }

    private void reset() {
        this.cmdEvent = NoEvent.INSTANCE;
        this.tracedStartCommand = null;
        this.editorProvider = NoEditorProvider.INSTANCE;
        this.editorStateBefore = null;
        this.editorStateAfter = null;
        this.originalDocument = null;
        this.undoableActions = new ArrayList<UndoableAction>(2);
        this.affectedDocuments = new UndoAffectedDocuments();
        this.additionalAffectedDocuments = new UndoAffectedDocuments();
        this.isForcedGlobal = false;
        this.isValid = true;
        this.isInsideCommand = false;
    }

    private static boolean isRefresh() {
        return ExternalChangeActionUtil.isExternalChangeInProgress();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdEvent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docRef";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docs";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/CommandBuilder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/CommandBuilder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAndReset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "commandStarted";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addUndoableAction";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addDocumentAsAffected";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addAffectedDocuments";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addAffectedFiles";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invalidateIfAffects";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "commandFinished";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasChangesOf";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }

    private static final class NoEvent
    implements CmdEvent {
        static final NoEvent INSTANCE = new NoEvent();

        private NoEvent() {
        }

        @Override
        @NotNull
        public CommandId id() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public Project project() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public Object groupId() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public UndoConfirmationPolicy confirmationPolicy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean recordOriginalDocument() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isTransparent() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class NoEditorProvider
    implements CurrentEditorProvider {
        static final CurrentEditorProvider INSTANCE = new NoEditorProvider();

        private NoEditorProvider() {
        }

        @Override
        @Nullable
        public FileEditor getCurrentEditor(@Nullable Project project2) {
            throw new UnsupportedOperationException();
        }
    }
}

