/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.CmdEvent;
import com.intellij.openapi.command.impl.CommandIdService;
import com.intellij.openapi.command.impl.SeparatedCommandListener;
import com.intellij.openapi.command.impl.UndoSpy;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class CommandSeparator
implements CommandListener {
    @NotNull
    private final SeparatedCommandListener publisher;
    private boolean commandStarted;
    private boolean transparentStarted;
    private boolean commandInsideTransparent;
    private boolean transparentInsideCommand;

    CommandSeparator() {
        this(CommandSeparator.getPublisher());
    }

    public CommandSeparator(@NotNull SeparatedCommandListener publisher) {
        if (publisher == null) {
            CommandSeparator.$$$reportNull$$$0(0);
        }
        this.publisher = publisher;
    }

    public void commandStarted(@NotNull CommandEvent event) {
        if (event == null) {
            CommandSeparator.$$$reportNull$$$0(1);
        }
        this.assertOutsideCommand();
        this.commandStarted = true;
        if (this.transparentStarted) {
            this.commandInsideTransparent = true;
        } else {
            this.notifyCommandStarted(event);
        }
    }

    public void commandFinished(@NotNull CommandEvent event) {
        if (event == null) {
            CommandSeparator.$$$reportNull$$$0(2);
        }
        this.assertInsideCommand();
        this.commandStarted = false;
        if (this.commandInsideTransparent) {
            this.commandInsideTransparent = false;
        } else {
            this.notifyCommandFinished(event);
        }
        if (this.transparentInsideCommand) {
            this.transparentInsideCommand = false;
            this.notifyTransparentStarted();
        }
    }

    public void undoTransparentActionStarted() {
        this.assertOutsideTransparent();
        this.transparentStarted = true;
        if (this.commandStarted) {
            this.transparentInsideCommand = true;
        } else {
            this.notifyTransparentStarted();
        }
    }

    public void undoTransparentActionFinished() {
        this.assertInsideTransparent();
        this.transparentStarted = false;
        if (this.transparentInsideCommand) {
            this.transparentInsideCommand = false;
        } else {
            this.notifyTransparentFinished();
        }
    }

    @TestOnly
    public boolean isInitialState() {
        return !this.commandStarted && !this.transparentStarted && !this.commandInsideTransparent && !this.transparentInsideCommand;
    }

    private void notifyCommandStarted(@NotNull CommandEvent event) {
        if (event == null) {
            CommandSeparator.$$$reportNull$$$0(3);
        }
        this.notifyCommandStarted(CommandSeparator.createCmdEvent(event));
    }

    private void notifyCommandFinished(@NotNull CommandEvent event) {
        if (event == null) {
            CommandSeparator.$$$reportNull$$$0(4);
        }
        this.notifyCommandFinished(CommandSeparator.createCmdEvent(event));
    }

    private void notifyTransparentStarted() {
        this.notifyCommandStarted(CommandSeparator.createTransparentCmdEvent());
    }

    private void notifyTransparentFinished() {
        this.notifyCommandFinished(CommandSeparator.createTransparentCmdEvent());
    }

    private void notifyCommandStarted(@NotNull CmdEvent cmdEvent) {
        if (cmdEvent == null) {
            CommandSeparator.$$$reportNull$$$0(5);
        }
        this.publisher.onCommandStarted(cmdEvent);
        UndoSpy undoSpy = UndoSpy.getInstance();
        if (undoSpy != null) {
            undoSpy.commandStarted(cmdEvent);
        }
    }

    private void notifyCommandFinished(@NotNull CmdEvent cmdEvent) {
        if (cmdEvent == null) {
            CommandSeparator.$$$reportNull$$$0(6);
        }
        this.publisher.onCommandFinished(cmdEvent);
        UndoSpy undoSpy = UndoSpy.getInstance();
        if (undoSpy != null) {
            undoSpy.commandFinished(cmdEvent);
        }
    }

    private void assertInsideCommand() {
        if (!this.commandStarted) {
            throw new IllegalStateException("Command not started");
        }
    }

    private void assertOutsideCommand() {
        if (this.commandStarted) {
            throw new IllegalStateException("Command already started");
        }
    }

    private void assertInsideTransparent() {
        if (!this.transparentStarted) {
            throw new IllegalStateException("Transparent action not started");
        }
    }

    private void assertOutsideTransparent() {
        if (this.transparentStarted) {
            throw new IllegalStateException("Transparent action already started");
        }
    }

    @NotNull
    private static CmdEvent createCmdEvent(@NotNull CommandEvent event) {
        if (event == null) {
            CommandSeparator.$$$reportNull$$$0(7);
        }
        CmdEvent cmdEvent = CmdEvent.create(CommandIdService.currCommandId(), event.getProject(), event.getCommandName(), event.getCommandGroupId(), event.getUndoConfirmationPolicy(), event.shouldRecordActionForOriginalDocument(), false);
        if (cmdEvent == null) {
            CommandSeparator.$$$reportNull$$$0(8);
        }
        return cmdEvent;
    }

    @NotNull
    private static CmdEvent createTransparentCmdEvent() {
        CmdEvent cmdEvent = CmdEvent.create(CommandIdService.currCommandId(), null, "", null, UndoConfirmationPolicy.DEFAULT, false, true);
        if (cmdEvent == null) {
            CommandSeparator.$$$reportNull$$$0(9);
        }
        return cmdEvent;
    }

    @NotNull
    private static SeparatedCommandListener getPublisher() {
        SeparatedCommandListener separatedCommandListener = (SeparatedCommandListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(SeparatedCommandListener.TOPIC);
        if (separatedCommandListener == null) {
            CommandSeparator.$$$reportNull$$$0(10);
        }
        return separatedCommandListener;
    }

    public String toString() {
        return "CommandSeparator{commandStarted=" + this.commandStarted + ", transparentStarted=" + this.transparentStarted + ", commandInsideTransparent=" + this.commandInsideTransparent + ", transparentInsideCommand=" + this.transparentInsideCommand + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publisher";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdEvent";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/CommandSeparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/CommandSeparator";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createCmdEvent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createTransparentCmdEvent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublisher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "commandStarted";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "commandFinished";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "notifyCommandStarted";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "notifyCommandFinished";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createCmdEvent";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

