/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.IndentStrategy;
import com.intellij.openapi.editor.LanguageIndentStrategy;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class IndentSelectionAction
extends EditorAction {
    public IndentSelectionAction() {
        super((EditorActionHandler)new Handler());
    }

    public void update(Editor editor2, Presentation presentation2, DataContext dataContext2) {
        presentation2.setEnabled(IndentSelectionAction.originalIsEnabled(editor2, true));
    }

    public void updateForKeyboardAccess(Editor editor2, Presentation presentation2, DataContext dataContext2) {
        presentation2.setEnabled(this.isEnabled(editor2, dataContext2));
    }

    protected boolean isEnabled(Editor editor2, DataContext dataContext2) {
        return IndentSelectionAction.originalIsEnabled(editor2, true);
    }

    protected static boolean originalIsEnabled(Editor editor2, boolean wantSelection) {
        return (!wantSelection || IndentSelectionAction.hasSuitableSelection(editor2)) && !editor2.isOneLineMode() && !editor2.isViewer();
    }

    private static boolean hasSuitableSelection(Editor editor2) {
        if (!editor2.getSelectionModel().hasSelection()) {
            return false;
        }
        Document document2 = editor2.getDocument();
        int selectionStart = editor2.getSelectionModel().getSelectionStart();
        int selectionEnd = editor2.getSelectionModel().getSelectionEnd();
        return !CharArrayUtil.containsOnlyWhiteSpaces((CharSequence)document2.getCharsSequence().subSequence(selectionStart, selectionEnd));
    }

    private static void indentSelection(Editor editor2, Project project2) {
        int endIndex;
        Document document2;
        int startIndex;
        int oldSelectionStart = editor2.getSelectionModel().getSelectionStart();
        int oldSelectionEnd = editor2.getSelectionModel().getSelectionEnd();
        if (!editor2.getSelectionModel().hasSelection()) {
            oldSelectionEnd = oldSelectionStart = editor2.getCaretModel().getOffset();
        }
        if ((startIndex = (document2 = editor2.getDocument()).getLineNumber(oldSelectionStart)) == -1) {
            startIndex = document2.getLineCount() - 1;
        }
        if ((endIndex = document2.getLineNumber(oldSelectionEnd)) > 0 && document2.getLineStartOffset(endIndex) == oldSelectionEnd && editor2.getSelectionModel().hasSelection()) {
            --endIndex;
        }
        if (endIndex == -1) {
            endIndex = document2.getLineCount() - 1;
        }
        int blockIndent = CodeStyle.getIndentOptions((Project)project2, (Document)document2).INDENT_SIZE;
        IndentSelectionAction.doIndent(endIndex, startIndex, document2, project2, editor2, blockIndent);
    }

    static void doIndent(int endIndex, int startIndex, Document document2, Project project2, Editor editor2, int blockIndent) {
        int[] caretOffset = new int[]{editor2.getCaretModel().getOffset()};
        SelectionModel selectionModel = editor2.getSelectionModel();
        boolean extendSelection = selectionModel.hasSelection() && DocumentUtil.isAtLineStart((int)selectionModel.getSelectionStart(), (Document)document2) && (selectionModel.getSelectionEnd() == document2.getTextLength() || DocumentUtil.isAtLineStart((int)selectionModel.getSelectionEnd(), (Document)document2));
        boolean bulkMode = endIndex - startIndex > 50;
        DocumentUtil.executeInBulk((Document)document2, (boolean)bulkMode, () -> {
            ArrayList<Integer> nonModifiableLines = new ArrayList<Integer>();
            if (project2 != null) {
                int indentationStartOffset = document2.getLineStartOffset(startIndex);
                int indentationEndOffset = document2.getLineStartOffset(endIndex);
                PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document2);
                IndentStrategy indentStrategy = LanguageIndentStrategy.getIndentStrategy((PsiFile)file2);
                if (file2 != null && !LanguageIndentStrategy.isDefault((IndentStrategy)indentStrategy)) {
                    for (int i2 = startIndex; i2 <= endIndex; ++i2) {
                        PsiElement element = file2.findElementAt(document2.getLineStartOffset(i2));
                        if (element == null || indentStrategy.canIndent(indentationStartOffset, indentationEndOffset, element)) continue;
                        nonModifiableLines.add(i2);
                    }
                }
            }
            for (int i3 = startIndex; i3 <= endIndex; ++i3) {
                if (nonModifiableLines.contains(i3)) continue;
                caretOffset[0] = EditorActionUtil.indentLine(project2, editor2, i3, blockIndent, caretOffset[0]);
            }
        });
        if (extendSelection) {
            selectionModel.setSelection(DocumentUtil.getLineStartOffset((int)selectionModel.getSelectionStart(), (Document)document2), selectionModel.getSelectionEnd());
        }
        editor2.getCaretModel().moveToOffset(caretOffset[0]);
    }

    private static final class Handler
    extends EditorWriteActionHandler.ForEachCaret {
        private Handler() {
        }

        public void executeWriteAction(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext2) {
            if (editor2 == null) {
                Handler.$$$reportNull$$$0(0);
            }
            if (caret == null) {
                Handler.$$$reportNull$$$0(1);
            }
            Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
            if (this.isEnabled(editor2, caret, dataContext2)) {
                IndentSelectionAction.indentSelection(editor2, project2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "caret";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/actions/IndentSelectionAction$Handler";
            objectArray[2] = "executeWriteAction";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

