/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex;

import com.intellij.codeInsight.editorActions.TabOutScopesTracker;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LineExtensionInfo;
import com.intellij.openapi.editor.ModNavigator;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.EditorPopupHandler;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.ex.SoftWrapModelEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.impl.TextDrawingCallback;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.function.IntFunction;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface EditorEx
extends Editor {
    @NonNls
    public static final String PROP_INSERT_MODE = "insertMode";
    @NonNls
    public static final String PROP_COLUMN_MODE = "columnMode";
    @NonNls
    public static final String PROP_FONT_SIZE = "fontSize";
    @NonNls
    public static final String PROP_FONT_SIZE_2D = "fontSize2D";
    @NonNls
    public static final String PROP_ONE_LINE_MODE = "oneLineMode";
    @NonNls
    public static final String PROP_HIGHLIGHTER = "highlighter";
    @NonNls
    public static final String PROP_HEADER_COMPONENT = "headerComponent";
    public static final Key<TextRange> LAST_PASTED_REGION = Key.create((String)"LAST_PASTED_REGION");
    public static final int VERTICAL_SCROLLBAR_LEFT = 0;
    public static final int VERTICAL_SCROLLBAR_RIGHT = 1;

    @NotNull
    public DocumentEx getDocument();

    @NotNull
    public MarkupModelEx getMarkupModel();

    @NotNull
    public MarkupModelEx getFilteredDocumentMarkupModel();

    @NotNull
    public EditorGutterComponentEx getGutterComponentEx();

    public JComponent getPermanentHeaderComponent();

    public void setViewer(boolean var1);

    public void setHighlighter(@NotNull EditorHighlighter var1);

    public void setPermanentHeaderComponent(JComponent var1);

    public void setColorsScheme(@NotNull EditorColorsScheme var1);

    public void setInsertMode(boolean var1);

    public void setColumnMode(boolean var1);

    public void setVerticalScrollbarOrientation(int var1);

    public int getVerticalScrollbarOrientation();

    public void setVerticalScrollbarVisible(boolean var1);

    public void setHorizontalScrollbarVisible(boolean var1);

    @NotNull
    public CutProvider getCutProvider();

    @NotNull
    public CopyProvider getCopyProvider();

    @NotNull
    public PasteProvider getPasteProvider();

    @NotNull
    public DeleteProvider getDeleteProvider();

    public void repaint(int var1, int var2);

    public void reinitSettings();

    public void addPropertyChangeListener(@NotNull PropertyChangeListener var1, @NotNull Disposable var2);

    public void addPropertyChangeListener(@NotNull PropertyChangeListener var1);

    public void removePropertyChangeListener(@NotNull PropertyChangeListener var1);

    public int getMaxWidthInRange(int var1, int var2);

    public boolean setCaretVisible(boolean var1);

    public boolean setCaretEnabled(boolean var1);

    public void addFocusListener(@NotNull FocusChangeListener var1);

    public void addFocusListener(@NotNull FocusChangeListener var1, @NotNull Disposable var2);

    public void setOneLineMode(boolean var1);

    @NotNull
    public JScrollPane getScrollPane();

    public boolean isRendererMode();

    public void setRendererMode(boolean var1);

    public void setFile(@NotNull VirtualFile var1);

    @NotNull
    public DataContext getDataContext();

    public boolean processKeyTyped(@NotNull KeyEvent var1);

    public void setFontSize(int var1);

    default public void setFontSize(float fontSize) {
        this.setFontSize((int)((double)fontSize + 0.5));
    }

    @NotNull
    public Color getBackgroundColor();

    public void setBackgroundColor(Color var1);

    public Dimension getContentSize();

    public boolean isEmbeddedIntoDialogWrapper();

    public void setEmbeddedIntoDialogWrapper(boolean var1);

    @Nullable
    @ApiStatus.Obsolete
    public VirtualFile getVirtualFile();

    @NotNull
    public TextDrawingCallback getTextDrawingCallback();

    @NotNull
    public FoldingModelEx getFoldingModel();

    @NotNull
    public SoftWrapModelEx getSoftWrapModel();

    @NotNull
    public ScrollingModelEx getScrollingModel();

    @NotNull
    public EditorColorsScheme createBoundColorSchemeDelegate(@Nullable EditorColorsScheme var1);

    public void setPlaceholder(@Nullable @Nls CharSequence var1);

    public void setPlaceholderAttributes(@Nullable TextAttributes var1);

    public void setShowPlaceholderWhenFocused(boolean var1);

    public boolean isStickySelection();

    public void setStickySelection(boolean var1);

    public int getPrefixTextWidthInPixels();

    public void setPrefixTextAndAttributes(@Nullable String var1, @Nullable TextAttributes var2);

    public boolean isPurePaintingMode();

    public void setPurePaintingMode(boolean var1);

    public void registerLineExtensionPainter(@NotNull @NotNull IntFunction<? extends @NotNull Collection<? extends LineExtensionInfo>> var1);

    public void registerScrollBarRepaintCallback(@Nullable ButtonlessScrollBarUI.ScrollbarRepaintCallback var1);

    public int getExpectedCaretOffset();

    public void setContextMenuGroupId(@Nullable String var1);

    @Nullable
    public String getContextMenuGroupId();

    public void installPopupHandler(@NotNull EditorPopupHandler var1);

    public void uninstallPopupHandler(@NotNull EditorPopupHandler var1);

    @Nullable
    default public ActionGroup getPopupActionGroup(@NotNull EditorMouseEvent event) {
        if (event == null) {
            EditorEx.$$$reportNull$$$0(0);
        }
        return null;
    }

    public void setCustomCursor(@NotNull Object var1, @Nullable Cursor var2);

    @ApiStatus.Experimental
    default public int getStickyLinesPanelHeight() {
        return 0;
    }

    @NotNull
    default public ModNavigator asModNavigator() {
        return new ModNavigator(){

            @NotNull
            public Document getDocument() {
                DocumentEx documentEx = EditorEx.this.getDocument();
                if (documentEx == null) {
                    1.$$$reportNull$$$0(0);
                }
                return documentEx;
            }

            public void select(@NotNull TextRange range) {
                if (range == null) {
                    1.$$$reportNull$$$0(1);
                }
                EditorEx.this.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
            }

            public void moveCaretTo(int offset) {
                EditorEx.this.getCaretModel().moveToOffset(offset);
            }

            public int getCaretOffset() {
                return EditorEx.this.getCaretModel().getOffset();
            }

            public void registerTabOut(@NotNull TextRange range, int tabOutOffset) {
                if (range == null) {
                    1.$$$reportNull$$$0(2);
                }
                TabOutScopesTracker.getInstance().registerScopeRange((Editor)EditorEx.this, range.getStartOffset(), range.getEndOffset(), tabOutOffset);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/editor/ex/EditorEx$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "range";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDocument";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/editor/ex/EditorEx$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "select";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "registerTabOut";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/ex/EditorEx", "getPopupActionGroup"));
    }
}

