/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.EditorThreading;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayProperties;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.InlayImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import java.awt.Point;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

final class AfterLineEndInlayImpl<R extends EditorCustomElementRenderer>
extends InlayImpl<R, AfterLineEndInlayImpl<?>> {
    private static int ourGlobalCounter = 0;
    final boolean mySoftWrappable;
    final int myPriority;
    final int myOrder;

    AfterLineEndInlayImpl(@NotNull EditorImpl editor2, int offset, boolean relatesToPrecedingText, boolean softWrappable, int priority, @NotNull R renderer2) {
        if (editor2 == null) {
            AfterLineEndInlayImpl.$$$reportNull$$$0(0);
        }
        if (renderer2 == null) {
            AfterLineEndInlayImpl.$$$reportNull$$$0(1);
        }
        super(editor2, offset, relatesToPrecedingText, renderer2);
        this.mySoftWrappable = softWrappable;
        this.myPriority = priority;
        this.myOrder = ourGlobalCounter++;
    }

    @Override
    @ApiStatus.Internal
    public RangeMarkerTree<AfterLineEndInlayImpl<?>> getTree() {
        return this.myEditor.getInlayModel().myAfterLineEndElementsTree;
    }

    @Override
    void doUpdate() {
        this.myWidthInPixels = this.myRenderer.calcWidthInPixels((Inlay)this);
        if (this.myWidthInPixels <= 0) {
            throw PluginException.createByClass((String)("Positive width should be defined for an after-line-end element by " + String.valueOf(this.myRenderer)), null, (Class)this.myRenderer.getClass());
        }
    }

    @Override
    Point getPosition() {
        VisualPosition pos = (VisualPosition)EditorThreading.compute(() -> this.getVisualPosition());
        return this.myEditor.visualPositionToXY(pos);
    }

    @NotNull
    public Inlay.Placement getPlacement() {
        Inlay.Placement placement = Inlay.Placement.AFTER_LINE_END;
        if (placement == null) {
            AfterLineEndInlayImpl.$$$reportNull$$$0(2);
        }
        return placement;
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        int offset = this.getOffset();
        int logicalLine = this.myEditor.getDocument().getLineNumber(offset);
        int lineEndOffset = this.myEditor.getDocument().getLineEndOffset(logicalLine);
        VisualPosition position = this.myEditor.offsetToVisualPosition(lineEndOffset, true, true);
        if (this.myEditor.getFoldingModel().isOffsetCollapsed(lineEndOffset)) {
            VisualPosition visualPosition = position;
            if (visualPosition == null) {
                AfterLineEndInlayImpl.$$$reportNull$$$0(3);
            }
            return visualPosition;
        }
        List<Inlay<?>> inlays = this.myEditor.getInlayModel().getAfterLineEndElementsForLogicalLine(logicalLine);
        int order = inlays.indexOf((Object)this);
        return new VisualPosition(position.line, position.column + 1 + order);
    }

    public int getHeightInPixels() {
        return this.myEditor.getLineHeight();
    }

    @NotNull
    public InlayProperties getProperties() {
        InlayProperties inlayProperties = new InlayProperties().relatesToPrecedingText(this.isRelatedToPrecedingText()).disableSoftWrapping(!this.mySoftWrappable).priority(this.myPriority);
        if (inlayProperties == null) {
            AfterLineEndInlayImpl.$$$reportNull$$$0(4);
        }
        return inlayProperties;
    }

    public String toString() {
        return "[After-line-end inlay, offset=" + this.getOffset() + ", width=" + this.myWidthInPixels + ", renderer=" + String.valueOf(this.myRenderer) + "]" + (this.isValid() ? "" : "(invalid)");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/AfterLineEndInlayImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/AfterLineEndInlayImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlacement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisualPosition";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

