/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.idea.AppMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.editor.ComponentInlayAlignment;
import com.intellij.openapi.editor.ComponentInlayRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.EditorHostedComponent;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.ComponentInlaysContainer;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RemoveUserDataKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0002\u0012\u0017\b\u0002\u0018\u0000 '2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001'B\u0011\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u001c\u001a\u00020\u001a2\u0010\u0010\u001d\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fH\u0002J\u001a\u0010\u001e\u001a\u00020\u001f2\u0010\u0010\u001d\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fH\u0002J\b\u0010 \u001a\u00020\u001fH\u0016J\b\u0010!\u001a\u00020\u001aH\u0016J\b\u0010\"\u001a\u00020\u001fH\u0016J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020\u001fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001b\u00a8\u0006("}, d2={"Lcom/intellij/openapi/editor/impl/ComponentInlaysContainer;", "Ljavax/swing/JComponent;", "Lcom/intellij/openapi/editor/EditorHostedComponent;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;)V", "getEditor", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "visibleAreaAwareInlaysCount", "", "contentSizeAwareInlayCount", "inlays", "", "Lcom/intellij/openapi/editor/Inlay;", "Lcom/intellij/openapi/editor/ComponentInlayRenderer;", "contentResizeListener", "com/intellij/openapi/editor/impl/ComponentInlaysContainer$contentResizeListener$1", "Lcom/intellij/openapi/editor/impl/ComponentInlaysContainer$contentResizeListener$1;", "visibleAreaListener", "Lcom/intellij/openapi/editor/event/VisibleAreaListener;", "foldingListener", "com/intellij/openapi/editor/impl/ComponentInlaysContainer$foldingListener$1", "Lcom/intellij/openapi/editor/impl/ComponentInlaysContainer$foldingListener$1;", "isInputFocusOwner", "", "()Z", "remove", "inlay", "add", "", "invalidate", "isValidateRoot", "doLayout", "isVerticalScrollbarFlipped", "scrollPane", "Ljavax/swing/JScrollPane;", "dispose", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nComponentInlay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComponentInlay.kt\ncom/intellij/openapi/editor/impl/ComponentInlaysContainer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,298:1\n1#2:299\n*E\n"})
final class ComponentInlaysContainer
extends JComponent
implements EditorHostedComponent,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorEx editor;
    private int visibleAreaAwareInlaysCount;
    private int contentSizeAwareInlayCount;
    @NotNull
    private final List<Inlay<ComponentInlayRenderer<?>>> inlays;
    @NotNull
    private final contentResizeListener.1 contentResizeListener;
    @NotNull
    private final VisibleAreaListener visibleAreaListener;
    @NotNull
    private final foldingListener.1 foldingListener;
    private final boolean isInputFocusOwner;
    @NotNull
    private static final Key<ComponentInlaysContainer> INLAYS_CONTAINER = new Key("INLAYS_CONTAINER");

    private ComponentInlaysContainer(EditorEx editor2) {
        this.editor = editor2;
        this.inlays = new ArrayList();
        this.contentResizeListener = new ComponentAdapter(this){
            final /* synthetic */ ComponentInlaysContainer this$0;
            {
                this.this$0 = $receiver;
            }

            public void componentResized(ComponentEvent e) {
                this.this$0.revalidate();
                this.this$0.repaint();
            }
        };
        this.visibleAreaListener = arg_0 -> ComponentInlaysContainer.visibleAreaListener$lambda$0(this, arg_0);
        this.foldingListener = new FoldingListener(this){
            final /* synthetic */ ComponentInlaysContainer this$0;
            {
                this.this$0 = $receiver;
            }

            public void onFoldProcessingEnd() {
                this.this$0.revalidate();
                this.this$0.repaint();
            }
        };
        this.isInputFocusOwner = true;
        this.editor.getFoldingModel().addListener(this.foldingListener, this);
    }

    @NotNull
    public final EditorEx getEditor() {
        return this.editor;
    }

    @Override
    public boolean isInputFocusOwner() {
        return this.isInputFocusOwner;
    }

    private final boolean remove(Inlay<ComponentInlayRenderer<?>> inlay) {
        if (!this.inlays.remove(inlay)) {
            return false;
        }
        EditorCustomElementRenderer editorCustomElementRenderer = inlay.getRenderer();
        Intrinsics.checkNotNullExpressionValue((Object)editorCustomElementRenderer, (String)"getRenderer(...)");
        ComponentInlayRenderer renderer2 = (ComponentInlayRenderer)editorCustomElementRenderer;
        ComponentInlayAlignment componentInlayAlignment = renderer2.getAlignment();
        switch (componentInlayAlignment == null ? -1 : WhenMappings.$EnumSwitchMapping$0[componentInlayAlignment.ordinal()]) {
            case 1: 
            case 2: {
                this.contentSizeAwareInlayCount += -1;
                if (this.contentSizeAwareInlayCount != 0) break;
                this.editor.getContentComponent().removeComponentListener(this.contentResizeListener);
                break;
            }
            case 3: 
            case 4: {
                this.visibleAreaAwareInlaysCount += -1;
                if (this.visibleAreaAwareInlaysCount != 0) break;
                this.editor.getScrollingModel().removeVisibleAreaListener(this.visibleAreaListener);
                break;
            }
        }
        this.remove((Component)renderer2.getComponent());
        if (!this.editor.isDisposed()) {
            this.revalidate();
            this.repaint();
        }
        return true;
    }

    private final void add(Inlay<ComponentInlayRenderer<?>> inlay) {
        EditorCustomElementRenderer editorCustomElementRenderer = inlay.getRenderer();
        Intrinsics.checkNotNullExpressionValue((Object)editorCustomElementRenderer, (String)"getRenderer(...)");
        ComponentInlayRenderer renderer2 = (ComponentInlayRenderer)editorCustomElementRenderer;
        this.inlays.add(inlay);
        this.add((Component)renderer2.getComponent());
        ((Component)renderer2.getComponent()).setVisible(!EditorUtil.isInlayFolded(inlay));
        ComponentInlayAlignment componentInlayAlignment = ((ComponentInlayRenderer)inlay.getRenderer()).getAlignment();
        switch (componentInlayAlignment == null ? -1 : WhenMappings.$EnumSwitchMapping$0[componentInlayAlignment.ordinal()]) {
            case 1: 
            case 2: {
                int n = this.contentSizeAwareInlayCount;
                this.contentSizeAwareInlayCount = n + 1;
                if (n != 0) break;
                this.editor.getContentComponent().addComponentListener(this.contentResizeListener);
                break;
            }
            case 3: 
            case 4: {
                int n = this.visibleAreaAwareInlaysCount;
                this.visibleAreaAwareInlaysCount = n + 1;
                if (n != 0) break;
                this.editor.getScrollingModel().addVisibleAreaListener(this.visibleAreaListener);
                break;
            }
        }
        if (((Component)renderer2.getComponent()).isVisible()) {
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void invalidate() {
        if (!this.isValid()) {
            return;
        }
        super.invalidate();
        RepaintManager.currentManager(this).addInvalidComponent(this);
    }

    @Override
    public boolean isValidateRoot() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doLayout() {
        List<Inlay<ComponentInlayRenderer<?>>> inlays = this.inlays;
        if (inlays.isEmpty()) {
            return;
        }
        JComponent jComponent = this.editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
        JComponent content2 = jComponent;
        int initialContentWidth = content2.getWidth();
        JScrollPane jScrollPane = this.editor.getScrollPane();
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"getScrollPane(...)");
        JScrollPane scrollPane = jScrollPane;
        int viewportReservedWidth = !this.isVerticalScrollbarFlipped(scrollPane) ? this.editor.getScrollPane().getVerticalScrollBar().getWidth() + content2.getInsets().left : content2.getInsets().left;
        int viewportWidth = scrollPane.getViewport().getWidth();
        int contentXInViewport = scrollPane.getViewport().getViewPosition().x;
        for (Inlay<ComponentInlayRenderer<?>> inlay : inlays) {
            Dimension dimension;
            ComponentInlayRenderer it = (ComponentInlayRenderer)inlay.getRenderer();
            boolean bl = false;
            ComponentInlayRenderer componentInlayRenderer = it;
            ComponentInlayAlignment componentInlayAlignment = it.getAlignment();
            switch (componentInlayAlignment == null ? -1 : WhenMappings.$EnumSwitchMapping$0[componentInlayAlignment.ordinal()]) {
                case 1: {
                    Object $this$doLayout_u24lambda_u240_u240;
                    Object t = it.getComponent();
                    ComponentInlayRenderer componentInlayRenderer2 = componentInlayRenderer;
                    boolean bl2 = false;
                    dimension = new Dimension(((Component)$this$doLayout_u24lambda_u240_u240).getMinimumSize().width, ((Component)$this$doLayout_u24lambda_u240_u240).getPreferredSize().height);
                    componentInlayRenderer = componentInlayRenderer2;
                    break;
                }
                case 3: 
                case 4: {
                    void $this$doLayout_u24lambda_u240_u241;
                    Object $this$doLayout_u24lambda_u240_u240 = it.getComponent();
                    ComponentInlayRenderer componentInlayRenderer2 = componentInlayRenderer;
                    boolean bl3 = false;
                    dimension = new Dimension($this$doLayout_u24lambda_u240_u241.getMinimumSize().width + viewportReservedWidth, $this$doLayout_u24lambda_u240_u241.getPreferredSize().height);
                    componentInlayRenderer = componentInlayRenderer2;
                    break;
                }
                default: {
                    Dimension dimension2 = ((Component)it.getComponent()).getPreferredSize();
                    Intrinsics.checkNotNull((Object)dimension2);
                    dimension = dimension2;
                }
            }
            componentInlayRenderer.setInlaySize$intellij_platform_ide_impl(dimension);
        }
        WriteIntentReadAction.runThrowable(() -> ComponentInlaysContainer.doLayout$lambda$1(this, inlays));
        if (content2.getWidth() < initialContentWidth && content2.getWidth() < viewportWidth) {
            content2.setSize(new Dimension(Math.min(initialContentWidth, viewportWidth), content2.getHeight()));
        }
        this.setBounds(SwingUtilities.calculateInnerArea(content2, null));
        ReadAction.run(() -> ComponentInlaysContainer.doLayout$lambda$2(inlays, contentXInViewport, this, viewportWidth, viewportReservedWidth));
    }

    private final boolean isVerticalScrollbarFlipped(JScrollPane scrollPane) {
        Object flipProperty = scrollPane.getClientProperty(JBScrollPane.Flip.class);
        return flipProperty == JBScrollPane.Flip.HORIZONTAL || flipProperty == JBScrollPane.Flip.BOTH;
    }

    public void dispose() {
    }

    private static final void visibleAreaListener$lambda$0(ComponentInlaysContainer this$0, VisibleAreaEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.revalidate();
        this$0.repaint();
    }

    private static final void doLayout$lambda$1(ComponentInlaysContainer this$0, List $inlays) {
        this$0.editor.getInlayModel().execute(true, () -> ComponentInlaysContainer.doLayout$lambda$1$0($inlays));
    }

    private static final void doLayout$lambda$1$0(List $inlays) {
        for (Inlay inlay : $inlays) {
            ComponentInlayRenderer it = (ComponentInlayRenderer)inlay.getRenderer();
            boolean bl = false;
            if (it.getInlaySize$intellij_platform_ide_impl().width == inlay.getWidthInPixels() && it.getInlaySize$intellij_platform_ide_impl().height == inlay.getHeightInPixels()) continue;
            inlay.update();
        }
    }

    private static final void doLayout$lambda$2(List $inlays, int $contentXInViewport, ComponentInlaysContainer this$0, int $viewportWidth, int $viewportReservedWidth) {
        for (Inlay inlay : $inlays) {
            ComponentInlayAlignment alignment;
            Object component2 = ((ComponentInlayRenderer)inlay.getRenderer()).getComponent();
            Rectangle componentBounds = inlay.getBounds();
            if (componentBounds == null) {
                ((Component)component2).setVisible(false);
                continue;
            }
            ((Component)component2).setVisible(true);
            ComponentInlayAlignment componentInlayAlignment = alignment = ((ComponentInlayRenderer)inlay.getRenderer()).getAlignment();
            switch (componentInlayAlignment == null ? -1 : WhenMappings.$EnumSwitchMapping$0[componentInlayAlignment.ordinal()]) {
                case 3: {
                    int n = $contentXInViewport;
                    break;
                }
                case 5: {
                    int n = this$0.editor.offsetToXY((int)inlay.getOffset()).x;
                    break;
                }
                default: {
                    int n = componentBounds.x = 0;
                }
            }
            if (alignment == ComponentInlayAlignment.INLINE_COMPONENT) {
                componentBounds.height = ((Component)component2).getPreferredSize().height;
            }
            if (alignment == ComponentInlayAlignment.INLINE_COMPONENT) {
                componentBounds.y = componentBounds.y + this$0.editor.getLineHeight() / 2 - componentBounds.height / 2;
            }
            if (alignment == ComponentInlayAlignment.STRETCH_TO_CONTENT_WIDTH || alignment == ComponentInlayAlignment.FIT_CONTENT_WIDTH) {
                componentBounds.width = this$0.getBounds().width;
            } else if (alignment == ComponentInlayAlignment.FIT_VIEWPORT_WIDTH || alignment == ComponentInlayAlignment.FIT_VIEWPORT_X_SPAN) {
                componentBounds.width = Math.max(((Component)component2).getMinimumSize().width, $viewportWidth - $viewportReservedWidth);
            }
            ((Component)component2).setBounds(componentBounds);
        }
    }

    public /* synthetic */ ComponentInlaysContainer(EditorEx editor2, DefaultConstructorMarker $constructor_marker) {
        this(editor2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/editor/impl/ComponentInlaysContainer$Companion;", "", "<init>", "()V", "INLAYS_CONTAINER", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/editor/impl/ComponentInlaysContainer;", "addInlay", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "Lcom/intellij/openapi/editor/ComponentInlayRenderer;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final void addInlay(@NotNull Inlay<ComponentInlayRenderer<?>> inlay) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            if (AppMode.isRemoteDevHost()) {
                return;
            }
            Editor editor2 = inlay.getEditor();
            Intrinsics.checkNotNull((Object)editor2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
            EditorEx editor3 = (EditorEx)editor2;
            if (editor3.isDisposed()) {
                return;
            }
            ComponentInlaysContainer componentInlaysContainer = (ComponentInlaysContainer)editor3.getUserData(INLAYS_CONTAINER);
            if (componentInlaysContainer == null) {
                ComponentInlaysContainer componentInlaysContainer2;
                ComponentInlaysContainer container = componentInlaysContainer2 = new ComponentInlaysContainer(editor3, null);
                boolean bl = false;
                editor3.putUserData(INLAYS_CONTAINER, container);
                editor3.getContentComponent().add(container);
                DisposerUtilKt.whenDisposed((Disposable)container, () -> Companion.addInlay$lambda$0$0(editor3, container));
                EditorUtil.disposeWithEditor(editor3, container);
                componentInlaysContainer = componentInlaysContainer2;
            }
            ComponentInlaysContainer inlaysContainer = componentInlaysContainer;
            inlaysContainer.add(inlay);
            DisposerUtilKt.whenDisposed((Disposable)((Disposable)inlay), () -> Companion.addInlay$lambda$1(inlaysContainer, inlay));
            Disposer.register((Disposable)inlaysContainer, (Disposable)((Disposable)inlay));
        }

        private static final Unit addInlay$lambda$0$0(EditorEx $editor, ComponentInlaysContainer $container) {
            $editor.getContentComponent().remove($container);
            RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)$editor), (Key)INLAYS_CONTAINER);
            return Unit.INSTANCE;
        }

        private static final Unit addInlay$lambda$1(ComponentInlaysContainer $inlaysContainer, Inlay $inlay) {
            if ($inlaysContainer.remove($inlay) && $inlaysContainer.inlays.isEmpty()) {
                Disposer.dispose((Disposable)$inlaysContainer);
            }
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ComponentInlayAlignment.values().length];
            try {
                nArray[ComponentInlayAlignment.FIT_CONTENT_WIDTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComponentInlayAlignment.STRETCH_TO_CONTENT_WIDTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComponentInlayAlignment.FIT_VIEWPORT_X_SPAN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComponentInlayAlignment.FIT_VIEWPORT_WIDTH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComponentInlayAlignment.INLINE_COMPONENT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

