/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.stickyLines.ui;

import com.intellij.openapi.util.registry.Registry;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J6\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\fJ\u000e\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\fJ\b\u0010\u001c\u001a\u00020\u000fH\u0002J\b\u0010\u001d\u001a\u00020\u000fH\u0002J\u0006\u0010\u001e\u001a\u00020\u0003R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0002\u0010\u0006\"\u0004\b\u0007\u0010\u0005R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/openapi/editor/impl/stickyLines/ui/StickyLineShadowPainter;", "", "isDarkColorScheme", "", "<init>", "(Z)V", "()Z", "setDarkColorScheme", "SHADOW_HEIGHT_FACTOR_LIGHT", "", "SHADOW_HEIGHT_FACTOR_DARK", "SHADOW_COLOR_ALPHA_LIGHT", "", "SHADOW_COLOR_ALPHA_DARK", "SHADOW_COLOR_LIGHT", "Ljava/awt/Color;", "SHADOW_COLOR_DARK", "SHADOW_COLOR_TRANSPARENT", "paintShadow", "", "g", "Ljava/awt/Graphics2D;", "x", "y", "width", "height", "shadowHeight", "lineHeight", "shadowColor", "shadowColorTransparent", "isShadowDebugEnabled", "intellij.platform.ide.impl"})
public final class StickyLineShadowPainter {
    private boolean isDarkColorScheme;
    private final double SHADOW_HEIGHT_FACTOR_LIGHT;
    private final double SHADOW_HEIGHT_FACTOR_DARK;
    private final int SHADOW_COLOR_ALPHA_LIGHT;
    private final int SHADOW_COLOR_ALPHA_DARK;
    @NotNull
    private final Color SHADOW_COLOR_LIGHT;
    @NotNull
    private final Color SHADOW_COLOR_DARK;
    @NotNull
    private final Color SHADOW_COLOR_TRANSPARENT;

    public StickyLineShadowPainter(boolean isDarkColorScheme) {
        this.isDarkColorScheme = isDarkColorScheme;
        this.SHADOW_HEIGHT_FACTOR_LIGHT = 0.17;
        this.SHADOW_HEIGHT_FACTOR_DARK = 0.25;
        this.SHADOW_COLOR_ALPHA_LIGHT = 8;
        this.SHADOW_COLOR_ALPHA_DARK = 32;
        this.SHADOW_COLOR_LIGHT = new Color(0, 0, 0, this.SHADOW_COLOR_ALPHA_LIGHT);
        this.SHADOW_COLOR_DARK = new Color(0, 0, 0, this.SHADOW_COLOR_ALPHA_DARK);
        this.SHADOW_COLOR_TRANSPARENT = new Color(0, 0, 0, 0);
    }

    public /* synthetic */ StickyLineShadowPainter(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public final boolean isDarkColorScheme() {
        return this.isDarkColorScheme;
    }

    public final void setDarkColorScheme(boolean bl) {
        this.isDarkColorScheme = bl;
    }

    public final void paintShadow(@NotNull Graphics2D g, int x, int y, int width, int height, int shadowHeight) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Paint tmpPaint = g.getPaint();
        g.setPaint(new GradientPaint(x, y + height - shadowHeight, this.shadowColor(), x, y + height, this.shadowColorTransparent()));
        g.fillRect(x, y + height - shadowHeight, width, height);
        g.setPaint(tmpPaint);
    }

    public final int shadowHeight(int lineHeight) {
        double factor = this.isDarkColorScheme ? this.SHADOW_HEIGHT_FACTOR_DARK : this.SHADOW_HEIGHT_FACTOR_LIGHT;
        return (int)((double)lineHeight * factor);
    }

    private final Color shadowColor() {
        if (this.isShadowDebugEnabled()) {
            Color color = Color.GREEN;
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"GREEN");
            return color;
        }
        return this.isDarkColorScheme ? this.SHADOW_COLOR_DARK : this.SHADOW_COLOR_LIGHT;
    }

    private final Color shadowColorTransparent() {
        if (this.isShadowDebugEnabled()) {
            Color color = Color.RED;
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"RED");
            return color;
        }
        return this.SHADOW_COLOR_TRANSPARENT;
    }

    public final boolean isShadowDebugEnabled() {
        return Registry.Companion.is("editor.show.sticky.lines.shadow.debug", false);
    }

    public StickyLineShadowPainter() {
        this(false, 1, null);
    }
}

