/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.zoomIndicator;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.zoomIndicator.ZoomIndicatorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.ui.awt.RelativePoint;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010\u0015\u001a\u00020\r*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0012H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/fileEditor/impl/zoomIndicator/AttachZoomIndicator;", "Lcom/intellij/openapi/editor/event/EditorFactoryListener;", "<init>", "()V", "service", "Lcom/intellij/openapi/fileEditor/impl/zoomIndicator/ZoomIndicatorManager;", "project", "Lcom/intellij/openapi/project/Project;", "shouldSuppressZoomIndicator", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "editorCreated", "", "event", "Lcom/intellij/openapi/editor/event/EditorFactoryEvent;", "editorReleased", "getComponentToUse", "Ljavax/swing/JComponent;", "editorEx", "Lcom/intellij/openapi/editor/ex/EditorEx;", "showInBottomCenterOf", "Lcom/intellij/openapi/ui/popup/Balloon;", "component", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nAttachZoomIndicator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttachZoomIndicator.kt\ncom/intellij/openapi/fileEditor/impl/zoomIndicator/AttachZoomIndicator\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,70:1\n30#2,2:71\n58#2:73\n*S KotlinDebug\n*F\n+ 1 AttachZoomIndicator.kt\ncom/intellij/openapi/fileEditor/impl/zoomIndicator/AttachZoomIndicator\n*L\n21#1:71,2\n54#1:73\n*E\n"})
final class AttachZoomIndicator
implements EditorFactoryListener {
    private final ZoomIndicatorManager service(Project project2) {
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<ZoomIndicatorManager> serviceClass$iv = ZoomIndicatorManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (ZoomIndicatorManager)object;
    }

    private final boolean shouldSuppressZoomIndicator(Editor editor2) {
        if (editor2.isDisposed()) {
            return true;
        }
        if (Intrinsics.areEqual((Object)editor2.getUserData(ZoomIndicatorManager.SUPPRESS_ZOOM_INDICATOR), (Object)true)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)editor2.getUserData(ZoomIndicatorManager.SUPPRESS_ZOOM_INDICATOR_ONCE), (Object)true)) {
            editor2.putUserData(ZoomIndicatorManager.SUPPRESS_ZOOM_INDICATOR_ONCE, (Object)false);
            return true;
        }
        return false;
    }

    public void editorCreated(@NotNull EditorFactoryEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Editor editor2 = event.getEditor();
        EditorImpl editorImpl = editor2 instanceof EditorImpl ? (EditorImpl)editor2 : null;
        if (editorImpl == null) {
            return;
        }
        EditorImpl editorEx = editorImpl;
        Project project2 = editorEx.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        if (project3.isDisposed() || this.shouldSuppressZoomIndicator(editorEx)) {
            return;
        }
        editorEx.addPropertyChangeListener(arg_0 -> AttachZoomIndicator.editorCreated$lambda$0(this, editorEx, project3, arg_0));
    }

    public void editorReleased(@NotNull EditorFactoryEvent event) {
        ZoomIndicatorManager manager2;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Editor editor2 = event.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        Editor editor3 = editor2;
        Project project2 = event.getEditor().getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        if (editor3.isDisposed() || project3.isDisposed()) {
            return;
        }
        ComponentManager $this$serviceIfCreated$iv = (ComponentManager)project3;
        boolean $i$f$serviceIfCreated = false;
        ZoomIndicatorManager zoomIndicatorManager = manager2 = (ZoomIndicatorManager)$this$serviceIfCreated$iv.getServiceIfCreated(ZoomIndicatorManager.class);
        if (Intrinsics.areEqual((Object)(zoomIndicatorManager != null ? zoomIndicatorManager.getEditor() : null), (Object)editor3)) {
            manager2.cancelCurrentPopup();
        }
    }

    private final JComponent getComponentToUse(Project project2, EditorEx editorEx) {
        Object object;
        if (EditorSettingsExternalizable.getInstance().isWheelFontChangePersistent()) {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project2);
            object = fileEditorManager instanceof FileEditorManagerImpl ? (FileEditorManagerImpl)fileEditorManager : null;
            if (object == null || (object = ((FileEditorManagerImpl)((Object)object)).getComponent()) == null) {
                JComponent jComponent = editorEx.getComponent();
                object = jComponent;
                Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            }
        } else {
            JComponent jComponent = editorEx.getComponent();
            Intrinsics.checkNotNull((Object)jComponent);
            object = jComponent;
        }
        return object;
    }

    private final void showInBottomCenterOf(Balloon $this$showInBottomCenterOf, JComponent component2) {
        $this$showInBottomCenterOf.show(RelativePoint.getSouthOf((JComponent)component2), Balloon.Position.below);
    }

    private static final void editorCreated$lambda$0(AttachZoomIndicator this$0, EditorImpl $editorEx, Project $project, PropertyChangeEvent it) {
        if (!Intrinsics.areEqual((Object)it.getPropertyName(), (Object)"fontSize")) {
            return;
        }
        if (!ZoomIndicatorManager.Companion.isEditorZoomIndicatorEnabled$intellij_platform_ide_impl() || this$0.shouldSuppressZoomIndicator($editorEx)) {
            return;
        }
        ActionsKt.invokeLater$default(null, () -> AttachZoomIndicator.editorCreated$lambda$0$0($editorEx, this$0, $project), (int)1, null);
    }

    private static final Unit editorCreated$lambda$0$0(EditorImpl $editorEx, AttachZoomIndicator this$0, Project $project) {
        block1: {
            Balloon balloon;
            if ($editorEx.isDisposed() || !$editorEx.getComponent().isShowing()) break block1;
            Balloon balloon2 = balloon = this$0.service($project).createOrGetBalloon($editorEx);
            if (balloon2 != null) {
                this$0.showInBottomCenterOf(balloon2, this$0.getComponentToUse($project, $editorEx));
            }
        }
        return Unit.INSTANCE;
    }
}

